// Copyright (c) 2011 RealSolid. Please read license.txt for applicable licensing.

#ifndef __uibase__
#define __uibase__

#include <wx/intl.h>

#include <wx/string.h>
#include <wx/bitmap.h>
#include <wx/image.h>
#include <wx/icon.h>
#include <wx/menu.h>
#include <wx/gdicmn.h>
#include <wx/font.h>
#include <wx/colour.h>
#include <wx/settings.h>
#include <wx/toolbar.h>
#include <wx/statusbr.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/combobox.h>
#include <wx/button.h>
#include <wx/sizer.h>
#include <wx/choice.h>
#include <wx/imaglist.h>
#include <wx/listctrl.h>
#include <wx/panel.h>
#include <wx/notebook.h>
#include <wx/frame.h>
#include <wx/html/htmlwin.h>
#include <wx/dialog.h>
#include <wx/listbox.h>
#include <wx/checkbox.h>
#include <wx/scrolwin.h>
#include <wx/statbmp.h>
#include <wx/mstream.h>
#include <wx/bmpbuttn.h>

///////////////////////////////////////////////////////////////////////////

#define wxID_MAINFRAME 1000
#define wxID_BUTTONSEND 1001
#define wxID_BUTTONRECEIVE 1002
#define wxID_TEXTCTRLADDRESS 1003
#define wxID_BUTTONTRADE 1004
#define wxID_BUTTONCOPY 1005
#define wxID_PROXYIP 1006
#define wxID_PROXYPORT 1007
#define wxID_TEXTCTRLPAYTO 1009
#define wxID_BUTTONPASTE 1010
#define wxID_BUTTONADDRESSBOOK 1011
#define wxID_TEXTCTRLAMOUNT 1012
#define wxID_CHOICETRANSFERTYPE 1013
#define wxID_LISTCTRL 1014
#define wxID_BUTTONRENAME 1015
#define wxID_PANELSENDING 1016
#define wxID_LISTCTRLSENDING 1017
#define wxID_PANELRECEIVING 1018
#define wxID_LISTCTRLRECEIVING 1019
#define wxID_BUTTONDELETE 1020
#define wxID_BUTTONEDIT 1021
#define wxID_TEXTCTRL 1022

///////////////////////////////////////////////////////////////////////////////
/// Class CMainFrameBase
///////////////////////////////////////////////////////////////////////////////
class CMainFrameBase : public wxFrame
{
	private:

	protected:
	    wxBoxSizer* m_MainSizer;
	    int m_nMaxTX;
		wxMenuBar* m_menubar;
		wxMenu* m_menuFile;
		wxMenu* m_menuHelp;
		wxToolBar* m_toolBar;

		wxStaticText* m_WalletText;
		wxComboBox* m_WalletSelect;

		wxComboBox* m_TxLimitSelect;

		wxBitmapButton* m_buttonLogo;

        wxStaticText* m_staticTextBalance;

		wxChoice* m_choiceFilter;
		wxNotebook* m_notebook;
		wxPanel* m_panel9;
		wxPanel* m_panel91;
		wxPanel* m_panel92;
		wxPanel* m_panel93;
		wxPanel* m_MiningPanel;



        wxTextCtrl* m_MiningName;
		wxTextCtrl* m_MiningAddress;
		wxTextCtrl* m_MiningPort;
		wxTextCtrl* m_MiningUserName;
		wxTextCtrl* m_MiningUserPass;
		wxComboBox* m_MiningThreads;
		wxComboBox* m_MiningUsage;
		wxButton* m_MiningButtonStart;
		wxButton* m_MiningButtonWebsite;

		// Virtual event handlers, overide them in your derived class
		virtual void OnSize(wxSizeEvent& event ) { event.Skip(); }
		virtual void OnClose( wxCloseEvent& event ) { event.Skip(); }
		virtual void OnIconize( wxIconizeEvent& event ) { event.Skip(); }
		virtual void OnIdle( wxIdleEvent& event ) { event.Skip(); }
		virtual void OnMouseEvents( wxMouseEvent& event ) { event.Skip(); }
		virtual void OnPaint( wxPaintEvent& event ) { event.Skip(); }

		virtual void OnMiningListItemSelected( wxListEvent& event ) { event.Skip(); }
		virtual void OnMiningListItemDeSelected( wxListEvent& event ) { event.Skip(); }
		virtual void OnMiningButtonStart( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnMiningButtonWebsite( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnMiningTextUpdate( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnMiningThreadSelect( wxCommandEvent& event ) { event.Skip(); }

        virtual void OnMenuFileOpenDataDir( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnMenuFileExit( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnMenuFileNewWallet(wxCommandEvent& event) { event.Skip(); }
		virtual void OnMenuRenameWallet(wxCommandEvent& event) { event.Skip(); }
		virtual void OnMenuSetDefaultWallet(wxCommandEvent& event) { event.Skip(); }
		virtual void OnMenuShowMiningPanel(wxCommandEvent& event) { event.Skip(); }
		virtual void OnMenuAboutHomePage( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnMenuOptionsChangeYourAddress( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnMenuOptionsEncryptWallet( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnMenuOptionsChangeWalletPassphrase( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnMenuOptionsOptions( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnMenuHelpAbout( wxCommandEvent& event ) { event.Skip(); }
        virtual void OnTXLimitSelect( wxCommandEvent& event ) { event.Skip(); }

        virtual void OnWalletSelect( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnButtonSend( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnButtonAddressBook( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnButtonTrade( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnKeyDown( wxKeyEvent& event ) { event.Skip(); }
		virtual void OnMouseEventsAddress( wxMouseEvent& event ) { event.Skip(); }
		virtual void OnSetFocusAddress( wxFocusEvent& event ) { event.Skip(); }
		virtual void OnButtonNew( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnButtonCopy( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnButtonLogo( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnNotebookPageChanged( wxNotebookEvent& event ) { event.Skip(); }
		virtual void OnListColBeginDrag( wxListEvent& event ) { event.Skip(); }
		virtual void OnListItemActivated( wxListEvent& event ) { event.Skip(); }
		virtual void OnPaintListCtrl( wxPaintEvent& event ) { event.Skip(); }


	public:
		wxMenu* m_menuOptions;
		wxMenuItem* m_menuOptionsEncryptWallet;
		wxMenuItem* m_menuOptionsChangeWalletPassphrase;
		wxMenuItem* m_menuHelpHomePage;
		wxMenuItem* m_menuShowMiningPanel;
		wxStatusBar* m_statusBar;
		wxListCtrl* m_listCtrlAll;
		wxListCtrl* m_listCtrlSent;
		wxListCtrl* m_listCtrlReceived;
		wxListCtrl *m_MiningStatus;
		wxListCtrl *m_MiningPoolSelect;
		wxTextCtrl* m_MiningTestworkStats;

		CMainFrameBase( wxWindow* parent, wxWindowID id = wxID_MAINFRAME, const wxString& title = _("SolidCoin 2.01"), const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxSize( 723,484 ), long style = wxDEFAULT_FRAME_STYLE|wxRESIZE_BORDER|wxTAB_TRAVERSAL );
		~CMainFrameBase();

};

///////////////////////////////////////////////////////////////////////////////
/// Class CTxDetailsDialogBase
///////////////////////////////////////////////////////////////////////////////
class CTxDetailsDialogBase : public wxDialog
{
	private:

	protected:
		wxHtmlWindow* m_htmlWin;
		wxButton* m_buttonOK;

		// Virtual event handlers, overide them in your derived class
		virtual void OnButtonOK( wxCommandEvent& event ) { event.Skip(); }


	public:

		CTxDetailsDialogBase( wxWindow* parent, wxWindowID id = wxID_ANY, const wxString& title = _("Transaction Details"), const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxSize( 620,450 ), long style = wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER );
		~CTxDetailsDialogBase();

};

///////////////////////////////////////////////////////////////////////////////
/// Class COptionsDialogBase
///////////////////////////////////////////////////////////////////////////////
class COptionsDialogBase : public wxDialog
{
	private:

	protected:
		wxListBox* m_listBox;
		wxScrolledWindow* m_scrolledWindow;
		wxPanel* m_panelMain;

		wxCheckBox* m_checkBoxStartOnSystemStartup;
		wxCheckBox* m_checkBoxMinimizeToTray;
		wxCheckBox* m_checkBoxUseUPnP;
		wxCheckBox* m_checkBoxMinimizeOnClose;
		wxCheckBox* m_checkBoxUseProxy;

		wxStaticText* m_staticTextProxyIP;
		wxTextCtrl* m_textCtrlProxyIP;
		wxStaticText* m_staticTextProxyPort;
		wxTextCtrl* m_textCtrlProxyPort;

		wxTextCtrl* m_MiningID;
		wxComboBox* m_MiningShareTarget;

		wxPanel* m_panelMining;

		wxStaticText* m_staticText321;
		wxStaticText* m_staticText69;
		wxButton* m_buttonOK;
		wxButton* m_buttonCancel;
		wxButton* m_buttonApply;

		wxPanel* m_panelTiming;
		wxComboBox* m_CBTime_NTP;
		wxComboBox* m_CBTime_SCTime;
		wxTextCtrl* m_Time_NTPServer;

		// Virtual event handlers, overide them in your derived class
		virtual void OnListBox( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnCheckBoxMinimizeToTray( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnCheckBoxUseProxy( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnKillFocusProxy( wxFocusEvent& event ) { event.Skip(); }
		virtual void OnButtonOK( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnButtonCancel( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnButtonApply( wxCommandEvent& event ) { event.Skip(); }


	public:

		COptionsDialogBase( wxWindow* parent, wxWindowID id = wxID_ANY, const wxString& title = _("SolidCoin Options"), const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxSize( 540,360 ), long style = wxDEFAULT_DIALOG_STYLE );
		~COptionsDialogBase();

};

///////////////////////////////////////////////////////////////////////////////
/// Class CAboutDialogBase
///////////////////////////////////////////////////////////////////////////////
class CAboutDialogBase : public wxDialog
{
	private:

	protected:
		wxStaticBitmap* m_bitmap;

		wxStaticText* m_staticText40;

		wxStaticText* m_staticTextMain;


		wxButton* m_buttonOK;
		wxBoxSizer* bSizer63;

		// Virtual event handlers, overide them in your derived class
		virtual void OnButtonOK( wxCommandEvent& event ) { event.Skip(); }


	public:
		wxStaticText* m_staticTextVersion;

		CAboutDialogBase( wxWindow* parent, wxWindowID id = wxID_ANY, const wxString& title = _("About SolidCoin"), const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxSize( 532,333 ), long style = wxDEFAULT_DIALOG_STYLE );
		~CAboutDialogBase();

};

///////////////////////////////////////////////////////////////////////////////
/// Class CSendDialogBase
///////////////////////////////////////////////////////////////////////////////
class CSendDialogBase : public wxDialog
{
	private:

	protected:


		wxStaticText* m_staticTextInstructions;

		wxStaticText* m_staticText36;
		wxTextCtrl* m_textCtrlAddress;
		wxButton* m_buttonPaste;
		wxButton* m_buttonAddress;
		wxStaticText* m_staticText19;
		wxTextCtrl* m_textCtrlAmount;
		wxStaticText* m_staticTextFee;
		wxTextCtrl* m_textCtrlFee;
		wxStaticText* m_staticTextTotal;
		wxTextCtrl* m_textCtrlTotal;

		wxStaticText* m_staticTextBalance;
		wxTextCtrl* m_textCtrlBalance;

		wxButton* m_buttonSend;
		wxButton* m_buttonCancel;

		// Virtual event handlers, overide them in your derived class
		virtual void OnKeyDown( wxKeyEvent& event ) { event.Skip(); }
		virtual void OnTextAddress( wxCommandEvent& event ) { event.Skip(); }

		virtual void OnButtonPaste( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnButtonAddressBook( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnKillFocusAmount( wxFocusEvent& event ) { event.Skip(); }
		virtual void OnButtonSend( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnButtonCancel( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnAmountTextUpdate( wxCommandEvent& event ) { event.Skip(); }


	public:

		CSendDialogBase( wxWindow* parent, wxWindowID id = wxID_ANY, const wxString& title = _("Send Coins"), const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxSize( 498,157 ), long style = wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER );
		~CSendDialogBase();

};

///////////////////////////////////////////////////////////////////////////////
/// Class CSendingDialogBase
///////////////////////////////////////////////////////////////////////////////
class CSendingDialogBase : public wxDialog
{
	private:

	protected:
		wxStaticText* m_staticTextSending;
		wxTextCtrl* m_textCtrlStatus;

		wxButton* m_buttonOK;
		wxButton* m_buttonCancel;

		// Virtual event handlers, overide them in your derived class
		virtual void OnClose( wxCloseEvent& event ) { event.Skip(); }
		virtual void OnPaint( wxPaintEvent& event ) { event.Skip(); }
		virtual void OnButtonOK( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnButtonCancel( wxCommandEvent& event ) { event.Skip(); }


	public:

		CSendingDialogBase( wxWindow* parent, wxWindowID id = wxID_ANY, const wxString& title = _("Sending..."), const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxSize( 442,151 ), long style = wxDEFAULT_DIALOG_STYLE );
		~CSendingDialogBase();

};

///////////////////////////////////////////////////////////////////////////////
/// Class CAddressBookDialogBase
///////////////////////////////////////////////////////////////////////////////
class CAddressBookDialogBase : public wxDialog
{
	private:

	protected:
		wxNotebook* m_notebook;
		wxPanel* m_panelSending;

		wxStaticText* m_staticText55;
		wxListCtrl* m_listCtrlSending;
		wxPanel* m_panelReceiving;

		wxStaticText* m_staticText45;

		wxListCtrl* m_listCtrlReceiving;

		wxButton* m_buttonDelete;
		wxButton* m_buttonCopy;
		wxButton* m_buttonEdit;
		wxButton* m_buttonNew;
		wxButton* m_buttonOK;

		// Virtual event handlers, overide them in your derived class
		virtual void OnClose( wxCloseEvent& event ) { event.Skip(); }
		virtual void OnNotebookPageChanged( wxNotebookEvent& event ) { event.Skip(); }
		virtual void OnListEndLabelEdit( wxListEvent& event ) { event.Skip(); }
		virtual void OnListItemActivated( wxListEvent& event ) { event.Skip(); }
		virtual void OnListItemSelected( wxListEvent& event ) { event.Skip(); }
		virtual void OnButtonDelete( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnButtonCopy( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnButtonEdit( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnButtonNew( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnButtonOK( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnButtonCancel( wxCommandEvent& event ) { event.Skip(); }


	public:
		wxButton* m_buttonCancel;

		CAddressBookDialogBase( wxWindow* parent, wxWindowID id = wxID_ANY, const wxString& title = _("Address Book"), const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxSize( 610,390 ), long style = wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER );
		~CAddressBookDialogBase();

};

///////////////////////////////////////////////////////////////////////////////
/// Class CGetTextFromUserDialogBase
///////////////////////////////////////////////////////////////////////////////
class CGetTextFromUserDialogBase : public wxDialog
{
	private:

	protected:
        wxBoxSizer* bSizer79;
		wxStaticText* m_staticTextMessage1;
		wxTextCtrl* m_textCtrl1;
		wxStaticText* m_staticTextMessage2;
		wxTextCtrl* m_textCtrl2;


		wxButton* m_buttonOK;
		wxButton* m_buttonCancel;

		// Virtual event handlers, overide them in your derived class
		virtual void OnClose( wxCloseEvent& event ) { event.Skip(); }
		virtual void OnKeyDown( wxKeyEvent& event ) { event.Skip(); }
		virtual void OnButtonOK( wxCommandEvent& event ) { event.Skip(); }
		virtual void OnButtonCancel( wxCommandEvent& event ) { event.Skip(); }


	public:

		CGetTextFromUserDialogBase( wxWindow* parent, wxWindowID id = wxID_ANY, const wxString& title = wxEmptyString, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxSize( 440,138 ), long style = wxDEFAULT_DIALOG_STYLE );
		~CGetTextFromUserDialogBase();

};

#endif //__uibase__
