/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.localserver;

import java.io.IOException;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;

public class EchoHandler
implements HttpRequestHandler {
    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        String method = request.getRequestLine().getMethod().toUpperCase(Locale.ENGLISH);
        if (!("GET".equals(method) || "POST".equals(method) || "PUT".equals(method))) {
            throw new MethodNotSupportedException(method + " not supported by " + this.getClass().getName());
        }
        HttpEntity entity = null;
        if (request instanceof HttpEntityEnclosingRequest) {
            entity = ((HttpEntityEnclosingRequest)request).getEntity();
        }
        byte[] data = entity == null ? new byte[]{} : EntityUtils.toByteArray((HttpEntity)entity);
        ByteArrayEntity bae = new ByteArrayEntity(data);
        if (entity != null) {
            bae.setContentType(entity.getContentType());
        }
        entity = bae;
        response.setStatusCode(200);
        response.setEntity(entity);
    }
}

