/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.tools;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.AbstractToolsAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.RunnerContext;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolHost;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolRunner;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.project.ProjectFactoryRegistry;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.tools.AbstractSoapUIRunner;
import com.eviware.soapui.tools.ToolActionFactory;
import java.io.File;
import org.apache.commons.cli.CommandLine;

public class SoapUIToolRunner
extends AbstractSoapUIRunner
implements ToolHost,
RunnerContext {
    private String iface;
    private String tool;
    private RunnerContext.RunnerStatus status;
    private String projectPassword;
    public static String TITLE = "soapUI 4.5.1 Tool Runner";

    public static void main(String[] args) throws Exception {
        System.exit(new SoapUIToolRunner().runFromCommandLine(args));
    }

    public void setTool(String tool) {
        this.tool = tool;
    }

    public void setInterface(String iface) {
        this.iface = iface;
    }

    public SoapUIToolRunner() {
        super(TITLE);
    }

    public SoapUIToolRunner(String title) {
        super(title);
    }

    public boolean runRunner() throws Exception {
        UISupport.setToolHost(this);
        String projectFile = this.getProjectFile();
        if (!new File(projectFile).exists()) {
            throw new Exception("soapUI project file [" + projectFile + "] not found");
        }
        WsdlProject project = (WsdlProject)ProjectFactoryRegistry.getProjectFactory("wsdl").createNew(projectFile, this.getProjectPassword());
        this.log.info((Object)("Running tools [" + this.tool + "] for interface [" + this.iface + "] in project [" + project.getName() + "]"));
        long startTime = System.nanoTime();
        for (int c = 0; c < project.getInterfaceCount(); ++c) {
            Interface i = project.getInterfaceAt(c);
            if (this.iface != null && !i.getName().equals(this.iface)) continue;
            this.runTool(i);
        }
        long timeTaken = (System.nanoTime() - startTime) / 1000000L;
        this.log.info((Object)("time taken: " + timeTaken + "ms"));
        return true;
    }

    public void runTool(Interface iface) {
        String[] tools;
        AbstractToolsAction<Interface> action = null;
        for (String toolName : tools = this.tool.split(",")) {
            if (toolName == null || toolName.trim().length() == 0) continue;
            action = ToolActionFactory.createToolAction(toolName);
            try {
                if (action != null) {
                    this.log.info((Object)("Running tool [" + toolName + "] for Interface [" + iface.getName() + "]"));
                    action.performHeadless(iface, null);
                    continue;
                }
                this.log.error((Object)("Specified tool [" + toolName + "] is unknown or unsupported."));
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
    }

    public void run(ToolRunner runner) throws Exception {
        this.status = RunnerContext.RunnerStatus.RUNNING;
        runner.setContext(this);
        runner.run();
    }

    public RunnerContext.RunnerStatus getStatus() {
        return this.status;
    }

    public String getTitle() {
        return this.getClass().getSimpleName();
    }

    public String getProjectPassword() {
        return this.projectPassword;
    }

    public void log(String msg) {
        System.out.print(msg);
    }

    public void logError(String msg) {
        System.err.println(msg);
    }

    public void setStatus(RunnerContext.RunnerStatus status) {
        this.status = status;
    }

    public void disposeContext() {
    }

    protected AbstractSoapUIRunner.SoapUIOptions initCommandLineOptions() {
        AbstractSoapUIRunner.SoapUIOptions options = new AbstractSoapUIRunner.SoapUIOptions("toolrunner");
        options.addOption("i", true, "Sets the interface");
        options.addOption("t", true, "Sets the tool to run");
        options.addOption("s", true, "Sets the soapui-settings.xml file to use");
        options.addOption("x", true, "Sets project password for decryption if project is encrypted");
        options.addOption("v", true, "Sets password for soapui-settings.xml file");
        options.addOption("f", true, "Sets report output folder");
        options.addOption("D", true, "Sets system property with name=value");
        options.addOption("G", true, "Sets global property with name=value");
        return options;
    }

    protected boolean processCommandLine(CommandLine cmd) {
        this.setTool(cmd.getOptionValue("t"));
        if (cmd.hasOption("i")) {
            this.setInterface(cmd.getOptionValue("i"));
        }
        if (cmd.hasOption("s")) {
            this.setSettingsFile(this.getCommandLineOptionSubstSpace(cmd, "s"));
        }
        if (cmd.hasOption("x")) {
            this.setProjectPassword(cmd.getOptionValue("x"));
        }
        if (cmd.hasOption("v")) {
            this.setSoapUISettingsPassword(cmd.getOptionValue("v"));
        }
        if (cmd.hasOption("D")) {
            this.setSystemProperties(cmd.getOptionValues("D"));
        }
        if (cmd.hasOption("G")) {
            this.setGlobalProperties(cmd.getOptionValues("G"));
        }
        if (cmd.hasOption("f")) {
            this.setOutputFolder(cmd.getOptionValue("f"));
        }
        return true;
    }

    public void setProjectPassword(String projectPassword) {
        this.projectPassword = projectPassword;
    }
}

