/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.testondemand;

import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.support.ExternalDependency;
import com.eviware.soapui.impl.wsdl.support.InterfaceExternalDependency;
import com.eviware.soapui.impl.wsdl.support.MockServiceExternalDependency;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.iface.Interface;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class DependencyValidator {
    private File filename;

    public File getFilename() {
        return this.filename;
    }

    protected void loadInterfaces(WsdlProject project) {
        for (Interface inf : project.getInterfaceList()) {
            try {
                if (inf instanceof WsdlInterface) {
                    ((WsdlInterface)inf).getWsdlContext().loadIfNecessary();
                    continue;
                }
                ((RestService)inf).getDefinitionContext().loadIfNecessary();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveProject(WsdlProject project) throws IOException {
        boolean shouldCache = project.isCacheDefinitions();
        try {
            File tempFile = File.createTempFile("project-temp-", ".xml", null);
            if (!shouldCache) {
                project.setCacheDefinitions(true);
            }
            project.saveIn(tempFile);
            this.filename = tempFile;
            Object var5_4 = null;
            project.setCacheDefinitions(shouldCache);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            project.setCacheDefinitions(shouldCache);
            throw throwable;
        }
    }

    public boolean isValid(WsdlTestCase testCase) {
        if (testCase != null) {
            WsdlProject project = testCase.getTestSuite().getProject();
            this.validate(project);
            List<ExternalDependency> deps = project.getExternalDependencies();
            for (ExternalDependency d : deps) {
                if (d instanceof InterfaceExternalDependency || d instanceof MockServiceExternalDependency) continue;
                return false;
            }
        }
        return true;
    }

    protected void validate(WsdlProject project) {
        this.loadInterfaces(project);
        try {
            this.saveProject(project);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

