/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.xml.actions;

import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class GoToLineAction
extends AbstractAction {
    private final RSyntaxTextArea editArea;

    public GoToLineAction(RSyntaxTextArea editArea, String title) {
        super(title);
        this.editArea = editArea;
        this.putValue("ShortDescription", "Moves the caret to the specified line");
        if (UISupport.isMac()) {
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("control meta L"));
        } else {
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("ctrl alt L"));
        }
    }

    public void actionPerformed(ActionEvent e) {
        String line = UISupport.prompt("Enter line-number to (1.." + this.editArea.getLineCount() + ")", "Go To Line", String.valueOf(this.editArea.getCaretLineNumber() + 1));
        if (line != null) {
            try {
                int ln = Integer.parseInt(line) - 1;
                if (ln < 0) {
                    ln = 0;
                }
                if (ln >= this.editArea.getLineCount()) {
                    ln = this.editArea.getLineCount() - 1;
                }
                this.editArea.scrollRectToVisible(this.editArea.modelToView(this.editArea.getLineStartOffset(ln)));
                this.editArea.setCaretPosition(this.editArea.getLineStartOffset(ln));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

