/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.xml;

import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

public class XmlObjectConfigurationReader {
    private final XmlObject config;

    public XmlObjectConfigurationReader(XmlObject config) {
        this.config = config;
    }

    public int readInt(String name, int def) {
        if (this.config == null) {
            return def;
        }
        try {
            String str = this.readString(name, null);
            return str == null ? def : Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public long readLong(String name, int def) {
        if (this.config == null) {
            return def;
        }
        try {
            String str = this.readString(name, null);
            return str == null ? (long)def : Long.parseLong(str);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public float readFloat(String name, float def) {
        if (this.config == null) {
            return def;
        }
        try {
            String str = this.readString(name, null);
            return str == null ? def : Float.parseFloat(str);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public String readString(String name, String def) {
        if (this.config == null) {
            return def;
        }
        XmlObject[] paths = this.config.selectPath("$this/" + name);
        if (paths.length == 1) {
            XmlCursor cursor = paths[0].newCursor();
            String textValue = cursor.getTextValue();
            cursor.dispose();
            return textValue;
        }
        return def;
    }

    public String[] readStrings(String name) {
        if (this.config == null) {
            return null;
        }
        XmlObject[] paths = this.config.selectPath("$this/" + name);
        String[] result = new String[paths.length];
        for (int c = 0; c < paths.length; ++c) {
            XmlCursor cursor = paths[c].newCursor();
            result[c] = cursor.getTextValue();
            cursor.dispose();
        }
        return result;
    }

    public boolean readBoolean(String name, boolean def) {
        try {
            return Boolean.valueOf(this.readString(name, String.valueOf(def)));
        }
        catch (Exception e) {
            return def;
        }
    }
}

