/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.resolver;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlRunTestCaseTestStep;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;

public class ChooseAnotherTestCase
implements ResolveContext.Resolver {
    private boolean resolved;
    private WsdlRunTestCaseTestStep runTestStep;
    private WsdlProject project;
    private WsdlTestCase pickedTestCase;

    public ChooseAnotherTestCase(WsdlRunTestCaseTestStep wsdlRunTestCaseTestStep) {
        this.runTestStep = wsdlRunTestCaseTestStep;
        this.project = this.runTestStep.getTestCase().getTestSuite().getProject();
    }

    public String getDescription() {
        return "Choose another test step";
    }

    public String toString() {
        return this.getDescription();
    }

    public String getResolvedPath() {
        return null;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public boolean resolve() {
        TestCaseChangeDialog dialog = new TestCaseChangeDialog("Choose another test case");
        dialog.showAndChoose();
        return this.resolved;
    }

    public WsdlTestCase getPickedTestCase() {
        return this.pickedTestCase;
    }

    private class TestCaseComboRender
    extends DefaultListCellRenderer {
        private TestCaseComboRender() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof TestCase) {
                TestCase item = (TestCase)value;
                this.setIcon(item.getIcon());
                this.setText(item.getName());
            }
            return result;
        }
    }

    private class TestSuiteComboRenderer
    extends DefaultListCellRenderer {
        private TestSuiteComboRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof TestSuite) {
                TestSuite item = (TestSuite)value;
                this.setIcon(item.getIcon());
                this.setText(item.getName());
            }
            return result;
        }
    }

    private class TestCaseChangeDialog
    extends JDialog {
        private JComboBox tSuiteStepCombo;
        private JComboBox tCaseCombo;
        private JButton okBtn;
        private JButton cancelBtn;

        public TestCaseChangeDialog(String title) {
            super(UISupport.getMainFrame(), title, true);
            this.okBtn = new JButton(" Ok ");
            this.cancelBtn = new JButton(" Cancel ");
            this.init();
        }

        private void init() {
            FormLayout layout = new FormLayout("right:pref, 4dlu, 30dlu, 5dlu, 30dlu, min ", "min, pref, 4dlu, pref, 4dlu, pref, min");
            CellConstraints cc = new CellConstraints();
            PanelBuilder panel = new PanelBuilder(layout);
            panel.addLabel("Interface:", cc.xy(1, 2));
            List<TestSuite> tSuites = ChooseAnotherTestCase.this.project.getTestSuiteList();
            DefaultComboBoxModel<TestSuite> sourceStepComboModel = new DefaultComboBoxModel<TestSuite>();
            this.tSuiteStepCombo = new JComboBox(sourceStepComboModel);
            this.tSuiteStepCombo.setRenderer(new TestSuiteComboRenderer());
            for (TestSuite element : tSuites) {
                sourceStepComboModel.addElement(element);
            }
            this.tSuiteStepCombo.setSelectedIndex(0);
            panel.add((Component)this.tSuiteStepCombo, cc.xyw(3, 2, 3));
            this.tCaseCombo = new JComboBox<Object>(((TestSuite)this.tSuiteStepCombo.getSelectedItem()).getTestCaseList().toArray());
            this.tCaseCombo.setRenderer(new TestCaseComboRender());
            panel.addLabel("Operation:", cc.xy(1, 4));
            panel.add((Component)this.tCaseCombo, cc.xyw(3, 4, 3));
            panel.add((Component)this.okBtn, cc.xy(3, 6));
            panel.add((Component)this.cancelBtn, cc.xy(5, 6));
            this.tSuiteStepCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Interface iface = ChooseAnotherTestCase.this.project.getInterfaceByName(((TestSuite)TestCaseChangeDialog.this.tSuiteStepCombo.getSelectedItem()).getName());
                    TestCaseChangeDialog.this.tCaseCombo.removeAllItems();
                    if (iface != null) {
                        TestCaseChangeDialog.this.tCaseCombo.setEnabled(true);
                        for (Operation op : iface.getOperationList()) {
                            TestCaseChangeDialog.this.tCaseCombo.addItem(op);
                        }
                    } else {
                        TestCaseChangeDialog.this.tCaseCombo.setEnabled(false);
                    }
                }
            });
            this.okBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ChooseAnotherTestCase.this.pickedTestCase = (WsdlTestCase)TestCaseChangeDialog.this.tCaseCombo.getSelectedItem();
                    ChooseAnotherTestCase.this.runTestStep.setTargetTestCase(ChooseAnotherTestCase.this.pickedTestCase);
                    ChooseAnotherTestCase.this.resolved = true;
                    TestCaseChangeDialog.this.setVisible(false);
                }
            });
            this.cancelBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ChooseAnotherTestCase.this.resolved = false;
                    TestCaseChangeDialog.this.setVisible(false);
                }
            });
            this.setLocationRelativeTo(UISupport.getParentFrame(this));
            panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.add(panel.getPanel());
        }

        public void showAndChoose() {
            this.pack();
            this.setVisible(true);
        }
    }
}

