/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.propertyexpansion.scrollmenu;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.propertyexpansion.scrollmenu.ScrollableMenuContainer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.Timer;

public class ScrollablePopup
extends JPopupMenu
implements ScrollableMenuContainer {
    private int scrollSpeed = 20;
    private Timer timerUp;
    private Timer timerDown;
    private int visibleItems;
    private int indexVisible = 0;
    private JButton upButton;
    private JButton downButton;
    private Vector<JMenuItem> subMenus = new Vector();
    private double screenHeight = 400.0;
    private double menuHeight;
    private int headerCount;
    private int footerCount;

    public ScrollablePopup(String name) {
        super(name);
        this.timerUp = new Timer(this.scrollSpeed, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScrollablePopup.this.scrollUp();
            }
        });
        this.timerDown = new Timer(this.scrollSpeed, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScrollablePopup.this.scrollDown();
            }
        });
        this.createButtons();
        this.hideButtons();
    }

    public JMenuItem add(JMenuItem menuItem) {
        this.add((Component)menuItem, this.subMenus.size() + this.headerCount + 1 + (this.headerCount == 0 ? 0 : 1));
        this.subMenus.add(menuItem);
        this.menuHeight += menuItem.getPreferredSize().getHeight();
        if (this.menuHeight > this.screenHeight) {
            menuItem.setVisible(false);
            this.downButton.setVisible(true);
        } else {
            ++this.visibleItems;
        }
        return menuItem;
    }

    public Component add(Component comp) {
        if (comp instanceof JMenuItem) {
            return this.add((JMenuItem)comp);
        }
        return super.add(comp);
    }

    public void removeAll() {
        super.removeAll();
        this.headerCount = 0;
        this.footerCount = 0;
        this.menuHeight = 0.0;
        this.indexVisible = 0;
        this.visibleItems = 0;
        this.subMenus.clear();
        this.add(this.upButton);
        this.add(this.downButton);
    }

    private void scrollUp() {
        if (this.indexVisible == 0) {
            this.upButton.setVisible(false);
            return;
        }
        --this.indexVisible;
        ((JComponent)this.subMenus.get(this.indexVisible + this.visibleItems)).setVisible(false);
        ((JComponent)this.subMenus.get(this.indexVisible)).setVisible(true);
        this.downButton.setVisible(true);
        if (this.indexVisible == 0) {
            this.upButton.setVisible(false);
        }
    }

    private void scrollDown() {
        if (this.indexVisible + this.visibleItems == this.subMenus.size()) {
            this.downButton.setVisible(false);
            return;
        }
        if (this.indexVisible + this.visibleItems > this.subMenus.size()) {
            return;
        }
        try {
            ((JComponent)this.subMenus.get(this.indexVisible)).setVisible(false);
            ((JComponent)this.subMenus.get(this.indexVisible + this.visibleItems)).setVisible(true);
            this.upButton.setVisible(true);
            ++this.indexVisible;
            if (this.indexVisible + this.visibleItems == this.subMenus.size()) {
                this.downButton.setVisible(false);
            }
        }
        catch (Exception eks) {
            eks.printStackTrace();
        }
    }

    private void createButtons() {
        this.upButton = new JButton(UISupport.createImageIcon("/up_arrow.gif"));
        Dimension d = new Dimension(100, 20);
        this.upButton.setPreferredSize(d);
        this.upButton.setBorderPainted(false);
        this.upButton.setFocusPainted(false);
        this.upButton.setRolloverEnabled(true);
        class Up
        extends MouseAdapter {
            Up() {
            }

            public void mouseEntered(MouseEvent e) {
                try {
                    ScrollablePopup.this.timerUp.start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void mouseExited(MouseEvent e) {
                try {
                    ScrollablePopup.this.timerUp.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Up scrollUpListener = new Up();
        this.upButton.addMouseListener(scrollUpListener);
        this.add(this.upButton);
        this.downButton = new JButton(UISupport.createImageIcon("/down_arrow.gif"));
        this.downButton.setPreferredSize(d);
        this.downButton.setBorderPainted(false);
        this.downButton.setFocusPainted(false);
        class Down
        extends MouseAdapter {
            Down() {
            }

            public void mouseEntered(MouseEvent e) {
                try {
                    ScrollablePopup.this.timerDown.start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void mouseExited(MouseEvent e) {
                try {
                    ScrollablePopup.this.timerDown.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Down scrollDownListener = new Down();
        this.downButton.addMouseListener(scrollDownListener);
        this.add((Component)this.downButton, 1 + this.subMenus.size());
    }

    public void hideButtons() {
        this.upButton.setVisible(false);
        this.downButton.setVisible(false);
    }

    public JMenuItem addHeader(JMenuItem header) {
        this.add((Component)header, this.headerCount);
        if (++this.headerCount == 1) {
            this.add((Component)new JSeparator(), 1);
        }
        return header;
    }

    public JMenuItem addHeader(Action action) {
        return this.addHeader(new JMenuItem(action));
    }

    public JMenuItem addFooter(JMenuItem footer) {
        if (this.footerCount == 0) {
            this.add((Component)new JSeparator(), this.subMenus.size() + this.headerCount + 2 + (this.headerCount == 0 ? 0 : 1));
        }
        this.add((Component)footer, this.subMenus.size() + this.headerCount + this.footerCount + 3 + (this.headerCount == 0 ? 0 : 1));
        ++this.footerCount;
        return footer;
    }

    public JMenuItem addFooter(Action action) {
        return this.addFooter(new JMenuItem(action));
    }
}

