/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.views.xml.raw;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.panels.teststeps.amf.AMFRequest;
import com.eviware.soapui.impl.wsdl.support.MessageExchangeModelItem;
import com.eviware.soapui.impl.wsdl.teststeps.AMFRequestTestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.editor.Editor;
import com.eviware.soapui.support.editor.EditorView;
import com.eviware.soapui.support.editor.registry.RequestEditorViewFactory;
import com.eviware.soapui.support.editor.registry.ResponseEditorViewFactory;
import com.eviware.soapui.support.editor.views.xml.raw.RawXmlEditor;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.editor.xml.XmlEditor;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawXmlEditorFactory
implements ResponseEditorViewFactory,
RequestEditorViewFactory {
    public static final String VIEW_ID = "Raw";

    @Override
    public String getViewId() {
        return VIEW_ID;
    }

    @Override
    public EditorView<?> createResponseEditorView(Editor<?> editor, ModelItem modelItem) {
        if (modelItem instanceof MessageExchangeModelItem) {
            return new WsdlMessageExchangeResponseRawXmlEditor((MessageExchangeModelItem)modelItem, (XmlEditor)editor);
        }
        if (modelItem instanceof AbstractHttpRequestInterface) {
            return new HttpResponseRawXmlEditor((AbstractHttpRequest)modelItem, (XmlEditor)editor);
        }
        if (modelItem instanceof WsdlMockResponse) {
            return new WsdlMockResponseRawXmlEditor((WsdlMockResponse)modelItem, (XmlEditor)editor);
        }
        if (modelItem instanceof AMFRequestTestStep) {
            return new AmfResponseRawXmlEditor((AMFRequestTestStep)modelItem, (XmlEditor)editor);
        }
        return null;
    }

    public EditorView<XmlDocument> createRequestEditorView(Editor<?> editor, ModelItem modelItem) {
        if (modelItem instanceof MessageExchangeModelItem) {
            return new WsdlMessageExchangeRequestRawXmlEditor((MessageExchangeModelItem)modelItem, (XmlEditor)editor);
        }
        if (modelItem instanceof AbstractHttpRequestInterface) {
            return new HttpRequestRawXmlEditor((AbstractHttpRequest)modelItem, (XmlEditor)editor);
        }
        if (modelItem instanceof WsdlMockResponse) {
            return new WsdlMockRequestRawXmlEditor((WsdlMockResponse)modelItem, (XmlEditor)editor);
        }
        if (modelItem instanceof AMFRequestTestStep) {
            return new AmfRequestRawXmlEditor((AMFRequestTestStep)modelItem, (XmlEditor)editor);
        }
        return null;
    }

    private static String buildRawContent(StringToStringsMap headers, byte[] data) {
        StringBuffer result = new StringBuffer();
        String status = headers.get("#status#", "");
        if (status != null) {
            result.append(status).append('\n');
        }
        for (String header : headers.keySet()) {
            if (header.equals("#status#")) continue;
            for (String value : (List)headers.get(header)) {
                result.append(header).append(": ").append(value).append('\n');
            }
        }
        result.append('\n');
        if (data != null) {
            result.append(new String(data).trim());
        }
        return result.toString().trim();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AmfRequestRawXmlEditor
    extends RawXmlEditor<XmlDocument> {
        private final AMFRequest request;

        public AmfRequestRawXmlEditor(AMFRequestTestStep requestTestStep, XmlEditor<XmlDocument> editor) {
            super(RawXmlEditorFactory.VIEW_ID, editor, "The actual content of the last request");
            this.request = requestTestStep.getAMFRequest();
            this.request.addPropertyChangeListener("response", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setXml("");
        }

        @Override
        public String getContent() {
            if (this.request.getResponse() == null) {
                return "";
            }
            byte[] rawRequestData = this.request.getResponse().getRawRequestData();
            int maxSize = (int)SoapUI.getSettings().getLong(UISettings.RAW_RESPONSE_MESSAGE_SIZE, 10000L);
            if (maxSize < rawRequestData.length) {
                return new String(Arrays.copyOf(rawRequestData, maxSize));
            }
            return new String(rawRequestData);
        }

        @Override
        public void release() {
            this.request.removePropertyChangeListener("response", this);
            super.release();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AmfResponseRawXmlEditor
    extends RawXmlEditor<XmlDocument> {
        private final AMFRequest request;

        public AmfResponseRawXmlEditor(AMFRequestTestStep requestTestStep, XmlEditor<XmlDocument> editor) {
            super(RawXmlEditorFactory.VIEW_ID, editor, "The actual content of the last received response");
            this.request = requestTestStep.getAMFRequest();
            this.request.addPropertyChangeListener("response", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setXml("");
        }

        @Override
        public String getContent() {
            if (this.request.getResponse() == null) {
                return "<missing response>";
            }
            byte[] rawResponseData = this.request.getResponse().getRawResponseData();
            int maxSize = (int)SoapUI.getSettings().getLong(UISettings.RAW_RESPONSE_MESSAGE_SIZE, 10000L);
            if (maxSize < rawResponseData.length) {
                return new String(Arrays.copyOf(rawResponseData, maxSize));
            }
            return new String(rawResponseData);
        }

        @Override
        public void release() {
            this.request.removePropertyChangeListener("response", this);
            super.release();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WsdlMessageExchangeRequestRawXmlEditor
    extends RawXmlEditor<XmlDocument> {
        private final MessageExchangeModelItem request;

        public WsdlMessageExchangeRequestRawXmlEditor(MessageExchangeModelItem request, XmlEditor<XmlDocument> editor) {
            super(RawXmlEditorFactory.VIEW_ID, editor, "The raw request data");
            this.request = request;
        }

        @Override
        public String getContent() {
            MessageExchange me = this.request.getMessageExchange();
            return me == null || me.getRawRequestData() == null ? "<missing raw request data>" : new String(me.getRawRequestData());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WsdlMessageExchangeResponseRawXmlEditor
    extends RawXmlEditor<XmlDocument> {
        private final MessageExchangeModelItem response;

        public WsdlMessageExchangeResponseRawXmlEditor(MessageExchangeModelItem response, XmlEditor<XmlDocument> editor) {
            super(RawXmlEditorFactory.VIEW_ID, editor, "The raw response data");
            this.response = response;
        }

        @Override
        public String getContent() {
            MessageExchange me = this.response.getMessageExchange();
            return me == null || me.getRawResponseData() == null ? "<missing raw response data>" : new String(me.getRawResponseData());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WsdlMockResponseRawXmlEditor
    extends RawXmlEditor<XmlDocument> {
        private final WsdlMockResponse request;

        public WsdlMockResponseRawXmlEditor(WsdlMockResponse response, XmlEditor<XmlDocument> editor) {
            super(RawXmlEditorFactory.VIEW_ID, editor, "The actual content of the last returned Mock Response");
            this.request = response;
            response.addPropertyChangeListener(WsdlMockResponse.MOCKRESULT_PROPERTY, this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(WsdlMockResponse.MOCKRESULT_PROPERTY)) {
                this.setXml("");
            }
        }

        @Override
        public String getContent() {
            if (this.request.getMockResult() == null) {
                return "<missing response>";
            }
            StringToStringsMap headers = this.request.getMockResult().getResponseHeaders();
            byte[] data = this.request.getMockResult().getRawResponseData();
            return RawXmlEditorFactory.buildRawContent(headers, data);
        }

        @Override
        public void release() {
            this.request.removePropertyChangeListener(WsdlMockResponse.MOCKRESULT_PROPERTY, this);
            super.release();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WsdlMockRequestRawXmlEditor
    extends RawXmlEditor<XmlDocument> {
        private final WsdlMockResponse request;

        public WsdlMockRequestRawXmlEditor(WsdlMockResponse response, XmlEditor<XmlDocument> editor) {
            super(RawXmlEditorFactory.VIEW_ID, editor, "The actual content of the last received mock request");
            this.request = response;
            response.addPropertyChangeListener(WsdlMockResponse.MOCKRESULT_PROPERTY, this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(WsdlMockResponse.MOCKRESULT_PROPERTY)) {
                this.setXml("");
            }
        }

        @Override
        public String getContent() {
            if (this.request.getMockResult() == null) {
                return "<missing request>";
            }
            return RawXmlEditorFactory.buildRawContent(this.request.getMockResult().getMockRequest().getRequestHeaders(), this.request.getMockResult().getMockRequest().getRawRequestData());
        }

        @Override
        public void release() {
            this.request.removePropertyChangeListener(WsdlMockResponse.MOCKRESULT_PROPERTY, this);
            super.release();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HttpResponseRawXmlEditor
    extends RawXmlEditor<XmlDocument> {
        private final AbstractHttpRequest<?> request;

        public HttpResponseRawXmlEditor(AbstractHttpRequest<?> request, XmlEditor<XmlDocument> editor) {
            super(RawXmlEditorFactory.VIEW_ID, editor, "The actual content of the last received response");
            this.request = request;
            request.addPropertyChangeListener(WsdlRequest.RESPONSE_PROPERTY, this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(WsdlRequest.RESPONSE_PROPERTY)) {
                this.setXml("");
            }
        }

        @Override
        public String getContent() {
            if (this.request.getResponse() == null || this.request.getResponse().getRawResponseData() == null || this.request.getResponse().getRawResponseData().length == 0) {
                return "<missing raw response data>";
            }
            byte[] rawResponseData = this.request.getResponse().getRawResponseData();
            int maxSize = (int)SoapUI.getSettings().getLong(UISettings.RAW_RESPONSE_MESSAGE_SIZE, 10000L);
            if (maxSize < rawResponseData.length) {
                return new String(Arrays.copyOf(rawResponseData, maxSize));
            }
            return new String(rawResponseData);
        }

        @Override
        public void release() {
            this.request.removePropertyChangeListener(WsdlRequest.RESPONSE_PROPERTY, this);
            super.release();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HttpRequestRawXmlEditor
    extends RawXmlEditor<XmlDocument> {
        private final AbstractHttpRequest<?> request;

        public HttpRequestRawXmlEditor(AbstractHttpRequest<?> request, XmlEditor<XmlDocument> editor) {
            super(RawXmlEditorFactory.VIEW_ID, editor, "The actual content of the last submitted request");
            this.request = request;
            request.addPropertyChangeListener(WsdlRequest.RESPONSE_PROPERTY, this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(WsdlRequest.RESPONSE_PROPERTY)) {
                this.setXml("");
            }
        }

        @Override
        public String getContent() {
            if (this.request.getResponse() == null || this.request.getResponse().getRawRequestData() == null || this.request.getResponse().getRawRequestData().length == 0) {
                return "<missing raw request data>";
            }
            byte[] rawRequestData = this.request.getResponse().getRawRequestData();
            int maxSize = (int)SoapUI.getSettings().getLong(UISettings.RAW_REQUEST_MESSAGE_SIZE, 10000L);
            if (maxSize < rawRequestData.length) {
                return new String(Arrays.copyOf(rawRequestData, maxSize));
            }
            return new String(rawRequestData);
        }

        @Override
        public void release() {
            this.request.removePropertyChangeListener(WsdlRequest.RESPONSE_PROPERTY, this);
            super.release();
        }
    }
}

