/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.dnd.handlers;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.actions.request.AddRequestToMockServiceAction;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.SoapUIAction;
import com.eviware.soapui.support.dnd.handlers.AbstractAfterModelItemDropHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestToMockOperationDropHandler
extends AbstractAfterModelItemDropHandler<WsdlRequest, WsdlMockOperation> {
    public RequestToMockOperationDropHandler() {
        super(WsdlRequest.class, WsdlMockOperation.class);
    }

    @Override
    boolean canCopyAfter(WsdlRequest source, WsdlMockOperation target) {
        return source.getOperation() == target.getOperation();
    }

    @Override
    boolean canMoveAfter(WsdlRequest source, WsdlMockOperation target) {
        return source.getOperation() == target.getOperation();
    }

    @Override
    boolean copyAfter(WsdlRequest source, WsdlMockOperation target) {
        return this.addRequestToMockOperation(source, target);
    }

    private boolean addRequestToMockOperation(WsdlRequest request, WsdlMockOperation mockOperation) {
        if (!UISupport.confirm("Add request to MockOperation [" + mockOperation.getName() + "]", "Add Request")) {
            return false;
        }
        SoapUIAction action = SoapUI.getActionRegistry().getAction("AddRequestToMockServiceAction");
        ((AddRequestToMockServiceAction)action).perform(request, (Object)mockOperation);
        return true;
    }

    @Override
    boolean moveAfter(WsdlRequest source, WsdlMockOperation target) {
        return this.addRequestToMockOperation(source, target);
    }

    @Override
    String getCopyAfterInfo(WsdlRequest source, WsdlMockOperation target) {
        return "Add Request [" + source.getName() + "] to MockOperation [" + target.getName() + "]";
    }

    @Override
    String getMoveAfterInfo(WsdlRequest source, WsdlMockOperation target) {
        return this.getCopyAfterInfo(source, target);
    }
}

