/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JCollapsiblePanel;
import com.eviware.soapui.support.components.JHyperlinkLabel;
import com.eviware.soapui.support.components.SimpleForm;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.VerticalLayout;

public class MetricsPanel
extends JPanel {
    private Map<String, Metric> metrics = new HashMap<String, Metric>();
    private Map<String, MetricsSection> sections = new HashMap<String, MetricsSection>();

    public MetricsPanel() {
        super((LayoutManager)new VerticalLayout());
        this.setBackground(Color.WHITE);
    }

    public MetricsSection addSection(String name) {
        MetricsSection section = new MetricsSection(name);
        this.sections.put(name, section);
        this.add(section);
        return section;
    }

    public MetricsSection getSection(String name) {
        return this.sections.get(name);
    }

    public boolean setMetric(String label, int value) {
        return this.setMetric(label, String.valueOf(value));
    }

    public boolean setMetric(String label, String value) {
        if (!this.hasMetric(label)) {
            return false;
        }
        this.metrics.get(label).set(value);
        return true;
    }

    public boolean hasMetric(String name) {
        return this.metrics.containsKey(name);
    }

    private class InternalCellRenderer
    extends DefaultTableCellRenderer {
        public InternalCellRenderer() {
            this.setHorizontalAlignment(2);
        }

        public Component getTableCellRendererComponent(JTable arg0, Object arg1, boolean arg2, boolean arg3, int arg4, int arg5) {
            Component result = super.getTableCellRendererComponent(arg0, arg1, arg2, arg3, arg4, arg5);
            this.setBorder(BorderFactory.createEmptyBorder(3, 1, 3, 2));
            return result;
        }
    }

    public static class InternalHeaderRenderer
    extends DefaultTableCellRenderer {
        private Font boldFont;
        private final Color color;

        public InternalHeaderRenderer(Color color) {
            this.color = color;
            this.setHorizontalAlignment(2);
            this.boldFont = this.getFont().deriveFont(1);
        }

        public InternalHeaderRenderer() {
            this((Color)null);
        }

        public Component getTableCellRendererComponent(JTable arg0, Object arg1, boolean arg2, boolean arg3, int arg4, int arg5) {
            JComponent result = (JComponent)super.getTableCellRendererComponent(arg0, arg1, arg2, arg3, arg4, arg5);
            this.setFont(this.boldFont);
            if (this.color != null) {
                this.setBackground(this.color);
            }
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 2, 1, 2)));
            return result;
        }
    }

    private class MetricsForm
    extends SimpleForm {
        private Dimension labelDimensions = new Dimension(200, 16);

        public MetricsForm() {
            this.addSpace(7);
            this.setRowSpacing(3);
        }

        public JPanel finish() {
            this.addSpace(7);
            JPanel formPanel = this.getPanel();
            formPanel.setBackground(Color.WHITE);
            formPanel.setOpaque(true);
            return formPanel;
        }

        public Metric addMetric(String labelText, ImageIcon icon, boolean isHyperlink) {
            return this.addMetric(labelText, "", icon, isHyperlink);
        }

        public Metric addMetric(String labelText, ImageIcon icon) {
            return this.addMetric(labelText, "", icon, false);
        }

        public Metric addMetric(String labelText, String text, ImageIcon icon, boolean isHyperlink) {
            JLabel label = new JLabel(labelText, icon, 2);
            UISupport.setFixedSize(label, this.labelDimensions);
            label.setIconTextGap(5);
            label.setBorder(BorderFactory.createEmptyBorder(2, icon == null ? 16 : 14, 0, 0));
            JLabel textField = null;
            textField = isHyperlink ? (JLabel)this.append(labelText, label, new JHyperlinkLabel(text)) : this.append(labelText, label, new JLabel(text));
            textField.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
            textField.setBackground(Color.WHITE);
            Metric metric = new Metric(textField);
            MetricsPanel.this.metrics.put(labelText, metric);
            return metric;
        }
    }

    public class MetricsSection
    extends JCollapsiblePanel {
        private MetricsForm form;

        public MetricsSection(String name) {
            super(name);
            this.form = new MetricsForm();
            this.setContentPanel(this.form.getPanel());
        }

        public Metric addMetric(ImageIcon icon, String label, MetricType type) {
            return this.form.addMetric(label, icon, type == MetricType.URL);
        }

        public Metric addMetric(ImageIcon icon, String label) {
            return this.addMetric(icon, label, MetricType.STRING);
        }

        public Metric addMetric(String label) {
            return this.addMetric(null, label, MetricType.STRING);
        }

        public void finish() {
            this.form.finish();
        }

        public MetricsSection clear() {
            this.form = new MetricsForm();
            this.setContentPanel(this.form.getPanel());
            return this;
        }

        public Metric addMetric(String label, MetricType type) {
            return this.addMetric(null, label, type);
        }

        public JXTable addTable(TableModel model) {
            JXTable table = new JXTable(model);
            table.setBorder(null);
            table.setShowGrid(false);
            table.setAutoResizeMode(0);
            table.setSortable(false);
            table.getColumn(0).setWidth(195);
            table.getColumn(0).setMinWidth(195);
            InternalHeaderRenderer internalHeaderRenderer = new InternalHeaderRenderer(table.getTableHeader().getBackground());
            InternalCellRenderer internalCellRenderer = new InternalCellRenderer();
            for (int c = 0; c < table.getColumnCount(); ++c) {
                table.getColumn(c).setHeaderRenderer(internalHeaderRenderer);
                table.getColumn(c).setCellRenderer(internalCellRenderer);
            }
            table.getTableHeader().setReorderingAllowed(false);
            table.getTableHeader().setBackground(Color.WHITE);
            JScrollPane scrollPane = new JScrollPane((Component)table);
            scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 14, 0, 14));
            this.form.addComponent(scrollPane);
            table.setPreferredScrollableViewportSize(new Dimension(100, 250));
            scrollPane.setBackground(Color.WHITE);
            scrollPane.getViewport().setBackground(Color.WHITE);
            scrollPane.setOpaque(true);
            table.setBackground(Color.WHITE);
            table.setOpaque(true);
            return table;
        }
    }

    public class Metric {
        private final JLabel label;

        public Metric(JLabel label) {
            this.label = label;
        }

        public void set(String value) {
            this.label.setText(value);
        }

        public void set(int value) {
            this.set(String.valueOf(value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetricType {
        STRING,
        URL;

    }
}

