/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.SoapUI;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class JEditorStatusBar
extends JPanel
implements CaretListener {
    private JLabel caretLabel;
    private JLabel infoLabel;
    private JEditorStatusBarTarget target;
    private JPanel statusPanel;

    public JEditorStatusBar() {
        this((JEditorStatusBarTarget)null);
    }

    public JEditorStatusBar(JEditorStatusBarTarget target) {
        this.target = target;
        this.caretLabel = new JLabel();
        this.caretLabel.setPreferredSize(new Dimension(60, 16));
        this.infoLabel = new JLabel();
        this.infoLabel.setVisible(false);
        this.caretLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.LIGHT_GRAY), BorderFactory.createMatteBorder(0, 1, 0, 0, Color.WHITE)));
        ButtonBarBuilder builder = new ButtonBarBuilder((JPanel)this);
        builder.addGriddedGrowing((JComponent)this.infoLabel);
        builder.addStrut(Sizes.pixel((int)2));
        this.statusPanel = new JPanel(new BorderLayout());
        this.statusPanel.setPreferredSize(new Dimension(60, 16));
        this.statusPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.LIGHT_GRAY), BorderFactory.createMatteBorder(0, 1, 0, 0, Color.WHITE)));
        builder.addFixed((JComponent)this.statusPanel);
        builder.addFixed((JComponent)this.caretLabel);
        builder.getPanel();
    }

    public void addNotify() {
        super.addNotify();
        if (this.target != null) {
            this.target.addCaretListener(this);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.target != null) {
            this.target.removeCaretListener(this);
        }
    }

    public void caretUpdate(CaretEvent e) {
        try {
            if (this.target == null) {
                this.caretLabel.setText("");
            } else {
                int offset = this.target.getCaretPosition();
                int line = this.target.getLineOfOffset(offset);
                int column = offset - this.target.getLineStartOffset(line);
                this.caretLabel.setText(" " + (line + 1) + " : " + (column + 1));
            }
        }
        catch (Exception e1) {
            SoapUI.logError(e1);
        }
    }

    public void setTarget(JEditorStatusBarTarget target) {
        if (this.target != null) {
            this.target.removeCaretListener(this);
        }
        this.target = target;
        this.target.addCaretListener(this);
        this.caretUpdate(null);
    }

    public void setInfo(String txt) {
        this.infoLabel.setText(txt);
        this.infoLabel.setVisible(txt != null);
    }

    public void setStatusComponent(JComponent statusComponent) {
        this.statusPanel.removeAll();
        this.statusPanel.add((Component)statusComponent, "Center");
        this.statusPanel.revalidate();
    }

    public static interface JEditorStatusBarTarget {
        public void addCaretListener(CaretListener var1);

        public int getCaretPosition();

        public void removeCaretListener(CaretListener var1);

        public int getLineStartOffset(int var1) throws Exception;

        public int getLineOfOffset(int var1) throws Exception;
    }
}

