/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.XmlHolder;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xmlbeans.XmlException;
import org.w3c.dom.Node;

public class GroovyUtils {
    protected final PropertyExpansionContext context;
    private static Set<String> registeredDrivers = new HashSet<String>();

    public GroovyUtils(PropertyExpansionContext context) {
        this.context = context;
    }

    public final String getProjectPath() {
        Project project = ModelSupport.getModelItemProject(this.context.getModelItem());
        String path = project.getPath();
        int ix = path.lastIndexOf(File.separatorChar);
        return ix == -1 ? "" : path.substring(0, ix);
    }

    public final XmlHolder getXmlHolder(String xmlPropertyOrString) throws Exception {
        try {
            return new XmlHolder(XmlUtils.createXmlObject(xmlPropertyOrString));
        }
        catch (Exception e) {
            return new XmlHolder(this.context, xmlPropertyOrString);
        }
    }

    public final String expand(String property) {
        return PropertyExpander.expandProperties(this.context, property);
    }

    public final void setPropertyValue(String testStep, String property, String value) throws Exception {
        if (!(this.context instanceof TestCaseRunContext)) {
            return;
        }
        TestStep step = ((TestCaseRunContext)this.context).getTestCase().getTestStepByName(testStep);
        if (step == null) {
            throw new Exception("Missing TestStep [" + testStep + "] in TestCase");
        }
        step.setPropertyValue(property, value);
    }

    public final String getXml(Node node) throws XmlException {
        return XmlUtils.createXmlObject(node).xmlText();
    }

    public static void registerJdbcDriver(String name) {
        if (registeredDrivers.contains(name)) {
            return;
        }
        try {
            Driver d = (Driver)Class.forName(name, true, SoapUI.getSoapUICore().getExtensionClassLoader()).newInstance();
            DriverManager.registerDriver(new DriverProxy(d));
            registeredDrivers.add(name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String extractErrorLineNumber(Throwable t) {
        try {
            StringWriter wresult = new StringWriter();
            PrintWriter printWriter = new PrintWriter(wresult);
            t.printStackTrace(printWriter);
            String stackTrace = ((Object)wresult).toString();
            Pattern p = Pattern.compile("at Script\\d+\\.run\\(Script\\d+\\.groovy:(\\d+)\\)");
            Matcher m = p.matcher(stackTrace);
            m.find();
            String b = m.group(1);
            return b;
        }
        catch (Exception e) {
            SoapUI.logError(e, "cannot get error line number!");
            return null;
        }
    }

    static class DriverProxy
    implements Driver {
        private Driver driver;

        DriverProxy(Driver d) {
            this.driver = d;
        }

        public boolean acceptsURL(String u) throws SQLException {
            return this.driver.acceptsURL(u);
        }

        public Connection connect(String u, Properties p) throws SQLException {
            return this.driver.connect(u, p);
        }

        public int getMajorVersion() {
            return this.driver.getMajorVersion();
        }

        public int getMinorVersion() {
            return this.driver.getMinorVersion();
        }

        public DriverPropertyInfo[] getPropertyInfo(String u, Properties p) throws SQLException {
            return this.driver.getPropertyInfo(u, p);
        }

        public boolean jdbcCompliant() {
            return this.driver.jdbcCompliant();
        }

        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return null;
        }
    }
}

