/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import java.text.SimpleDateFormat;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateUtil {
    private static final ThreadLocal<SimpleDateFormat> SIMPLE_FORMAT = DateUtil.createThreadLocal("HH:mm:ss");
    private static final ThreadLocal<SimpleDateFormat> SIMPLE_FORMAT_WITH_MILLIS = DateUtil.createThreadLocal("HH:mm:ss.SSS");
    private static final ThreadLocal<SimpleDateFormat> FULL_FORMAT = DateUtil.createThreadLocal("yyyy-MM-dd HH:mm:ss");
    private static final ThreadLocal<SimpleDateFormat> EXTRA_FULL_FORMAT = DateUtil.createThreadLocal("yyyy-MM-dd HH:mm:ss.SSS");

    private static ThreadLocal<SimpleDateFormat> createThreadLocal(final String format) {
        return new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat(format);
            }
        };
    }

    public static String formatSimple(Date date) {
        return SIMPLE_FORMAT.get().format(date);
    }

    public static String formatFull(Date date) {
        return FULL_FORMAT.get().format(date);
    }

    public static String formatExtraFull(Date date) {
        return EXTRA_FULL_FORMAT.get().format(date);
    }

    public static String formatSimpleWithMillis(Date date) {
        return SIMPLE_FORMAT_WITH_MILLIS.get().format(date);
    }
}

