/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.ui;

import com.eviware.soapui.config.MalformedXmlAttributeConfig;
import com.eviware.soapui.config.MalformedXmlConfig;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.impl.swing.JFormDialog;
import com.eviware.x.impl.swing.JTextFieldFormField;
import javax.swing.JComponent;

public class MalformedXmlAdvancedSettingsPanel {
    private JFormDialog dialog;
    private MalformedXmlConfig configuration;
    private MalformedXmlAttributeConfig attributeConfig;

    public MalformedXmlAdvancedSettingsPanel(MalformedXmlConfig malformedXmlConfig) {
        this.configuration = malformedXmlConfig;
        this.attributeConfig = malformedXmlConfig.getAttributeMutation();
        this.dialog = (JFormDialog)ADialogBuilder.buildDialog(AdvancedSettings.class);
        this.initDialog();
        ((JTextFieldFormField)this.dialog.getFormField("New element value")).setWidth(20);
        ((JTextFieldFormField)this.dialog.getFormField("New attribute name")).setWidth(20);
        ((JTextFieldFormField)this.dialog.getFormField("New attribute value")).setWidth(20);
    }

    private void initDialog() {
        this.dialog.setBooleanValue("Insert new element", this.configuration.getInsertNewElement());
        this.dialog.setValue("New element value", this.configuration.getNewElementValue());
        this.dialog.setBooleanValue("Change tag name", this.configuration.getChangeTagName());
        this.dialog.setBooleanValue("Leave tag open", this.configuration.getLeaveTagOpen());
        this.dialog.setBooleanValue("Insert invalid char in xml", this.configuration.getInsertInvalidCharacter());
        this.dialog.setBooleanValue("Mutate attributes", this.attributeConfig.getMutateAttributes());
        this.dialog.setBooleanValue("Insert invalid chars in attribute", this.attributeConfig.getInsertInvalidChars());
        this.dialog.setBooleanValue("Leave attribute open", this.attributeConfig.getLeaveAttributeOpen());
        this.dialog.setBooleanValue("Add new attribute", this.attributeConfig.getAddNewAttribute());
        this.dialog.setValue("New attribute name", this.attributeConfig.getNewAttributeName());
        this.dialog.setValue("New attribute value", this.attributeConfig.getNewAttributeValue());
        this.dialog.getFormField("Insert new element").addFormFieldListener(new XFormFieldListener(){

            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                MalformedXmlAdvancedSettingsPanel.this.configuration.setInsertNewElement(Boolean.parseBoolean(newValue));
            }
        });
        this.dialog.getFormField("New element value").addFormFieldListener(new XFormFieldListener(){

            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                MalformedXmlAdvancedSettingsPanel.this.configuration.setNewElementValue(newValue);
            }
        });
        this.dialog.getFormField("Change tag name").addFormFieldListener(new XFormFieldListener(){

            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                MalformedXmlAdvancedSettingsPanel.this.configuration.setChangeTagName(Boolean.parseBoolean(newValue));
            }
        });
        this.dialog.getFormField("Leave tag open").addFormFieldListener(new XFormFieldListener(){

            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                MalformedXmlAdvancedSettingsPanel.this.configuration.setLeaveTagOpen(Boolean.parseBoolean(newValue));
            }
        });
        this.dialog.getFormField("Mutate attributes").addFormFieldListener(new XFormFieldListener(){

            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                MalformedXmlAdvancedSettingsPanel.this.attributeConfig.setMutateAttributes(Boolean.parseBoolean(newValue));
            }
        });
        this.dialog.getFormField("Insert invalid chars in attribute").addFormFieldListener(new XFormFieldListener(){

            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                MalformedXmlAdvancedSettingsPanel.this.attributeConfig.setInsertInvalidChars(Boolean.parseBoolean(newValue));
            }
        });
        this.dialog.getFormField("Leave attribute open").addFormFieldListener(new XFormFieldListener(){

            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                MalformedXmlAdvancedSettingsPanel.this.attributeConfig.setLeaveAttributeOpen(Boolean.parseBoolean(newValue));
            }
        });
        this.dialog.getFormField("Add new attribute").addFormFieldListener(new XFormFieldListener(){

            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                MalformedXmlAdvancedSettingsPanel.this.attributeConfig.setAddNewAttribute(Boolean.parseBoolean(newValue));
            }
        });
        this.dialog.getFormField("New attribute name").addFormFieldListener(new XFormFieldListener(){

            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                MalformedXmlAdvancedSettingsPanel.this.attributeConfig.setNewAttributeName(newValue);
            }
        });
        this.dialog.getFormField("New attribute value").addFormFieldListener(new XFormFieldListener(){

            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                MalformedXmlAdvancedSettingsPanel.this.attributeConfig.setNewAttributeValue(newValue);
            }
        });
        this.dialog.getFormField("Insert invalid char in xml").addFormFieldListener(new XFormFieldListener(){

            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                MalformedXmlAdvancedSettingsPanel.this.configuration.setInsertInvalidCharacter(Boolean.parseBoolean(newValue));
            }
        });
    }

    public JComponent getPanel() {
        return this.dialog.getPanel();
    }

    public void release() {
        this.dialog.release();
        this.dialog = null;
        this.configuration = null;
        this.attributeConfig = null;
    }

    @AForm(description="Malformed XML Configuration", name="Malformed XML Configuration")
    protected static interface AdvancedSettings {
        @AField(description="", name="Insert new element", type=AField.AFieldType.BOOLEAN)
        public static final String INSERT_NEW_ELEMENT = "Insert new element";
        @AField(description="", name="New element value", type=AField.AFieldType.STRING)
        public static final String NEW_ELEMENT_VALUE = "New element value";
        @AField(description="", name="Change tag name", type=AField.AFieldType.BOOLEAN)
        public static final String CHANGE_TAG_NAME = "Change tag name";
        @AField(description="", name="Leave tag open", type=AField.AFieldType.BOOLEAN)
        public static final String LEAVE_TAG_OPEN = "Leave tag open";
        @AField(description="", name="Insert invalid char in xml", type=AField.AFieldType.BOOLEAN)
        public static final String INSERT_INVALID_CHARACTER = "Insert invalid char in xml";
        @AField(description="", name="Mutate attributes", type=AField.AFieldType.BOOLEAN)
        public static final String MUTATE_ATTRIBUTES = "Mutate attributes";
        @AField(description="", name="Insert invalid chars in attribute", type=AField.AFieldType.BOOLEAN)
        public static final String INSERT_INVALID_CHARS = "Insert invalid chars in attribute";
        @AField(description="", name="Leave attribute open", type=AField.AFieldType.BOOLEAN)
        public static final String LEAVE_ATTRIBUTE_OPEN = "Leave attribute open";
        @AField(description="", name="Add new attribute", type=AField.AFieldType.BOOLEAN)
        public static final String ADD_NEW_ATTRIBUTE = "Add new attribute";
        @AField(description="", name="New attribute name", type=AField.AFieldType.STRING)
        public static final String NEW_ATTRIBUTE_NAME = "New attribute name";
        @AField(description="", name="New attribute value", type=AField.AFieldType.STRING)
        public static final String NEW_ATTRIBUTE_VALUE = "New attribute value";
    }
}

