/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.scan;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.SecurityScanConfig;
import com.eviware.soapui.config.XmlBombSecurityScanConfig;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStepResult;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.security.SecurityCheckedParameter;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.security.scan.AbstractSecurityScanWithProperties;
import com.eviware.soapui.security.ui.XmlBombSecurityScanConfigPanel;
import com.eviware.soapui.support.types.StringToStringMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBombSecurityScan
extends AbstractSecurityScanWithProperties {
    public static final String TYPE = "XmlBombSecurityScan";
    public static final String NAME = "XML Bomb";
    private static final String DEFAULT_PREFIX = "xmlbomb";
    private int currentIndex = 0;
    private XmlBombSecurityScanConfig xmlBombConfig;
    private Map<SecurityCheckedParameter, ArrayList<String>> parameterMutations = new HashMap<SecurityCheckedParameter, ArrayList<String>>();
    private boolean mutation;

    public XmlBombSecurityScan(TestStep testStep, SecurityScanConfig config, ModelItem parent, String icon) {
        super(testStep, config, parent, icon);
        if (config.getConfig() == null || !(config.getConfig() instanceof XmlBombSecurityScanConfig)) {
            this.initXmlBombConfig();
        } else {
            this.xmlBombConfig = (XmlBombSecurityScanConfig)config.getConfig();
        }
        this.getExecutionStrategy().setImmutable(true);
    }

    private void initXmlBombConfig() {
        ((SecurityScanConfig)this.getConfig()).setConfig((XmlObject)XmlBombSecurityScanConfig.Factory.newInstance());
        this.xmlBombConfig = (XmlBombSecurityScanConfig)((SecurityScanConfig)this.getConfig()).getConfig();
        this.xmlBombConfig.setAttachXmlBomb(false);
        this.xmlBombConfig.setXmlAttachmentPrefix(DEFAULT_PREFIX);
        this.initDefaultVectors();
    }

    private void initDefaultVectors() {
        XmlString bomb;
        String strLine;
        StringBuffer value;
        BufferedReader br;
        InputStream in;
        try {
            in = SoapUI.class.getResourceAsStream("/com/eviware/soapui/resources/security/xmlbomb/BillionLaughsAttack.xml.txt");
            br = new BufferedReader(new InputStreamReader(in));
            value = new StringBuffer();
            while ((strLine = br.readLine()) != null) {
                value.append(strLine).append('\n');
            }
            in.close();
            bomb = this.xmlBombConfig.addNewXmlBombs();
            bomb.setStringValue(value.toString());
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        try {
            in = SoapUI.class.getResourceAsStream("/com/eviware/soapui/resources/security/xmlbomb/QuadraticBlowup.xml.txt");
            br = new BufferedReader(new InputStreamReader(in));
            value = new StringBuffer();
            while ((strLine = br.readLine()) != null) {
                value.append(strLine).append('\n');
            }
            in.close();
            bomb = this.xmlBombConfig.addNewXmlBombs();
            bomb.setStringValue(value.toString());
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        try {
            in = SoapUI.class.getResourceAsStream("/com/eviware/soapui/resources/security/xmlbomb/ExternalEntity.dtd.txt");
            br = new BufferedReader(new InputStreamReader(in));
            value = new StringBuffer();
            while ((strLine = br.readLine()) != null) {
                value.append(strLine).append('\n');
            }
            in.close();
            bomb = this.xmlBombConfig.addNewXmlBombs();
            bomb.setStringValue(value.toString());
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    @Override
    protected void execute(SecurityTestRunner securityTestRunner, TestStep testStep, SecurityTestRunContext context) {
        try {
            StringToStringMap updatedParams = this.update(testStep, context);
            this.addAttachement(testStep);
            WsdlTestRequestStepResult message = (WsdlTestRequestStepResult)testStep.run((TestCaseRunner)((Object)securityTestRunner), context);
            message.setRequestContent("", false);
            this.createMessageExchange(updatedParams, message, context);
        }
        catch (XmlException e) {
            SoapUI.logError(e, "[XmlBombSecurityScan]XPath seems to be invalid!");
            this.reportSecurityScanException("Property value is not XML or XPath is wrong!");
        }
        catch (Exception e) {
            SoapUI.logError(e, "[XmlBombSecurityScan]Property value is not valid xml!");
            this.reportSecurityScanException("Property value is not XML or XPath is wrong!");
        }
    }

    private StringToStringMap update(TestStep testStep, SecurityTestRunContext context) throws XmlException, Exception {
        StringToStringMap params = new StringToStringMap();
        if (this.parameterMutations.size() == 0) {
            this.mutateParameters(testStep, context);
        }
        for (SecurityCheckedParameter param : this.getParameterHolder().getParameterList()) {
            ArrayList<String> mutations = this.parameterMutations.get(param);
            if (mutations == null || mutations.isEmpty()) continue;
            testStep.getProperties().get(param.getName()).setValue(mutations.get(0));
            params.put(param.getLabel(), mutations.get(0));
            mutations.remove(0);
            break;
        }
        return params;
    }

    private void mutateParameters(TestStep testStep, SecurityTestRunContext context) throws XmlException, Exception {
        this.mutation = true;
        for (SecurityCheckedParameter parameter : this.getParameterHolder().getParameterList()) {
            if (!parameter.isChecked()) continue;
            for (String bomb : this.xmlBombConfig.getXmlBombsList()) {
                if (!this.parameterMutations.containsKey(parameter)) {
                    this.parameterMutations.put(parameter, new ArrayList());
                }
                this.parameterMutations.get(parameter).add(bomb);
            }
        }
    }

    @Override
    public JComponent getAdvancedSettingsPanel() {
        return new XmlBombSecurityScanConfigPanel(this);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public boolean isAttachXmlBomb() {
        return this.xmlBombConfig.getAttachXmlBomb();
    }

    public void setAttachXmlBomb(boolean attach) {
        this.xmlBombConfig.setAttachXmlBomb(attach);
    }

    private Attachment addAttachement(TestStep testStep) {
        Attachment attach = null;
        if (this.isAttachXmlBomb()) {
            WsdlRequest request = (WsdlRequest)((Object)this.getRequest(testStep));
            if (this.currentIndex < this.getXmlBombList().size()) {
                String bomb = this.getXmlBombList().get(this.currentIndex);
                try {
                    File bombFile = File.createTempFile(this.getAttachmentPrefix(), ".xml");
                    BufferedWriter writer = new BufferedWriter(new FileWriter(bombFile));
                    writer.write(bomb);
                    writer.flush();
                    request.setInlineFilesEnabled(false);
                    attach = request.attachFile(bombFile, false);
                    attach.setContentType("text/xml;");
                    ++this.currentIndex;
                }
                catch (IOException e) {
                    SoapUI.logError(e);
                }
            }
        }
        return attach;
    }

    public List<String> getXmlBombList() {
        return this.xmlBombConfig.getXmlBombsList();
    }

    protected void setBombList(List<String> bombList) {
        this.xmlBombConfig.setXmlBombsArray(bombList.toArray(new String[1]));
    }

    public String getAttachmentPrefix() {
        return this.xmlBombConfig.getXmlAttachmentPrefix();
    }

    public void setAttachmentPrefix(String prefix) {
        this.xmlBombConfig.setXmlAttachmentPrefix(prefix);
    }

    @Override
    protected boolean hasNext(TestStep testStep, SecurityTestRunContext context) {
        boolean hasNext = false;
        if (!(this.parameterMutations != null && this.parameterMutations.size() != 0 || this.mutation)) {
            hasNext = this.getParameterHolder().getParameterList().size() > 0;
        } else {
            for (SecurityCheckedParameter param : this.parameterMutations.keySet()) {
                if (this.parameterMutations.get(param).size() <= 0) continue;
                hasNext = true;
                break;
            }
        }
        if (this.isAttachXmlBomb()) {
            boolean bl = hasNext = this.currentIndex < this.getXmlBombList().size();
        }
        if (!hasNext) {
            this.parameterMutations.clear();
            this.mutation = false;
            this.currentIndex = 0;
        }
        return hasNext;
    }

    @Override
    protected void clear() {
        this.parameterMutations.clear();
        this.mutation = false;
        this.currentIndex = 0;
    }

    @Override
    public String getConfigDescription() {
        return "Configures Xml bomb security scan";
    }

    @Override
    public String getConfigName() {
        return "XML Bomb Security Scan";
    }

    @Override
    public String getHelpURL() {
        return "http://soapui.org/Security/xml-bomb.html";
    }
}

