/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.scan;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.CrossSiteScriptingScanConfig;
import com.eviware.soapui.config.SecurityScanConfig;
import com.eviware.soapui.config.StrategyTypeConfig;
import com.eviware.soapui.impl.wsdl.teststeps.RestRequestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.security.SecurityCheckedParameter;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.security.SecurityTestRunnerImpl;
import com.eviware.soapui.security.scan.AbstractSecurityScanWithProperties;
import com.eviware.soapui.security.scan.PropertyMutation;
import com.eviware.soapui.support.SecurityScanUtil;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.StringListFormComponent;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectTreeModel;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.impl.swing.JFormDialog;
import com.eviware.x.impl.swing.JStringListFormField;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.xmlbeans.XmlObject;

public class CrossSiteScriptingScan
extends AbstractSecurityScanWithProperties {
    public static final String TYPE = "CrossSiteScriptingScan";
    public static final String NAME = "Cross Site Scripting";
    public static final String PARAMETER_EXPOSURE_SCAN_CONFIG = "CrossSiteScriptingScanConfig";
    public static final String TEST_CASE_RUNNER = "testCaseRunner";
    public static final String TEST_STEP = "testStep";
    private CrossSiteScriptingScanConfig cssConfig;
    StrategyTypeConfig.Enum strategy = StrategyTypeConfig.ONE_BY_ONE;
    List<String> defaultParameterExposureStrings = new ArrayList<String>();
    private JFormDialog dialog;

    public CrossSiteScriptingScan(TestStep testStep, SecurityScanConfig config, ModelItem parent, String icon) {
        super(testStep, config, parent, icon);
        if (config.getConfig() == null || !(config.getConfig() instanceof CrossSiteScriptingScanConfig)) {
            this.initConfig();
        } else {
            this.cssConfig = (CrossSiteScriptingScanConfig)((SecurityScanConfig)this.getConfig()).getConfig();
        }
    }

    private void initDefaultVectors() {
        try {
            String strLine;
            InputStream in = SoapUI.class.getResourceAsStream("/com/eviware/soapui/resources/security/XSS-vectors.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((strLine = br.readLine()) != null) {
                this.defaultParameterExposureStrings.add(strLine);
            }
            in.close();
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    protected void initAssertions() {
        super.initAssertions();
        if (this.assertionsSupport.getAssertionByName("Cross Site Scripting Detection") == null) {
            this.assertionsSupport.addWsdlAssertion("Cross Site Scripting Detection");
        }
    }

    private void initConfig() {
        this.initDefaultVectors();
        ((SecurityScanConfig)this.getConfig()).setConfig((XmlObject)CrossSiteScriptingScanConfig.Factory.newInstance());
        this.cssConfig = (CrossSiteScriptingScanConfig)((SecurityScanConfig)this.getConfig()).getConfig();
        this.cssConfig.setParameterExposureStringsArray(this.defaultParameterExposureStrings.toArray(new String[this.defaultParameterExposureStrings.size()]));
    }

    public void updateSecurityConfig(SecurityScanConfig config) {
        super.updateSecurityConfig(config);
        if (this.cssConfig != null) {
            this.cssConfig = (CrossSiteScriptingScanConfig)((SecurityScanConfig)this.getConfig()).getConfig();
        }
    }

    protected void execute(SecurityTestRunner securityTestRunner, TestStep testStep, SecurityTestRunContext context) {
        this.sendToContext(context, testStep, securityTestRunner);
        PropertyMutation mutation = PropertyMutation.popMutation(context);
        if (mutation != null) {
            if (testStep instanceof RestTestRequestStep) {
                RestRequestStepResult message = (RestRequestStepResult)mutation.getTestStep().run((TestCaseRunner)((Object)securityTestRunner), context);
                message.setRequestContent("");
                this.createMessageExchange(mutation.getMutatedParameters(), message, context);
            } else {
                WsdlTestRequestStepResult message = (WsdlTestRequestStepResult)mutation.getTestStep().run((TestCaseRunner)((Object)securityTestRunner), context);
                message.setRequestContent("", false);
                this.createMessageExchange(mutation.getMutatedParameters(), message, context);
            }
        }
    }

    private void sendToContext(SecurityTestRunContext context, TestStep testStep, SecurityTestRunner securityTestRunner) {
        context.put(TEST_CASE_RUNNER, (Object)securityTestRunner);
        context.put(TEST_STEP, (Object)testStep);
    }

    private void removeFromContext(SecurityTestRunContext context) {
        context.remove(TEST_CASE_RUNNER);
        context.remove(TEST_STEP);
    }

    public JComponent getComponent() {
        JPanel p = UISupport.createEmptyPanel(5, 75, 0, 5);
        p.add(new JLabel("Strings for Cross Site Scripting can be configured under Advanced Settings"));
        return p;
    }

    public String getType() {
        return TYPE;
    }

    protected boolean hasNext(TestStep testStep, SecurityTestRunContext context) {
        if (!context.hasProperty("RequestMutationsStack")) {
            Stack requestMutationsList = new Stack();
            context.put("RequestMutationsStack", (Object)requestMutationsList);
            context.put(PARAMETER_EXPOSURE_SCAN_CONFIG, (Object)this.cssConfig);
            try {
                this.extractMutations(testStep, context);
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
            return this.checkIfEmptyStack(context);
        }
        Stack stack = (Stack)context.get("RequestMutationsStack");
        if (stack.empty()) {
            context.remove("RequestMutationsStack");
            context.remove(PARAMETER_EXPOSURE_SCAN_CONFIG);
            this.removeFromContext(context);
            return false;
        }
        return true;
    }

    private boolean checkIfEmptyStack(SecurityTestRunContext context) {
        Stack stack = (Stack)context.get("RequestMutationsStack");
        return !stack.empty();
    }

    private void extractMutations(TestStep testStep, SecurityTestRunContext context) {
        this.strategy = this.getExecutionStrategy().getStrategy();
        for (String value : this.cssConfig.getParameterExposureStringsList()) {
            value = context.expand(value);
            PropertyMutation allAtOncePropertyMutation = new PropertyMutation();
            TestStep testStepCopy = null;
            XmlObjectTreeModel model = null;
            List<SecurityCheckedParameter> scpList = this.getParameterHolder().getParameterList();
            StringToStringMap stsmap = new StringToStringMap();
            for (SecurityCheckedParameter scp : scpList) {
                if (this.strategy.equals(StrategyTypeConfig.ONE_BY_ONE)) {
                    stsmap = new StringToStringMap();
                    model = SecurityScanUtil.getXmlObjectTreeModel(testStep, scp);
                    testStepCopy = SecurityTestRunnerImpl.cloneTestStepForSecurityScan((WsdlTestStep)testStep);
                } else {
                    if (model == null) {
                        model = SecurityScanUtil.getXmlObjectTreeModel(testStep, scp);
                    }
                    if (testStepCopy == null) {
                        testStepCopy = SecurityTestRunnerImpl.cloneTestStepForSecurityScan((WsdlTestStep)testStep);
                    }
                }
                if (scp.isChecked() && scp.getXpath().trim().length() > 0) {
                    XmlObjectTreeModel.XmlTreeNode mynode;
                    XmlObjectTreeModel.XmlTreeNode[] treeNodes = null;
                    treeNodes = model.selectTreeNodes(context.expand(scp.getXpath()));
                    if (treeNodes.length <= 0 || !(mynode = treeNodes[0]).isLeaf()) continue;
                    mynode.setValue(1, value);
                    if (this.strategy.equals(StrategyTypeConfig.ONE_BY_ONE)) {
                        PropertyMutation oneByOnePropertyMutation = new PropertyMutation();
                        oneByOnePropertyMutation.setPropertyName(scp.getName());
                        oneByOnePropertyMutation.setPropertyValue(this.unescapEscaped(model.getXmlObject().toString()));
                        stsmap.put(scp.getLabel(), mynode.getNodeText());
                        oneByOnePropertyMutation.setMutatedParameters(stsmap);
                        oneByOnePropertyMutation.updateRequestProperty(testStepCopy);
                        oneByOnePropertyMutation.setTestStep(testStepCopy);
                        oneByOnePropertyMutation.addMutation(context);
                        continue;
                    }
                    allAtOncePropertyMutation.setPropertyName(scp.getName());
                    allAtOncePropertyMutation.setPropertyValue(this.unescapEscaped(model.getXmlObject().toString()));
                    stsmap.put(scp.getLabel(), mynode.getNodeText());
                    allAtOncePropertyMutation.setMutatedParameters(stsmap);
                    allAtOncePropertyMutation.updateRequestProperty(testStepCopy);
                    allAtOncePropertyMutation.setTestStep(testStepCopy);
                    continue;
                }
                if (this.strategy.equals(StrategyTypeConfig.ONE_BY_ONE)) {
                    PropertyMutation oneByOnePropertyMutation = new PropertyMutation();
                    oneByOnePropertyMutation.setPropertyName(scp.getName());
                    oneByOnePropertyMutation.setPropertyValue(value);
                    stsmap.put(scp.getLabel(), value);
                    oneByOnePropertyMutation.setMutatedParameters(stsmap);
                    oneByOnePropertyMutation.updateRequestProperty(testStepCopy);
                    oneByOnePropertyMutation.setTestStep(testStepCopy);
                    oneByOnePropertyMutation.addMutation(context);
                    continue;
                }
                allAtOncePropertyMutation.setPropertyName(scp.getName());
                allAtOncePropertyMutation.setPropertyValue(value);
                stsmap.put(scp.getLabel(), value);
                allAtOncePropertyMutation.setMutatedParameters(stsmap);
                allAtOncePropertyMutation.updateRequestProperty(testStepCopy);
                allAtOncePropertyMutation.setTestStep(testStepCopy);
            }
            if (!this.strategy.equals(StrategyTypeConfig.ALL_AT_ONCE)) continue;
            allAtOncePropertyMutation.addMutation(context);
        }
    }

    private String unescapEscaped(String value) {
        return value.replaceAll("&lt;", "<");
    }

    public String getConfigDescription() {
        return "Configures parameter exposure security scan";
    }

    public String getConfigName() {
        return "Cross Site Scripting Scan";
    }

    public String getHelpURL() {
        return "http://soapui.org/Security/cross-site-scripting.html";
    }

    public JComponent getAdvancedSettingsPanel() {
        this.dialog = (JFormDialog)ADialogBuilder.buildDialog(AdvancedSettings.class);
        JStringListFormField stringField = (JStringListFormField)this.dialog.getFormField("###Cross Site Scripting");
        stringField.setOptions(this.cssConfig.getParameterExposureStringsList().toArray());
        stringField.setProperty("dimension", new Dimension(470, 150));
        ((StringListFormComponent)stringField.getComponent()).addPropertyChangeListener("options", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String[] oldOptions;
                String[] newOptions = (String[])evt.getNewValue();
                if (newOptions.length > (oldOptions = (String[])evt.getOldValue()).length) {
                    String[] newValue = (String[])evt.getNewValue();
                    String itemToAdd = newValue[newValue.length - 1];
                    CrossSiteScriptingScan.this.cssConfig.addParameterExposureStrings(itemToAdd);
                }
                if (newOptions.length < oldOptions.length) {
                    for (int cnt = 0; cnt < oldOptions.length; ++cnt) {
                        if (cnt < newOptions.length) {
                            if (newOptions[cnt] == oldOptions[cnt]) continue;
                            CrossSiteScriptingScan.this.cssConfig.removeParameterExposureStrings(cnt);
                            break;
                        }
                        CrossSiteScriptingScan.this.cssConfig.removeParameterExposureStrings(oldOptions.length - 1);
                    }
                }
            }
        });
        return this.dialog.getPanel();
    }

    public void release() {
        if (this.dialog != null) {
            this.dialog.release();
        }
        super.release();
    }

    @AForm(description="Cross Site Scripting", name="Cross Site Scripting")
    protected static interface AdvancedSettings {
        @AField(description="Cross Site Scripting Vectors", name="###Cross Site Scripting", type=AField.AFieldType.STRINGLIST)
        public static final String PARAMETER_EXPOSURE_STRINGS = "###Cross Site Scripting";
    }
}

