/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.panels;

import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.security.panels.CustomTreeNode;
import com.eviware.soapui.security.panels.ReleasableNode;
import com.eviware.soapui.security.panels.SecurityScanNode;
import com.eviware.soapui.security.panels.SecurityTreeRootNode;
import com.eviware.soapui.security.panels.TestStepNode;
import com.eviware.soapui.security.scan.AbstractSecurityScan;
import com.eviware.soapui.security.support.ProgressBarSecurityScanAdapter;
import com.eviware.soapui.security.support.ProgressBarSecurityTestStepAdapter;
import com.eviware.soapui.support.UISupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;

public class SecurityTreeCellRender
implements TreeCellRenderer {
    Map<DefaultMutableTreeNode, Component> componentTree = new HashMap<DefaultMutableTreeNode, Component>();
    private JTree tree;
    Color selected = new Color(205, 205, 205);
    Color unselected = new Color(228, 228, 228);
    private boolean released;

    public Component getTreeCellRendererComponent(JTree arg0, Object node, boolean sel, boolean exp, boolean leaf, int arg5, boolean arg6) {
        Component result = null;
        if (this.released) {
            if (node instanceof TestStepNode) {
                result = this.getTreeCellRendererTestNode(arg0, (TestStepNode)node, sel, exp, leaf, arg5, arg6);
            }
            if (node instanceof SecurityScanNode) {
                result = this.getTreeCellRendererSecurityScanNode(arg0, (SecurityScanNode)node, sel, exp, leaf, arg5, arg6);
            }
            return result;
        }
        this.tree = arg0;
        if (this.componentTree.containsKey(node)) {
            result = this.componentTree.get(node);
            ((CustomTreeNode)((Object)result)).setExpandedIcon(exp);
            ((CustomTreeNode)((Object)result)).updateLabel();
            ((CustomTreeNode)((Object)result)).setSelected(sel);
        } else {
            if (node instanceof TestStepNode) {
                result = this.getTreeCellRendererTestNode(arg0, (TestStepNode)node, sel, exp, leaf, arg5, arg6);
            }
            if (node instanceof SecurityScanNode) {
                result = this.getTreeCellRendererSecurityScanNode(arg0, (SecurityScanNode)node, sel, exp, leaf, arg5, arg6);
            }
            this.componentTree.put((DefaultMutableTreeNode)node, result);
        }
        return result;
    }

    private Component getTreeCellRendererSecurityScanNode(JTree arg0, SecurityScanNode node, boolean sel, boolean arg3, boolean arg4, int arg5, boolean arg6) {
        return new SecurityScanCellRender(arg0, node, sel, arg3, arg4, arg5, arg6);
    }

    private Component getTreeCellRendererTestNode(JTree arg0, TestStepNode node, boolean sel, boolean arg3, boolean arg4, int arg5, boolean arg6) {
        return new TestStepCellRender(arg0, node, sel, arg3, arg4, arg5, arg6);
    }

    public void remove(DefaultMutableTreeNode node) {
        Component component = this.componentTree.get(node);
        if (component instanceof ReleasableNode) {
            ((ReleasableNode)((Object)component)).release();
        }
        this.componentTree.remove(node);
    }

    public boolean isOn(TestStepNode node, int x, int y) {
        TestStepCellRender component = (TestStepCellRender)this.componentTree.get(node);
        return component.isOnExpandButton(x, y);
    }

    public void release() {
        this.released = true;
        for (DefaultMutableTreeNode key : this.componentTree.keySet()) {
            if (!(this.componentTree.get(key) instanceof ReleasableNode)) continue;
            ((ReleasableNode)((Object)this.componentTree.get(key))).release();
        }
        this.componentTree.clear();
    }

    public class SecurityScanCellRender
    extends JPanel
    implements PropertyChangeListener,
    CustomTreeNode,
    ReleasableNode {
        private SecurityScan securityCheck;
        private JProgressBar progressBar;
        private JLabel label;
        private ProgressBarSecurityScanAdapter progressBarAdapter;
        private JPanel progressPanel;
        private JLabel cntLabel;
        private SecurityScanNode node;
        private JPanel leftInnerPanel;

        public SecurityScanCellRender(JTree tree, SecurityScanNode node, boolean sel, boolean arg3, boolean arg4, int arg5, boolean arg6) {
            super(new BorderLayout());
            this.node = node;
            this.securityCheck = node.getSecurityScan();
            this.securityCheck.addPropertyChangeListener(this);
            this.label = new JLabel(this.securityCheck.getName(), 2);
            String iconPath = UISupport.getIconPath(this.securityCheck.getIcon());
            this.label.setIcon(UISupport.createImageIcon(iconPath));
            this.label.setBorder(BorderFactory.createEmptyBorder(5, 45, 5, 5));
            this.label.setEnabled(!this.securityCheck.isDisabled());
            this.leftInnerPanel = new JPanel(new BorderLayout());
            this.leftInnerPanel.add((Component)this.label, "Center");
            this.leftInnerPanel.setBackground(this.getBackground());
            this.progressBar = new JProgressBar();
            this.progressPanel = new JPanel(new FlowLayout(0, 10, 0));
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            this.progressBar.setString("");
            this.progressBar.setIndeterminate(false);
            this.progressBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.LIGHT_GRAY));
            this.progressPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
            this.progressPanel.add(this.progressBar);
            this.progressBar.setMinimumSize(new Dimension(0, 200));
            this.progressBar.setInheritsPopupMenu(true);
            this.cntLabel = new JLabel("");
            this.cntLabel.setForeground(Color.white);
            this.cntLabel.setBackground(SecurityTreeCellRender.this.selected);
            this.cntLabel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            this.progressPanel.add(this.cntLabel);
            this.add((Component)this.progressPanel, "After");
            this.add((Component)this.leftInnerPanel, "Before");
            this.setSelected(sel);
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black));
            this.progressBarAdapter = new ProgressBarSecurityScanAdapter(tree, this.node, this.progressBar, this.securityCheck, (SecurityTest)this.securityCheck.getParent(), this.cntLabel);
        }

        public void release() {
            this.progressBarAdapter.release();
        }

        public void reset() {
            this.progressBar.setValue(0);
            this.progressBar.setString("");
        }

        public void setSelected(boolean sel) {
            if (sel) {
                this.setBackground(SecurityTreeCellRender.this.selected);
                this.label.setBackground(SecurityTreeCellRender.this.selected);
                this.progressPanel.setBackground(SecurityTreeCellRender.this.selected);
                this.leftInnerPanel.setBackground(SecurityTreeCellRender.this.selected);
            } else {
                this.setBackground(SecurityTreeCellRender.this.unselected);
                this.label.setBackground(SecurityTreeCellRender.this.unselected);
                this.progressPanel.setBackground(SecurityTreeCellRender.this.unselected);
                this.leftInnerPanel.setBackground(SecurityTreeCellRender.this.unselected);
            }
        }

        public void propertyChange(PropertyChangeEvent arg0) {
            this.label.setEnabled(!this.securityCheck.isDisabled());
            ((DefaultTreeModel)SecurityTreeCellRender.this.tree.getModel()).nodeChanged(this.node);
        }

        public void setExpandedIcon(boolean exp) {
        }

        public void updateLabel() {
            this.label.setEnabled(!this.securityCheck.isDisabled());
        }
    }

    public class TestStepCellRender
    extends JPanel
    implements PropertyChangeListener,
    CustomTreeNode,
    ReleasableNode {
        private WsdlTestStep testStep;
        private JProgressBar progressBar;
        private JLabel label;
        private ProgressBarSecurityTestStepAdapter progressBarAdapter;
        private SecurityTest securityTest;
        private Icon collapsed;
        private Icon expanded;
        private JLabel expandCollapseBtn;
        private DefaultMutableTreeNode node;
        private JPanel innerLeftPanel;
        private JPanel progressPanel;
        private JLabel cntLabel;

        public TestStepCellRender(JTree tree, TestStepNode node, boolean sel, boolean exp, boolean leaf, int arg5, boolean arg6) {
            super(new BorderLayout());
            this.collapsed = UISupport.createImageIcon("/plus.gif");
            this.expanded = UISupport.createImageIcon("/minus.gif");
            this.node = node;
            this.testStep = (WsdlTestStep)node.getTestStep();
            this.securityTest = ((SecurityTreeRootNode)node.getParent()).getSecurityTest();
            if (AbstractSecurityScan.isSecurable(this.testStep)) {
                if (this.securityTest.getSecurityScansMap().get(this.testStep.getId()) != null) {
                    String labelText = this.securityTest.getSecurityScansMap().get(this.testStep.getId()).size() == 1 ? this.securityTest.getSecurityScansMap().get(this.testStep.getId()).size() + " scan)" : this.securityTest.getSecurityScansMap().get(this.testStep.getId()).size() + " scans)";
                    this.label = new JLabel(this.testStep.getLabel() + " (" + labelText, 2);
                } else {
                    this.label = new JLabel(this.testStep.getLabel() + " (0 scans)", 2);
                }
            } else {
                this.label = new JLabel(this.testStep.getLabel(), 2);
            }
            this.label.setIcon(this.testStep.getIcon());
            this.label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.label.setEnabled(!this.testStep.isDisabled() && AbstractSecurityScan.isSecurable(this.testStep));
            this.testStep.addPropertyChangeListener(TestStep.ICON_PROPERTY, this);
            this.testStep.addPropertyChangeListener(TestStep.DISABLED_PROPERTY, this);
            this.innerLeftPanel = new JPanel(new BorderLayout());
            this.expandCollapseBtn = exp ? new JLabel(this.expanded) : new JLabel(this.collapsed);
            this.expandCollapseBtn.setEnabled(false);
            if (this.securityTest.getSecurityScansMap().get(this.testStep.getId()) == null || this.securityTest.getSecurityScansMap().get(this.testStep.getId()).size() == 0) {
                this.expandCollapseBtn.setVisible(false);
            } else {
                this.expandCollapseBtn.setVisible(true);
            }
            this.innerLeftPanel.add((Component)this.expandCollapseBtn, "West");
            if (AbstractSecurityScan.isSecurable(this.testStep)) {
                this.progressBar = new JProgressBar();
                this.progressPanel = new JPanel(new FlowLayout(0, 10, 0));
                this.progressBar.setValue(0);
                this.progressBar.setStringPainted(true);
                this.progressBar.setString("");
                this.progressBar.setIndeterminate(false);
                this.progressBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.LIGHT_GRAY));
                this.progressPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
                this.progressPanel.add(this.progressBar);
                this.progressBar.setMinimumSize(new Dimension(0, 200));
                this.progressBar.setInheritsPopupMenu(true);
                this.cntLabel = new JLabel("");
                this.cntLabel.setForeground(Color.white);
                this.cntLabel.setBackground(SecurityTreeCellRender.this.selected);
                this.cntLabel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
                this.progressPanel.add(this.cntLabel);
                this.add((Component)this.progressPanel, "After");
                this.expandCollapseBtn.setVisible(true);
                this.innerLeftPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            } else {
                this.expandCollapseBtn.setVisible(false);
                this.innerLeftPanel.setBorder(BorderFactory.createEmptyBorder(0, 21, 0, 0));
            }
            this.innerLeftPanel.add((Component)this.label, "Center");
            this.add((Component)this.innerLeftPanel, "Before");
            this.setSelected(sel);
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black));
            this.progressBarAdapter = new ProgressBarSecurityTestStepAdapter(tree, node, this.progressBar, this.securityTest, this.testStep, this.cntLabel);
        }

        public void reset() {
            this.progressBar.setValue(0);
            this.progressBar.setString("");
        }

        public void setSelected(boolean sel) {
            if (AbstractSecurityScan.isSecurable(this.testStep)) {
                if (sel) {
                    this.setBackground(SecurityTreeCellRender.this.selected);
                    this.label.setBackground(SecurityTreeCellRender.this.selected);
                    this.innerLeftPanel.setBackground(SecurityTreeCellRender.this.selected);
                    this.expandCollapseBtn.setBackground(SecurityTreeCellRender.this.selected);
                    this.progressPanel.setBackground(SecurityTreeCellRender.this.selected);
                } else {
                    this.setBackground(SecurityTreeCellRender.this.unselected);
                    this.label.setBackground(SecurityTreeCellRender.this.unselected);
                    this.innerLeftPanel.setBackground(SecurityTreeCellRender.this.unselected);
                    this.expandCollapseBtn.setBackground(SecurityTreeCellRender.this.unselected);
                    this.progressPanel.setBackground(SecurityTreeCellRender.this.unselected);
                }
            } else {
                this.setBackground(SecurityTreeCellRender.this.unselected);
                this.label.setBackground(SecurityTreeCellRender.this.unselected);
                this.innerLeftPanel.setBackground(SecurityTreeCellRender.this.unselected);
                this.expandCollapseBtn.setBackground(SecurityTreeCellRender.this.unselected);
            }
        }

        protected TestStep getTestStep() {
            return this.testStep;
        }

        public ModelItem getModelItem() {
            return this.testStep;
        }

        public void propertyChange(PropertyChangeEvent arg0) {
            this.label.setIcon(this.testStep.getIcon());
            this.label.setEnabled(!this.testStep.isDisabled() && AbstractSecurityScan.isSecurable(this.testStep));
            this.updateLabel();
            ((DefaultTreeModel)SecurityTreeCellRender.this.tree.getModel()).nodeChanged(this.node);
        }

        public void setExpandedIcon(boolean exp) {
            if (this.securityTest.getSecurityScansMap().get(this.testStep.getId()) == null || this.securityTest.getSecurityScansMap().get(this.testStep.getId()).size() == 0) {
                this.expandCollapseBtn.setVisible(false);
                this.innerLeftPanel.setBorder(BorderFactory.createEmptyBorder(0, 21, 0, 0));
            } else {
                this.expandCollapseBtn.setVisible(true);
                this.innerLeftPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            }
            if (exp) {
                this.expandCollapseBtn.setIcon(this.expanded);
            } else {
                this.expandCollapseBtn.setIcon(this.collapsed);
            }
        }

        public void updateLabel() {
            if (AbstractSecurityScan.isSecurable(this.testStep)) {
                if (this.securityTest.getSecurityScansMap().get(this.testStep.getId()) != null) {
                    String labelText = this.securityTest.getSecurityScansMap().get(this.testStep.getId()).size() == 1 ? this.securityTest.getSecurityScansMap().get(this.testStep.getId()).size() + " scan)" : this.securityTest.getSecurityScansMap().get(this.testStep.getId()).size() + " scans)";
                    this.label.setText(this.testStep.getLabel() + " (" + labelText);
                } else {
                    this.label.setText(this.testStep.getLabel() + " (0 scans)");
                }
            } else {
                this.label.setText(this.testStep.getLabel());
            }
        }

        public boolean isOnExpandButton(int x, int y) {
            y -= 30 * SecurityTreeCellRender.this.tree.getRowForLocation(x, y);
            return 5 <= x && 20 >= x && 5 <= y && 20 >= y;
        }

        public void release() {
            this.testStep.removePropertyChangeListener(TestStep.ICON_PROPERTY, this);
            this.testStep.removePropertyChangeListener(TestStep.DISABLED_PROPERTY, this);
            this.progressBarAdapter.release();
            this.testStep = null;
            this.securityTest = null;
        }
    }
}

