/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.panels;

import com.eviware.soapui.config.ProjectConfig;
import com.eviware.soapui.config.SensitiveInformationConfig;
import com.eviware.soapui.model.security.SensitiveInformationTableModel;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.security.SensitiveInformationPropertyHolder;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import org.apache.xmlbeans.XmlObject;
import org.jdesktop.swingx.JXTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectSensitiveInformationPanel {
    private XFormDialog dialog;
    private SensitiveInformationConfig config;
    private List<String> projectSpecificExposureList;
    public static final String PROJECT_SPECIFIC_EXPOSURE_LIST = "ProjectSpecificExposureList";
    private SensitiveInformationTableModel sensitivInformationTableModel;
    private JXTable tokenTable;
    private JPanel sensitiveInfoTableForm;

    public ProjectSensitiveInformationPanel(ProjectConfig projectConfig) {
        this.config = projectConfig.getSensitiveInformation();
        if (this.config == null) {
            this.config = SensitiveInformationConfig.Factory.newInstance();
            projectConfig.addNewSensitiveInformation();
            projectConfig.setSensitiveInformation(this.config);
        }
        this.init();
    }

    private void init() {
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader((XmlObject)this.config);
        this.projectSpecificExposureList = StringUtils.toStringList(reader.readStrings(PROJECT_SPECIFIC_EXPOSURE_LIST));
        this.extractTokenTable();
    }

    private void extractTokenTable() {
        SensitiveInformationPropertyHolder siph = new SensitiveInformationPropertyHolder();
        for (String str : this.projectSpecificExposureList) {
            String[] tokens = str.split("###");
            if (tokens.length == 2) {
                siph.setPropertyValue(tokens[0], tokens[1]);
                continue;
            }
            siph.setPropertyValue(tokens[0], "");
        }
        this.sensitivInformationTableModel = new SensitiveInformationTableModel(siph);
    }

    public boolean build() {
        if (this.dialog == null) {
            this.buildDialog();
        }
        return false;
    }

    public void save() {
        this.projectSpecificExposureList = this.createListFromTable();
        this.setConfiguration(this.createConfiguration());
    }

    private List<String> createListFromTable() {
        ArrayList<String> temp = new ArrayList<String>();
        for (TestProperty tp : this.sensitivInformationTableModel.getHolder().getPropertyList()) {
            String tokenPlusDescription = tp.getName() + "###" + tp.getValue();
            temp.add(tokenPlusDescription);
        }
        return temp;
    }

    protected XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add(PROJECT_SPECIFIC_EXPOSURE_LIST, this.projectSpecificExposureList.toArray(new String[this.projectSpecificExposureList.size()]));
        return builder.finish();
    }

    protected void buildDialog() {
        this.dialog = ADialogBuilder.buildDialog(SensitiveInformationConfigDialog.class);
        this.dialog.getFormField("Sensitive Information Tokens").setProperty("component", this.getForm());
    }

    public void setConfiguration(XmlObject configuration) {
        this.config.set(configuration);
    }

    public XFormDialog getDialog() {
        return this.dialog;
    }

    public JPanel getForm() {
        if (this.sensitiveInfoTableForm == null) {
            this.sensitiveInfoTableForm = new JPanel(new BorderLayout());
            JXToolBar toolbar = UISupport.createToolbar();
            toolbar.add(UISupport.createToolbarButton(new AddTokenAction()));
            toolbar.add(UISupport.createToolbarButton(new RemoveTokenAction()));
            this.tokenTable = new JXTable((TableModel)this.sensitivInformationTableModel);
            this.tokenTable.setPreferredSize(new Dimension(200, 100));
            this.sensitiveInfoTableForm.add((Component)toolbar, "North");
            this.sensitiveInfoTableForm.add((Component)new JScrollPane((Component)this.tokenTable), "Center");
        }
        return this.sensitiveInfoTableForm;
    }

    public void release() {
        if (this.dialog != null) {
            this.dialog.release();
        }
    }

    class RemoveTokenAction
    extends AbstractAction {
        public RemoveTokenAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_property.gif"));
            this.putValue("ShortDescription", "Removes token from assertion");
        }

        public void actionPerformed(ActionEvent arg0) {
            ProjectSensitiveInformationPanel.this.sensitivInformationTableModel.removeRows(ProjectSensitiveInformationPanel.this.tokenTable.getSelectedRows());
            ProjectSensitiveInformationPanel.this.save();
        }
    }

    class AddTokenAction
    extends AbstractAction {
        public AddTokenAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
            this.putValue("ShortDescription", "Adds a token to assertion");
        }

        public void actionPerformed(ActionEvent arg0) {
            String newToken = "";
            newToken = UISupport.prompt("Enter token", "New Token", newToken);
            String newValue = "";
            newValue = UISupport.prompt("Enter description", "New Description", newValue);
            ProjectSensitiveInformationPanel.this.sensitivInformationTableModel.addToken(newToken, newValue);
            ProjectSensitiveInformationPanel.this.save();
        }
    }

    @AForm(description="Configure Sensitive Information Exposure Assertion", name="Sensitive Information Exposure Assertion", helpUrl="http://www.soapui.org/Security/security-scans-overview.html#3-3-system-information-exposure")
    protected static interface SensitiveInformationConfigDialog {
        @AField(description="Sensitive informations to check. Use ~ as prefix for values that are regular expressions.", name="Sensitive Information Tokens", type=AField.AFieldType.COMPONENT)
        public static final String TOKENS = "Sensitive Information Tokens";
    }
}

