/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.assertion;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.model.security.SensitiveInformationTableModel;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.security.SensitiveInformationPropertyHolder;
import com.eviware.soapui.support.SecurityScanUtil;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import org.apache.xmlbeans.XmlObject;
import org.jdesktop.swingx.JXTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SensitiveInfoExposureAssertion
extends WsdlMessageAssertion
implements ResponseAssertion {
    private static final String PREFIX = "~";
    public static final String ID = "Sensitive Information Exposure";
    public static final String LABEL = "Sensitive Information Exposure";
    private List<String> assertionSpecificExposureList;
    private XFormDialog dialog;
    private static final String ASSERTION_SPECIFIC_EXPOSURE_LIST = "AssertionSpecificExposureList";
    private static final String INCLUDE_GLOBAL = "IncludeGlobal";
    private static final String INCLUDE_PROJECT_SPECIFIC = "IncludeProjectSpecific";
    public static final String DESCRIPTION = "Checks that the last received message does not expose an sensitive information about the target system. Applicable to REST, SOAP and HTTP TestSteps.";
    private boolean includeGlobal;
    private boolean includeProjectSpecific;
    private JPanel sensitiveInfoTableForm;
    private SensitiveInformationTableModel sensitiveInformationTableModel;
    private JXTable tokenTable;

    public SensitiveInfoExposureAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable, false, true, false, true);
        this.init();
    }

    private void init() {
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.includeGlobal = reader.readBoolean(INCLUDE_GLOBAL, true);
        this.includeProjectSpecific = reader.readBoolean(INCLUDE_PROJECT_SPECIFIC, true);
        this.assertionSpecificExposureList = StringUtils.toStringList(reader.readStrings(ASSERTION_SPECIFIC_EXPOSURE_LIST));
        this.extractTokenTable();
    }

    private void extractTokenTable() {
        SensitiveInformationPropertyHolder siph = new SensitiveInformationPropertyHolder();
        for (String str : this.assertionSpecificExposureList) {
            if ("###".equals(str)) continue;
            String[] tokens = str.split("###");
            if (tokens.length == 2) {
                siph.setPropertyValue(tokens[0], tokens[1]);
                continue;
            }
            if (tokens.length != 1) continue;
            siph.setPropertyValue(tokens[0], "");
        }
        this.sensitiveInformationTableModel = new SensitiveInformationTableModel(siph);
    }

    @Override
    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        Map<String, String> checkMap = this.createCheckMap(context);
        ArrayList<AssertionError> assertionErrorList = new ArrayList<AssertionError>();
        String response = messageExchange.getResponseContent();
        HashSet<String> messages = new HashSet<String>();
        try {
            for (String token : checkMap.keySet()) {
                String message;
                String match;
                String description;
                boolean useRegexp = token.trim().startsWith(PREFIX);
                String string = description = !checkMap.get(token).equals("") ? checkMap.get(token) : token;
                if (useRegexp) {
                    token = token.substring(token.indexOf(PREFIX) + 1);
                }
                if ((match = SecurityScanUtil.contains(context, response, token, useRegexp)) == null || messages.contains(message = description + " - Token [" + token + "] found [" + match + "]")) continue;
                assertionErrorList.add(new AssertionError(message));
                messages.add(message);
            }
        }
        catch (Throwable e) {
            SoapUI.logError(e);
        }
        if (!messages.isEmpty()) {
            throw new AssertionException(assertionErrorList.toArray(new AssertionError[assertionErrorList.size()]));
        }
        return "OK";
    }

    @Override
    protected String internalAssertProperty(TestPropertyHolder source, String propertyName, MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        Map<String, String> checkMap = this.createCheckMap(context);
        ArrayList<AssertionError> assertionErrorList = new ArrayList<AssertionError>();
        String propertyValue = source.getPropertyValue(propertyName);
        HashSet<String> messages = new HashSet<String>();
        try {
            for (String token : checkMap.keySet()) {
                String message;
                String match;
                String description;
                boolean useRegexp = token.trim().startsWith(PREFIX);
                String string = description = !checkMap.get(token).equals("") ? checkMap.get(token) : token;
                if (useRegexp) {
                    token = token.substring(token.indexOf(PREFIX) + 1);
                }
                if ((match = SecurityScanUtil.contains(context, propertyValue, token, useRegexp)) == null || messages.contains(message = description + " - Token [" + token + "] found [" + match + "] in property " + propertyName)) continue;
                assertionErrorList.add(new AssertionError(message));
                messages.add(message);
            }
        }
        catch (Throwable e) {
            SoapUI.logError(e);
        }
        if (!messages.isEmpty()) {
            throw new AssertionException(assertionErrorList.toArray(new AssertionError[assertionErrorList.size()]));
        }
        return "OK";
    }

    private Map<String, String> createCheckMap(SubmitContext context) {
        HashMap<String, String> checkMap = new HashMap<String, String>();
        checkMap.putAll(this.createMapFromTable());
        if (this.includeProjectSpecific) {
            checkMap.putAll(SecurityScanUtil.projectEntriesList(this));
        }
        if (this.includeGlobal) {
            checkMap.putAll(SecurityScanUtil.globalEntriesList());
        }
        Map<String, String> expandedMap = this.propertyExpansionSupport(checkMap, context);
        return expandedMap;
    }

    private Map<String, String> propertyExpansionSupport(Map<String, String> checkMap, SubmitContext context) {
        HashMap<String, String> expanded = new HashMap<String, String>();
        for (String key : checkMap.keySet()) {
            expanded.put(context.expand(key), context.expand(checkMap.get(key)));
        }
        return expanded;
    }

    @Override
    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    protected XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add(ASSERTION_SPECIFIC_EXPOSURE_LIST, this.assertionSpecificExposureList.toArray(new String[this.assertionSpecificExposureList.size()]));
        builder.add(INCLUDE_PROJECT_SPECIFIC, this.includeProjectSpecific);
        builder.add(INCLUDE_GLOBAL, this.includeGlobal);
        return builder.finish();
    }

    @Override
    public boolean configure() {
        if (this.dialog == null) {
            this.buildDialog();
        }
        if (this.dialog.show()) {
            this.assertionSpecificExposureList = this.createListFromTable();
            this.includeProjectSpecific = Boolean.valueOf(this.dialog.getFormField("Project Specific").getValue());
            this.includeGlobal = Boolean.valueOf(this.dialog.getFormField("Global Configuration").getValue());
            this.setConfiguration(this.createConfiguration());
            return true;
        }
        return false;
    }

    private List<String> createListFromTable() {
        ArrayList<String> temp = new ArrayList<String>();
        for (TestProperty tp : this.sensitiveInformationTableModel.getHolder().getPropertyList()) {
            String tokenPlusDescription = tp.getName() + "###" + tp.getValue();
            temp.add(tokenPlusDescription);
        }
        return temp;
    }

    private Map<String, String> createMapFromTable() {
        HashMap<String, String> temp = new HashMap<String, String>();
        for (TestProperty tp : this.sensitiveInformationTableModel.getHolder().getPropertyList()) {
            temp.put(tp.getName(), tp.getValue());
        }
        return temp;
    }

    protected void buildDialog() {
        this.dialog = ADialogBuilder.buildDialog(SensitiveInformationConfigDialog.class);
        this.dialog.setBooleanValue("Global Configuration", this.includeGlobal);
        this.dialog.setBooleanValue("Project Specific", this.includeProjectSpecific);
        this.dialog.getFormField("Sensitive Information Tokens").setProperty("component", this.getForm());
    }

    @Override
    public void release() {
        if (this.dialog != null) {
            this.dialog.release();
        }
        super.release();
    }

    public JPanel getForm() {
        if (this.sensitiveInfoTableForm == null) {
            this.sensitiveInfoTableForm = new JPanel(new BorderLayout());
            JXToolBar toolbar = UISupport.createToolbar();
            toolbar.add(UISupport.createToolbarButton(new AddTokenAction()));
            toolbar.add(UISupport.createToolbarButton(new RemoveTokenAction()));
            this.tokenTable = new JXTable((TableModel)this.sensitiveInformationTableModel);
            this.tokenTable.setPreferredSize(new Dimension(200, 100));
            this.sensitiveInfoTableForm.add((Component)toolbar, "North");
            this.sensitiveInfoTableForm.add((Component)new JScrollPane((Component)this.tokenTable), "Center");
        }
        return this.sensitiveInfoTableForm;
    }

    class RemoveTokenAction
    extends AbstractAction {
        public RemoveTokenAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_property.gif"));
            this.putValue("ShortDescription", "Removes token from assertion");
        }

        public void actionPerformed(ActionEvent arg0) {
            SensitiveInfoExposureAssertion.this.sensitiveInformationTableModel.removeRows(SensitiveInfoExposureAssertion.this.tokenTable.getSelectedRows());
        }
    }

    class AddTokenAction
    extends AbstractAction {
        public AddTokenAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
            this.putValue("ShortDescription", "Adds a token to assertion");
        }

        public void actionPerformed(ActionEvent arg0) {
            String newToken = "";
            while (newToken.trim().length() == 0) {
                if ((newToken = UISupport.prompt("Enter token", "New Token", newToken)) == null) {
                    return;
                }
                if (newToken.trim().length() != 0) continue;
                UISupport.showErrorMessage("Enter token name!");
            }
            String newValue = "";
            if ((newValue = UISupport.prompt("Enter description", "New Description", newValue)) == null) {
                newValue = "";
            }
            SensitiveInfoExposureAssertion.this.sensitiveInformationTableModel.addToken(newToken, newValue);
        }
    }

    @AForm(description="Configure Sensitive Information Exposure Assertion", name="Sensitive Information Exposure Assertion", helpUrl="http://www.soapui.org/Security/security-scans-overview.html#3-3-system-information-exposure")
    protected static interface SensitiveInformationConfigDialog {
        @AField(description="Sensitive informations to check. Use ~ as prefix for values that are regular expressions.", name="Sensitive Information Tokens", type=AField.AFieldType.COMPONENT)
        public static final String TOKENS = "Sensitive Information Tokens";
        @AField(description="Include project specific sensitive information configuration", name="Project Specific", type=AField.AFieldType.BOOLEAN)
        public static final String INCLUDE_PROJECT_SPECIFIC = "Project Specific";
        @AField(description="Include global sensitive information configuration", name="Global Configuration", type=AField.AFieldType.BOOLEAN)
        public static final String INCLUDE_GLOBAL = "Global Configuration";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super("Sensitive Information Exposure", "Sensitive Information Exposure", SensitiveInfoExposureAssertion.class, new Class[]{SecurityScan.class, AbstractHttpRequest.class});
        }

        @Override
        public String getCategory() {
            return "Security";
        }

        @Override
        public Class<? extends WsdlMessageAssertion> getAssertionClassType() {
            return SensitiveInfoExposureAssertion.class;
        }

        @Override
        public AssertionListEntry getAssertionListEntry() {
            return new AssertionListEntry("Sensitive Information Exposure", "Sensitive Information Exposure", SensitiveInfoExposureAssertion.DESCRIPTION);
        }
    }
}

