/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.support;

import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.DefaultPropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.types.StringToObjectMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSubmitContext<T extends ModelItem>
implements SubmitContext,
Map<String, Object> {
    private DefaultPropertyExpansionContext properties;
    private final T modelItem;

    public AbstractSubmitContext(T modelItem) {
        this.modelItem = modelItem;
        this.properties = new DefaultPropertyExpansionContext((ModelItem)modelItem);
        this.setProperty("RunCount", 0);
        this.setProperty("ThreadIndex", 0);
    }

    public AbstractSubmitContext(T modelItem, StringToObjectMap properties) {
        this(modelItem);
        if (properties != null && properties.size() > 0) {
            if (this.properties == null) {
                this.properties = new DefaultPropertyExpansionContext((ModelItem)modelItem);
            }
            this.properties.putAll(properties);
        }
    }

    public T getModelItem() {
        return this.modelItem;
    }

    public Object getProperty(String name, TestStep testStep, WsdlTestCase testCase) {
        if (this.properties != null && this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        if (testCase != null) {
            String teststepname;
            WsdlTestStep refTestStep;
            int ix = name.indexOf("#");
            if (ix > 0 && (refTestStep = testCase.getTestStepByName(teststepname = name.substring(0, ix))) != null) {
                TestProperty property = refTestStep.getProperty(name.substring(ix + 1));
                return property == null ? null : property.getValue();
            }
            if (testCase.getSearchProperties()) {
                int n = ix = testStep == null ? testCase.getTestStepCount() - 1 : testCase.getIndexOfTestStep(testStep);
                if (ix >= testCase.getTestStepCount()) {
                    ix = testCase.getTestStepCount() - 1;
                }
                while (ix >= 0) {
                    TestProperty property = testCase.getTestStepAt(ix).getProperty(name);
                    if (property != null) {
                        return property.getValue();
                    }
                    --ix;
                }
            }
        }
        return null;
    }

    @Override
    public Object removeProperty(String name) {
        return this.properties == null ? null : this.properties.remove(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new DefaultPropertyExpansionContext((ModelItem)this.modelItem);
        }
        this.properties.put(name, value);
    }

    public void setProperty(String name, Object value, TestCase testCase) {
        TestProperty property;
        String teststepname;
        TestStep refTestStep;
        int ix = name.indexOf("#");
        if (ix > 0 && (refTestStep = testCase.getTestStepByName(teststepname = name.substring(0, ix))) != null && (property = refTestStep.getProperty(name.substring(ix + 1))) != null && !property.isReadOnly()) {
            property.setValue(value.toString());
            return;
        }
        if (this.properties == null) {
            this.properties = new DefaultPropertyExpansionContext((ModelItem)this.modelItem);
        }
        this.properties.put(name, value);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.properties == null ? false : this.properties.containsKey(name);
    }

    public void resetProperties() {
        if (this.properties != null) {
            this.properties.clear();
        }
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    public Object clone() {
        return this.properties.clone();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.properties.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.properties.equals(o);
    }

    @Override
    public Object get(Object key) {
        return this.properties.get(key);
    }

    @Override
    public int hashCode() {
        return this.properties.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        return this.properties.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.properties.putAll(m);
    }

    @Override
    public Object remove(Object key) {
        return this.properties.remove(key);
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    public String toString() {
        return this.properties.toString();
    }

    @Override
    public Collection<Object> values() {
        return this.properties.values();
    }

    @Override
    public StringToObjectMap getProperties() {
        return this.properties;
    }

    @Override
    public String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    @Override
    public String expand(String content) {
        return PropertyExpander.expandProperties(this, content);
    }
}

