/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.integration.loadui;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.LoadTestLimitTypesConfig;
import com.eviware.soapui.impl.wsdl.loadtest.LoadTestAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.assertions.TestStepAverageAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.assertions.TestStepMaxAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.assertions.TestStepTpsAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.AbstractLoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.BurstLoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.SimpleLoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.ThreadCountChangeLoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.VarianceLoadStrategy;
import com.eviware.soapui.settings.HttpSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextMapping {
    private static final String NOT_SELECTED = "-";
    private static final String TEST_CASE = "testCase";
    private static final String TEST_SUITE = "testSuite";
    private static final String PROJECT_FILE = "projectFile";
    public static final String MOCK_SERVICE = "mockService";
    public static final String PATH = "path";
    public static final String PORT = "port";
    private static final String CLOSE_CONNECTIONS_AFTER_REQUEST = "closeConnectionsAfterRequest";
    private static final String SOAPUI_RUNNER_LABEL = "soapuiSamplerLabel";
    public static final String LOADUI_TEST_CASE_NAME = "loaduiTestCaseName";
    public static final String LOADUI_PROJECT_NAME = "loaduiProjectName";
    private static final String SOAPUI_RUNNER_PROPERTIES = "SoapUISamplerComponent_properties";
    private static final String MOCKSERVICE_RUNNER_LABEL = "mockRunnerLabel";
    private static final String MOCKSERVICE_RUNNER_PROPERTIES = "MockServiceComponent_properties";
    private static final String ASSERTION_LABEL = "assertionLabel";
    private static final String ASSERTION_TYPE = "assertionType";
    private static final String ASSERTION_PROPERTIES = "assertionProperties";
    private static final String ASSERTION = "Assertion";
    private static final String ASSERTION_CREATE_NEW = "assertionCreateNew";
    private static final String STATISTICS_LABEL = "statisticsLabel";
    private static final String STATISTICS_TYPE = "statisticsType";
    private static final String STATISTICS_PROPERTIES = "statisticsProperties";
    private static final String STATISTICS = "Statistics";
    private static final String STATISTICS_CREATE_NEW = "statisticsCreateNew";
    private static final String TRIGGER_LABEL = "triggerLabel";
    private static final String TRIGGER_TYPE = "triggerType";
    protected static final String TRIGGER_PROPERTIES = "triggerProperties";
    private static final String TRIGGER_CREATE_NEW = "triggerCreateNew";
    private static final String DELAY_LABEL = "delayLabel";
    private static final String DELAY_TYPE = "delayType";
    private static final String DELAY_PROPERTIES = "delayProperties";
    private static final String DELAY = "Delay";
    private static final String DELAY_CREATE_NEW = "delayCreateNew";
    protected static final String FIXED_LOAD_TRIGGER = "Fixed Load";
    private static final String VARIANCE_TRIGGER = "Variance";
    private static final String RAMP_TRIGGER = "Ramp";
    private WsdlLoadTest loadTest;
    private String loadUIProject;
    private String loadUITestCase;
    private String loadUISoapUISampler;
    private String soapUIProjectPath;
    private String soapUITestSuite;
    private String soapUITestCase;
    protected String loadUITriggerType;
    private String soapUIMockService;
    private String mockServicePath;
    private String mockServicePort;
    private String loadUIMockServiceRunner;
    HashMap<String, String> triggerProperties;
    HashMap<String, String> delayProperties;
    List<HashMap<String, String>> assertionPropertiesList;
    HashMap<String, String> statisticsProperties;

    public ContextMapping(WsdlLoadTest loadTest, String loadUIProject, String loadUITestCase, String loadUISoapUISampler) {
        this.loadTest = loadTest;
        this.loadUIProject = loadUIProject;
        this.loadUITestCase = loadUITestCase;
        this.loadUISoapUISampler = loadUISoapUISampler;
    }

    public ContextMapping(String soapUIProjectPath, String soapUITestSuite, String soapUITestCase, String loadUIProject, String loadUITestCase, String loadUISoapUISampler) {
        this.loadUIProject = loadUIProject;
        this.loadUITestCase = loadUITestCase;
        this.loadUISoapUISampler = loadUISoapUISampler;
        this.soapUIProjectPath = soapUIProjectPath;
        this.soapUITestSuite = soapUITestSuite;
        this.soapUITestCase = soapUITestCase;
    }

    public ContextMapping(String soapUIProjectPath, String soapUIMockService, String path, String port, String loadUIProject, String loadUITestCase, String loadUIMockServiceRunner) {
        this.loadUIProject = loadUIProject;
        this.loadUITestCase = loadUITestCase;
        this.loadUIMockServiceRunner = loadUIMockServiceRunner;
        this.soapUIProjectPath = soapUIProjectPath;
        this.soapUIMockService = soapUIMockService;
        this.mockServicePath = path;
        this.mockServicePort = port;
    }

    public static String createProperyValue(Class clazz, String value) {
        return clazz.getName() + "@" + value;
    }

    public HashMap<String, Object> setCreateSoapUIRunnerContext(String generatorType, String analisysType) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(PROJECT_FILE, ContextMapping.createProperyValue(File.class, this.soapUIProjectPath));
        properties.put(TEST_SUITE, ContextMapping.createProperyValue(String.class, this.soapUITestSuite));
        properties.put(TEST_CASE, ContextMapping.createProperyValue(String.class, this.soapUITestCase));
        context.put(LOADUI_PROJECT_NAME, this.loadUIProject);
        context.put(LOADUI_TEST_CASE_NAME, this.loadUITestCase);
        context.put(SOAPUI_RUNNER_LABEL, this.loadUISoapUISampler);
        context.put(SOAPUI_RUNNER_PROPERTIES, properties);
        if (!NOT_SELECTED.equals(generatorType)) {
            this.mapDefaultTriggerProperties(generatorType);
            context.put(TRIGGER_PROPERTIES, this.triggerProperties);
            context.put(TRIGGER_LABEL, this.loadUITriggerType);
            context.put(TRIGGER_TYPE, this.loadUITriggerType);
            context.put(TRIGGER_CREATE_NEW, new Boolean(true));
        }
        if (!NOT_SELECTED.equals(analisysType)) {
            this.mapStatisticsProperties(null);
            context.put(STATISTICS_PROPERTIES, this.statisticsProperties);
            context.put(STATISTICS_LABEL, STATISTICS);
            context.put(STATISTICS_TYPE, STATISTICS);
            context.put(STATISTICS_CREATE_NEW, new Boolean(true));
        }
        return context;
    }

    public HashMap<String, Object> setCreateMockServiceRunnerContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(PROJECT_FILE, ContextMapping.createProperyValue(File.class, this.soapUIProjectPath));
        properties.put(MOCK_SERVICE, ContextMapping.createProperyValue(String.class, this.soapUIMockService));
        properties.put(PATH, ContextMapping.createProperyValue(String.class, this.mockServicePath));
        properties.put(PORT, ContextMapping.createProperyValue(String.class, this.mockServicePort));
        context.put(LOADUI_PROJECT_NAME, this.loadUIProject);
        context.put(LOADUI_TEST_CASE_NAME, this.loadUITestCase);
        context.put(MOCKSERVICE_RUNNER_LABEL, this.loadUIMockServiceRunner);
        context.put(MOCKSERVICE_RUNNER_PROPERTIES, properties);
        return context;
    }

    public HashMap<String, Object> setInitExportLoadTestToLoadUIContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(PROJECT_FILE, ContextMapping.createProperyValue(File.class, this.loadTest.getTestCase().getTestSuite().getProject().getPath()));
        properties.put(TEST_SUITE, ContextMapping.createProperyValue(String.class, this.loadTest.getTestCase().getTestSuite().getName()));
        properties.put(TEST_CASE, ContextMapping.createProperyValue(String.class, this.loadTest.getTestCase().getName()));
        properties.put(CLOSE_CONNECTIONS_AFTER_REQUEST, ContextMapping.createProperyValue(Boolean.class, Boolean.toString(this.loadTest.getSettings().getBoolean(HttpSettings.CLOSE_CONNECTIONS))));
        context.put(LOADUI_PROJECT_NAME, this.loadUIProject);
        context.put(LOADUI_TEST_CASE_NAME, this.loadUITestCase);
        context.put(SOAPUI_RUNNER_LABEL, this.loadUISoapUISampler);
        context.put(SOAPUI_RUNNER_PROPERTIES, properties);
        this.mapInitialTriggerProperties(this.loadTest);
        context.put(TRIGGER_PROPERTIES, this.triggerProperties);
        context.put(TRIGGER_LABEL, this.loadUITriggerType);
        context.put(TRIGGER_TYPE, this.loadUITriggerType);
        context.put(TRIGGER_CREATE_NEW, new Boolean(true));
        if (this.delayProperties != null) {
            context.put(DELAY_PROPERTIES, this.delayProperties);
            context.put(DELAY_LABEL, DELAY);
            context.put(DELAY_TYPE, DELAY);
            context.put(DELAY_CREATE_NEW, new Boolean(true));
        }
        this.mapAssertionProperties(this.loadTest);
        for (int i = 0; i < this.assertionPropertiesList.size(); ++i) {
            context.put(ASSERTION_PROPERTIES + i, this.assertionPropertiesList.get(i));
            context.put(ASSERTION_LABEL + i, ASSERTION + i);
            context.put(ASSERTION_TYPE + i, ASSERTION);
            context.put(ASSERTION_CREATE_NEW + i, new Boolean(true));
        }
        this.mapStatisticsProperties(this.loadTest);
        context.put(STATISTICS_PROPERTIES, this.statisticsProperties);
        context.put(STATISTICS_LABEL, STATISTICS);
        context.put(STATISTICS_TYPE, STATISTICS);
        context.put(STATISTICS_CREATE_NEW, new Boolean(true));
        return context;
    }

    protected void mapInitialTriggerProperties(WsdlLoadTest loadTest) {
        this.triggerProperties = new HashMap();
        LoadStrategy loadStrategy = loadTest.getLoadStrategy();
        if (loadStrategy instanceof SimpleLoadStrategy) {
            SimpleLoadStrategy currentStrategy = (SimpleLoadStrategy)loadStrategy;
            this.loadUITriggerType = FIXED_LOAD_TRIGGER;
            this.triggerProperties.put("load", ContextMapping.createProperyValue(Long.class, Long.toString(loadTest.getThreadCount())));
            long testDelay = currentStrategy.getTestDelay();
            if (testDelay > 0L) {
                this.delayProperties = new HashMap();
                this.delayProperties.put("delay", ContextMapping.createProperyValue(Long.class, Long.toString(testDelay)));
                int randomFactor = (int)(currentStrategy.getRandomFactor() * 100.0f);
                this.delayProperties.put("randomDelay", ContextMapping.createProperyValue(Long.class, Integer.toString(randomFactor)));
            }
            return;
        }
        if (loadStrategy instanceof VarianceLoadStrategy) {
            this.loadUITriggerType = VARIANCE_TRIGGER;
            VarianceLoadStrategy currentStrategy = (VarianceLoadStrategy)loadStrategy;
            return;
        }
        if (loadStrategy instanceof ThreadCountChangeLoadStrategy) {
            this.loadUITriggerType = RAMP_TRIGGER;
            ThreadCountChangeLoadStrategy currentStrategy = (ThreadCountChangeLoadStrategy)loadStrategy;
            return;
        }
        if (loadStrategy instanceof BurstLoadStrategy) {
            this.loadUITriggerType = FIXED_LOAD_TRIGGER;
            this.triggerProperties.put("load", ContextMapping.createProperyValue(Long.class, Long.toString(loadTest.getThreadCount())));
            return;
        }
    }

    protected void mapDefaultTriggerProperties(String generatorType) {
        this.triggerProperties = new HashMap();
        this.loadUITriggerType = generatorType;
    }

    public HashMap<String, Object> setFinalExportLoadTestToLoadUIContext(HashMap<String, Object> createdItemContext) {
        this.mapExistingTriggerProperties(this.loadTest, createdItemContext);
        createdItemContext.put(TRIGGER_PROPERTIES, this.triggerProperties);
        return createdItemContext;
    }

    protected HashMap<String, String> mapExistingTriggerProperties(WsdlLoadTest loadTest, HashMap<String, Object> createdItemContext) {
        AbstractLoadStrategy currentStrategy;
        LoadStrategy loadStrategy = loadTest.getLoadStrategy();
        this.triggerProperties = (HashMap)createdItemContext.get(TRIGGER_PROPERTIES);
        if (loadStrategy instanceof VarianceLoadStrategy) {
            this.loadUITriggerType = VARIANCE_TRIGGER;
            currentStrategy = (VarianceLoadStrategy)loadStrategy;
            long rate = this.extractLongProperty("rate");
            this.triggerProperties.put("shape", ContextMapping.createProperyValue(String.class, "Sine-wave"));
            this.triggerProperties.put("amplitude", ContextMapping.createProperyValue(Long.class, Long.toString((long)(((VarianceLoadStrategy)currentStrategy).getVariance() * (float)rate))));
            this.triggerProperties.put("period", ContextMapping.createProperyValue(Long.class, Long.toString(((VarianceLoadStrategy)currentStrategy).getInterval() / 1000L)));
        }
        if (loadStrategy instanceof ThreadCountChangeLoadStrategy) {
            this.loadUITriggerType = RAMP_TRIGGER;
            currentStrategy = (ThreadCountChangeLoadStrategy)loadStrategy;
            long end2 = this.extractLongProperty("end");
            this.triggerProperties.put("end", ContextMapping.createProperyValue(Long.class, Long.toString(end2 * (long)(((ThreadCountChangeLoadStrategy)currentStrategy).getEndThreadCount() / ((ThreadCountChangeLoadStrategy)currentStrategy).getStartThreadCount()))));
            if (loadTest.getLimitType().equals(LoadTestLimitTypesConfig.TIME)) {
                this.triggerProperties.put("period", ContextMapping.createProperyValue(Long.class, Long.toString(loadTest.getTestLimit())));
            }
        }
        return this.triggerProperties;
    }

    public Long extractLongProperty(String propertyKey) {
        Long value = null;
        String[] parts = this.triggerProperties.get(propertyKey).split("@");
        try {
            value = new Long(parts[1]);
        }
        catch (NumberFormatException e) {
            SoapUI.logError(e, "property " + propertyKey + "is not a Long");
        }
        return value;
    }

    private void mapAssertionProperties(WsdlLoadTest loadTest) {
        this.assertionPropertiesList = new ArrayList<HashMap<String, String>>();
        List<LoadTestAssertion> loadTestAssertions = loadTest.getAssertionList();
        for (LoadTestAssertion loadTestAssertion : loadTestAssertions) {
            if (!loadTestAssertion.getTargetStep().equals("- Total -")) continue;
            HashMap<String, String> asrtProperties = new HashMap<String, String>();
            if (loadTestAssertion instanceof TestStepTpsAssertion) {
                asrtProperties.put("value", ContextMapping.createProperyValue(String.class, "Tps"));
            }
            if (loadTestAssertion instanceof TestStepMaxAssertion) {
                asrtProperties.put("value", ContextMapping.createProperyValue(String.class, "Max"));
            }
            if (loadTestAssertion instanceof TestStepAverageAssertion) {
                asrtProperties.put("value", ContextMapping.createProperyValue(String.class, "Avg"));
            }
            this.assertionPropertiesList.add(asrtProperties);
        }
    }

    private void mapStatisticsProperties(WsdlLoadTest loadTest) {
        this.statisticsProperties = new HashMap();
    }

    public boolean isFinalTriggerMappingNeeded() {
        return this.loadUITriggerType.equals(VARIANCE_TRIGGER) || this.loadUITriggerType.equals(RAMP_TRIGGER);
    }
}

