/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.integration.impl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.integration.impl.CajoClient;
import com.eviware.soapui.integration.impl.TestCaseEditIntegrationImpl;
import com.eviware.soapui.integration.loadui.IntegrationUtils;
import com.eviware.soapui.settings.LoadUISettings;
import gnu.cajo.invoke.Remote;
import gnu.cajo.utils.ItemServer;
import java.io.IOException;

public class CajoServer {
    public static final String DEFAULT_SOAPUI_CAJO_PORT = "1198";
    private String server = null;
    private String port = "1198";
    private String itemName = "soapuiIntegration";

    public static CajoServer getInstance() {
        return SingletonHolder.instance;
    }

    private CajoServer() {
    }

    public void start() {
        String cajoPort = IntegrationUtils.getIntegrationPort("soapUI", LoadUISettings.SOAPUI_CAJO_PORT, DEFAULT_SOAPUI_CAJO_PORT);
        Remote.config((String)this.server, (int)Integer.valueOf(cajoPort), null, (int)0);
        try {
            ItemServer.bind((Object)new TestCaseEditIntegrationImpl(), (String)this.itemName);
            SoapUI.log("The cajo server is running on localhost:" + cajoPort + "/" + this.itemName);
        }
        catch (IOException e) {
            SoapUI.log(e.getMessage());
        }
        CajoClient.getInstance().testConnection();
    }

    public String getServer() {
        return this.server;
    }

    public String getPort() {
        return this.port;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    static class SingletonHolder {
        static CajoServer instance = new CajoServer();

        SingletonHolder() {
        }
    }
}

