/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.integration.impl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.integration.loadui.IntegrationUtils;
import com.eviware.soapui.settings.LoadUISettings;
import gnu.cajo.invoke.Remote;
import java.io.IOException;
import java.rmi.ConnectException;

public class CajoClient {
    public static final String DEFAULT_LOADUI_CAJO_PORT = "1199";
    private String server = "localhost";
    private String port = "1199";
    private String itemName = "loaduiIntegration";
    private static CajoClient instance;

    public static CajoClient getInstance() {
        if (instance == null) {
            instance = new CajoClient();
            CajoClient.instance.port = IntegrationUtils.getIntegrationPort("loadUI", LoadUISettings.LOADUI_CAJO_PORT, DEFAULT_LOADUI_CAJO_PORT);
            return instance;
        }
        return instance;
    }

    private CajoClient() {
    }

    public Object getItem() throws Exception {
        return Remote.getItem((String)("//" + this.server + ":" + this.port + "/" + this.itemName));
    }

    public Object invoke(String method, Object object) throws Exception {
        try {
            return Remote.invoke((Object)this.getItem(), (String)method, (Object)object);
        }
        catch (ConnectException e) {
            SoapUI.log.info((Object)("Could not connect to SoapUI cajo server on " + this.getConnectionString()));
            return null;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            SoapUI.log.info((Object)"Connected SoapUI cajo server, but with exception: ");
            e.printStackTrace();
            return null;
        }
    }

    public boolean testConnection() {
        try {
            Remote.invoke((Object)this.getItem(), (String)"test", null);
            this.setLoadUIPath();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setLoadUIPath() {
        String loadUIPath = SoapUI.getSettings().getString(LoadUISettings.LOADUI_PATH, "");
        if (loadUIPath == null || loadUIPath.trim().length() == 0) {
            try {
                loadUIPath = (String)this.invoke("getLoadUIPath", null);
                if (loadUIPath != null) {
                    SoapUI.getSettings().setString(LoadUISettings.LOADUI_PATH, loadUIPath);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getConnectionString() {
        return "//" + this.server + ":" + this.port + "/" + this.itemName;
    }

    public String getServer() {
        return this.server;
    }

    public String getPort() {
        return this.port;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }
}

