/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.integration.exporter;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.support.ExternalDependency;
import com.eviware.soapui.model.project.ProjectFactoryRegistry;
import com.eviware.soapui.support.SoapUIException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectExporter {
    private static final int BUFFER = 1024;
    private WsdlProject project;
    private WsdlProject projectCopy;
    private final int TEMP_DIR_ATTEMPTS = 10000;
    private File tmpDir;

    public ProjectExporter(WsdlProject project) {
        this.project = project;
    }

    public boolean exportProject(String exportPath) throws IOException, XmlException, SoapUIException {
        boolean result = false;
        this.tmpDir = this.createTemporaryDirectory();
        if (this.tmpDir != null) {
            if (this.createProjectCopy() && this.copyDependencies()) {
                this.projectCopy.setResourceRoot("${projectDir}");
                this.projectCopy.save();
                if (this.packageAll(exportPath)) {
                    result = true;
                }
            }
            this.deleteDir(this.tmpDir);
        }
        return result;
    }

    private boolean packageAll(String exportPath) {
        if (!exportPath.endsWith(".zip")) {
            exportPath = exportPath + ".zip";
        }
        BufferedInputStream origin = null;
        boolean result = true;
        try {
            FileOutputStream dest = new FileOutputStream(exportPath);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[1024];
            String[] files = this.tmpDir.list();
            for (int i = 0; i < files.length; ++i) {
                int count;
                FileInputStream fi = new FileInputStream(new File(this.tmpDir, files[i]));
                origin = new BufferedInputStream(fi, 1024);
                ZipEntry entry = new ZipEntry(files[i]);
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, 1024)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
            }
            out.close();
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }

    public static void unpackageAll(String archive, String path) {
        try {
            ZipEntry entry;
            BufferedOutputStream dest = null;
            FileInputStream fis = new FileInputStream(archive);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                byte[] data = new byte[1024];
                FileOutputStream fos = new FileOutputStream(path + File.separator + entry.getName());
                dest = new BufferedOutputStream(fos, 1024);
                while ((count = zis.read(data, 0, 1024)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            zis.close();
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    public static List<String> getZipContents(String archive) {
        ArrayList<String> contents = new ArrayList<String>();
        try {
            ZipFile zipFile = new ZipFile(archive);
            Enumeration<? extends ZipEntry> em1 = zipFile.entries();
            while (em1.hasMoreElements()) {
                contents.add(em1.nextElement().toString());
            }
        }
        catch (ZipException ze) {
            SoapUI.logError(ze);
        }
        catch (IOException e) {
            SoapUI.logError(e);
        }
        return contents;
    }

    private boolean copyDependencies() throws IOException {
        boolean result = true;
        this.projectCopy.setResourceRoot("${projectDir}");
        List<ExternalDependency> dependencies = this.projectCopy.getExternalDependencies();
        for (ExternalDependency dependency : dependencies) {
            switch (dependency.getType()) {
                case FILE: {
                    File targetDependency;
                    File originalDependency = new File(dependency.getPath());
                    if (originalDependency.exists()) {
                        targetDependency = new File(this.tmpDir, originalDependency.getName());
                        FileUtils.copyFile((File)originalDependency, (File)targetDependency);
                        dependency.updatePath(targetDependency.getPath());
                        break;
                    }
                    SoapUI.log.warn((Object)("Do not exists on local file system [" + originalDependency.getPath() + "]"));
                    break;
                }
                case FOLDER: {
                    File originalDependency = new File(dependency.getPath());
                    File targetDependency = new File(this.tmpDir, originalDependency.getName());
                    targetDependency.mkdir();
                    FileUtils.copyDirectory((File)originalDependency, (File)targetDependency, (boolean)false);
                    dependency.updatePath(targetDependency.getPath());
                    break;
                }
            }
        }
        return result;
    }

    private boolean createProjectCopy() throws IOException, XmlException, SoapUIException {
        this.project.saveIn(new File(this.tmpDir, this.project.getName() + "-soapui-project.xml"));
        this.projectCopy = (WsdlProject)ProjectFactoryRegistry.getProjectFactory("wsdl").createNew(new File(this.tmpDir, this.project.getName() + "-soapui-project.xml").getAbsolutePath());
        return this.projectCopy != null;
    }

    private File createTemporaryDirectory() {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        return null;
    }

    private boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

