/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.registry;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.teststeps.registry.AMFRequestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.DelayStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.GotoStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.GroovyScriptStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.HttpRequestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.JdbcRequestTestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.ManualTestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.ProPlaceholderStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.PropertiesStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.PropertyTransfersStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.RestRequestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.RunTestCaseStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlMockResponseStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestRequestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepFactory;
import java.util.ArrayList;
import java.util.List;

public class WsdlTestStepRegistry {
    private static WsdlTestStepRegistry instance;
    private List<WsdlTestStepFactory> factories = new ArrayList<WsdlTestStepFactory>();

    public WsdlTestStepRegistry() {
        this.addFactory(new WsdlTestRequestStepFactory());
        this.addFactory(new GroovyScriptStepFactory());
        this.addFactory(new PropertiesStepFactory());
        this.addFactory(new PropertyTransfersStepFactory());
        this.addFactory(new GotoStepFactory());
        this.addFactory(new DelayStepFactory());
        this.addFactory(new RunTestCaseStepFactory());
        this.addFactory(new RestRequestStepFactory());
        this.addFactory(new HttpRequestStepFactory());
        this.addFactory(new WsdlMockResponseStepFactory());
        this.addFactory(new JdbcRequestTestStepFactory());
        this.addFactory(new AMFRequestStepFactory());
        this.addFactory(new ManualTestStepFactory());
        this.addFactory(new ProPlaceholderStepFactory("datasource", "soapUI Pro DataSource", "/datasource.gif"));
        this.addFactory(new ProPlaceholderStepFactory("datasourceloop", "soapUI Pro DataSourceLoop", "/datasource_loop.gif"));
        this.addFactory(new ProPlaceholderStepFactory("datasink", "soapUI Pro DataSink", "/datasink.gif"));
        this.addFactory(new ProPlaceholderStepFactory("datagen", "soapUI Pro DataGen", "/datagen.gif"));
        this.addFactory(new ProPlaceholderStepFactory("assertionteststep", "soapUI Pro Assertion TestStep", "/unknown_assertion_step.gif"));
        for (WsdlTestStepFactory factory : SoapUI.getFactoryRegistry().getFactories(WsdlTestStepFactory.class)) {
            this.addFactory(factory);
        }
    }

    public WsdlTestStepFactory getFactory(String type) {
        for (WsdlTestStepFactory factory : this.factories) {
            if (!factory.getType().equals(type)) continue;
            return factory;
        }
        return null;
    }

    public void addFactory(WsdlTestStepFactory factory) {
        this.removeFactory(factory.getType());
        this.factories.add(factory);
    }

    public void removeFactory(String type) {
        for (WsdlTestStepFactory factory : this.factories) {
            if (!factory.getType().equals(type)) continue;
            this.factories.remove(factory);
            break;
        }
    }

    public static synchronized WsdlTestStepRegistry getInstance() {
        if (instance == null) {
            instance = new WsdlTestStepRegistry();
        }
        return instance;
    }

    public WsdlTestStepFactory[] getFactories() {
        return this.factories.toArray(new WsdlTestStepFactory[this.factories.size()]);
    }

    public boolean hasFactory(TestStepConfig config) {
        return this.getFactory(config.getType()) != null;
    }
}

