/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.basic;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertedXPathImpl;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertedXPathsContainer;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.support.XPathReference;
import com.eviware.soapui.model.support.XPathReferenceContainer;
import com.eviware.soapui.model.support.XPathReferenceImpl;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JUndoableTextArea;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.soapui.support.xml.XmlUtils;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import junit.framework.ComparisonFailure;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlQName;
import org.apache.xmlbeans.impl.values.XmlValueDisconnectedException;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceEngine;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.XMLAssert;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathContainsAssertion
extends WsdlMessageAssertion
implements RequestAssertion,
ResponseAssertion,
XPathReferenceContainer {
    private static final Logger log = Logger.getLogger(XPathContainsAssertion.class);
    private String expectedContent;
    private String path;
    private JDialog configurationDialog;
    private JTextArea pathArea;
    private JTextArea contentArea;
    private boolean configureResult;
    private boolean allowWildcards;
    private boolean ignoreNamespaceDifferences;
    private boolean ignoreComments;
    public static final String ID = "XPath Match";
    public static final String LABEL = "XPath Match";
    public static final String DESCRIPTION = "Uses an XPath expression to select content from the target property and compares the result to an expected value. Applicable to any property containing XML.";
    private JCheckBox allowWildcardsCheckBox;
    private JCheckBox ignoreNamespaceDifferencesCheckBox;
    private JCheckBox ignoreCommentsCheckBox;

    public XPathContainsAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable, true, true, true, true);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.path = reader.readString("path", null);
        this.expectedContent = reader.readString("content", null);
        this.allowWildcards = reader.readBoolean("allowWildcards", false);
        this.ignoreNamespaceDifferences = reader.readBoolean("ignoreNamspaceDifferences", false);
        this.ignoreComments = reader.readBoolean("ignoreComments", false);
    }

    public String getExpectedContent() {
        return this.expectedContent;
    }

    public void setExpectedContent(String expectedContent) {
        this.setExpectedContent(expectedContent, true);
    }

    @Deprecated
    public void setContent(String content) {
        this.setExpectedContent(content);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
        this.setConfiguration(this.createConfiguration());
    }

    public boolean isAllowWildcards() {
        return this.allowWildcards;
    }

    public void setAllowWildcards(boolean allowWildcards) {
        this.allowWildcards = allowWildcards;
        this.setConfiguration(this.createConfiguration());
    }

    public boolean isIgnoreNamespaceDifferences() {
        return this.ignoreNamespaceDifferences;
    }

    public void setIgnoreNamespaceDifferences(boolean ignoreNamespaceDifferences) {
        this.ignoreNamespaceDifferences = ignoreNamespaceDifferences;
        this.setConfiguration(this.createConfiguration());
    }

    public boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    public void setIgnoreComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
        this.setConfiguration(this.createConfiguration());
    }

    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        if (!messageExchange.hasResponse()) {
            return "Missing Response";
        }
        return this.assertContent(messageExchange.getResponseContentAsXml(), context, "Response");
    }

    protected String internalAssertProperty(TestPropertyHolder source, String propertyName, MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        if (!XmlUtils.seemsToBeXml(source.getPropertyValue(propertyName))) {
            throw new AssertionException(new AssertionError("Property '" + propertyName + "' has value which is not xml!"));
        }
        return this.assertContent(source.getPropertyValue(propertyName), context, propertyName);
    }

    public String assertContent(String response, SubmitContext context, String type) throws AssertionException {
        try {
            if (this.path == null) {
                return "Missing path for XPath assertion";
            }
            if (this.expectedContent == null) {
                return "Missing content for XPath assertion";
            }
            XmlOptions options = new XmlOptions();
            if (this.ignoreComments) {
                options.setLoadStripComments();
            }
            XmlObject xml = XmlUtils.createXmlObject(response, options);
            String expandedPath = PropertyExpander.expandProperties(context, this.path);
            XmlObject[] items = xml.selectPath(expandedPath);
            AssertedXPathsContainer assertedXPathsContainer = (AssertedXPathsContainer)context.getProperty(AssertedXPathsContainer.ASSERTEDXPATHSCONTAINER_PROPERTY);
            XmlObject contentObj = null;
            String expandedContent = PropertyExpander.expandProperties(context, this.expectedContent);
            if (!expandedPath.endsWith("text()")) {
                try {
                    contentObj = XmlUtils.createXmlObject(expandedContent, options);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (items.length == 0) {
                throw new Exception("Missing content for xpath [" + this.path + "] in " + type);
            }
            options.setSavePrettyPrint();
            options.setSaveOuter();
            for (int c = 0; c < items.length; ++c) {
                try {
                    String xpath;
                    AssertedXPathImpl assertedXPathImpl = null;
                    if (assertedXPathsContainer != null && (xpath = XmlUtils.createAbsoluteXPath(items[c].getDomNode())) != null) {
                        XmlObject xmlObj = items[c];
                        assertedXPathImpl = new AssertedXPathImpl(this, xpath, xmlObj);
                        assertedXPathsContainer.addAssertedXPath(assertedXPathImpl);
                    }
                    if (contentObj == null) {
                        String expandedValue;
                        if (items[c] instanceof XmlAnySimpleType && !(items[c] instanceof XmlQName)) {
                            String value = ((XmlAnySimpleType)items[c]).getStringValue();
                            expandedValue = PropertyExpander.expandProperties(context, value);
                            XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                        } else {
                            Node domNode = items[c].getDomNode();
                            switch (domNode.getNodeType()) {
                                case 1: {
                                    expandedValue = PropertyExpander.expandProperties(context, XmlUtils.getElementText((Element)domNode));
                                    if (this.allowWildcards) {
                                        Tools.assertSimilar(expandedContent, expandedValue, '*');
                                        break;
                                    }
                                    XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                                    break;
                                }
                                case 2: {
                                    expandedValue = PropertyExpander.expandProperties(context, domNode.getNodeValue());
                                    if (this.allowWildcards) {
                                        Tools.assertSimilar(expandedContent, expandedValue, '*');
                                        break;
                                    }
                                    XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                                    break;
                                }
                                default: {
                                    expandedValue = PropertyExpander.expandProperties(context, domNode.getNodeValue());
                                    XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                                    break;
                                }
                            }
                        }
                    } else {
                        this.compareValues(contentObj.xmlText(options), items[c].xmlText(options), items[c]);
                    }
                    break;
                }
                catch (Throwable e) {
                    if (c != items.length - 1) continue;
                    throw e;
                }
            }
        }
        catch (Throwable e) {
            String msg = "";
            if (e instanceof ComparisonFailure) {
                ComparisonFailure cf = (ComparisonFailure)e;
                String expected = cf.getExpected();
                String actual = cf.getActual();
                msg = "XPathContains comparison failed, expecting [" + expected + "], actual was [" + actual + "]";
            } else {
                msg = "XPathContains assertion failed for path [" + this.path + "] : " + e.getClass().getSimpleName() + ":" + e.getMessage();
            }
            throw new AssertionException(new AssertionError(msg));
        }
        return type + " matches content for [" + this.path + "]";
    }

    private void compareValues(String expandedContent, String expandedValue, XmlObject object) throws Exception {
        Diff diff = new Diff(expandedContent, expandedValue);
        InternalDifferenceListener internalDifferenceListener = new InternalDifferenceListener();
        diff.overrideDifferenceListener((DifferenceListener)internalDifferenceListener);
        if (!diff.identical()) {
            throw new Exception(diff.toString());
        }
        StringList nodesToRemove = internalDifferenceListener.getNodesToRemove();
        if (!nodesToRemove.isEmpty()) {
            for (String node : nodesToRemove) {
                XmlObject[] paths;
                if (node == null) continue;
                int ix = node.indexOf("\n/");
                if (ix != -1) {
                    node = node.substring(0, ix + 1) + "./" + node.substring(ix + 1);
                } else if (node.startsWith("/")) {
                    node = "/" + node;
                }
                if ((paths = object.selectPath(node)).length <= 0) continue;
                Node domNode = paths[0].getDomNode();
                if (domNode.getNodeType() == 2) {
                    ((Attr)domNode).getOwnerElement().removeAttributeNode((Attr)domNode);
                } else {
                    domNode.getParentNode().removeChild(domNode);
                }
                try {
                    object.set(object.copy());
                }
                catch (XmlValueDisconnectedException e) {
                    return;
                }
            }
        }
    }

    public boolean configure() {
        if (this.configurationDialog == null) {
            this.buildConfigurationDialog();
        }
        this.pathArea.setText(this.path);
        this.contentArea.setText(this.expectedContent);
        this.allowWildcardsCheckBox.setSelected(this.allowWildcards);
        this.ignoreNamespaceDifferencesCheckBox.setSelected(this.ignoreNamespaceDifferences);
        UISupport.showDialog(this.configurationDialog);
        return this.configureResult;
    }

    protected void buildConfigurationDialog() {
        this.configurationDialog = new JDialog(UISupport.getMainFrame());
        this.configurationDialog.setTitle("XPath Match Configuration");
        this.configurationDialog.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                    }
                });
            }
        });
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)UISupport.buildDescription("Specify xpath expression and expected result", "declare namespaces with <code>declare namespace &lt;prefix&gt;='&lt;namespace&gt;';</code>", null), "North");
        JSplitPane splitPane = UISupport.createVerticalSplit();
        this.pathArea = new JUndoableTextArea();
        this.pathArea.setToolTipText("Specifies the XPath expression to select from the message for validation");
        JPanel pathPanel = new JPanel(new BorderLayout());
        JXToolBar pathToolbar = UISupport.createToolbar();
        this.addPathEditorActions(pathToolbar);
        pathPanel.add((Component)pathToolbar, "North");
        pathPanel.add((Component)new JScrollPane(this.pathArea), "Center");
        splitPane.setTopComponent(UISupport.addTitledBorder(pathPanel, "XPath Expression"));
        this.contentArea = new JUndoableTextArea();
        this.contentArea.setToolTipText("Specifies the expected result of the XPath expression");
        JPanel matchPanel = new JPanel(new BorderLayout());
        JXToolBar contentToolbar = UISupport.createToolbar();
        this.addMatchEditorActions(contentToolbar);
        matchPanel.add((Component)contentToolbar, "North");
        matchPanel.add((Component)new JScrollPane(this.contentArea), "Center");
        splitPane.setBottomComponent(UISupport.addTitledBorder(matchPanel, "Expected Result"));
        splitPane.setDividerLocation(150);
        splitPane.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        contentPanel.add((Component)splitPane, "Center");
        ButtonBarBuilder builder = new ButtonBarBuilder();
        ShowOnlineHelpAction showOnlineHelpAction = new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/response-assertions.html#XPath_Match");
        builder.addFixed((JComponent)UISupport.createToolbarButton(showOnlineHelpAction));
        builder.addGlue();
        JButton okButton = new JButton(new OkAction());
        builder.addFixed((JComponent)okButton);
        builder.addRelatedGap();
        builder.addFixed((JComponent)new JButton(new CancelAction()));
        builder.setBorder(BorderFactory.createEmptyBorder(1, 5, 5, 5));
        contentPanel.add((Component)builder.getPanel(), "South");
        this.configurationDialog.setContentPane(contentPanel);
        this.configurationDialog.setSize(800, 500);
        this.configurationDialog.setModal(true);
        UISupport.initDialogActions(this.configurationDialog, showOnlineHelpAction, okButton);
    }

    protected void addPathEditorActions(JXToolBar toolbar) {
        toolbar.addFixed(new JButton(new DeclareNamespacesFromCurrentAction()));
    }

    protected void addMatchEditorActions(JXToolBar toolbar) {
        toolbar.addFixed(new JButton(new SelectFromCurrentAction()));
        toolbar.addRelatedGap();
        toolbar.addFixed(new JButton(new TestPathAction()));
        this.allowWildcardsCheckBox = new JCheckBox("Allow Wildcards");
        Dimension dim = new Dimension(120, 20);
        this.allowWildcardsCheckBox.setSize(dim);
        this.allowWildcardsCheckBox.setPreferredSize(dim);
        this.allowWildcardsCheckBox.setOpaque(false);
        toolbar.addRelatedGap();
        toolbar.addFixed(this.allowWildcardsCheckBox);
        Dimension largerDim = new Dimension(170, 20);
        this.ignoreNamespaceDifferencesCheckBox = new JCheckBox("Ignore namespace prefixes");
        this.ignoreNamespaceDifferencesCheckBox.setSize(largerDim);
        this.ignoreNamespaceDifferencesCheckBox.setPreferredSize(largerDim);
        this.ignoreNamespaceDifferencesCheckBox.setOpaque(false);
        toolbar.addRelatedGap();
        toolbar.addFixed(this.ignoreNamespaceDifferencesCheckBox);
        this.ignoreCommentsCheckBox = new JCheckBox("Ignore XML Comments");
        this.ignoreCommentsCheckBox.setSize(largerDim);
        this.ignoreCommentsCheckBox.setPreferredSize(largerDim);
        this.ignoreCommentsCheckBox.setOpaque(false);
        toolbar.addRelatedGap();
        toolbar.addFixed(this.ignoreCommentsCheckBox);
    }

    public XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add("path", this.path);
        builder.add("content", this.expectedContent);
        builder.add("allowWildcards", this.allowWildcards);
        builder.add("ignoreNamspaceDifferences", this.ignoreNamespaceDifferences);
        builder.add("ignoreComments", this.ignoreComments);
        return builder.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void selectFromCurrent() {
        XmlCursor cursor;
        block13: {
            block12: {
                cursor = null;
                try {
                    try {
                        String txt;
                        String assertableContent = this.getAssertable().getAssertableContent();
                        if (assertableContent == null || assertableContent.trim().length() == 0) {
                            UISupport.showErrorMessage("Missing content to select from");
                            Object var9_4 = null;
                            if (cursor == null) return;
                            break block12;
                        }
                        XmlObject xml = XmlUtils.createXmlObject(assertableContent);
                        String string = txt = this.pathArea == null || !this.pathArea.isVisible() ? this.getPath() : this.pathArea.getSelectedText();
                        if (txt == null) {
                            txt = this.pathArea == null ? "" : this.pathArea.getText();
                        }
                        WsdlTestRunContext context = new WsdlTestRunContext(this.getAssertable().getTestStep());
                        String expandedPath = PropertyExpander.expandProperties(context, txt.trim());
                        if (this.contentArea != null && this.contentArea.isVisible()) {
                            this.contentArea.setText("");
                        }
                        cursor = xml.newCursor();
                        cursor.selectPath(expandedPath);
                        if (!cursor.toNextSelection()) {
                            UISupport.showErrorMessage("No match in current response");
                            break block13;
                        }
                        if (cursor.hasNextSelection()) {
                            UISupport.showErrorMessage("More than one match in current response");
                            break block13;
                        }
                        String stringValue = XmlUtils.getValueForMatch(cursor);
                        if (this.contentArea != null && this.contentArea.isVisible()) {
                            this.contentArea.setText(stringValue);
                            break block13;
                        } else {
                            this.setExpectedContent(stringValue, false);
                        }
                        break block13;
                    }
                    catch (Throwable e) {
                        UISupport.showErrorMessage("Invalid XPath expression.");
                        SoapUI.logError(e);
                        Object var9_6 = null;
                        if (cursor == null) return;
                        cursor.dispose();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_7 = null;
                    if (cursor == null) throw throwable;
                    cursor.dispose();
                    throw throwable;
                }
            }
            cursor.dispose();
            return;
        }
        Object var9_5 = null;
        if (cursor == null) return;
        cursor.dispose();
    }

    private void setExpectedContent(String expectedContent, boolean save) {
        this.expectedContent = expectedContent;
        if (save) {
            this.setConfiguration(this.createConfiguration());
        }
    }

    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        if (!messageExchange.hasRequest(true)) {
            return "Missing Request";
        }
        return this.assertContent(messageExchange.getRequestContent(), context, "Request");
    }

    public JTextArea getContentArea() {
        return this.contentArea;
    }

    public JTextArea getPathArea() {
        return this.pathArea;
    }

    public PropertyExpansion[] getPropertyExpansions() {
        ArrayList<PropertyExpansion> result = new ArrayList<PropertyExpansion>();
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this.getAssertable().getModelItem(), this, "expectedContent"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this.getAssertable().getModelItem(), this, "path"));
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    public XPathReference[] getXPathReferences() {
        ArrayList<XPathReferenceImpl> result = new ArrayList<XPathReferenceImpl>();
        if (StringUtils.hasContent(this.getPath())) {
            TestStep testStep = this.getAssertable().getTestStep();
            TestProperty property = testStep instanceof WsdlTestRequestStep ? testStep.getProperty("Response") : testStep.getProperty("Request");
            result.add(new XPathReferenceImpl("XPath for " + this.getName() + " XPathContainsAssertion in " + testStep.getName(), property, this, "path"));
        }
        return result.toArray(new XPathReference[result.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super("XPath Match", "XPath Match", XPathContainsAssertion.class);
        }

        @Override
        public String getCategory() {
            return "Property Content";
        }

        @Override
        public Class<? extends WsdlMessageAssertion> getAssertionClassType() {
            return XPathContainsAssertion.class;
        }

        @Override
        public AssertionListEntry getAssertionListEntry() {
            return new AssertionListEntry("XPath Match", "XPath Match", XPathContainsAssertion.DESCRIPTION);
        }

        @Override
        public boolean canAssert(TestPropertyHolder modelItem, String property) {
            if (!modelItem.getProperty(property).getSchemaType().isPrimitiveType()) {
                return true;
            }
            String content = modelItem.getPropertyValue(property);
            return XmlUtils.seemsToBeXml(content);
        }
    }

    public class SelectFromCurrentAction
    extends AbstractAction {
        public SelectFromCurrentAction() {
            super("Select from current");
            this.putValue("ShortDescription", "Selects the XPath expression from the current message into the Expected Content field");
        }

        public void actionPerformed(ActionEvent arg0) {
            XPathContainsAssertion.this.selectFromCurrent();
        }
    }

    public class TestPathAction
    extends AbstractAction {
        public TestPathAction() {
            super("Test");
            this.putValue("ShortDescription", "Tests the XPath expression for the current message against the Expected Content field");
        }

        public void actionPerformed(ActionEvent arg0) {
            String oldPath = XPathContainsAssertion.this.getPath();
            String oldContent = XPathContainsAssertion.this.getExpectedContent();
            boolean oldAllowWildcards = XPathContainsAssertion.this.isAllowWildcards();
            XPathContainsAssertion.this.setPath(XPathContainsAssertion.this.pathArea.getText().trim());
            XPathContainsAssertion.this.setExpectedContent(XPathContainsAssertion.this.contentArea.getText());
            XPathContainsAssertion.this.setAllowWildcards(XPathContainsAssertion.this.allowWildcardsCheckBox.isSelected());
            XPathContainsAssertion.this.setIgnoreNamespaceDifferences(XPathContainsAssertion.this.ignoreNamespaceDifferencesCheckBox.isSelected());
            XPathContainsAssertion.this.setIgnoreComments(XPathContainsAssertion.this.ignoreCommentsCheckBox.isSelected());
            try {
                String msg = XPathContainsAssertion.this.assertContent(XPathContainsAssertion.this.getAssertable().getAssertableContent(), new WsdlTestRunContext(XPathContainsAssertion.this.getAssertable().getTestStep()), "Response");
                UISupport.showInfoMessage(msg, "Success");
            }
            catch (AssertionException e) {
                UISupport.showErrorMessage(e.getMessage());
            }
            XPathContainsAssertion.this.setPath(oldPath);
            XPathContainsAssertion.this.setExpectedContent(oldContent);
            XPathContainsAssertion.this.setAllowWildcards(oldAllowWildcards);
        }
    }

    public class DeclareNamespacesFromCurrentAction
    extends AbstractAction {
        public DeclareNamespacesFromCurrentAction() {
            super("Declare");
            this.putValue("ShortDescription", "Add namespace declaration from current message to XPath expression");
        }

        public void actionPerformed(ActionEvent arg0) {
            try {
                String content = XPathContainsAssertion.this.getAssertable().getAssertableContent();
                if (content != null && content.trim().length() > 0) {
                    XPathContainsAssertion.this.pathArea.setText(XmlUtils.declareXPathNamespaces(content) + XPathContainsAssertion.this.pathArea.getText());
                } else if (UISupport.confirm("Declare namespaces from schema instead?", "Missing Response")) {
                    XPathContainsAssertion.this.pathArea.setText(XmlUtils.declareXPathNamespaces((WsdlInterface)XPathContainsAssertion.this.getAssertable().getInterface()) + XPathContainsAssertion.this.pathArea.getText());
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
            }
        }
    }

    public class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        public void actionPerformed(ActionEvent arg0) {
            XPathContainsAssertion.this.configureResult = false;
            XPathContainsAssertion.this.configurationDialog.setVisible(false);
        }
    }

    public class OkAction
    extends AbstractAction {
        public OkAction() {
            super("Save");
        }

        public void actionPerformed(ActionEvent arg0) {
            XPathContainsAssertion.this.setPath(XPathContainsAssertion.this.pathArea.getText().trim());
            XPathContainsAssertion.this.setExpectedContent(XPathContainsAssertion.this.contentArea.getText());
            XPathContainsAssertion.this.setAllowWildcards(XPathContainsAssertion.this.allowWildcardsCheckBox.isSelected());
            XPathContainsAssertion.this.setIgnoreNamespaceDifferences(XPathContainsAssertion.this.ignoreNamespaceDifferencesCheckBox.isSelected());
            XPathContainsAssertion.this.setIgnoreComments(XPathContainsAssertion.this.ignoreCommentsCheckBox.isSelected());
            XPathContainsAssertion.this.setConfiguration(XPathContainsAssertion.this.createConfiguration());
            XPathContainsAssertion.this.configureResult = true;
            XPathContainsAssertion.this.configurationDialog.setVisible(false);
        }
    }

    private final class InternalDifferenceListener
    implements DifferenceListener {
        private StringList nodesToRemove = new StringList();

        private InternalDifferenceListener() {
        }

        public int differenceFound(Difference diff) {
            if (XPathContainsAssertion.this.allowWildcards && (diff.getId() == DifferenceEngine.TEXT_VALUE.getId() || diff.getId() == DifferenceEngine.ATTR_VALUE.getId())) {
                if (diff.getControlNodeDetail().getValue().equals("*")) {
                    Node node = diff.getTestNodeDetail().getNode();
                    String xp = XmlUtils.createAbsoluteXPath(node.getNodeType() == 2 ? node : node.getParentNode());
                    this.nodesToRemove.add(xp);
                    return 1;
                }
            } else if (XPathContainsAssertion.this.allowWildcards && diff.getId() == DifferenceEngine.NODE_TYPE.getId()) {
                if (diff.getControlNodeDetail().getNode().getNodeValue().equals("*")) {
                    Node node = diff.getTestNodeDetail().getNode();
                    String xp = XmlUtils.createAbsoluteXPath(node.getNodeType() == 2 ? node : node.getParentNode());
                    this.nodesToRemove.add(xp);
                    return 1;
                }
            } else if (XPathContainsAssertion.this.ignoreNamespaceDifferences && diff.getId() == 15) {
                return 1;
            }
            return 0;
        }

        public void skippedComparison(Node arg0, Node arg1) {
        }

        public StringList getNodesToRemove() {
            return this.nodesToRemove;
        }
    }
}

