/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.RequestStepConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.support.http.HttpRequestTestStep;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.WsdlSubmit;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.WsdlSinglePartHttpResponse;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertedXPathsContainer;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepWithProperties;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContainer;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.model.support.DefaultTestStepProperty;
import com.eviware.soapui.model.support.InterfaceListenerAdapter;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.support.ProjectListenerAdapter;
import com.eviware.soapui.model.support.TestStepBeanProperty;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.OperationTestStep;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.security.Securable;
import com.eviware.soapui.support.resolver.ChangeOperationResolver;
import com.eviware.soapui.support.resolver.ImportInterfaceResolver;
import com.eviware.soapui.support.resolver.RemoveTestStepResolver;
import com.eviware.soapui.support.resolver.ResolveContext;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlTestRequestStep
extends WsdlTestStepWithProperties
implements OperationTestStep,
PropertyChangeListener,
PropertyExpansionContainer,
Assertable,
HttpRequestTestStep,
Securable {
    private static final Logger log = Logger.getLogger(WsdlTestRequestStep.class);
    private RequestStepConfig requestStepConfig;
    private WsdlTestRequest testRequest;
    private WsdlOperation wsdlOperation;
    private final InternalProjectListener projectListener = new InternalProjectListener();
    private final InternalInterfaceListener interfaceListener = new InternalInterfaceListener();
    private WsdlSubmit<WsdlRequest> submit;

    public WsdlTestRequestStep(WsdlTestCase testCase, TestStepConfig config, boolean forLoadTest) {
        super(testCase, config, true, forLoadTest);
        if (((TestStepConfig)this.getConfig()).getConfig() != null) {
            this.requestStepConfig = (RequestStepConfig)((TestStepConfig)this.getConfig()).getConfig().changeType(RequestStepConfig.type);
            this.wsdlOperation = this.findWsdlOperation();
            if (this.wsdlOperation == null) {
                log.error((Object)("Could not find operation [" + this.requestStepConfig.getOperation() + "] in interface [" + this.requestStepConfig.getInterface() + "] for test request [" + this.getName() + "] in TestCase [" + this.getTestCase().getTestSuite().getName() + "/" + this.getTestCase().getName() + "]"));
                this.setDisabled(true);
            } else {
                this.initTestRequest(config, forLoadTest);
            }
        } else {
            this.requestStepConfig = (RequestStepConfig)((TestStepConfig)this.getConfig()).addNewConfig().changeType(RequestStepConfig.type);
        }
        if (this.testRequest != null) {
            this.initRequestProperties();
        }
    }

    private void initRequestProperties() {
        this.addProperty(new TestStepBeanProperty("Endpoint", false, this.testRequest, "endpoint", this, false));
        this.addProperty(new TestStepBeanProperty("Username", false, this.testRequest, "username", this, true));
        this.addProperty(new TestStepBeanProperty("Password", false, this.testRequest, "password", this, true));
        this.addProperty(new TestStepBeanProperty("Domain", false, this.testRequest, "domain", this, false));
        this.addProperty(new TestStepBeanProperty("AuthType", false, this.testRequest, "authType", this, true){

            public String getDefaultValue() {
                return "XXX";
            }
        });
        this.addProperty(new TestStepBeanProperty("Request", false, this.testRequest, "requestContent", this, true){

            public String getDefaultValue() {
                return WsdlTestRequestStep.this.getOperation().createRequest(true);
            }

            public SchemaType getSchemaType() {
                try {
                    WsdlInterface iface = WsdlTestRequestStep.this.getOperation().getInterface();
                    if (WsdlUtils.isRpc(iface.getBinding())) {
                        return WsdlUtils.generateRpcBodyType(WsdlTestRequestStep.this.getOperation());
                    }
                    return iface.getDefinitionContext().getSchemaTypeSystem().findElement(WsdlTestRequestStep.this.getOperation().getRequestBodyElementQName()).getType();
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                    return XmlString.type;
                }
            }

            public QName getType() {
                return this.getSchemaType().getName();
            }
        });
        this.addProperty(new TestStepBeanProperty("Response", true, this.testRequest, "responseContent", this){

            public String getDefaultValue() {
                return WsdlTestRequestStep.this.getOperation().createResponse(true);
            }
        });
        this.addProperty(new DefaultTestStepProperty("RawRequest", true, (WsdlTestStep)this){

            public String getValue() {
                Response response = WsdlTestRequestStep.this.testRequest.getResponse();
                return response == null ? null : response.getRequestContent();
            }
        });
    }

    private void initTestRequest(TestStepConfig config, boolean forLoadTest) {
        if (!forLoadTest) {
            this.wsdlOperation.getInterface().getProject().addProjectListener(this.projectListener);
            this.wsdlOperation.getInterface().addInterfaceListener(this.interfaceListener);
            this.wsdlOperation.getInterface().addPropertyChangeListener(this);
            this.wsdlOperation.addPropertyChangeListener(this);
        }
        this.testRequest = new WsdlTestRequest(this.wsdlOperation, this.requestStepConfig.getRequest(), this, forLoadTest);
        this.testRequest.addPropertyChangeListener(this);
        if (config.isSetName()) {
            this.testRequest.setName(config.getName());
        } else {
            config.setName(this.testRequest.getName());
        }
    }

    @Override
    public WsdlTestStep clone(WsdlTestCase targetTestCase, String name) {
        this.beforeSave();
        TestStepConfig config = (TestStepConfig)((TestStepConfig)this.getConfig()).copy();
        RequestStepConfig stepConfig = (RequestStepConfig)config.getConfig().changeType(RequestStepConfig.type);
        while (stepConfig.getRequest().sizeOfAttachmentArray() > 0) {
            stepConfig.getRequest().removeAttachment(0);
        }
        config.setName(name);
        stepConfig.getRequest().setName(name);
        WsdlTestRequestStep result = (WsdlTestRequestStep)targetTestCase.addTestStep(config);
        this.testRequest.copyAttachmentsTo(result.getTestRequest());
        return result;
    }

    private WsdlOperation findWsdlOperation() {
        WsdlTestCase testCase = this.getTestCase();
        if (testCase == null || testCase.getTestSuite() == null) {
            return null;
        }
        WsdlProject project = testCase.getTestSuite().getProject();
        WsdlOperation operation = null;
        for (int c = 0; c < project.getInterfaceCount(); ++c) {
            if (!project.getInterfaceAt(c).getName().equals(this.requestStepConfig.getInterface())) continue;
            WsdlInterface iface = (WsdlInterface)project.getInterfaceAt(c);
            for (int i = 0; i < iface.getOperationCount(); ++i) {
                if (!iface.getOperationAt(i).getName().equals(this.requestStepConfig.getOperation())) continue;
                operation = iface.getOperationAt(i);
                break;
            }
            if (operation != null) break;
        }
        return operation;
    }

    public String getInterfaceName() {
        return this.requestStepConfig.getInterface();
    }

    public String getOperationName() {
        return this.requestStepConfig.getOperation();
    }

    @Override
    public void release() {
        super.release();
        if (this.wsdlOperation == null) {
            this.wsdlOperation = this.findWsdlOperation();
        }
        if (this.wsdlOperation != null) {
            this.wsdlOperation.removePropertyChangeListener(this);
            this.wsdlOperation.getInterface().getProject().removeProjectListener(this.projectListener);
            this.wsdlOperation.getInterface().removeInterfaceListener(this.interfaceListener);
            this.wsdlOperation.getInterface().removePropertyChangeListener(this);
        }
        if (this.testRequest != null) {
            this.testRequest.removePropertyChangeListener(this);
            this.testRequest.release();
        }
    }

    @Override
    public void resetConfigOnMove(TestStepConfig config) {
        super.resetConfigOnMove(config);
        this.requestStepConfig = (RequestStepConfig)config.getConfig().changeType(RequestStepConfig.type);
        this.testRequest.updateConfig(this.requestStepConfig.getRequest());
    }

    @Override
    public ImageIcon getIcon() {
        return this.testRequest == null ? null : this.testRequest.getIcon();
    }

    @Override
    public WsdlTestRequest getTestRequest() {
        return this.testRequest;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.testRequest.setName(name);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.testRequest) {
            if (event.getNewValue() instanceof WsdlSinglePartHttpResponse) {
                WsdlSinglePartHttpResponse response = (WsdlSinglePartHttpResponse)event.getNewValue();
                WsdlRequest request = response.getRequest();
                byte[] rawRequest = response.getRawRequestData();
                this.firePropertyValueChanged("Response", String.valueOf(response), null);
                this.firePropertyValueChanged("Request", String.valueOf(request), null);
                this.firePropertyValueChanged("RawRequest", String.valueOf(rawRequest), null);
            }
            if (event.getPropertyName().equals("domain")) {
                this.delegatePropertyChange("Domain", event);
            } else if (event.getPropertyName().equals("password")) {
                this.delegatePropertyChange("Password", event);
            } else if (event.getPropertyName().equals("username")) {
                this.delegatePropertyChange("Username", event);
            } else if (event.getPropertyName().equals("endpoint")) {
                this.delegatePropertyChange("Endpoint", event);
            }
        }
        if (event.getSource() == this.wsdlOperation) {
            if (event.getPropertyName().equals(Operation.NAME_PROPERTY)) {
                this.requestStepConfig.setOperation((String)event.getNewValue());
            }
        } else if (event.getSource() == this.wsdlOperation.getInterface()) {
            if (event.getPropertyName().equals(Interface.NAME_PROPERTY)) {
                this.requestStepConfig.setInterface((String)event.getNewValue());
            }
        } else if (event.getPropertyName().equals(TestAssertion.CONFIGURATION_PROPERTY) || event.getPropertyName().equals(TestAssertion.DISABLED_PROPERTY)) {
            if (this.getTestRequest().getResponse() != null) {
                this.getTestRequest().assertResponse(new WsdlTestRunContext(this));
            }
        } else {
            if (event.getSource() == this.testRequest && event.getPropertyName().equals(WsdlTestRequest.NAME_PROPERTY) && !super.getName().equals((String)event.getNewValue())) {
                super.setName((String)event.getNewValue());
            }
            this.notifyPropertyChanged(event.getPropertyName(), event.getOldValue(), event.getNewValue());
        }
    }

    private void delegatePropertyChange(String customPropertyname, PropertyChangeEvent event) {
        this.firePropertyValueChanged(customPropertyname, String.valueOf(event.getOldValue()), String.valueOf(event.getNewValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestStepResult run(TestCaseRunner runner, TestCaseRunContext runContext) {
        WsdlTestRequestStepResult testStepResult = new WsdlTestRequestStepResult(this);
        testStepResult.startTimer();
        runContext.setProperty(AssertedXPathsContainer.ASSERTEDXPATHSCONTAINER_PROPERTY, testStepResult);
        try {
            Object var6_6;
            try {
                this.submit = this.testRequest.submit(runContext, false);
                WsdlResponse response = (WsdlResponse)this.submit.getResponse();
                if (this.submit.getStatus() != Submit.Status.CANCELED) {
                    if (this.submit.getStatus() == Submit.Status.ERROR) {
                        testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                        testStepResult.addMessage(this.submit.getError().toString());
                        this.testRequest.setResponse(null, runContext);
                    } else if (response == null) {
                        testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                        testStepResult.addMessage("Request is missing response");
                        this.testRequest.setResponse(null, runContext);
                    } else {
                        runContext.setProperty(AssertedXPathsContainer.ASSERTEDXPATHSCONTAINER_PROPERTY, testStepResult);
                        this.testRequest.setResponse(response, runContext);
                        testStepResult.setTimeTaken(response.getTimeTaken());
                        testStepResult.setSize(response.getContentLength());
                        switch (this.testRequest.getAssertionStatus()) {
                            case FAILED: {
                                testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                                break;
                            }
                            case VALID: {
                                testStepResult.setStatus(TestStepResult.TestStepStatus.OK);
                                break;
                            }
                            case UNKNOWN: {
                                testStepResult.setStatus(TestStepResult.TestStepStatus.UNKNOWN);
                            }
                        }
                        testStepResult.setResponse(response, testStepResult.getStatus() != TestStepResult.TestStepStatus.FAILED);
                    }
                } else {
                    testStepResult.setStatus(TestStepResult.TestStepStatus.CANCELED);
                    testStepResult.addMessage("Request was canceled");
                }
                if (response != null) {
                    testStepResult.setRequestContent(response.getRequestContent(), testStepResult.getStatus() != TestStepResult.TestStepStatus.FAILED);
                } else {
                    testStepResult.setRequestContent(this.testRequest.getRequestContent(), testStepResult.getStatus() != TestStepResult.TestStepStatus.FAILED);
                }
                testStepResult.stopTimer();
            }
            catch (Request.SubmitException e) {
                testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                testStepResult.addMessage("SubmitException: " + e);
                testStepResult.stopTimer();
                var6_6 = null;
                this.submit = null;
            }
            var6_6 = null;
            this.submit = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.submit = null;
            throw throwable;
        }
        testStepResult.setDomain(PropertyExpander.expandProperties(runContext, this.testRequest.getDomain()));
        testStepResult.setUsername(PropertyExpander.expandProperties(runContext, this.testRequest.getUsername()));
        testStepResult.setPassword(PropertyExpander.expandProperties(runContext, this.testRequest.getPassword()));
        testStepResult.setEndpoint(PropertyExpander.expandProperties(runContext, this.testRequest.getEndpoint()));
        testStepResult.setEncoding(PropertyExpander.expandProperties(runContext, this.testRequest.getEncoding()));
        if (testStepResult.getStatus() != TestStepResult.TestStepStatus.CANCELED) {
            Assertable.AssertionStatus assertionStatus = this.testRequest.getAssertionStatus();
            switch (assertionStatus) {
                case FAILED: {
                    testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                    if (this.getAssertionCount() == 0) {
                        testStepResult.addMessage("Invalid/empty response");
                        break;
                    }
                    for (int c = 0; c < this.getAssertionCount(); ++c) {
                        WsdlMessageAssertion assertion = this.getAssertionAt(c);
                        AssertionError[] errors = assertion.getErrors();
                        if (errors == null) continue;
                        for (AssertionError error : errors) {
                            testStepResult.addMessage("[" + assertion.getName() + "] " + error.getMessage());
                        }
                    }
                    break;
                }
            }
        }
        if (this.testRequest.isDiscardResponse() && !SoapUI.getDesktop().hasDesktopPanel(this)) {
            this.testRequest.setResponse(null, runContext);
        }
        return testStepResult;
    }

    @Override
    public WsdlMessageAssertion getAssertionAt(int index) {
        return this.testRequest.getAssertionAt(index);
    }

    @Override
    public int getAssertionCount() {
        return this.testRequest == null ? 0 : this.testRequest.getAssertionCount();
    }

    public WsdlTestRequest getHttpRequest() {
        return this.testRequest;
    }

    @Override
    public boolean cancel() {
        if (this.submit == null) {
            return false;
        }
        this.submit.cancel();
        return true;
    }

    @Override
    public Collection<Interface> getRequiredInterfaces() {
        ArrayList<Interface> result = new ArrayList<Interface>();
        result.add(this.findWsdlOperation().getInterface());
        return result;
    }

    @Override
    public String getDefaultSourcePropertyName() {
        return "Response";
    }

    @Override
    public String getDefaultTargetPropertyName() {
        return "Request";
    }

    @Override
    public boolean dependsOn(AbstractWsdlModelItem<?> modelItem) {
        if (modelItem instanceof Interface && this.testRequest.getOperation().getInterface() == modelItem) {
            return true;
        }
        return modelItem instanceof Operation && this.testRequest.getOperation() == modelItem;
    }

    @Override
    public void beforeSave() {
        super.beforeSave();
        if (this.testRequest != null) {
            this.testRequest.beforeSave();
        }
    }

    @Override
    public String getDescription() {
        return this.testRequest == null ? "<missing>" : this.testRequest.getDescription();
    }

    @Override
    public void setDescription(String description) {
        if (this.testRequest != null) {
            this.testRequest.setDescription(description);
        }
    }

    public void setOperation(WsdlOperation operation) {
        if (this.wsdlOperation == operation) {
            return;
        }
        WsdlOperation oldOperation = this.wsdlOperation;
        this.wsdlOperation = operation;
        this.requestStepConfig.setInterface(operation.getInterface().getName());
        this.requestStepConfig.setOperation(operation.getName());
        if (oldOperation != null) {
            oldOperation.removePropertyChangeListener(this);
        }
        this.wsdlOperation.addPropertyChangeListener(this);
        this.initTestRequest((TestStepConfig)this.getConfig(), false);
        this.testRequest.setOperation(this.wsdlOperation);
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        return this.testRequest == null ? Collections.EMPTY_LIST : this.testRequest.getAssertionList();
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        if (this.testRequest == null) {
            return new PropertyExpansion[0];
        }
        PropertyExpansionsResult result = new PropertyExpansionsResult(this, this.testRequest);
        result.extractAndAddAll("requestContent");
        result.extractAndAddAll("endpoint");
        result.extractAndAddAll("username");
        result.extractAndAddAll("password");
        result.extractAndAddAll("domain");
        StringToStringsMap requestHeaders = this.testRequest.getRequestHeaders();
        for (String key : requestHeaders.keySet()) {
            for (String value : (List)requestHeaders.get(key)) {
                result.extractAndAddAll(new HttpTestRequestStep.RequestHeaderHolder(key, value, this.testRequest), "value");
            }
        }
        this.testRequest.addWsaPropertyExpansions(result, this.testRequest.getWsaConfig(), this);
        this.testRequest.addJMSHeaderExpansions(result, this.testRequest.getJMSHeaderConfig(), this);
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    @Override
    public TestAssertion addAssertion(String type) {
        WsdlMessageAssertion result = this.testRequest.addAssertion(type);
        return result;
    }

    @Override
    public void addAssertionsListener(AssertionsListener listener) {
        this.testRequest.addAssertionsListener(listener);
    }

    @Override
    public TestAssertion cloneAssertion(TestAssertion source, String name) {
        return this.testRequest.cloneAssertion(source, name);
    }

    @Override
    public String getAssertableContent() {
        return this.testRequest.getAssertableContent();
    }

    @Override
    public TestAssertionRegistry.AssertableType getAssertableType() {
        return this.testRequest.getAssertableType();
    }

    @Override
    public TestAssertion getAssertionByName(String name) {
        return this.testRequest.getAssertionByName(name);
    }

    @Override
    public List<TestAssertion> getAssertionList() {
        return this.testRequest.getAssertionList();
    }

    @Override
    public Assertable.AssertionStatus getAssertionStatus() {
        return this.testRequest.getAssertionStatus();
    }

    @Override
    public Interface getInterface() {
        return this.getOperation().getInterface();
    }

    @Override
    public WsdlOperation getOperation() {
        return this.wsdlOperation;
    }

    @Override
    public TestStep getTestStep() {
        return this;
    }

    @Override
    public void removeAssertion(TestAssertion assertion) {
        this.testRequest.removeAssertion(assertion);
    }

    @Override
    public TestAssertion moveAssertion(int ix, int whereTo) {
        return this.testRequest.moveAssertion(ix, whereTo);
    }

    @Override
    public void removeAssertionsListener(AssertionsListener listener) {
        this.testRequest.removeAssertionsListener(listener);
    }

    @Override
    public Map<String, TestAssertion> getAssertions() {
        return this.testRequest.getAssertions();
    }

    @Override
    public void prepare(TestCaseRunner testRunner, TestCaseRunContext testRunContext) throws Exception {
        super.prepare(testRunner, testRunContext);
        this.testRequest.setResponse(null, testRunContext);
        for (TestAssertion assertion : this.testRequest.getAssertionList()) {
            assertion.prepare(testRunner, testRunContext);
        }
    }

    @Override
    public String getDefaultAssertableContent() {
        return this.testRequest.getDefaultAssertableContent();
    }

    @Override
    public void resolve(ResolveContext<?> context) {
        super.resolve(context);
        if (this.wsdlOperation == null) {
            if (context.hasThisModelItem(this, "Missing SOAP Operation in Project", this.requestStepConfig.getInterface() + "/" + this.requestStepConfig.getOperation())) {
                return;
            }
            context.addPathToResolve(this, "Missing SOAP Operation in Project", this.requestStepConfig.getInterface() + "/" + this.requestStepConfig.getOperation()).addResolvers(new RemoveTestStepResolver(this), new ImportInterfaceResolver(this){

                protected boolean update() {
                    WsdlTestRequestStep.this.wsdlOperation = WsdlTestRequestStep.this.findWsdlOperation();
                    if (WsdlTestRequestStep.this.wsdlOperation == null) {
                        return false;
                    }
                    WsdlTestRequestStep.this.initTestRequest((TestStepConfig)WsdlTestRequestStep.this.getConfig(), false);
                    WsdlTestRequestStep.this.initRequestProperties();
                    WsdlTestRequestStep.this.setDisabled(false);
                    return true;
                }
            }, new ChangeOperationResolver(this, "Operation"){

                public boolean update() {
                    WsdlOperation wsdlOperation = (WsdlOperation)this.getSelectedOperation();
                    if (wsdlOperation == null) {
                        return false;
                    }
                    WsdlTestRequestStep.this.setOperation(wsdlOperation);
                    WsdlTestRequestStep.this.initTestRequest((TestStepConfig)WsdlTestRequestStep.this.getConfig(), false);
                    WsdlTestRequestStep.this.initRequestProperties();
                    WsdlTestRequestStep.this.setDisabled(false);
                    return true;
                }

                protected Interface[] getInterfaces(WsdlProject project) {
                    List<WsdlInterface> interfaces = ModelSupport.getChildren(project, WsdlInterface.class);
                    return interfaces.toArray(new Interface[interfaces.size()]);
                }
            });
        } else {
            this.testRequest.resolve(context);
            if (context.hasThisModelItem(this, "Missing SOAP Operation in Project", this.requestStepConfig.getInterface() + "/" + this.requestStepConfig.getOperation())) {
                ResolveContext.PathToResolve path = context.getPath(this, "Missing SOAP Operation in Project", this.requestStepConfig.getInterface() + "/" + this.requestStepConfig.getOperation());
                path.setSolved(true);
            }
        }
    }

    public class InternalInterfaceListener
    extends InterfaceListenerAdapter {
        public void operationRemoved(Operation operation) {
            if (operation == WsdlTestRequestStep.this.wsdlOperation) {
                log.debug((Object)"Removing test step due to removed operation");
                WsdlTestRequestStep.this.getTestCase().removeTestStep(WsdlTestRequestStep.this);
            }
        }

        public void operationUpdated(Operation operation) {
            if (operation == WsdlTestRequestStep.this.wsdlOperation) {
                WsdlTestRequestStep.this.requestStepConfig.setOperation(operation.getName());
            }
        }
    }

    public class InternalProjectListener
    extends ProjectListenerAdapter {
        public void interfaceRemoved(Interface iface) {
            if (WsdlTestRequestStep.this.wsdlOperation != null && WsdlTestRequestStep.this.wsdlOperation.getInterface().equals(iface)) {
                log.debug((Object)"Removing test step due to removed interface");
                WsdlTestRequestStep.this.getTestCase().removeTestStep(WsdlTestRequestStep.this);
            }
        }
    }
}

