/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.testcase;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.TestModelItem;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.support.AbstractSubmitContext;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.types.StringToObjectMap;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlTestRunContext
extends AbstractSubmitContext<TestModelItem>
implements TestCaseRunContext {
    private final TestCaseRunner testRunner;
    private int currentStepIndex;
    private TestCase testCase;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public WsdlTestRunContext(TestCaseRunner testRunner, StringToObjectMap properties, TestModelItem testModelItem) {
        super(testModelItem, properties);
        this.testRunner = testRunner;
    }

    public WsdlTestRunContext(TestStep testStep) {
        super(testStep);
        this.testRunner = null;
        this.testCase = testStep.getTestCase();
        this.currentStepIndex = this.testCase.getIndexOfTestStep(testStep);
    }

    @Override
    public TestStep getCurrentStep() {
        if (this.currentStepIndex < 0 || this.currentStepIndex >= this.getTestCase().getTestStepCount()) {
            return null;
        }
        return this.getTestCase().getTestStepAt(this.currentStepIndex);
    }

    @Override
    public void setProperty(String name, Object value) {
        Object oldValue = new Object();
        super.setProperty(name, value, this.getTestCase());
        if (this.pcs != null) {
            this.pcs.firePropertyChange(name, oldValue, value);
        }
    }

    @Override
    public int getCurrentStepIndex() {
        return this.currentStepIndex;
    }

    public void setCurrentStep(int index) {
        this.currentStepIndex = index;
    }

    @Override
    public TestCaseRunner getTestRunner() {
        return this.testRunner;
    }

    @Override
    public Object getProperty(String testStepName, String propertyName) {
        TestStep testStep = this.getTestCase().getTestStepByName(testStepName);
        return testStep == null ? null : testStep.getPropertyValue(propertyName);
    }

    @Override
    public TestCase getTestCase() {
        return this.testRunner == null ? this.testCase : this.testRunner.getTestCase();
    }

    @Override
    public Object get(Object key) {
        if ("currentStep".equals(key)) {
            return this.getCurrentStep();
        }
        if ("currentStepIndex".equals(key)) {
            return this.getCurrentStepIndex();
        }
        if ("settings".equals(key)) {
            return this.getSettings();
        }
        if ("testCase".equals(key)) {
            return this.getTestCase();
        }
        if ("testRunner".equals(key)) {
            return this.getTestRunner();
        }
        Object result = this.getProperty(key.toString());
        if (result == null) {
            result = super.get(key);
        }
        return result;
    }

    @Override
    public Object put(String key, Object value) {
        Object oldValue = this.get(key);
        this.setProperty(key, value);
        return oldValue;
    }

    @Override
    public Object getProperty(String name) {
        WsdlTestCase testCase = (WsdlTestCase)this.getTestCase();
        WsdlTestStep testStep = this.currentStepIndex >= 0 && this.currentStepIndex < testCase.getTestStepCount() ? testCase.getTestStepAt(this.currentStepIndex) : null;
        return this.getProperty(name, testStep, testCase);
    }

    public void reset() {
        this.resetProperties();
        this.currentStepIndex = 0;
    }

    @Override
    public String expand(String content) {
        return PropertyExpander.expandProperties(this, content);
    }

    public Settings getSettings() {
        return this.testCase == null ? SoapUI.getSettings() : this.testCase.getSettings();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }
}

