/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.testcase;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.support.AbstractTestRunner;
import com.eviware.soapui.impl.wsdl.testcase.WsdlProjectRunContext;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestSuiteRunner;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.propertyexpansion.DefaultPropertyExpansionContext;
import com.eviware.soapui.model.support.TestSuiteRunListenerAdapter;
import com.eviware.soapui.model.testsuite.ProjectRunContext;
import com.eviware.soapui.model.testsuite.ProjectRunListener;
import com.eviware.soapui.model.testsuite.ProjectRunner;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.model.testsuite.TestSuiteRunContext;
import com.eviware.soapui.model.testsuite.TestSuiteRunListener;
import com.eviware.soapui.model.testsuite.TestSuiteRunner;
import com.eviware.soapui.support.types.StringToObjectMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlProjectRunner
extends AbstractTestRunner<WsdlProject, WsdlProjectRunContext>
implements ProjectRunner {
    private ProjectRunListener[] listeners;
    private Set<TestSuiteRunner> finishedRunners = new HashSet<TestSuiteRunner>();
    private Set<TestSuiteRunner> activeRunners = new HashSet<TestSuiteRunner>();
    private int currentTestSuiteIndex;
    private WsdlTestSuite currentTestSuite;
    private TestSuiteRunListener internalTestRunListener = new InternalTestSuiteRunListener();

    public WsdlProjectRunner(WsdlProject project, StringToObjectMap properties) {
        super(project, properties);
    }

    @Override
    public WsdlProjectRunContext createContext(StringToObjectMap properties) {
        return new WsdlProjectRunContext(this, properties);
    }

    @Override
    public void onCancel(String reason) {
        for (TestSuiteRunner runner : this.activeRunners.toArray(new TestSuiteRunner[this.activeRunners.size()])) {
            runner.cancel(reason);
        }
    }

    @Override
    public void onFail(String reason) {
        for (TestSuiteRunner runner : this.activeRunners.toArray(new TestSuiteRunner[this.activeRunners.size()])) {
            runner.fail(reason);
        }
    }

    @Override
    public void internalRun(WsdlProjectRunContext runContext) throws Exception {
        WsdlProject project = (WsdlProject)this.getTestRunnable();
        this.listeners = project.getProjectRunListeners();
        project.runBeforeRunScript(runContext, this);
        if (!this.isRunning()) {
            return;
        }
        if (project.getTimeout() > 0L) {
            this.startTimeoutTimer(project.getTimeout());
        }
        this.notifyBeforeRun();
        if (!this.isRunning()) {
            return;
        }
        if (project.getRunType() == TestSuite.TestSuiteRunType.SEQUENTIAL) {
            this.runSequential(project, runContext);
        } else if (project.getRunType() == TestSuite.TestSuiteRunType.PARALLEL) {
            this.runParallel(project, runContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runParallel(WsdlProject project, WsdlProjectRunContext runContext) {
        this.currentTestSuiteIndex = -1;
        this.currentTestSuite = null;
        for (TestSuite testSuite : project.getTestSuiteList()) {
            if (testSuite.isDisabled()) continue;
            testSuite.addTestSuiteRunListener(this.internalTestRunListener);
            this.notifyBeforeRunTestSuite(testSuite);
            this.runTestSuite((WsdlTestSuite)testSuite, true);
        }
        try {
            Set<TestSuiteRunner> i$ = this.activeRunners;
            synchronized (i$) {
                this.activeRunners.wait();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void runSequential(WsdlProject project, WsdlProjectRunContext runContext) {
        this.currentTestSuiteIndex = 0;
        while (this.isRunning() && this.currentTestSuiteIndex < project.getTestSuiteCount()) {
            this.currentTestSuite = project.getTestSuiteAt(this.currentTestSuiteIndex);
            if (!this.currentTestSuite.isDisabled()) {
                this.notifyBeforeRunTestSuite(this.currentTestSuite);
                WsdlTestSuiteRunner testSuiteRunner = this.runTestSuite(this.currentTestSuite, false);
                this.activeRunners.remove(testSuiteRunner);
                this.finishedRunners.add(testSuiteRunner);
                this.notifyAfterRunTestSuite(testSuiteRunner);
            }
            ++this.currentTestSuiteIndex;
        }
        this.updateStatus();
    }

    private void updateStatus() {
        for (TestSuiteRunner runner : this.finishedRunners) {
            if (runner.getStatus() != TestRunner.Status.FAILED) continue;
            this.setStatus(TestRunner.Status.FAILED);
            break;
        }
    }

    private WsdlTestSuiteRunner runTestSuite(WsdlTestSuite testSuite, boolean async) {
        DefaultPropertyExpansionContext properties = (DefaultPropertyExpansionContext)((WsdlProjectRunContext)this.getRunContext()).getProperties();
        properties.put("#ProjectRunner#", this);
        properties.put("#TestSuiteRunner#", this);
        WsdlTestSuiteRunner currentRunner = testSuite.run(properties, true);
        this.activeRunners.add(currentRunner);
        if (!async) {
            currentRunner.waitUntilFinished();
        }
        return currentRunner;
    }

    @Override
    protected void internalFinally(WsdlProjectRunContext runContext) {
        WsdlProject project = (WsdlProject)this.getTestRunnable();
        try {
            project.runAfterRunScript(runContext, this);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        this.notifyAfterRun();
        runContext.clear();
        this.listeners = null;
    }

    private void notifyAfterRun() {
        if (this.listeners == null || this.listeners.length == 0) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].afterRun(this, (ProjectRunContext)this.getRunContext());
        }
    }

    private void notifyBeforeRun() {
        if (this.listeners == null || this.listeners.length == 0) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].beforeRun(this, (ProjectRunContext)this.getRunContext());
        }
    }

    private void notifyAfterRunTestSuite(TestSuiteRunner testSuiteRunner) {
        if (this.listeners == null || this.listeners.length == 0) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].afterTestSuite(this, (ProjectRunContext)this.getRunContext(), testSuiteRunner);
        }
    }

    private void notifyBeforeRunTestSuite(TestSuite testSuite) {
        if (this.listeners == null || this.listeners.length == 0) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].beforeTestSuite(this, (ProjectRunContext)this.getRunContext(), testSuite);
        }
    }

    @Override
    public List<TestSuiteRunner> getResults() {
        return Arrays.asList(this.finishedRunners.toArray(new TestSuiteRunner[this.finishedRunners.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishRunner(TestSuiteRunner testRunner) {
        this.notifyAfterRunTestSuite(testRunner);
        this.activeRunners.remove(testRunner);
        this.finishedRunners.add(testRunner);
        testRunner.getTestSuite().removeTestSuiteRunListener(this.internalTestRunListener);
        if (this.activeRunners.isEmpty()) {
            this.updateStatus();
            Set<TestSuiteRunner> set = this.activeRunners;
            synchronized (set) {
                this.activeRunners.notify();
            }
        }
    }

    @Override
    public Project getProject() {
        return (Project)this.getTestRunnable();
    }

    private class InternalTestSuiteRunListener
    extends TestSuiteRunListenerAdapter {
        private InternalTestSuiteRunListener() {
        }

        public void afterRun(TestSuiteRunner testRunner, TestSuiteRunContext runContext) {
            WsdlProjectRunner.this.finishRunner(testRunner);
        }
    }
}

