/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.xsd;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.SoapUIExtensionClassLoader;
import com.eviware.soapui.impl.wsdl.support.xsd.SchemaException;
import com.eviware.soapui.impl.wsdl.support.xsd.SchemaLoader;
import com.eviware.soapui.impl.wsdl.support.xsd.SettingUtils;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaAnnotation;
import org.apache.xmlbeans.SchemaField;
import org.apache.xmlbeans.SchemaLocalElement;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlBase64Binary;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlHexBinary;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaUtils {
    private static final Logger log = Logger.getLogger(SchemaUtils.class);
    private static Map<String, XmlObject> defaultSchemas = new HashMap<String, XmlObject>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDefaultSchemas() {
        SoapUIExtensionClassLoader.SoapUIClassLoaderState state = SoapUIExtensionClassLoader.ensure();
        try {
            block4: {
                try {
                    defaultSchemas.clear();
                    String root = "/com/eviware/soapui/resources/xsds";
                    SchemaUtils.loadDefaultSchema(SoapUI.class.getResource(root + "/xop.xsd"));
                    SchemaUtils.loadDefaultSchema(SoapUI.class.getResource(root + "/XMLSchema.xsd"));
                    SchemaUtils.loadDefaultSchema(SoapUI.class.getResource(root + "/xml.xsd"));
                    SchemaUtils.loadDefaultSchema(SoapUI.class.getResource(root + "/swaref.xsd"));
                    SchemaUtils.loadDefaultSchema(SoapUI.class.getResource(root + "/xmime200505.xsd"));
                    SchemaUtils.loadDefaultSchema(SoapUI.class.getResource(root + "/xmime200411.xsd"));
                    SchemaUtils.loadDefaultSchema(SoapUI.class.getResource(root + "/soapEnvelope.xsd"));
                    SchemaUtils.loadDefaultSchema(SoapUI.class.getResource(root + "/soapEncoding.xsd"));
                    SchemaUtils.loadDefaultSchema(SoapUI.class.getResource(root + "/soapEnvelope12.xsd"));
                    SchemaUtils.loadDefaultSchema(SoapUI.class.getResource(root + "/soapEncoding12.xsd"));
                    String schemaDirectory = SoapUI.getSettings().getString(WsdlSettings.SCHEMA_DIRECTORY, null);
                    if (!StringUtils.hasContent(schemaDirectory)) break block4;
                    SchemaUtils.loadSchemaDirectory(schemaDirectory);
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                    Object var4_5 = null;
                    state.restore();
                }
            }
            Object var4_4 = null;
            state.restore();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            state.restore();
            throw throwable;
        }
    }

    private static void loadSchemaDirectory(String schemaDirectory) throws IOException, MalformedURLException {
        File dir = new File(schemaDirectory);
        if (dir.exists() && dir.isDirectory()) {
            String[] xsdFiles = dir.list();
            int cnt = 0;
            if (xsdFiles != null && xsdFiles.length > 0) {
                for (int c = 0; c < xsdFiles.length; ++c) {
                    try {
                        String xsdFile = xsdFiles[c];
                        if (!xsdFile.endsWith(".xsd")) continue;
                        String filename = schemaDirectory + File.separator + xsdFile;
                        SchemaUtils.loadDefaultSchema(new URL("file:" + filename));
                        ++cnt;
                        continue;
                    }
                    catch (Throwable e) {
                        SoapUI.logError(e);
                    }
                }
            }
            if (cnt == 0) {
                log.warn((Object)("Missing schema files in  schemaDirectory [" + schemaDirectory + "]"));
            }
        } else {
            log.warn((Object)("Failed to open schemaDirectory [" + schemaDirectory + "]"));
        }
    }

    private static void loadDefaultSchema(URL url) throws Exception {
        XmlObject xmlObject = XmlUtils.createXmlObject(url);
        if (!((Document)xmlObject.getDomNode()).getDocumentElement().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            return;
        }
        String targetNamespace = SchemaUtils.getTargetNamespace(xmlObject);
        if (defaultSchemas.containsKey(targetNamespace)) {
            log.warn((Object)("Overriding schema for targetNamespace " + targetNamespace));
        }
        defaultSchemas.put(targetNamespace, xmlObject);
        log.info((Object)("Added default schema from " + url.getPath() + " with targetNamespace " + targetNamespace));
    }

    public static SchemaTypeSystem loadSchemaTypes(String wsdlUrl, SchemaLoader loader) throws SchemaException {
        SoapUIExtensionClassLoader.SoapUIClassLoaderState state = SoapUIExtensionClassLoader.ensure();
        try {
            log.info((Object)("Loading schema types from [" + wsdlUrl + "]"));
            ArrayList<XmlObject> schemas = new ArrayList<XmlObject>(SchemaUtils.getSchemas(wsdlUrl, loader).values());
            SchemaTypeSystem schemaTypeSystem = SchemaUtils.buildSchemaTypes(schemas);
            Object var6_6 = null;
            state.restore();
            return schemaTypeSystem;
        }
        catch (Exception e) {
            try {
                SoapUI.logError(e);
                if (e instanceof SchemaException) {
                    throw (SchemaException)e;
                }
                throw new SchemaException("Error loading schema types", e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                state.restore();
                throw throwable;
            }
        }
    }

    public static SchemaTypeSystem buildSchemaTypes(List<XmlObject> schemas) throws SchemaException {
        SchemaTypeSystem schemaTypeSystem;
        XmlOptions options = new XmlOptions();
        options.setCompileNoValidation();
        options.setCompileNoPvrRule();
        options.setCompileDownloadUrls();
        options.setCompileNoUpaRule();
        options.setValidateTreatLaxAsSkip();
        for (int c = 0; c < schemas.size(); ++c) {
            XmlObject xmlObject = schemas.get(c);
            if (xmlObject != null && ((Document)xmlObject.getDomNode()).getDocumentElement().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) continue;
            schemas.remove(c);
            --c;
        }
        boolean strictSchemaTypes = SoapUI.getSettings().getBoolean(WsdlSettings.STRICT_SCHEMA_TYPES);
        if (!strictSchemaTypes) {
            HashSet<String> mdefNamespaces = new HashSet<String>();
            for (XmlObject xObj : schemas) {
                mdefNamespaces.add(SchemaUtils.getTargetNamespace(xObj));
            }
            options.setCompileMdefNamespaces(mdefNamespaces);
        }
        ArrayList errorList = new ArrayList();
        options.setErrorListener(errorList);
        XmlCursor cursor = null;
        try {
            SchemaTypeSystem sts;
            for (int c = 0; c < schemas.size(); ++c) {
                XmlObject s = schemas.get(c);
                HashMap map = new HashMap();
                cursor = s.newCursor();
                cursor.toStartDoc();
                if (SchemaUtils.toNextContainer(cursor)) {
                    cursor.getAllNamespaces(map);
                } else {
                    log.warn((Object)("Can not get namespaces for " + s));
                }
                String tns = SchemaUtils.getTargetNamespace(s);
                if (strictSchemaTypes && defaultSchemas.containsKey(tns)) {
                    schemas.remove(c);
                    --c;
                } else {
                    SchemaUtils.removeImports(s);
                }
                cursor.dispose();
                cursor = null;
            }
            schemas.addAll(defaultSchemas.values());
            schemaTypeSystem = sts = XmlBeans.compileXsd((XmlObject[])schemas.toArray(new XmlObject[schemas.size()]), (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), (XmlOptions)options);
            Object var10_12 = null;
        }
        catch (Exception e) {
            try {
                SoapUI.logError(e);
                throw new SchemaException(e, errorList);
            }
            catch (Throwable throwable) {
                block15: {
                    Object var10_13 = null;
                    for (int c = 0; c < errorList.size(); ++c) {
                        log.warn((Object)("Error: " + errorList.get(c)));
                    }
                    if (cursor == null) break block15;
                    cursor.dispose();
                }
                throw throwable;
            }
        }
        for (int c = 0; c < errorList.size(); ++c) {
            log.warn((Object)("Error: " + errorList.get(c)));
        }
        if (cursor != null) {
            cursor.dispose();
        }
        return schemaTypeSystem;
    }

    public static boolean toNextContainer(XmlCursor cursor) {
        while (!cursor.isContainer() && !cursor.isEnddoc()) {
            cursor.toNextToken();
        }
        return cursor.isContainer();
    }

    public static String getTargetNamespace(XmlObject s) {
        return ((Document)s.getDomNode()).getDocumentElement().getAttribute("targetNamespace");
    }

    public static Map<String, XmlObject> getSchemas(String wsdlUrl, SchemaLoader loader) throws SchemaException {
        HashMap<String, XmlObject> result = new HashMap<String, XmlObject>();
        SchemaUtils.getSchemas(wsdlUrl, result, loader, null);
        return result;
    }

    public static void getSchemas(String wsdlUrl, Map<String, XmlObject> existing, SchemaLoader loader, String tns) throws SchemaException {
        if (existing.containsKey(wsdlUrl)) {
            return;
        }
        log.info((Object)("Getting schema " + wsdlUrl));
        ArrayList errorList = new ArrayList();
        HashMap<String, XmlObject> result = new HashMap<String, XmlObject>();
        boolean common = false;
        try {
            String location;
            int i;
            XmlObject[] schemas;
            XmlOptions options = new XmlOptions();
            options.setCompileNoValidation();
            options.setSaveUseOpenFrag();
            options.setErrorListener(errorList);
            options.setSaveSyntheticDocumentElement(new QName("http://www.w3.org/2001/XMLSchema", "schema"));
            XmlObject xmlObject = loader.loadXmlObject(wsdlUrl, options);
            if (xmlObject == null) {
                throw new Exception("Failed to load schema from [" + wsdlUrl + "]");
            }
            Document dom = (Document)xmlObject.getDomNode();
            Element domNode = dom.getDocumentElement();
            if (domNode.getLocalName().equals("schema") && "http://www.w3.org/2001/XMLSchema".equals(domNode.getNamespaceURI())) {
                if (tns != null) {
                    Node item;
                    int c;
                    Element elm = domNode;
                    if (!elm.hasAttribute("targetNamespace")) {
                        common = true;
                        elm.setAttribute("targetNamespace", tns);
                    }
                    NamedNodeMap attributes = elm.getAttributes();
                    for (c = 0; !(c >= attributes.getLength() || (item = attributes.item(c)).getNodeName().equals("xmlns") || item.getNodeValue().equals(tns) && item.getNodeName().startsWith("xmlns")); ++c) {
                    }
                    if (c == attributes.getLength()) {
                        elm.setAttribute("xmlns", tns);
                    }
                }
                if (common && !existing.containsKey(wsdlUrl + "@" + tns)) {
                    result.put(wsdlUrl + "@" + tns, xmlObject);
                } else {
                    result.put(wsdlUrl, xmlObject);
                }
            } else {
                existing.put(wsdlUrl, null);
                schemas = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:schema");
                for (int i2 = 0; i2 < schemas.length; ++i2) {
                    XmlCursor xmlCursor = schemas[i2].newCursor();
                    String xmlText = xmlCursor.getObject().xmlText(options);
                    schemas[i2] = XmlUtils.createXmlObject(xmlText, options);
                    schemas[i2].documentProperties().setSourceName(wsdlUrl);
                    result.put(wsdlUrl + "@" + (i2 + 1), schemas[i2]);
                }
                XmlObject[] wsdlImports = xmlObject.selectPath("declare namespace s='http://schemas.xmlsoap.org/wsdl/' .//s:import/@location");
                for (int i3 = 0; i3 < wsdlImports.length; ++i3) {
                    String location2 = ((SimpleValue)wsdlImports[i3]).getStringValue();
                    if (location2 == null) continue;
                    if (!location2.startsWith("file:") && location2.indexOf("://") == -1) {
                        location2 = Tools.joinRelativeUrl(wsdlUrl, location2);
                    }
                    SchemaUtils.getSchemas(location2, existing, loader, null);
                }
                XmlObject[] wadl10Imports = xmlObject.selectPath("declare namespace s='http://research.sun.com/wadl/2006/10' .//s:grammars/s:include/@href");
                for (int i4 = 0; i4 < wadl10Imports.length; ++i4) {
                    String location3 = ((SimpleValue)wadl10Imports[i4]).getStringValue();
                    if (location3 == null) continue;
                    if (!location3.startsWith("file:") && location3.indexOf("://") == -1) {
                        location3 = Tools.joinRelativeUrl(wsdlUrl, location3);
                    }
                    SchemaUtils.getSchemas(location3, existing, loader, null);
                }
                XmlObject[] wadlImports = xmlObject.selectPath("declare namespace s='http://wadl.dev.java.net/2009/02' .//s:grammars/s:include/@href");
                for (i = 0; i < wadlImports.length; ++i) {
                    location = ((SimpleValue)wadlImports[i]).getStringValue();
                    if (location == null) continue;
                    if (!location.startsWith("file:") && location.indexOf("://") == -1) {
                        location = Tools.joinRelativeUrl(wsdlUrl, location);
                    }
                    SchemaUtils.getSchemas(location, existing, loader, null);
                }
            }
            existing.putAll(result);
            schemas = result.values().toArray(new XmlObject[result.size()]);
            for (int c = 0; c < schemas.length; ++c) {
                xmlObject = schemas[c];
                XmlObject[] schemaImports = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:import/@schemaLocation");
                for (int i5 = 0; i5 < schemaImports.length; ++i5) {
                    String location4 = ((SimpleValue)schemaImports[i5]).getStringValue();
                    Element elm = ((Attr)schemaImports[i5].getDomNode()).getOwnerElement();
                    if (location4 == null || defaultSchemas.containsKey(elm.getAttribute("namespace"))) continue;
                    if (!location4.startsWith("file:") && location4.indexOf("://") == -1) {
                        location4 = Tools.joinRelativeUrl(wsdlUrl, location4);
                    }
                    SchemaUtils.getSchemas(location4, existing, loader, null);
                }
                XmlObject[] schemaIncludes = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:include/@schemaLocation");
                for (i = 0; i < schemaIncludes.length; ++i) {
                    location = ((SimpleValue)schemaIncludes[i]).getStringValue();
                    if (location == null) continue;
                    String targetNS = SchemaUtils.getTargetNamespace(xmlObject);
                    if (!location.startsWith("file:") && location.indexOf("://") == -1) {
                        location = Tools.joinRelativeUrl(wsdlUrl, location);
                    }
                    SchemaUtils.getSchemas(location, existing, loader, targetNS);
                }
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
            throw new SchemaException(e, errorList);
        }
    }

    public static Map<String, XmlObject> getDefinitionParts(SchemaLoader loader) throws Exception {
        LinkedHashMap<String, XmlObject> result = new LinkedHashMap<String, XmlObject>();
        SchemaUtils.getDefinitionParts(loader.getBaseURI(), result, loader);
        return result;
    }

    public static void getDefinitionParts(String origWsdlUrl, Map<String, XmlObject> existing, SchemaLoader loader) throws Exception {
        String wsdlUrl = origWsdlUrl;
        if (existing.containsKey(wsdlUrl)) {
            return;
        }
        XmlObject xmlObject = loader.loadXmlObject(wsdlUrl, null);
        existing.put(wsdlUrl, xmlObject);
        SchemaUtils.selectDefinitionParts(wsdlUrl, existing, loader, xmlObject, "declare namespace s='http://schemas.xmlsoap.org/wsdl/' .//s:import/@location");
        SchemaUtils.selectDefinitionParts(wsdlUrl, existing, loader, xmlObject, "declare namespace s='http://research.sun.com/wadl/2006/10' .//s:grammars/s:include/@href");
        SchemaUtils.selectDefinitionParts(wsdlUrl, existing, loader, xmlObject, "declare namespace s='http://wadl.dev.java.net/2009/02' .//s:grammars/s:include/@href");
        SchemaUtils.selectDefinitionParts(wsdlUrl, existing, loader, xmlObject, "declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:import/@schemaLocation");
        SchemaUtils.selectDefinitionParts(wsdlUrl, existing, loader, xmlObject, "declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:include/@schemaLocation");
    }

    private static void selectDefinitionParts(String wsdlUrl, Map<String, XmlObject> existing, SchemaLoader loader, XmlObject xmlObject, String path) throws Exception {
        XmlObject[] wsdlImports = xmlObject.selectPath(path);
        for (int i = 0; i < wsdlImports.length; ++i) {
            String location = ((SimpleValue)wsdlImports[i]).getStringValue();
            if (location == null) continue;
            if (StringUtils.hasContent(location)) {
                if (!location.startsWith("file:") && location.indexOf("://") == -1) {
                    location = Tools.joinRelativeUrl(wsdlUrl, location);
                }
                SchemaUtils.getDefinitionParts(location, existing, loader);
                continue;
            }
            Element domNode = ((Attr)wsdlImports[i].getDomNode()).getOwnerElement();
            domNode.getParentNode().removeChild(domNode);
        }
    }

    public static Collection<String> extractNamespaces(SchemaTypeSystem schemaTypes, boolean removeDefault) {
        HashSet<String> namespaces = new HashSet<String>();
        SchemaType[] globalTypes = schemaTypes.globalTypes();
        for (int c = 0; c < globalTypes.length; ++c) {
            namespaces.add(globalTypes[c].getName().getNamespaceURI());
        }
        if (removeDefault) {
            namespaces.removeAll(defaultSchemas.keySet());
            namespaces.remove("http://schemas.xmlsoap.org/soap/envelope/");
            namespaces.remove("http://schemas.xmlsoap.org/soap/encoding/");
        }
        return namespaces;
    }

    public static void removeImports(XmlObject xmlObject) throws XmlException {
        XmlObject[] imports = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:import");
        for (int c = 0; c < imports.length; ++c) {
            XmlCursor cursor = imports[c].newCursor();
            cursor.removeXml();
            cursor.dispose();
        }
        XmlObject[] includes = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:include");
        for (int c = 0; c < includes.length; ++c) {
            XmlCursor cursor = includes[c].newCursor();
            cursor.removeXml();
            cursor.dispose();
        }
    }

    public static boolean isInstanceOf(SchemaType schemaType, SchemaType baseType) {
        if (schemaType == null) {
            return false;
        }
        return schemaType.equals(baseType) ? true : SchemaUtils.isInstanceOf(schemaType.getBaseType(), baseType);
    }

    public static boolean isBinaryType(SchemaType schemaType) {
        return SchemaUtils.isInstanceOf(schemaType, XmlHexBinary.type) || SchemaUtils.isInstanceOf(schemaType, XmlBase64Binary.type);
    }

    public static String getDocumentation(SchemaType schemaType) {
        XmlObject[] userInformation;
        XmlObject[] userInformation2;
        SchemaAnnotation annotation;
        String result = null;
        String xsPrefix = null;
        SchemaField containerField = schemaType.getContainerField();
        if (containerField instanceof SchemaLocalElement && (annotation = ((SchemaLocalElement)containerField).getAnnotation()) != null && (userInformation2 = annotation.getUserInformation()) != null && userInformation2.length > 0) {
            XmlObject xmlObject = userInformation2[0];
            XmlCursor cursor = xmlObject.newCursor();
            xsPrefix = cursor.prefixForNamespace("http://www.w3.org/2001/XMLSchema");
            cursor.dispose();
            result = xmlObject.xmlText();
        }
        if (result == null && schemaType != null && schemaType.getAnnotation() != null && (userInformation = schemaType.getAnnotation().getUserInformation()) != null && userInformation.length > 0 && userInformation[0] != null) {
            XmlObject xmlObject = userInformation[0];
            XmlCursor cursor = xmlObject.newCursor();
            xsPrefix = cursor.prefixForNamespace("http://www.w3.org/2001/XMLSchema");
            cursor.dispose();
            result = xmlObject.xmlText();
        }
        if (result != null) {
            if ((result = result.trim()).startsWith("<") && result.endsWith(">")) {
                int ix = result.indexOf(62);
                if (ix > 0) {
                    result = result.substring(ix + 1);
                }
                if ((ix = result.lastIndexOf(60)) >= 0) {
                    result = result.substring(0, ix);
                }
            }
            xsPrefix = xsPrefix == null || xsPrefix.length() == 0 ? "xs:" : xsPrefix + ":";
            result = result.trim().replaceAll(xsPrefix, "").trim();
            result = StringUtils.toHtml(result);
        }
        return result;
    }

    public static String[] getEnumerationValues(SchemaType schemaType, boolean addNull) {
        XmlAnySimpleType[] enumerationValues;
        if (schemaType != null && (enumerationValues = schemaType.getEnumerationValues()) != null && enumerationValues.length > 0) {
            if (addNull) {
                String[] values = new String[enumerationValues.length + 1];
                values[0] = null;
                for (int c = 1; c < values.length; ++c) {
                    values[c] = enumerationValues[c - 1].getStringValue();
                }
                return values;
            }
            String[] values = new String[enumerationValues.length];
            for (int c = 0; c < values.length; ++c) {
                values[c] = enumerationValues[c].getStringValue();
            }
            return values;
        }
        return new String[0];
    }

    public static Collection<? extends QName> getExcludedTypes() {
        String excluded = SoapUI.getSettings().getString(WsdlSettings.EXCLUDED_TYPES, null);
        return SettingUtils.string2QNames(excluded);
    }

    public static boolean isAnyType(SchemaType schemaType) {
        return schemaType != null && (schemaType.getBuiltinTypeCode() == 1 || schemaType.getBaseType() != null && schemaType.getBaseType().getBuiltinTypeCode() == 1);
    }

    static {
        SchemaUtils.initDefaultSchemas();
        SoapUI.getSettings().addSettingsListener(new SettingsListener(){

            public void settingChanged(String name, String newValue, String oldValue) {
                if (name.equals(WsdlSettings.SCHEMA_DIRECTORY)) {
                    log.info((Object)"Reloading default schemas..");
                    SchemaUtils.initDefaultSchemas();
                }
            }

            public void settingsReloaded() {
            }
        });
    }
}

