/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wsdl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.AnonymousTypeConfig;
import com.eviware.soapui.config.DefinitionCacheConfig;
import com.eviware.soapui.config.DefinitionCacheTypeConfig;
import com.eviware.soapui.config.DefintionPartConfig;
import com.eviware.soapui.config.WsaVersionTypeConfig;
import com.eviware.soapui.impl.support.definition.DefinitionLoader;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.WsdlMessageExchange;
import com.eviware.soapui.impl.wsdl.support.soap.SoapUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsa.WsaConfig;
import com.eviware.soapui.impl.wsdl.support.wsa.WsaUtils;
import com.eviware.soapui.impl.wsdl.support.wsdl.UrlWsdlLoader;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.impl.wsdl.support.xsd.SchemaUtils;
import com.eviware.soapui.settings.WsaSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.support.xml.XmlUtils;
import com.ibm.wsdl.util.xml.QNameUtils;
import com.ibm.wsdl.xml.WSDLReaderImpl;
import com.ibm.wsdl.xml.WSDLWriterImpl;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.AttributeExtensible;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Fault;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlUtils {
    private static final Logger log = Logger.getLogger(WsdlUtils.class);
    private static WSDLReader wsdlReader;
    private static final String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";

    public static <T extends ExtensibilityElement> T getExtensiblityElement(List<?> list, Class<T> clazz) {
        List<T> elements = WsdlUtils.getExtensiblityElements(list, clazz);
        return (T)(elements.isEmpty() ? null : (ExtensibilityElement)elements.get(0));
    }

    public static <T extends ExtensibilityElement> List<T> getExtensiblityElements(List list, Class<T> clazz) {
        ArrayList<ExtensibilityElement> result = new ArrayList<ExtensibilityElement>();
        for (ExtensibilityElement elm : list) {
            if (!clazz.isAssignableFrom(elm.getClass())) continue;
            result.add(elm);
        }
        return result;
    }

    public static Element[] getExentsibilityElements(ElementExtensible item, QName qname) {
        if (item == null) {
            return new Element[0];
        }
        ArrayList<Element> result = new ArrayList<Element>();
        List list = item.getExtensibilityElements();
        for (ExtensibilityElement elm : list) {
            if (!elm.getElementType().equals(qname) || !(elm instanceof UnknownExtensibilityElement)) continue;
            result.add(((UnknownExtensibilityElement)elm).getElement());
        }
        return result.toArray(new Element[result.size()]);
    }

    public static String[] getExentsibilityAttributes(AttributeExtensible item, QName qname) {
        if (item == null) {
            return new String[0];
        }
        StringList result = new StringList();
        Map map = item.getExtensionAttributes();
        for (QName name : map.keySet()) {
            if (!name.equals(qname)) continue;
            result.add(map.get(name).toString());
        }
        return result.toStringArray();
    }

    public static String getSoapAction(BindingOperation operation) {
        List list = operation.getExtensibilityElements();
        SOAPOperation soapOperation = WsdlUtils.getExtensiblityElement(list, SOAPOperation.class);
        if (soapOperation != null) {
            return soapOperation.getSoapActionURI();
        }
        SOAP12Operation soap12Operation = WsdlUtils.getExtensiblityElement(list, SOAP12Operation.class);
        if (soap12Operation != null) {
            return soap12Operation.getSoapActionURI();
        }
        return null;
    }

    public static String[] getEndpointsForBinding(Definition definition, Binding binding) {
        ArrayList<String> result = new ArrayList<String>();
        Map map = definition.getAllServices();
        for (Service service : map.values()) {
            Map portMap = service.getPorts();
            for (Port port : portMap.values()) {
                String endpoint;
                if (port.getBinding() != binding || (endpoint = WsdlUtils.getSoapEndpoint(port)) == null) continue;
                result.add(endpoint);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static Binding findBindingForOperation(Definition definition, BindingOperation bindingOperation) {
        List bindingOperations;
        Binding binding;
        Map services = definition.getAllServices();
        Iterator s = services.values().iterator();
        while (s.hasNext()) {
            Map ports = ((Service)s.next()).getPorts();
            Iterator p = ports.values().iterator();
            while (p.hasNext()) {
                binding = ((Port)p.next()).getBinding();
                bindingOperations = binding.getBindingOperations();
                for (BindingOperation op : bindingOperations) {
                    if (!op.getName().equals(bindingOperation.getName())) continue;
                    return binding;
                }
            }
        }
        Map bindings = definition.getAllBindings();
        Iterator names = bindings.keySet().iterator();
        while (names.hasNext()) {
            binding = definition.getBinding((QName)names.next());
            bindingOperations = binding.getBindingOperations();
            for (BindingOperation op : bindingOperations) {
                if (!op.getName().equals(bindingOperation.getName())) continue;
                return binding;
            }
        }
        return null;
    }

    public static BindingOperation findBindingOperation(Definition definition, String operationName) {
        Map services = definition.getAllServices();
        for (QName qName : services.keySet()) {
            Service service = definition.getService(qName);
            Map ports = service.getPorts();
            for (String key : ports.keySet()) {
                Port port = service.getPort(key);
                BindingOperation bindingOperation = port.getBinding().getBindingOperation(operationName, null, null);
                if (bindingOperation == null) continue;
                return bindingOperation;
            }
        }
        Map bindings = definition.getAllBindings();
        for (Object key : bindings.keySet()) {
            Binding binding = (Binding)bindings.get(key);
            BindingOperation bindingOperation = binding.getBindingOperation(operationName, null, null);
            if (bindingOperation == null) continue;
            return bindingOperation;
        }
        return null;
    }

    public static boolean isInputSoapEncoded(BindingOperation bindingOperation) {
        if (bindingOperation == null) {
            return false;
        }
        BindingInput bindingInput = bindingOperation.getBindingInput();
        if (bindingInput == null) {
            return false;
        }
        SOAPBody soapBody = WsdlUtils.getExtensiblityElement(bindingInput.getExtensibilityElements(), SOAPBody.class);
        if (soapBody != null) {
            return soapBody.getUse() != null && soapBody.getUse().equalsIgnoreCase("encoded") && (soapBody.getEncodingStyles() == null || soapBody.getEncodingStyles().contains("http://schemas.xmlsoap.org/soap/encoding/"));
        }
        SOAP12Body soap12Body = WsdlUtils.getExtensiblityElement(bindingInput.getExtensibilityElements(), SOAP12Body.class);
        if (soap12Body != null) {
            return soap12Body.getUse() != null && soap12Body.getUse().equalsIgnoreCase("encoded") && (soap12Body.getEncodingStyle() == null || soap12Body.getEncodingStyle().equals("http://schemas.xmlsoap.org/soap/encoding/"));
        }
        return false;
    }

    public static boolean isOutputSoapEncoded(BindingOperation bindingOperation) {
        if (bindingOperation == null) {
            return false;
        }
        BindingOutput bindingOutput = bindingOperation.getBindingOutput();
        if (bindingOutput == null) {
            return false;
        }
        SOAPBody soapBody = WsdlUtils.getExtensiblityElement(bindingOutput.getExtensibilityElements(), SOAPBody.class);
        if (soapBody != null) {
            return soapBody.getUse() != null && soapBody.getUse().equalsIgnoreCase("encoded") && (soapBody.getEncodingStyles() == null || soapBody.getEncodingStyles().contains("http://schemas.xmlsoap.org/soap/encoding/"));
        }
        SOAP12Body soap12Body = WsdlUtils.getExtensiblityElement(bindingOutput.getExtensibilityElements(), SOAP12Body.class);
        if (soap12Body != null) {
            return soap12Body.getUse() != null && soap12Body.getUse().equalsIgnoreCase("encoded") && (soap12Body.getEncodingStyle() == null || soap12Body.getEncodingStyle().equals("http://schemas.xmlsoap.org/soap/encoding/"));
        }
        return false;
    }

    public static boolean isRpc(Definition definition, BindingOperation bindingOperation) {
        SOAPOperation soapOperation = WsdlUtils.getExtensiblityElement(bindingOperation.getExtensibilityElements(), SOAPOperation.class);
        if (soapOperation != null && soapOperation.getStyle() != null) {
            return soapOperation.getStyle().equalsIgnoreCase("rpc");
        }
        SOAP12Operation soap12Operation = WsdlUtils.getExtensiblityElement(bindingOperation.getExtensibilityElements(), SOAP12Operation.class);
        if (soap12Operation != null && soap12Operation.getStyle() != null) {
            return soap12Operation.getStyle().equalsIgnoreCase("rpc");
        }
        Binding binding = WsdlUtils.findBindingForOperation(definition, bindingOperation);
        if (binding == null) {
            log.error((Object)("Failed to find binding for operation [" + bindingOperation.getName() + "] in definition [" + definition.getDocumentBaseURI() + "]"));
            return false;
        }
        return WsdlUtils.isRpc(binding);
    }

    public static boolean isRpc(Binding binding) {
        SOAPBinding soapBinding = WsdlUtils.getExtensiblityElement(binding.getExtensibilityElements(), SOAPBinding.class);
        if (soapBinding != null) {
            return "rpc".equalsIgnoreCase(soapBinding.getStyle());
        }
        SOAP12Binding soap12Binding = WsdlUtils.getExtensiblityElement(binding.getExtensibilityElements(), SOAP12Binding.class);
        if (soap12Binding != null) {
            return "rpc".equalsIgnoreCase(soap12Binding.getStyle());
        }
        return false;
    }

    public static Part[] getInputParts(BindingOperation operation) {
        ArrayList<Part> result;
        block3: {
            SOAPBody soapBody;
            Message msg;
            block4: {
                SOAP12Body soap12Body;
                block5: {
                    result = new ArrayList<Part>();
                    Input input = operation.getOperation().getInput();
                    if (input == null || operation.getBindingInput() == null) {
                        return new Part[0];
                    }
                    msg = input.getMessage();
                    if (msg == null) break block3;
                    soapBody = WsdlUtils.getExtensiblityElement(operation.getBindingInput().getExtensibilityElements(), SOAPBody.class);
                    if (soapBody != null && soapBody.getParts() != null) break block4;
                    soap12Body = WsdlUtils.getExtensiblityElement(operation.getBindingInput().getExtensibilityElements(), SOAP12Body.class);
                    if (soap12Body != null && soap12Body.getParts() != null) break block5;
                    if (msg == null) break block3;
                    result.addAll(msg.getOrderedParts(null));
                    break block3;
                }
                for (String partName : soap12Body.getParts()) {
                    Part part = msg.getPart(partName);
                    result.add(part);
                }
                break block3;
            }
            for (String partName : soapBody.getParts()) {
                Part part = msg.getPart(partName);
                result.add(part);
            }
        }
        return result.toArray(new Part[result.size()]);
    }

    public static boolean isAttachmentInputPart(Part part, BindingOperation operation) {
        return WsdlUtils.getInputMultipartContent(part, operation).length > 0;
    }

    public static boolean isAttachmentOutputPart(Part part, BindingOperation operation) {
        return WsdlUtils.getOutputMultipartContent(part, operation).length > 0;
    }

    public static MIMEContent[] getOutputMultipartContent(Part part, BindingOperation operation) {
        BindingOutput output = operation.getBindingOutput();
        if (output == null) {
            return new MIMEContent[0];
        }
        MIMEMultipartRelated multipartOutput = WsdlUtils.getExtensiblityElement(output.getExtensibilityElements(), MIMEMultipartRelated.class);
        return WsdlUtils.getContentParts(part, multipartOutput);
    }

    public static MIMEContent[] getInputMultipartContent(Part part, BindingOperation operation) {
        BindingInput bindingInput = operation.getBindingInput();
        if (bindingInput == null) {
            return new MIMEContent[0];
        }
        MIMEMultipartRelated multipartInput = WsdlUtils.getExtensiblityElement(bindingInput.getExtensibilityElements(), MIMEMultipartRelated.class);
        return WsdlUtils.getContentParts(part, multipartInput);
    }

    public static MIMEContent[] getContentParts(Part part, MIMEMultipartRelated multipart) {
        ArrayList<MIMEContent> result = new ArrayList<MIMEContent>();
        if (multipart != null) {
            List parts = multipart.getMIMEParts();
            for (int c = 0; c < parts.size(); ++c) {
                List<MIMEContent> contentParts = WsdlUtils.getExtensiblityElements(((MIMEPart)parts.get(c)).getExtensibilityElements(), MIMEContent.class);
                for (MIMEContent content : contentParts) {
                    if (!content.getPart().equals(part.getName())) continue;
                    result.add(content);
                }
            }
        }
        return result.toArray(new MIMEContent[result.size()]);
    }

    public static Part[] getFaultParts(BindingOperation bindingOperation, String faultName) throws Exception {
        ArrayList result = new ArrayList();
        BindingFault bindingFault = bindingOperation.getBindingFault(faultName);
        SOAPFault soapFault = WsdlUtils.getExtensiblityElement(bindingFault.getExtensibilityElements(), SOAPFault.class);
        Operation operation = bindingOperation.getOperation();
        if (soapFault != null && soapFault.getName() != null) {
            Fault fault = operation.getFault(soapFault.getName());
            if (fault == null) {
                throw new Exception("Missing Fault [" + soapFault.getName() + "] in operation [" + operation.getName() + "]");
            }
            result.addAll(fault.getMessage().getOrderedParts(null));
        } else {
            SOAP12Fault soap12Fault = WsdlUtils.getExtensiblityElement(bindingFault.getExtensibilityElements(), SOAP12Fault.class);
            if (soap12Fault != null && soap12Fault.getName() != null) {
                Fault fault = operation.getFault(soap12Fault.getName());
                if (fault != null && fault.getMessage() != null) {
                    result.addAll(fault.getMessage().getOrderedParts(null));
                }
            } else {
                Fault fault = operation.getFault(faultName);
                if (fault != null && fault.getMessage() != null) {
                    result.addAll(fault.getMessage().getOrderedParts(null));
                }
            }
        }
        return result.toArray(new Part[result.size()]);
    }

    public static String findSoapFaultPartName(SoapVersion soapVersion, BindingOperation bindingOperation, String message) throws Exception {
        if (WsdlUtils.isOutputSoapEncoded(bindingOperation)) {
            throw new Exception("SOAP-Encoded messages not supported");
        }
        XmlObject xml = XmlUtils.createXmlObject(message);
        XmlObject[] msgPaths = xml.selectPath("declare namespace env='" + soapVersion.getEnvelopeNamespace() + "';" + "$this/env:Envelope/env:Body/env:Fault");
        if (msgPaths.length == 0) {
            return null;
        }
        XmlObject msgXml = msgPaths[0];
        Map faults = bindingOperation.getBindingFaults();
        for (BindingFault bindingFault : faults.values()) {
            String faultName = bindingFault.getName();
            Part[] faultParts = WsdlUtils.getFaultParts(bindingOperation, faultName);
            Part part = faultParts[0];
            QName elementName = part.getElementName();
            if (elementName != null) {
                XmlObject[] faultPaths = msgXml.selectPath("declare namespace env='" + soapVersion.getEnvelopeNamespace() + "';" + "declare namespace ns='" + elementName.getNamespaceURI() + "';" + "//env:Fault/detail/ns:" + elementName.getLocalPart());
                if (faultPaths.length != 1) continue;
                return faultName;
            }
            if (part.getTypeName() == null) continue;
            QName typeName = part.getTypeName();
            XmlObject[] faultPaths = msgXml.selectPath("declare namespace env='" + soapVersion.getEnvelopeNamespace() + "';" + "declare namespace ns='" + typeName.getNamespaceURI() + "';" + "//env:Fault/detail/ns:" + part.getName());
            if (faultPaths.length != 1) continue;
            return faultName;
        }
        return null;
    }

    public static Part[] getOutputParts(BindingOperation operation) {
        BindingOutput bindingOutput = operation.getBindingOutput();
        if (bindingOutput == null) {
            return new Part[0];
        }
        ArrayList<Part> result = new ArrayList<Part>();
        Output output = operation.getOperation().getOutput();
        if (output == null) {
            return new Part[0];
        }
        Message msg = output.getMessage();
        if (msg != null) {
            SOAPBody soapBody = WsdlUtils.getExtensiblityElement(bindingOutput.getExtensibilityElements(), SOAPBody.class);
            if (soapBody == null || soapBody.getParts() == null) {
                SOAP12Body soap12Body = WsdlUtils.getExtensiblityElement(bindingOutput.getExtensibilityElements(), SOAP12Body.class);
                if (soap12Body == null || soap12Body.getParts() == null) {
                    result.addAll(msg.getOrderedParts(null));
                } else {
                    for (String partName : soap12Body.getParts()) {
                        Part part = msg.getPart(partName);
                        result.add(part);
                    }
                }
            } else {
                for (String partName : soapBody.getParts()) {
                    Part part = msg.getPart(partName);
                    result.add(part);
                }
            }
        } else {
            log.warn((Object)("Missing output message for binding operation [" + operation.getName() + "]"));
        }
        return result.toArray(new Part[result.size()]);
    }

    public static boolean isMultipartRequest(Definition definition, BindingOperation bindingOperation) {
        return WsdlUtils.getExtensiblityElement(bindingOperation.getBindingInput().getExtensibilityElements(), MIMEMultipartRelated.class) != null;
    }

    public static String getUsingAddressing(ElementExtensible item) {
        String addressingVersion;
        String version = WsaVersionTypeConfig.NONE.toString();
        Element[] usingAddressingElements = WsdlUtils.getExentsibilityElements(item, new QName("http://www.w3.org/2006/05/addressing/wsdl", "UsingAddressing"));
        if (usingAddressingElements.length == 0) {
            usingAddressingElements = WsdlUtils.getExentsibilityElements(item, new QName("http://www.w3.org/2006/02/addressing/wsdl", "UsingAddressing"));
        }
        if (usingAddressingElements.length != 0 && (addressingVersion = usingAddressingElements[0].getAttributeNS(WSDL_NAMESPACE, "required")) != null && addressingVersion.equals("true")) {
            version = WsaVersionTypeConfig.X_200508.toString();
        }
        return version;
    }

    private static String checkIfWsaPolicy(String version, Element policy) {
        return version;
    }

    public static String getWsaPolicyAnonymous(Element policy) {
        String version = WsaVersionTypeConfig.NONE.toString();
        String anonymous = AnonymousTypeConfig.OPTIONAL.toString();
        Element wsAddressing = XmlUtils.getFirstChildElementNS(policy, "http://www.w3.org/2007/05/addressing/metadata", "Addressing");
        Element addressingPolicy = null;
        if (wsAddressing != null) {
            String optional = wsAddressing.getAttributeNS("http://www.w3.org/ns/ws-policy", "Optional");
            addressingPolicy = XmlUtils.getFirstChildElementNS(wsAddressing, "http://www.w3.org/ns/ws-policy", "Policy");
            if (addressingPolicy != null) {
                Element anonymousElm;
                if (StringUtils.isNullOrEmpty(optional) || optional.equals("false") || optional.equals("true") && SoapUI.getSettings().getBoolean(WsaSettings.ENABLE_FOR_OPTIONAL)) {
                    version = WsaVersionTypeConfig.X_200508.toString();
                }
                if ((anonymousElm = XmlUtils.getFirstChildElementNS(addressingPolicy, new QName("http://www.w3.org/2007/05/addressing/metadata", "AnonymousResponses"))) != null) {
                    anonymous = AnonymousTypeConfig.REQUIRED.toString();
                } else {
                    Element nonAnonymousElement = XmlUtils.getFirstChildElementNS(addressingPolicy, new QName("http://www.w3.org/2007/05/addressing/metadata", "NonAnonymousResponses"));
                    if (nonAnonymousElement != null) {
                        anonymous = AnonymousTypeConfig.PROHIBITED.toString();
                    }
                }
            }
        }
        return anonymous;
    }

    public static String getSoapEndpoint(Port port) {
        SOAPAddress soapAddress = WsdlUtils.getExtensiblityElement(port.getExtensibilityElements(), SOAPAddress.class);
        if (soapAddress != null && StringUtils.hasContent(soapAddress.getLocationURI())) {
            try {
                return URLDecoder.decode(soapAddress.getLocationURI(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return soapAddress.getLocationURI();
            }
        }
        SOAP12Address soap12Address = WsdlUtils.getExtensiblityElement(port.getExtensibilityElements(), SOAP12Address.class);
        if (soap12Address != null && StringUtils.hasContent(soap12Address.getLocationURI())) {
            try {
                return URLDecoder.decode(soap12Address.getLocationURI(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return soap12Address.getLocationURI();
            }
        }
        return null;
    }

    public static boolean replaceSoapEndpoint(Port port, String endpoint) {
        SOAPAddress soapAddress = WsdlUtils.getExtensiblityElement(port.getExtensibilityElements(), SOAPAddress.class);
        if (soapAddress != null) {
            soapAddress.setLocationURI(endpoint);
            return true;
        }
        SOAP12Address soap12Address = WsdlUtils.getExtensiblityElement(port.getExtensibilityElements(), SOAP12Address.class);
        if (soap12Address != null) {
            soap12Address.setLocationURI(endpoint);
            return true;
        }
        return false;
    }

    public static String getSoapBodyNamespace(List<?> list) {
        SOAPBody soapBody = WsdlUtils.getExtensiblityElement(list, SOAPBody.class);
        if (soapBody != null) {
            return soapBody.getNamespaceURI();
        }
        SOAP12Body soap12Body = WsdlUtils.getExtensiblityElement(list, SOAP12Body.class);
        if (soap12Body != null) {
            return soap12Body.getNamespaceURI();
        }
        return null;
    }

    public static List<SoapHeader> getSoapHeaders(List list) {
        ArrayList<SoapHeader> result;
        block3: {
            block2: {
                result = new ArrayList<SoapHeader>();
                List<SOAPHeader> soapHeaders = WsdlUtils.getExtensiblityElements(list, SOAPHeader.class);
                if (soapHeaders == null || soapHeaders.isEmpty()) break block2;
                for (SOAPHeader header : soapHeaders) {
                    result.add(new Soap11Header(header));
                }
                break block3;
            }
            List<SOAP12Header> soap12Headers = WsdlUtils.getExtensiblityElements(list, SOAP12Header.class);
            if (soap12Headers == null || soap12Headers.isEmpty()) break block3;
            for (SOAP12Header header : soap12Headers) {
                result.add(new Soap12Header(header));
            }
        }
        return result;
    }

    public static synchronized Definition readDefinition(String wsdlUrl) throws Exception {
        if (wsdlReader == null) {
            WSDLFactory factory = WSDLFactory.newInstance();
            wsdlReader = factory.newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.verbose", true);
            wsdlReader.setFeature("javax.wsdl.importDocuments", true);
        }
        return wsdlReader.readWSDL((WSDLLocator)new UrlWsdlLoader(wsdlUrl));
    }

    public static SchemaType getSchemaTypeForPart(WsdlContext wsdlContext, Part part) throws Exception {
        SchemaType schemaType = null;
        QName elementName = part.getElementName();
        if (elementName != null) {
            SchemaGlobalElement elm = wsdlContext.getSchemaTypeLoader().findElement(elementName);
            if (elm != null) {
                schemaType = elm.getType();
            } else {
                WsdlRequest.log.error((Object)("Could not find element [" + elementName + "] specified in part [" + part.getName() + "]"));
            }
        } else {
            QName typeName = part.getTypeName();
            if (typeName != null && (schemaType = wsdlContext.getSchemaTypeLoader().findType(typeName)) == null) {
                WsdlRequest.log.error((Object)("Could not find type [" + typeName + "] specified in part [" + part.getName() + "]"));
            }
        }
        return schemaType;
    }

    public static SchemaGlobalElement getSchemaElementForPart(WsdlContext wsdlContext, Part part) throws Exception {
        QName elementName = part.getElementName();
        if (elementName != null) {
            return wsdlContext.getSchemaTypeLoader().findElement(elementName);
        }
        return null;
    }

    public static String replacePortEndpoint(WsdlInterface iface, InputSource inputSource, String endpoint) throws WSDLException {
        NonSchemaImportingWsdlReaderImpl wsdlReader = new NonSchemaImportingWsdlReaderImpl();
        wsdlReader.setFeature("javax.wsdl.verbose", true);
        wsdlReader.setFeature("javax.wsdl.importDocuments", false);
        Definition definition = wsdlReader.readWSDL(null, inputSource);
        boolean updated = false;
        Map map = definition.getServices();
        for (Service service : map.values()) {
            Map portMap = service.getPorts();
            for (Port port : portMap.values()) {
                if (!port.getBinding().getQName().equals(iface.getBindingName()) || !WsdlUtils.replaceSoapEndpoint(port, endpoint)) continue;
                updated = true;
            }
        }
        if (updated) {
            StringWriter writer = new StringWriter();
            Map nsMap = definition.getNamespaces();
            if (!nsMap.values().contains("http://schemas.xmlsoap.org/wsdl/soap/")) {
                definition.addNamespace("soaphttp", "http://schemas.xmlsoap.org/wsdl/soap/");
            }
            new WSDLWriterImpl().writeWSDL(definition, (Writer)writer);
            return writer.toString();
        }
        return null;
    }

    public static BindingOperation findBindingOperation(Binding binding, String bindingOperationName, String inputName, String outputName) {
        BindingOperation result;
        if (binding == null) {
            return null;
        }
        if (inputName == null) {
            inputName = ":none";
        }
        if (outputName == null) {
            outputName = ":none";
        }
        if ((result = binding.getBindingOperation(bindingOperationName, inputName, outputName)) == null && (inputName.equals(":none") || outputName.equals(":none"))) {
            result = binding.getBindingOperation(bindingOperationName, inputName.equals(":none") ? null : inputName, outputName.equals(":none") ? null : outputName);
        }
        return result;
    }

    public static boolean isHeaderInputPart(Part part, Message message, BindingOperation bindingOperation) {
        List<SOAPHeader> headers = WsdlUtils.getExtensiblityElements(bindingOperation.getBindingInput().getExtensibilityElements(), SOAPHeader.class);
        if (headers == null || headers.isEmpty()) {
            return false;
        }
        for (SOAPHeader header : headers) {
            if (!message.getQName().equals(header.getMessage()) || !part.getName().equals(header.getPart())) continue;
            return true;
        }
        return false;
    }

    public static boolean isHeaderOutputPart(Part part, Message message, BindingOperation bindingOperation) {
        List<SOAPHeader> headers;
        BindingOutput bindingOutput = bindingOperation.getBindingOutput();
        List<SOAPHeader> list = headers = bindingOutput == null ? null : WsdlUtils.getExtensiblityElements(bindingOutput.getExtensibilityElements(), SOAPHeader.class);
        if (headers == null || headers.isEmpty()) {
            return false;
        }
        for (SOAPHeader header : headers) {
            if (!message.getQName().equals(header.getMessage()) || !part.getName().equals(header.getPart())) continue;
            return true;
        }
        return false;
    }

    public static DefinitionCacheConfig cacheWsdl(DefinitionLoader loader) throws Exception {
        DefinitionCacheConfig definitionCache = DefinitionCacheConfig.Factory.newInstance();
        definitionCache.setRootPart(loader.getBaseURI());
        definitionCache.setType(DefinitionCacheTypeConfig.TEXT);
        Map<String, XmlObject> urls = SchemaUtils.getDefinitionParts(loader);
        Iterator<String> i = urls.keySet().iterator();
        while (i.hasNext()) {
            Node node;
            DefintionPartConfig definitionPart = definitionCache.addNewPart();
            String url = i.next();
            definitionPart.setUrl(url);
            XmlObject xmlObject = urls.get(url);
            Node domNode = xmlObject.getDomNode();
            if (domNode.getNodeType() == 11 && (node = ((DocumentFragment)domNode).getFirstChild()).getNodeType() == 3) {
                domNode = XmlUtils.parseXml(node.getNodeValue());
                xmlObject = XmlUtils.createXmlObject(domNode);
            }
            Element contentElement = ((Document)domNode).getDocumentElement();
            Node newDomNode = definitionPart.addNewContent().getDomNode();
            newDomNode.appendChild(newDomNode.getOwnerDocument().createTextNode(xmlObject.toString()));
            definitionPart.setType(contentElement.getNamespaceURI());
        }
        return definitionCache;
    }

    public static void getAnonymous(WsdlOperation wsdlOperation) {
        String anonymous = "";
        Element[] anonymousElements = WsdlUtils.getExentsibilityElements((ElementExtensible)wsdlOperation.getBindingOperation(), new QName("http://www.w3.org/2006/05/addressing/wsdl", "Anonymous"));
        if (anonymousElements.length == 0) {
            anonymousElements = WsdlUtils.getExentsibilityElements((ElementExtensible)wsdlOperation.getBindingOperation(), new QName("http://www.w3.org/2006/02/addressing/wsdl", "Anonymous"));
        }
        if (anonymousElements != null && anonymousElements.length > 0) {
            anonymous = XmlUtils.getElementText(anonymousElements[0]);
        }
        wsdlOperation.setAnonymous(anonymous);
    }

    public static String getDefaultWsaAction(WsdlOperation operation, boolean output) {
        if (operation.getInterface().getSoapVersion() == SoapVersion.Soap11 && StringUtils.hasContent(operation.getAction()) && SoapUI.getSettings().getBoolean(WsaSettings.SOAP_ACTION_OVERRIDES_WSA_ACTION)) {
            return operation.getAction();
        }
        try {
            String operationInOutName;
            Operation op;
            String[] attrs;
            Output attributeExtensible;
            if (operation.getBindingOperation() == null || operation.getBindingOperation().getOperation() == null) {
                return null;
            }
            Object object = attributeExtensible = output ? operation.getBindingOperation().getOperation().getOutput() : operation.getBindingOperation().getOperation().getInput();
            if (attributeExtensible == null) {
                return null;
            }
            for (String namespace : WsaUtils.wsaNamespaces) {
                attrs = WsdlUtils.getExentsibilityAttributes((AttributeExtensible)attributeExtensible, new QName(namespace, "Action"));
                if (attrs == null || attrs.length <= 0) continue;
                return attrs[0];
            }
            WsdlInterface iface = operation.getInterface();
            Definition definition = iface.getWsdlContext().getDefinition();
            String targetNamespace = WsdlUtils.getTargetNamespace(definition);
            String portTypeName = iface.getBinding().getPortType().getQName().getLocalPart();
            String operationName = operation.getName();
            if (!StringUtils.isNullOrEmpty(operationName) && (op = iface.getBinding().getPortType().getOperation(operationName, null, null)) != null && (attrs = WsdlUtils.getExentsibilityAttributes((AttributeExtensible)(attributeExtensible = output ? op.getOutput() : op.getInput()), new QName("http://www.w3.org/2007/05/addressing/metadata", "Action"))) != null && attrs.length > 0) {
                return attrs[0];
            }
            String string = operationInOutName = output ? operation.getOutputName() : operation.getInputName();
            if (operationInOutName == null) {
                operationInOutName = operation.getName() + (output ? "Response" : "Request");
            }
            StringBuffer result = new StringBuffer(targetNamespace);
            if (targetNamespace.length() > 0 && targetNamespace.charAt(targetNamespace.length() - 1) != '/' && portTypeName.charAt(0) != '/') {
                result.append('/');
            }
            result.append(portTypeName);
            if (portTypeName.charAt(portTypeName.length() - 1) != '/' && operationInOutName.charAt(0) != '/') {
                result.append('/');
            }
            result.append(operationInOutName);
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn((Object)e.toString());
            return null;
        }
    }

    public static void setDefaultWsaAction(WsaConfig wsaConfig, boolean b) {
        String defaultAction = WsdlUtils.getDefaultWsaAction(wsaConfig.getWsaContainer().getOperation(), b);
        if (StringUtils.hasContent(defaultAction)) {
            wsaConfig.setAction(defaultAction);
        }
    }

    public static String getRequestWsaMessageId(WsdlMessageExchange messageExchange, String wsaVersionNameSpace) {
        String requestMessageId = null;
        try {
            XmlObject xmlObject = XmlUtils.createXmlObject(messageExchange.getRequestContent());
            SoapVersion soapVersion = messageExchange.getOperation().getInterface().getSoapVersion();
            Element header = (Element)SoapUtils.getHeaderElement(xmlObject, soapVersion, true).getDomNode();
            Element msgNode = XmlUtils.getFirstChildElementNS(header, wsaVersionNameSpace, "MessageID");
            if (msgNode != null) {
                requestMessageId = XmlUtils.getElementText(msgNode);
            }
        }
        catch (XmlException e) {
            e.printStackTrace();
            log.warn((Object)e.toString());
            return null;
        }
        return requestMessageId;
    }

    public static NodeList getRequestReplyToRefProps(WsdlMessageExchange messageExchange, String wsaVersionNameSpace) {
        try {
            XmlObject xmlObject = XmlUtils.createXmlObject(messageExchange.getRequestContent());
            SoapVersion soapVersion = messageExchange.getOperation().getInterface().getSoapVersion();
            Element header = (Element)SoapUtils.getHeaderElement(xmlObject, soapVersion, true).getDomNode();
            Element replyToNode = XmlUtils.getFirstChildElementNS(header, wsaVersionNameSpace, "ReplyTo");
            Element replyRefParamsNode = XmlUtils.getFirstChildElementNS(replyToNode, wsaVersionNameSpace, "ReferenceParameters");
            if (replyRefParamsNode != null) {
                return XmlUtils.getChildElements(replyRefParamsNode);
            }
        }
        catch (XmlException e) {
            e.printStackTrace();
            log.warn((Object)e.toString());
        }
        return null;
    }

    public static NodeList getRequestFaultToRefProps(WsdlMessageExchange messageExchange, String wsaVersionNameSpace) {
        try {
            XmlObject xmlObject = XmlUtils.createXmlObject(messageExchange.getRequestContent());
            SoapVersion soapVersion = messageExchange.getOperation().getInterface().getSoapVersion();
            Element header = (Element)SoapUtils.getHeaderElement(xmlObject, soapVersion, true).getDomNode();
            Element faultToNode = XmlUtils.getFirstChildElementNS(header, wsaVersionNameSpace, "FaultTo");
            Element faultRefParamsNode = XmlUtils.getFirstChildElementNS(faultToNode, wsaVersionNameSpace, "ReferenceParameters");
            if (faultRefParamsNode != null) {
                return XmlUtils.getChildElements(faultRefParamsNode);
            }
        }
        catch (XmlException e) {
            e.printStackTrace();
            log.warn((Object)e.toString());
        }
        return null;
    }

    public static String getFaultCode(WsdlMessageExchange messageExchange) {
        try {
            XmlObject xmlObject = XmlUtils.createXmlObject(messageExchange.getResponseContent());
            SoapVersion soapVersion = messageExchange.getOperation().getInterface().getSoapVersion();
            Element body = (Element)SoapUtils.getBodyElement(xmlObject, soapVersion).getDomNode();
            Element soapenvFault = XmlUtils.getFirstChildElementNS(body, "http://schemas.xmlsoap.org/soap/envelope/", "Fault");
            Element faultCode = XmlUtils.getFirstChildElement(soapenvFault, "faultcode");
            if (faultCode != null) {
                return XmlUtils.getElementText(faultCode);
            }
        }
        catch (XmlException e) {
            e.printStackTrace();
            log.warn((Object)e.toString());
        }
        return null;
    }

    public static String getTargetNamespace(Definition definition) {
        return definition.getTargetNamespace() == null ? "" : definition.getTargetNamespace();
    }

    public static SchemaType generateRpcBodyType(WsdlOperation operation) {
        return XmlString.type;
    }

    public static class Soap12Header
    implements SoapHeader {
        private final SOAP12Header soapHeader;

        public Soap12Header(SOAP12Header soapHeader) {
            this.soapHeader = soapHeader;
        }

        public QName getMessage() {
            return this.soapHeader.getMessage();
        }

        public String getPart() {
            return this.soapHeader.getPart();
        }
    }

    public static class Soap11Header
    implements SoapHeader {
        private final SOAPHeader soapHeader;

        public Soap11Header(SOAPHeader soapHeader) {
            this.soapHeader = soapHeader;
        }

        public QName getMessage() {
            return this.soapHeader.getMessage();
        }

        public String getPart() {
            return this.soapHeader.getPart();
        }
    }

    public static interface SoapHeader {
        public QName getMessage();

        public String getPart();
    }

    public static final class NonSchemaImportingWsdlReaderImpl
    extends WSDLReaderImpl {
        protected ExtensibilityElement parseSchema(Class parentType, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
            QName elementType = QNameUtils.newQName((Node)el);
            ExtensionDeserializer exDS = extReg.queryDeserializer(parentType, elementType);
            ExtensibilityElement ee = exDS.unmarshall(parentType, elementType, el, def, extReg);
            return ee;
        }
    }
}

