/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.http;

import com.eviware.soapui.impl.wsdl.submit.transports.http.support.metrics.SoapUIMetrics;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.HttpConnectionMetricsImpl;
import org.apache.http.impl.conn.AbstractPoolEntry;
import org.apache.http.impl.conn.DefaultClientConnection;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.BasicPooledConnAdapter;
import org.apache.http.impl.conn.tsccm.PoolEntryRequest;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;

public class SoapUIMultiThreadedHttpConnectionManager
extends ThreadSafeClientConnManager {
    private static final Logger log = Logger.getLogger(SoapUIMultiThreadedHttpConnectionManager.class);
    IdleConnectionMonitorThread idleConnectionHandler = new IdleConnectionMonitorThread((ClientConnectionManager)this);

    public SoapUIMultiThreadedHttpConnectionManager(SchemeRegistry registry) {
        super(registry);
        this.idleConnectionHandler.start();
    }

    protected ClientConnectionOperator createConnectionOperator(SchemeRegistry schreg) {
        return new SoapUIClientConnectionOperator(schreg);
    }

    public ClientConnectionRequest requestConnection(final HttpRoute route, Object state) {
        final PoolEntryRequest poolRequest = this.pool.requestPoolEntry(route, state);
        return new ClientConnectionRequest(){

            public void abortRequest() {
                poolRequest.abortRequest();
            }

            public ManagedClientConnection getConnection(long timeout, TimeUnit tunit) throws InterruptedException, ConnectionPoolTimeoutException {
                if (route == null) {
                    throw new IllegalArgumentException("Route may not be null.");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Get connection: " + route + ", timeout = " + timeout));
                }
                BasicPoolEntry entry = poolRequest.getPoolEntry(timeout, tunit);
                SoapUIBasicPooledConnAdapter connAdapter = new SoapUIBasicPooledConnAdapter(SoapUIMultiThreadedHttpConnectionManager.this, (AbstractPoolEntry)entry);
                return connAdapter;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
        if (!(conn instanceof SoapUIBasicPooledConnAdapter)) {
            throw new IllegalArgumentException("Connection class mismatch, connection not obtained from this manager.");
        }
        SoapUIBasicPooledConnAdapter hca = (SoapUIBasicPooledConnAdapter)conn;
        if (hca.getPoolEntry() != null && hca.getManager() != this) {
            throw new IllegalArgumentException("Connection not obtained from this manager.");
        }
        SoapUIBasicPooledConnAdapter soapUIBasicPooledConnAdapter = hca;
        synchronized (soapUIBasicPooledConnAdapter) {
            block20: {
                BasicPoolEntry entry = (BasicPoolEntry)hca.getPoolEntry();
                if (entry == null) {
                    return;
                }
                try {
                    block19: {
                        try {
                            if (!hca.isOpen() || hca.isMarkedReusable()) break block19;
                            hca.shutdown();
                        }
                        catch (IOException iox) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Exception shutting down released connection.", (Throwable)iox);
                            }
                            Object var10_8 = null;
                            boolean reusable = hca.isMarkedReusable();
                            if (log.isDebugEnabled()) {
                                if (reusable) {
                                    log.debug((Object)"Released connection is reusable.");
                                } else {
                                    log.debug((Object)"Released connection is not reusable.");
                                }
                            }
                            hca.detach();
                            this.pool.freeEntry(entry, reusable, validDuration, timeUnit);
                            break block20;
                        }
                    }
                    Object var10_7 = null;
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    boolean reusable = hca.isMarkedReusable();
                    if (log.isDebugEnabled()) {
                        if (reusable) {
                            log.debug((Object)"Released connection is reusable.");
                        } else {
                            log.debug((Object)"Released connection is not reusable.");
                        }
                    }
                    hca.detach();
                    this.pool.freeEntry(entry, reusable, validDuration, timeUnit);
                    throw throwable;
                }
                boolean reusable = hca.isMarkedReusable();
                if (log.isDebugEnabled()) {
                    if (reusable) {
                        log.debug((Object)"Released connection is reusable.");
                    } else {
                        log.debug((Object)"Released connection is not reusable.");
                    }
                }
                hca.detach();
                this.pool.freeEntry(entry, reusable, validDuration, timeUnit);
            }
            return;
        }
    }

    private class SoapUIBasicPooledConnAdapter
    extends BasicPooledConnAdapter {
        protected SoapUIBasicPooledConnAdapter(ThreadSafeClientConnManager tsccm, AbstractPoolEntry entry) {
            super(tsccm, entry);
        }

        protected ClientConnectionManager getManager() {
            return super.getManager();
        }

        protected AbstractPoolEntry getPoolEntry() {
            return super.getPoolEntry();
        }

        protected void detach() {
            super.detach();
        }
    }

    private class SoapUIDefaultClientConnection
    extends DefaultClientConnection {
        protected HttpConnectionMetricsImpl createConnectionMetrics(HttpTransportMetrics inTransportMetric, HttpTransportMetrics outTransportMetric) {
            return new SoapUIMetrics(inTransportMetric, outTransportMetric);
        }
    }

    private class SoapUIClientConnectionOperator
    extends DefaultClientConnectionOperator {
        public SoapUIClientConnectionOperator(SchemeRegistry schemes) {
            super(schemes);
        }

        public OperatedClientConnection createConnection() {
            SoapUIDefaultClientConnection connection = new SoapUIDefaultClientConnection();
            return connection;
        }

        public void openConnection(OperatedClientConnection conn, HttpHost target, InetAddress local, HttpContext context, HttpParams params) throws IOException {
            if (conn == null) {
                throw new IllegalArgumentException("Connection may not be null");
            }
            if (target == null) {
                throw new IllegalArgumentException("Target host may not be null");
            }
            if (params == null) {
                throw new IllegalArgumentException("Parameters may not be null");
            }
            if (conn.isOpen()) {
                throw new IllegalStateException("Connection must not be open");
            }
            Scheme schm = this.schemeRegistry.getScheme(target.getSchemeName());
            SchemeSocketFactory sf = schm.getSchemeSocketFactory();
            long start = System.currentTimeMillis();
            InetAddress[] addresses = this.resolveHostname(target.getHostName());
            long dnsEnd = System.currentTimeMillis();
            int port = schm.resolvePort(target.getPort());
            for (int i = 0; i < addresses.length; ++i) {
                InetSocketAddress remoteAddress;
                block13: {
                    InetAddress address = addresses[i];
                    boolean last = i == addresses.length - 1;
                    Socket sock = sf.createSocket(params);
                    conn.opening(sock, target);
                    remoteAddress = new InetSocketAddress(address, port);
                    InetSocketAddress localAddress = null;
                    if (local != null) {
                        localAddress = new InetSocketAddress(local, 0);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Connecting to " + remoteAddress));
                    }
                    try {
                        Socket connsock = sf.connectSocket(sock, remoteAddress, localAddress, params);
                        if (sock != connsock) {
                            sock = connsock;
                            conn.opening(sock, target);
                        }
                        this.prepareSocket(sock, context, params);
                        conn.openCompleted(sf.isSecure(sock), params);
                        SoapUIMetrics metrics = (SoapUIMetrics)conn.getMetrics();
                        if (metrics != null) {
                            metrics.getDNSTimer().set(start, dnsEnd);
                        }
                        return;
                    }
                    catch (ConnectException ex) {
                        if (last) {
                            throw new HttpHostConnectException(target, ex);
                        }
                    }
                    catch (ConnectTimeoutException ex) {
                        if (!last) break block13;
                        throw ex;
                    }
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Connect to " + remoteAddress + " timed out. " + "Connection will be retried using another IP address"));
            }
        }
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final ClientConnectionManager connMgr;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(ClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(5000L);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

