/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.http;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.metrics.SoapUIMetrics;
import com.eviware.soapui.impl.wsdl.support.CompressionSupport;
import com.eviware.soapui.impl.wsdl.support.http.HeadderRequestInterceptor;
import com.eviware.soapui.impl.wsdl.support.http.SoapUIMultiThreadedHttpConnectionManager;
import com.eviware.soapui.impl.wsdl.support.http.SoapUISSLSocketFactory;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.settings.SSLSettings;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.apache.commons.ssl.KeyMaterial;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.log4j.Logger;

public class HttpClientSupport {
    private static final Helper helper = new Helper();

    public static SoapUIHttpClient getHttpClient() {
        return helper.getHttpClient();
    }

    public static HttpResponse execute(ExtendedHttpMethod method, HttpContext httpContext) throws ClientProtocolException, IOException {
        return helper.execute(method, httpContext);
    }

    public static HttpResponse execute(ExtendedHttpMethod method) throws ClientProtocolException, IOException {
        return helper.execute(method);
    }

    public static void applyHttpSettings(HttpRequest httpMethod, Settings settings) {
        String userAgent = settings.getString(HttpSettings.USER_AGENT, null);
        if (userAgent != null && userAgent.length() > 0) {
            httpMethod.setHeader("User-Agent", userAgent);
        }
        long timeout = settings.getLong(HttpSettings.SOCKET_TIMEOUT, 60000L);
        httpMethod.getParams().setParameter("http.socket.timeout", (Object)((int)timeout));
    }

    public static String getResponseCompressionType(HttpResponse httpResponse) {
        Header contentType = null;
        if (httpResponse.getEntity() != null) {
            contentType = httpResponse.getEntity().getContentType();
        }
        Header contentEncoding = null;
        if (httpResponse.getEntity() != null) {
            contentEncoding = httpResponse.getEntity().getContentEncoding();
        }
        return HttpClientSupport.getCompressionType(contentType == null ? null : contentType.getValue(), contentEncoding == null ? null : contentEncoding.getValue());
    }

    public static String getCompressionType(String contentType, String contentEncoding) {
        String compressionAlg;
        String string = compressionAlg = contentType == null ? null : CompressionSupport.getAvailableAlgorithm(contentType);
        if (compressionAlg != null) {
            return compressionAlg;
        }
        if (contentEncoding == null) {
            return null;
        }
        return CompressionSupport.getAvailableAlgorithm(contentEncoding);
    }

    public static void addSSLListener(Settings settings) {
        settings.addSettingsListener(helper.new Helper.SSLSettingsListener());
    }

    private static class Helper {
        private final SoapUIHttpClient httpClient;
        private static final Logger log = Logger.getLogger(Helper.class);
        private final SoapUIMultiThreadedHttpConnectionManager connectionManager;
        private final SchemeRegistry registry;

        public Helper() {
            Settings settings = SoapUI.getSettings();
            this.registry = new SchemeRegistry();
            this.registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
            try {
                SoapUISSLSocketFactory socketFactory = this.initSocketFactory();
                this.registry.register(new Scheme("https", 443, (SchemeSocketFactory)socketFactory));
            }
            catch (Throwable e) {
                SoapUI.logError(e);
            }
            this.connectionManager = new SoapUIMultiThreadedHttpConnectionManager(this.registry);
            this.connectionManager.setMaxTotal((int)settings.getLong(HttpSettings.MAX_TOTAL_CONNECTIONS, 2000L));
            this.connectionManager.setDefaultMaxPerRoute((int)settings.getLong(HttpSettings.MAX_CONNECTIONS_PER_HOST, 500L));
            this.httpClient = new SoapUIHttpClient((ClientConnectionManager)this.connectionManager);
            this.httpClient.addRequestInterceptor(new HeadderRequestInterceptor(), this.httpClient.getRequestInterceptorCount());
            this.httpClient.getAuthSchemes().register("NTLM", (AuthSchemeFactory)new NTLMSchemeFactory());
            this.httpClient.getAuthSchemes().register("negotiate", (AuthSchemeFactory)new NTLMSchemeFactory());
            settings.addSettingsListener(new SSLSettingsListener());
        }

        public SoapUIHttpClient getHttpClient() {
            return this.httpClient;
        }

        public HttpResponse execute(ExtendedHttpMethod method, HttpContext httpContext) throws ClientProtocolException, IOException {
            method.afterWriteRequest();
            if (method.getMetrics() != null) {
                method.getMetrics().getConnectTimer().start();
            }
            HttpResponse httpResponse = this.httpClient.execute(method, httpContext);
            method.setHttpResponse(httpResponse);
            return httpResponse;
        }

        public HttpResponse execute(ExtendedHttpMethod method) throws ClientProtocolException, IOException {
            method.afterWriteRequest();
            if (method.getMetrics() != null) {
                method.getMetrics().getConnectTimer().start();
            }
            HttpResponse httpResponse = this.httpClient.execute(method);
            method.setHttpResponse(httpResponse);
            return httpResponse;
        }

        public SoapUISSLSocketFactory initSocketFactory() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
            File f;
            KeyStore keyStore = null;
            Settings settings = SoapUI.getSettings();
            String keyStoreUrl = System.getProperty("soapui.ssl.keystore.location", settings.getString(SSLSettings.KEYSTORE, null));
            keyStoreUrl = keyStoreUrl != null ? keyStoreUrl.trim() : "";
            String pass = System.getProperty("soapui.ssl.keystore.password", settings.getString(SSLSettings.KEYSTORE_PASSWORD, ""));
            char[] pwd = pass.toCharArray();
            if (keyStoreUrl.trim().length() > 0 && (f = new File(keyStoreUrl)).exists()) {
                log.info((Object)"Initializing KeyStore");
                try {
                    KeyMaterial km = new KeyMaterial(f, pwd);
                    keyStore = km.getKeyStore();
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
            }
            return new SoapUISSLSocketFactory(keyStore, pass);
        }

        public final class SSLSettingsListener
        implements SettingsListener {
            public void settingChanged(String name, String newValue, String oldValue) {
                if (name.equals(SSLSettings.KEYSTORE) || name.equals(SSLSettings.KEYSTORE_PASSWORD)) {
                    try {
                        log.info((Object)"Updating keyStore..");
                        Helper.this.registry.register(new Scheme("https", 443, (SchemeSocketFactory)Helper.this.initSocketFactory()));
                    }
                    catch (Throwable e) {
                        SoapUI.logError(e);
                    }
                } else if (name.equals(HttpSettings.MAX_CONNECTIONS_PER_HOST)) {
                    log.info((Object)("Updating max connections per host to " + newValue));
                    Helper.this.connectionManager.setDefaultMaxPerRoute(Integer.parseInt(newValue));
                } else if (name.equals(HttpSettings.MAX_TOTAL_CONNECTIONS)) {
                    log.info((Object)("Updating max total connections host to " + newValue));
                    Helper.this.connectionManager.setMaxTotal(Integer.parseInt(newValue));
                }
            }

            public void settingsReloaded() {
                try {
                    log.info((Object)"Updating keyStore..");
                    Helper.this.registry.register(new Scheme("https", 443, (SchemeSocketFactory)Helper.this.initSocketFactory()));
                }
                catch (Throwable e) {
                    SoapUI.logError(e);
                }
            }
        }
    }

    public static class SoapUIHttpRequestExecutor
    extends HttpRequestExecutor {
        public void preProcess(HttpRequest request, HttpProcessor processor, HttpContext context) throws HttpException, IOException {
            HttpRequest original = request;
            if (original instanceof RequestWrapper) {
                RequestWrapper w = (RequestWrapper)request;
                original = w.getOriginal();
            }
            if (original instanceof ExtendedHttpMethod) {
                SoapUIMetrics metrics = ((ExtendedHttpMethod)original).getMetrics();
                metrics.getConnectTimer().stop();
                metrics.getTimeToFirstByteTimer().start();
            }
            super.preProcess(request, processor, context);
        }

        protected HttpResponse doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
            HttpResponse response = super.doSendRequest(request, conn, context);
            return response;
        }

        protected HttpResponse doReceiveResponse(HttpRequest request, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
            if (request == null) {
                throw new IllegalArgumentException("HTTP request may not be null");
            }
            if (conn == null) {
                throw new IllegalArgumentException("HTTP connection may not be null");
            }
            if (context == null) {
                throw new IllegalArgumentException("HTTP context may not be null");
            }
            HttpResponse response = null;
            int statuscode = 0;
            HttpRequest original = request;
            if (original instanceof RequestWrapper) {
                RequestWrapper w = (RequestWrapper)request;
                original = w.getOriginal();
            }
            while (response == null || statuscode < 200) {
                response = conn.receiveResponseHeader();
                SoapUIMetrics metrics = null;
                if (original instanceof ExtendedHttpMethod) {
                    metrics = ((ExtendedHttpMethod)original).getMetrics();
                    metrics.getTimeToFirstByteTimer().stop();
                    metrics.getReadTimer().start();
                }
                if (this.canResponseHaveBody(request, response)) {
                    conn.receiveResponseEntity(response);
                }
                statuscode = response.getStatusLine().getStatusCode();
                if (!(conn.getMetrics() instanceof SoapUIMetrics)) continue;
                SoapUIMetrics connectionMetrics = (SoapUIMetrics)conn.getMetrics();
                if (metrics == null || connectionMetrics == null || connectionMetrics.isDone()) continue;
                metrics.getDNSTimer().set(connectionMetrics.getDNSTimer().getStart(), connectionMetrics.getDNSTimer().getStop());
                connectionMetrics.reset();
            }
            return response;
        }
    }

    public static class SoapUIHttpClient
    extends DefaultHttpClient {
        public SoapUIHttpClient(ClientConnectionManager conman) {
            super(conman, null);
        }

        protected HttpRequestExecutor createRequestExecutor() {
            return new SoapUIHttpRequestExecutor();
        }
    }
}

