/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.propertyexpansion.DefaultPropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathUtils {
    public static String getAbsoluteFolder(String path) {
        File folder = new File(path);
        if (!folder.exists()) {
            return null;
        }
        if (folder.isDirectory()) {
            return folder.getAbsolutePath();
        }
        File parentFile = folder.getParentFile();
        return parentFile == null ? null : parentFile.getAbsolutePath();
    }

    public static String expandPath(String path, AbstractWsdlModelItem<?> modelItem) {
        return PathUtils.expandPath(path, modelItem, null);
    }

    public static String expandPath(String path, AbstractWsdlModelItem<?> modelItem, PropertyExpansionContext context) {
        if (PathUtils.isHttpPath(path = PathUtils.stripQuotes(path))) {
            path = path.replaceAll(" ", "%20");
        }
        String string = path = context == null ? PropertyExpander.expandProperties(modelItem, path) : PropertyExpander.expandProperties(context, path);
        if (!PathUtils.isRelativePath(path)) {
            return path;
        }
        String root = PathUtils.getExpandedResourceRoot(modelItem, context);
        if (StringUtils.isNullOrEmpty(root) || StringUtils.isNullOrEmpty(root)) {
            return path;
        }
        root = PathUtils.isHttpPath(root) ? root + "/" : root + File.separatorChar;
        return Tools.joinRelativeUrl(root, path);
    }

    private static String stripQuotes(String path) {
        if (path != null && path.startsWith("\"") && path.endsWith("\"")) {
            path = path.substring(1, path.length() - 1);
        }
        return path;
    }

    public static String adjustRelativePath(String str, String root, ModelItem contextModelItem) {
        if (StringUtils.isNullOrEmpty(root) || StringUtils.isNullOrEmpty(str)) {
            return str;
        }
        if (!PathUtils.isRelativePath(str)) {
            return str;
        }
        root = PathUtils.isHttpPath(root = PropertyExpander.expandProperties(contextModelItem, root)) ? root + "/" : root + File.separatorChar;
        return Tools.joinRelativeUrl(root, str);
    }

    public static boolean isHttpPath(String str) {
        if (StringUtils.isNullOrEmpty(str)) {
            return false;
        }
        return (str = str.toLowerCase()).startsWith("http:/") || str.startsWith("https:/");
    }

    public static boolean isRelativePath(String str) {
        if (StringUtils.isNullOrEmpty(str)) {
            return false;
        }
        return !(str = str.toLowerCase()).startsWith("/") && !str.startsWith("\\") && !str.startsWith("http:/") && !str.startsWith("https:/") && str.indexOf(":\\") != 1 && !str.startsWith("file:") && str.indexOf(":/") != 1;
    }

    public static String createRelativePath(String path, String root, ModelItem contextModelItem) {
        if (StringUtils.isNullOrEmpty(root)) {
            return path;
        }
        root = PropertyExpander.expandProperties(contextModelItem, root);
        return PathUtils.relativize(path, root);
    }

    public static String relativizeResourcePath(String path, ModelItem modelItem) {
        String projectPath;
        if (modelItem == null || StringUtils.isNullOrEmpty(path) || PathUtils.isRelativePath(path) || PathUtils.isHttpPath(path)) {
            return path;
        }
        Project project = ModelSupport.getModelItemProject(modelItem);
        if (project == null) {
            return path;
        }
        if (StringUtils.isNullOrEmpty(project.getPath()) && project.getResourceRoot().indexOf("${projectDir}") >= 0 && UISupport.confirm("Save project before setting path?", "Project has not been saved")) {
            try {
                project.save();
            }
            catch (IOException e) {
                SoapUI.logError(e);
                UISupport.showErrorMessage(e);
                return path;
            }
        }
        if (StringUtils.isNullOrEmpty(projectPath = PropertyExpander.expandProperties(project, project.getResourceRoot()))) {
            return path;
        }
        return PathUtils.relativize(path, projectPath);
    }

    public static String resolveResourcePath(String path, ModelItem modelItem) {
        if (path == null || modelItem == null) {
            return path;
        }
        path = PathUtils.denormalizePath(path);
        path = PropertyExpander.expandProperties(new DefaultPropertyExpansionContext(modelItem), path);
        String prefix = "";
        if (path.startsWith("file:")) {
            prefix = path.substring(0, 5);
            path = path.substring(5);
        }
        if (PathUtils.isAbsolutePath(path)) {
            return prefix + path;
        }
        WsdlProject project = (WsdlProject)ModelSupport.getModelItemProject(modelItem);
        if (project == null) {
            return prefix + path;
        }
        String resourceRoot = PathUtils.getExpandedResourceRoot(modelItem);
        if (StringUtils.hasContent(resourceRoot) && !resourceRoot.endsWith(File.separator)) {
            resourceRoot = resourceRoot + File.separator;
        }
        String result = Tools.joinRelativeUrl(resourceRoot, path);
        return prefix + result;
    }

    public static String relativize(String path, String rootPath) {
        if (StringUtils.isNullOrEmpty(path) || StringUtils.isNullOrEmpty(rootPath)) {
            return path;
        }
        if (path.toLowerCase().startsWith("http:/") || path.toLowerCase().startsWith("https:/")) {
            String prefix = "";
            while (rootPath != null) {
                if (path.startsWith(rootPath)) {
                    if (!(path = path.substring(rootPath.length())).startsWith("/")) break;
                    path = path.substring(1);
                    break;
                }
                int ix = rootPath.lastIndexOf(47);
                rootPath = ix == -1 ? null : rootPath.substring(0, ix);
                prefix = prefix + "../";
            }
            return prefix + path;
        }
        String prefix = "";
        if (path.toLowerCase().startsWith("file:")) {
            try {
                path = new File(new URL(path).toURI()).getAbsolutePath();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (rootPath.startsWith("file:")) {
            try {
                rootPath = new File(new URL(rootPath).toURI()).getAbsolutePath();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!(rootPath.toUpperCase().charAt(0) == path.toUpperCase().charAt(0) || rootPath.indexOf(":\\") != 1 && rootPath.indexOf(":/") != 1 || path.indexOf(":\\") != 1 && path.indexOf(":/") != 1)) {
            return path;
        }
        while (rootPath != null) {
            if (path.startsWith(rootPath)) {
                if (!(path = path.substring(rootPath.length())).startsWith(File.separator)) break;
                path = path.substring(1);
                break;
            }
            File file = new File(rootPath);
            rootPath = file.getParent();
            prefix = prefix + ".." + File.separatorChar;
        }
        return prefix + path;
    }

    public static boolean isAbsolutePath(String path) {
        return !PathUtils.isRelativePath(path);
    }

    public static boolean isFilePath(String path) {
        if (StringUtils.isNullOrEmpty(path)) {
            return false;
        }
        return !PathUtils.isHttpPath(path);
    }

    public static String normalizePath(String path) {
        if (StringUtils.isNullOrEmpty(path)) {
            return path;
        }
        return File.separatorChar == '/' ? path : path.replace(File.separatorChar, '/');
    }

    public static String denormalizePath(String path) {
        if (StringUtils.isNullOrEmpty(path)) {
            return path;
        }
        if (PathUtils.isHttpPath(path)) {
            return path;
        }
        return File.separatorChar == '/' ? path.replace('\\', File.separatorChar) : path.replace('/', File.separatorChar);
    }

    public static String getExpandedResourceRoot(ModelItem modelItem) {
        return PathUtils.getExpandedResourceRoot(modelItem, null);
    }

    public static String getExpandedResourceRoot(ModelItem modelItem, PropertyExpansionContext context) {
        if (!(modelItem instanceof AbstractWsdlModelItem)) {
            return null;
        }
        WsdlProject project = (WsdlProject)ModelSupport.getModelItemProject(modelItem);
        if (project == null) {
            return null;
        }
        String docroot = project.getResourceRoot();
        if (!StringUtils.hasContent(docroot)) {
            return new File("").getAbsolutePath();
        }
        docroot = context == null ? PropertyExpander.expandProperties(modelItem, docroot) : PropertyExpander.expandProperties(context, docroot);
        return docroot;
    }

    public static String ensureFilePathIsUrl(String url) {
        if (PathUtils.isFilePath(url) && !url.startsWith("file:")) {
            try {
                return new File(url).toURI().toURL().toString();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    public static String fixForwardSlashesInPath(String path) {
        String prefix = null;
        String query = null;
        int ix = path.indexOf(63);
        if (ix >= 0) {
            query = path.substring(ix);
            path = path.substring(0, ix);
        }
        if (path.contains("://")) {
            prefix = path.substring(0, path.indexOf("://") + 3);
            path = path.substring(prefix.length());
        }
        path = path.replaceAll("/{2,}", "/");
        if (prefix != null) {
            path = prefix + path;
        }
        if (query != null) {
            path = path + query;
        }
        return path;
    }
}

