/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.support.wsdl.UrlWsdlLoader;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.support.types.StringList;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapTestPropertyHolder
implements MutableTestPropertyHolder {
    private Map<String, TestProperty> propertyMap = new HashMap<String, TestProperty>();
    private Set<TestPropertyListener> listeners = new HashSet<TestPropertyListener>();
    private List<TestProperty> properties = new ArrayList<TestProperty>();
    public ModelItem modelItem;
    private String propertiesLabel = "Test Properties";

    public MapTestPropertyHolder(ModelItem modelItem) {
        this.modelItem = modelItem;
    }

    private void firePropertyAdded(String name) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyAdded(name);
        }
    }

    private void firePropertyRemoved(String name) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyRemoved(name);
        }
    }

    private void firePropertyMoved(String name, int oldIndex, int newIndex) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyMoved(name, oldIndex, newIndex);
        }
    }

    private void firePropertyRenamed(String oldName, String newName) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyRenamed(oldName, newName);
        }
    }

    private void firePropertyValueChanged(String name, String oldValue, String newValue) {
        TestPropertyListener[] listenersArray;
        for (TestPropertyListener listener : listenersArray = this.listeners.toArray(new TestPropertyListener[this.listeners.size()])) {
            listener.propertyValueChanged(name, oldValue, newValue);
        }
    }

    @Override
    public TestProperty addProperty(String name) {
        InternalTestProperty result = new InternalTestProperty(name, null);
        this.propertyMap.put(name.toUpperCase(), result);
        this.properties.add(result);
        this.firePropertyAdded(name);
        return result;
    }

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public TestProperty getProperty(String name) {
        return this.propertyMap.get(name.toUpperCase());
    }

    @Override
    public String[] getPropertyNames() {
        StringList result = new StringList();
        for (String name : this.propertyMap.keySet()) {
            result.add(this.propertyMap.get(name).getName());
        }
        return result.toStringArray();
    }

    @Override
    public List<TestProperty> getPropertyList() {
        return Collections.unmodifiableList(this.properties);
    }

    @Override
    public String getPropertyValue(String name) {
        TestProperty property = this.getProperty(name);
        return property == null ? null : property.getValue();
    }

    @Override
    public TestProperty removeProperty(String propertyName) {
        TestProperty property = this.getProperty(propertyName);
        if (property != null) {
            this.properties.remove(property);
            this.propertyMap.remove(propertyName.toUpperCase());
            this.firePropertyRemoved(propertyName);
        }
        return property;
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setPropertyValue(String name, String value) {
        InternalTestProperty property = (InternalTestProperty)this.getProperty(name);
        if (property != null) {
            property.setValue(value);
        }
    }

    @Override
    public boolean renameProperty(String name, String newName) {
        if (this.getProperty(newName) != null) {
            return false;
        }
        InternalTestProperty property = (InternalTestProperty)this.getProperty(name);
        if (property == null) {
            return false;
        }
        property.setName(newName);
        return true;
    }

    public void saveTo(Properties props) {
        int cnt = 0;
        for (TestProperty p : this.properties) {
            String name = p.getName();
            String value = p.getValue();
            if (value == null) {
                value = "";
            }
            props.setProperty(name, value);
            ++cnt;
        }
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        HashMap<String, TestProperty> result = new HashMap<String, TestProperty>();
        for (String name : this.propertyMap.keySet()) {
            result.put(name, this.propertyMap.get(name));
        }
        return result;
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertyMap.containsKey(name.toUpperCase());
    }

    public int addPropertiesFromFile(String propFile) {
        try {
            InputStream input = null;
            File file = new File(propFile);
            if (file.exists()) {
                input = new FileInputStream(file);
            } else if (propFile.toLowerCase().startsWith("http://") || propFile.toLowerCase().startsWith("https://")) {
                UrlWsdlLoader loader = new UrlWsdlLoader(propFile, this.getModelItem());
                loader.setUseWorker(false);
                input = loader.load();
            }
            Properties properties = new Properties();
            properties.load(input);
            for (Object key : properties.keySet()) {
                String name = key.toString();
                if (!this.hasProperty(name)) {
                    this.addProperty(name).setValue(properties.getProperty(name));
                    continue;
                }
                this.setPropertyValue(name, properties.getProperty(name));
            }
            return properties.size();
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return 0;
        }
    }

    @Override
    public ModelItem getModelItem() {
        return this.modelItem;
    }

    @Override
    public void moveProperty(String propertyName, int targetIndex) {
        TestProperty property = this.getProperty(propertyName);
        int ix = this.properties.indexOf(property);
        if (ix == targetIndex) {
            return;
        }
        if (targetIndex < 0) {
            targetIndex = 0;
        }
        if (targetIndex < this.properties.size()) {
            this.properties.add(targetIndex, this.properties.remove(ix));
        } else {
            this.properties.add(this.properties.remove(ix));
        }
        if (targetIndex > this.properties.size()) {
            targetIndex = this.properties.size();
        }
        this.firePropertyMoved(propertyName, ix, targetIndex);
    }

    @Override
    public TestProperty getPropertyAt(int index) {
        return this.properties.get(index);
    }

    @Override
    public int getPropertyCount() {
        return this.properties.size();
    }

    public void setPropertiesLabel(String propertiesLabel) {
        this.propertiesLabel = propertiesLabel;
    }

    @Override
    public String getPropertiesLabel() {
        return this.propertiesLabel;
    }

    public class InternalTestProperty
    implements TestProperty {
        private String name;
        private String value;

        public InternalTestProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String oldName = this.getName();
            MapTestPropertyHolder.this.propertyMap.remove(oldName.toUpperCase());
            MapTestPropertyHolder.this.propertyMap.put(name.toUpperCase(), this);
            this.name = name;
            MapTestPropertyHolder.this.firePropertyRenamed(oldName, name);
        }

        public String getDescription() {
            return null;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            String oldValue = this.getValue();
            this.value = value;
            MapTestPropertyHolder.this.firePropertyValueChanged(this.getName(), oldValue, value);
        }

        public boolean isReadOnly() {
            return false;
        }

        public QName getType() {
            return XmlString.type.getName();
        }

        public ModelItem getModelItem() {
            return MapTestPropertyHolder.this.modelItem;
        }

        public String getDefaultValue() {
            return null;
        }

        public boolean isRequestPart() {
            return false;
        }

        public SchemaType getSchemaType() {
            return XmlBeans.getBuiltinTypeSystem().findType(this.getType());
        }
    }
}

