/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.support.AbstractTestRunner;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.support.AbstractSubmitContext;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunListener;
import com.eviware.soapui.model.testsuite.TestRunnable;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.types.StringToObjectMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.list.TreeList;
import org.apache.http.protocol.BasicHttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTestCaseRunner<T extends TestRunnable, T2 extends WsdlTestRunContext>
extends AbstractTestRunner<T, T2>
implements TestCaseRunner {
    private TestRunListener[] testRunListeners = new TestRunListener[0];
    private List<TestStepResult> testStepResults = Collections.synchronizedList(new TreeList());
    private int gotoStepIndex;
    private int resultCount;
    private int initCount;
    private int startStep = 0;

    public AbstractTestCaseRunner(T modelItem, StringToObjectMap properties) {
        super(modelItem, properties);
    }

    public int getGotoStepIndex() {
        return this.gotoStepIndex;
    }

    public int getStartStep() {
        return this.startStep;
    }

    public void setStartStep(int startStep) {
        this.startStep = startStep;
    }

    @Override
    public void onCancel(String reason) {
        TestStep currentStep = ((WsdlTestRunContext)this.getRunContext()).getCurrentStep();
        if (currentStep != null) {
            currentStep.cancel();
        }
    }

    @Override
    public void onFail(String reason) {
        TestStep currentStep = ((WsdlTestRunContext)this.getRunContext()).getCurrentStep();
        if (currentStep != null) {
            currentStep.cancel();
        }
    }

    @Override
    public void internalRun(T2 runContext) throws Exception {
        int currentStepIndex;
        WsdlTestCase testCase = this.getTestCase();
        this.gotoStepIndex = -1;
        this.testStepResults.clear();
        if (testCase.getKeepSession()) {
            if (!(((WsdlTestRunContext)runContext).getProperty("#HTTP_STATE") instanceof BasicHttpContext)) {
                ((WsdlTestRunContext)runContext).setProperty("#HTTP_STATE", new BasicHttpContext());
            }
        } else {
            ((WsdlTestRunContext)runContext).setProperty("#HTTP_STATE", null);
        }
        this.fillInTestRunnableListeners();
        this.runSetupScripts(runContext);
        if (!this.isRunning()) {
            return;
        }
        if (testCase.getTimeout() > 0L) {
            this.startTimeoutTimer(testCase.getTimeout());
        }
        this.notifyBeforeRun();
        if (!this.isRunning()) {
            return;
        }
        this.initCount = this.getStartStep();
        this.setStartTime();
        while (this.initCount < testCase.getTestStepCount() && this.isRunning()) {
            WsdlTestStep testStep = testCase.getTestStepAt(this.initCount);
            if (!testStep.isDisabled()) {
                try {
                    testStep.prepare(this, (TestCaseRunContext)runContext);
                }
                catch (Exception e) {
                    this.setStatus(TestRunner.Status.FAILED);
                    SoapUI.logError(e);
                    throw new Exception("Failed to prepare testStep [" + testStep.getName() + "]; " + e.toString());
                }
            }
            ++this.initCount;
        }
        ((WsdlTestRunContext)runContext).setCurrentStep(currentStepIndex);
        for (currentStepIndex = this.startStep; this.isRunning() && currentStepIndex < testCase.getTestStepCount(); ++currentStepIndex) {
            if ((currentStepIndex = this.runCurrentTestStep(runContext, currentStepIndex)) != -2) continue;
            return;
        }
        this.failTestRunnableOnErrors(runContext);
        this.preserveContext((WsdlTestRunContext)this.getRunContext());
    }

    protected abstract void failTestRunnableOnErrors(T2 var1);

    protected abstract int runCurrentTestStep(T2 var1, int var2) throws Exception;

    @Override
    protected void internalFinally(T2 runContext) {
        WsdlTestCase testCase = this.getTestCase();
        for (int c = 0; c < this.initCount && c < testCase.getTestStepCount(); ++c) {
            WsdlTestStep testStep = testCase.getTestStepAt(c);
            if (testStep.isDisabled()) continue;
            testStep.finish(this, (TestCaseRunContext)runContext);
        }
        try {
            this.runTearDownScripts(runContext);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        this.notifyAfterRun();
        this.clear(runContext);
    }

    protected void runSetupScripts(T2 runContext) throws Exception {
        this.getTestCase().runSetupScript((TestCaseRunContext)runContext, this);
    }

    protected void runTearDownScripts(T2 runContext) throws Exception {
        this.getTestCase().runTearDownScript((TestCaseRunContext)runContext, this);
    }

    protected void clear(T2 runContext) {
        ((AbstractSubmitContext)runContext).clear();
        this.testRunListeners = null;
    }

    protected void fillInTestRunnableListeners() {
        this.testRunListeners = this.getTestCase().getTestRunListeners();
    }

    @Override
    public TestStepResult runTestStepByName(String name) {
        return this.runTestStep(this.getTestCase().getTestStepByName(name), true, true);
    }

    public TestStepResult runTestStep(TestStep testStep) {
        return this.runTestStep(testStep, true, true);
    }

    public TestStepResult runTestStep(TestStep testStep, boolean discard, boolean process) {
        for (int i = 0; i < this.testRunListeners.length; ++i) {
            if (Arrays.asList(this.getTestCase().getTestRunListeners()).contains(this.testRunListeners[i])) {
                this.testRunListeners[i].beforeStep(this, (TestCaseRunContext)this.getRunContext(), testStep);
            }
            if (this.isRunning()) continue;
            return null;
        }
        TestStepResult stepResult = testStep.run(this, (TestCaseRunContext)this.getRunContext());
        this.testStepResults.add(stepResult);
        ++this.resultCount;
        this.enforceMaxResults(this.getTestCase().getMaxResults());
        for (int i = 0; i < this.testRunListeners.length; ++i) {
            if (!Arrays.asList(this.getTestCase().getTestRunListeners()).contains(this.testRunListeners[i])) continue;
            this.testRunListeners[i].afterStep(this, (TestCaseRunContext)this.getRunContext(), stepResult);
        }
        if (discard && stepResult.getStatus() == TestStepResult.TestStepStatus.OK && this.getTestCase().getDiscardOkResults() && !stepResult.isDiscarded()) {
            stepResult.discard();
        }
        if (process && stepResult.getStatus() == TestStepResult.TestStepStatus.FAILED) {
            if (this.getTestCase().getFailOnError()) {
                this.setError(stepResult.getError());
                this.fail("Cancelling due to failed test step");
            } else {
                ((WsdlTestRunContext)this.getRunContext()).setProperty(TestRunner.Status.class.getName(), (Object)TestRunner.Status.FAILED);
            }
        }
        return stepResult;
    }

    private void preserveContext(T2 runContext) {
        this.getTestCase().setRunFromHereContext(((AbstractSubmitContext)runContext).getProperties());
    }

    protected void notifyAfterRun() {
        if (this.testRunListeners == null || this.testRunListeners.length == 0) {
            return;
        }
        for (int i = 0; i < this.testRunListeners.length; ++i) {
            try {
                if (!Arrays.asList(this.getTestCase().getTestRunListeners()).contains(this.testRunListeners[i])) continue;
                this.testRunListeners[i].afterRun(this, (TestCaseRunContext)this.getRunContext());
                continue;
            }
            catch (Throwable t) {
                SoapUI.logError(t);
            }
        }
    }

    protected void notifyBeforeRun() {
        if (this.testRunListeners == null || this.testRunListeners.length == 0) {
            return;
        }
        for (int i = 0; i < this.testRunListeners.length; ++i) {
            try {
                if (!Arrays.asList(this.getTestCase().getTestRunListeners()).contains(this.testRunListeners[i])) continue;
                this.testRunListeners[i].beforeRun(this, (TestCaseRunContext)this.getRunContext());
                continue;
            }
            catch (Throwable t) {
                SoapUI.logError(t);
            }
        }
    }

    @Override
    public abstract WsdlTestCase getTestCase();

    @Override
    public long getTimeTaken() {
        long sum = 0L;
        for (int c = 0; c < this.testStepResults.size(); ++c) {
            TestStepResult testStepResult = this.testStepResults.get(c);
            if (testStepResult == null) continue;
            sum += testStepResult.getTimeTaken();
        }
        return sum;
    }

    @Override
    public List<TestStepResult> getResults() {
        return this.testStepResults;
    }

    public void setResultCount(int resultCount) {
        this.resultCount = resultCount;
    }

    public int getResultCount() {
        return this.resultCount;
    }

    @Override
    public void gotoStep(int index) {
        this.gotoStepIndex = index;
    }

    public void enforceMaxResults(long maxResults) {
        if (maxResults < 1L) {
            return;
        }
        while ((long)this.testStepResults.size() > maxResults) {
            this.testStepResults.remove(0);
        }
    }

    @Override
    public void gotoStepByName(String stepName) {
        WsdlTestStep testStep = this.getTestCase().getTestStepByName(stepName);
        if (testStep != null) {
            this.gotoStep(this.getTestCase().getIndexOfTestStep(testStep));
        }
    }
}

