/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.AttachmentUtils;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.WsdlRequestMimeMessageRequestEntity;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.http.Header;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicHeader;

public class MimeMessageMockResponseEntity
extends AbstractHttpEntity {
    private final MimeMessage message;
    private final boolean isXOP;
    private final WsdlMockResponse mockResponse;

    public MimeMessageMockResponseEntity(MimeMessage message, boolean isXOP, WsdlMockResponse response) {
        this.message = message;
        this.isXOP = isXOP;
        this.mockResponse = response;
    }

    public long getContentLength() {
        try {
            WsdlRequestMimeMessageRequestEntity.DummyOutputStream out = new WsdlRequestMimeMessageRequestEntity.DummyOutputStream();
            this.writeTo(out);
            return out.getSize();
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return -1L;
        }
    }

    public Header getContentType() {
        try {
            SoapVersion soapVersion = this.mockResponse.getSoapVersion();
            if (this.isXOP) {
                String header = this.message.getHeader("Content-Type")[0];
                return new BasicHeader("Content-Type", AttachmentUtils.buildMTOMContentType(header, null, soapVersion));
            }
            String header = this.message.getHeader("Content-Type")[0];
            int ix = header.indexOf("boundary");
            return new BasicHeader("Content-Type", "multipart/related; type=\"" + soapVersion.getContentType() + "\"; start=\"" + "<rootpart@soapui.org>" + "\"; " + header.substring(ix));
        }
        catch (MessagingException e) {
            SoapUI.logError(e);
            return null;
        }
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeTo(OutputStream arg0) throws IOException {
        try {
            arg0.write("\r\n".getBytes());
            ((MimeMultipart)this.message.getContent()).writeTo(arg0);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        try {
            return this.message.getInputStream();
        }
        catch (MessagingException e) {
            throw new IOException(e);
        }
    }

    public boolean isStreaming() {
        return false;
    }
}

