/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.testcase;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.panels.support.MockTestRunContext;
import com.eviware.soapui.impl.wsdl.panels.support.MockTestRunner;
import com.eviware.soapui.impl.wsdl.panels.support.ProgressBarTestCaseAdapter;
import com.eviware.soapui.impl.wsdl.panels.testcase.JTestCaseTestRunLog;
import com.eviware.soapui.impl.wsdl.panels.testcase.JTestStepList;
import com.eviware.soapui.impl.wsdl.panels.testcase.TestOnDemandPanel;
import com.eviware.soapui.impl.wsdl.panels.testcase.actions.SetCredentialsAction;
import com.eviware.soapui.impl.wsdl.panels.testcase.actions.SetEndpointAction;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.AbstractGroovyEditorModel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.PropertyHolderTable;
import com.eviware.soapui.impl.wsdl.support.AbstractTestCaseRunner;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.registry.ProPlaceholderStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepRegistry;
import com.eviware.soapui.integration.loadui.IntegrationUtils;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.support.TestRunListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.monitor.support.TestMonitorListenerAdapter;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.DateUtil;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.components.GroovyEditorComponent;
import com.eviware.soapui.support.components.GroovyEditorInspector;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JFocusableComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JUndoableTextArea;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.dnd.JListDragAndDropable;
import com.eviware.soapui.support.dnd.SoapUIDragAndDropHandler;
import com.eviware.soapui.support.swing.ComponentBag;
import com.eviware.soapui.support.types.StringToObjectMap;
import com.eviware.soapui.ui.support.KeySensitiveModelItemDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlTestCaseDesktopPanel
extends KeySensitiveModelItemDesktopPanel<WsdlTestCase> {
    private JProgressBar progressBar;
    private JTestStepList testStepList;
    private InternalTestRunListener testRunListener = new InternalTestRunListener();
    private JButton runButton;
    private JButton cancelButton;
    private TestCaseRunner runner;
    private JButton setEndpointButton;
    private JButton setCredentialsButton;
    private JButton optionsButton;
    private ComponentBag stateDependantComponents = new ComponentBag();
    private JTestCaseTestRunLog testCaseLog;
    private JToggleButton loopButton;
    private ProgressBarTestCaseAdapter progressBarAdapter;
    private InternalTestMonitorListener testMonitorListener;
    public boolean canceled;
    protected JTextArea descriptionArea;
    private PropertyHolderTable propertiesTable;
    private GroovyEditorComponent tearDownGroovyEditor;
    private GroovyEditorComponent setupGroovyEditor;
    private JInspectorPanel testStepListInspectorPanel;
    private JButton createLoadTestButton;
    private JButton createSecurityTestButton;
    private JInspectorPanel inspectorPanel;
    public TestCaseRunner lastRunner;
    private JButton runWithLoadUIButton;
    private JButton synchronizeWithLoadUIButton;
    private WsdlTestCase testCase;
    protected TestOnDemandPanel testOnDemandPanel;

    public WsdlTestCaseDesktopPanel(WsdlTestCase testCase) {
        super(testCase);
        this.buildUI();
        this.setPreferredSize(new Dimension(400, 550));
        this.setRunningState();
        testCase.addTestRunListener(this.testRunListener);
        this.progressBarAdapter = new ProgressBarTestCaseAdapter(this.progressBar, testCase);
        this.testMonitorListener = new InternalTestMonitorListener();
        SoapUI.getTestMonitor().addTestMonitorListener(this.testMonitorListener);
        DragSource dragSource = DragSource.getDefaultDragSource();
        SoapUIDragAndDropHandler dragAndDropHandler = new SoapUIDragAndDropHandler(new ModelItemListDragAndDropable(this.getTestStepList().getTestStepList(), testCase), 3);
        dragSource.createDefaultDragGestureRecognizer(this.getTestStepList().getTestStepList(), 3, dragAndDropHandler);
        this.testCase = testCase;
    }

    private void setRunningState() {
        boolean hasRunningTests = SoapUI.getTestMonitor().hasRunningLoadTest((TestCase)this.getModelItem()) || SoapUI.getTestMonitor().hasRunningSecurityTest((TestCase)this.getModelItem());
        this.stateDependantComponents.setEnabled(!hasRunningTests);
        WsdlProject project = ((WsdlTestCase)this.getModelItem()).getTestSuite().getProject();
        if (project.isEnvironmentMode()) {
            this.getSetEndpointButton().setEnabled(false);
        } else {
            this.getSetEndpointButton().setEnabled(!hasRunningTests);
        }
    }

    private void buildUI() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.buildToolbar(), "First");
        panel.add(this.buildRunnerBar(), "Center");
        this.add((Component)panel, "North");
        this.inspectorPanel = JInspectorPanelFactory.build(this.buildContent());
        this.inspectorPanel.addInspector(new JComponentInspector<JComponent>(this.buildTestLog(), "TestCase Log", "TestCase Execution Log", true));
        this.inspectorPanel.setDefaultDividerLocation(0.7f);
        this.inspectorPanel.setCurrentInspector("TestCase Log");
        if (StringUtils.hasContent(((WsdlTestCase)this.getModelItem()).getDescription()) && ((WsdlTestCase)this.getModelItem()).getSettings().getBoolean(UISettings.SHOW_DESCRIPTIONS)) {
            this.testStepListInspectorPanel.setCurrentInspector("Description");
        }
        this.add((Component)this.inspectorPanel.getComponent(), "Center");
    }

    protected JTestStepList getTestStepList() {
        return this.testStepList;
    }

    private JComponent buildTestLog() {
        this.testCaseLog = new JTestCaseTestRunLog((WsdlTestCase)this.getModelItem());
        this.stateDependantComponents.add(this.testCaseLog);
        return this.testCaseLog;
    }

    private JComponent buildContent() {
        JTabbedPane tabs = new JTabbedPane(1);
        this.testStepListInspectorPanel = JInspectorPanelFactory.build(this.buildTestStepList(), 3);
        tabs.addTab("TestSteps", this.testStepListInspectorPanel.getComponent());
        this.addTabs(tabs, this.testStepListInspectorPanel);
        tabs.setTabLayoutPolicy(1);
        tabs.addChangeListener(new TestOnDemandTabChangeListener());
        return UISupport.createTabPanel(tabs, true);
    }

    protected JComponent buildTestStepList() {
        WsdlTestStepFactory[] factories;
        JPanel p = new JPanel(new BorderLayout());
        JXToolBar toolbar = UISupport.createToolbar();
        for (WsdlTestStepFactory factory : factories = WsdlTestStepRegistry.getInstance().getFactories()) {
            JButton testStepButton = UISupport.createToolbarButton(new AddWsdlTestStepAction(factory));
            if (factory instanceof ProPlaceholderStepFactory) {
                testStepButton.setEnabled(false);
            }
            toolbar.addFixed(testStepButton);
        }
        p.add((Component)toolbar, "North");
        this.testStepList = new JTestStepList((WsdlTestCase)this.getModelItem());
        this.stateDependantComponents.add(this.testStepList);
        p.add((Component)new JScrollPane(this.testStepList), "Center");
        return p;
    }

    protected void addTabs(JTabbedPane tabs, JInspectorPanel inspectorPanel) {
        inspectorPanel.addInspector(new JFocusableComponentInspector<JPanel>(this.buildDescriptionPanel(), this.descriptionArea, "Description", "TestCase Description", true));
        inspectorPanel.addInspector(new JComponentInspector<JComponent>(this.buildPropertiesPanel(), "Properties", "TestCase level properties", true));
        inspectorPanel.addInspector(new GroovyEditorInspector(this.buildSetupScriptPanel(), "Setup Script", "Script to run before running a TestCase"));
        inspectorPanel.addInspector(new GroovyEditorInspector(this.buildTearDownScriptPanel(), "TearDown Script", "Script to run after a TestCase Run"));
        tabs.addTab("Test On Demand", this.buildTestOnDemandPanel());
    }

    protected GroovyEditorComponent buildTearDownScriptPanel() {
        this.tearDownGroovyEditor = new GroovyEditorComponent(new TearDownScriptGroovyEditorModel(), null);
        return this.tearDownGroovyEditor;
    }

    protected GroovyEditorComponent buildSetupScriptPanel() {
        this.setupGroovyEditor = new GroovyEditorComponent(new SetupScriptGroovyEditorModel(), null);
        return this.setupGroovyEditor;
    }

    protected JComponent buildPropertiesPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.propertiesTable = this.buildPropertiesTable();
        panel.add((Component)this.propertiesTable, "Center");
        return panel;
    }

    protected PropertyHolderTable buildPropertiesTable() {
        return new PropertyHolderTable((TestPropertyHolder)this.getModelItem());
    }

    protected JPanel buildDescriptionPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.descriptionArea = new JUndoableTextArea(((WsdlTestCase)this.getModelItem()).getDescription());
        this.descriptionArea.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                ((WsdlTestCase)WsdlTestCaseDesktopPanel.this.getModelItem()).setDescription(WsdlTestCaseDesktopPanel.this.descriptionArea.getText());
            }
        });
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        panel.add((Component)new JScrollPane(this.descriptionArea), "Center");
        UISupport.addTitledBorder(panel, "TestCase Description");
        return panel;
    }

    protected Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        this.runButton = UISupport.createToolbarButton(new RunTestCaseAction());
        this.optionsButton = UISupport.createToolbarButton(SwingActionDelegate.createDelegate("TestCaseOptionsAction", this.getModelItem(), null, "/options.gif"));
        this.optionsButton.setText(null);
        this.cancelButton = UISupport.createToolbarButton(new CancelRunTestCaseAction(), false);
        this.loopButton = new JToggleButton(UISupport.createImageIcon("/loop.gif"));
        this.loopButton.setPreferredSize(UISupport.getPreferredButtonSize());
        this.loopButton.setToolTipText("Loop TestCase continuously");
        this.setCredentialsButton = UISupport.createToolbarButton(new SetCredentialsAction((WsdlTestCase)this.getModelItem()));
        this.setEndpointButton = UISupport.createToolbarButton(new SetEndpointAction((WsdlTestCase)this.getModelItem()));
        this.stateDependantComponents.add(this.runButton);
        this.stateDependantComponents.add(this.optionsButton);
        this.stateDependantComponents.add(this.cancelButton);
        this.stateDependantComponents.add(this.setCredentialsButton);
        this.stateDependantComponents.add(this.setEndpointButton);
        this.createLoadTestButton = UISupport.createToolbarButton(SwingActionDelegate.createDelegate("AddNewLoadTestAction", this.getModelItem(), null, "/loadTest.gif"));
        this.createSecurityTestButton = UISupport.createToolbarButton(SwingActionDelegate.createDelegate("AddNewSecurityTestAction", this.getModelItem(), null, "/security_test.gif"));
        this.runWithLoadUIButton = UISupport.createToolbarButton(SwingActionDelegate.createDelegate("RunTestCaseWithLoadUIAction", this.getModelItem(), null, "/runTestCaseWithLoadUI.png"));
        this.synchronizeWithLoadUIButton = UISupport.createToolbarButton(new SynchronizeWithLoadUIAction());
        this.addToolbarActions(toolbar);
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/testcases.html#The_TestCase_Editor")));
        return toolbar;
    }

    protected JButton getSetEndpointButton() {
        return this.setEndpointButton;
    }

    protected void addToolbarActions(JXToolBar toolbar) {
        toolbar.add(this.runButton);
        toolbar.add(this.cancelButton);
        toolbar.add(this.loopButton);
        toolbar.addSeparator();
        toolbar.add(this.setCredentialsButton);
        toolbar.add(this.setEndpointButton);
        toolbar.addSeparator();
        toolbar.add(this.createLoadTestButton);
        toolbar.add(this.createSecurityTestButton);
        toolbar.addSeparator();
        toolbar.add(this.optionsButton);
        toolbar.addSeparator();
        toolbar.add(this.runWithLoadUIButton);
        toolbar.add(this.synchronizeWithLoadUIButton);
    }

    private Component buildRunnerBar() {
        this.progressBar = new JProgressBar(0, ((WsdlTestCase)this.getModelItem()).getTestStepCount());
        return UISupport.createProgressBarPanel(this.progressBar, 10, false);
    }

    protected void runTestCase() {
        if (this.canceled) {
            this.runButton.setEnabled(true);
            this.cancelButton.setEnabled(false);
            this.testStepList.setEnabled(true);
            return;
        }
        StringToObjectMap properties = new StringToObjectMap();
        properties.put("loopButton", this.loopButton);
        properties.put("Interactive", Boolean.TRUE);
        this.lastRunner = null;
        this.runner = ((WsdlTestCase)this.getModelItem()).run(properties, true);
    }

    @Override
    public boolean onClose(boolean canCancel) {
        if (canCancel) {
            if (this.runner != null && this.runner.getStatus() == TestRunner.Status.RUNNING) {
                Boolean retval = UISupport.confirmOrCancel("Cancel running TestCase?", "Cancel Run");
                if (retval == null) {
                    return false;
                }
                if (retval.booleanValue() && this.runner != null) {
                    this.runner.cancel(null);
                }
            }
        } else if (this.runner != null && this.runner.getStatus() == TestRunner.Status.RUNNING && this.runner != null) {
            this.runner.cancel(null);
        }
        SoapUI.getTestMonitor().removeTestMonitorListener(this.testMonitorListener);
        ((WsdlTestCase)this.getModelItem()).removeTestRunListener(this.testRunListener);
        this.testStepList.release();
        this.progressBarAdapter.release();
        this.propertiesTable.release();
        this.inspectorPanel.release();
        this.setupGroovyEditor.getEditor().release();
        this.tearDownGroovyEditor.getEditor().release();
        this.testCaseLog.release();
        this.lastRunner = null;
        if (this.testOnDemandPanel != null) {
            this.testOnDemandPanel.release();
        }
        return this.release();
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.getModelItem() || modelItem == ((WsdlTestCase)this.getModelItem()).getTestSuite() || modelItem == ((WsdlTestCase)this.getModelItem()).getTestSuite().getProject();
    }

    protected void beforeRun() {
    }

    protected void afterRun() {
        this.runButton.setEnabled(true);
        this.cancelButton.setEnabled(false);
        this.testStepList.setEnabled(true);
    }

    public TestCaseRunner getTestCaseRunner() {
        return this.runner == null ? this.lastRunner : this.runner;
    }

    @Override
    protected void renameModelItem() {
        SoapUI.getActionRegistry().performAction("RenameTestCaseAction", (ModelItem)this.getModelItem(), null);
    }

    @Override
    protected void cloneModelItem() {
        SoapUI.getActionRegistry().performAction("CloneTestCaseAction", (ModelItem)this.getModelItem(), null);
    }

    protected Component buildTestOnDemandPanel() {
        this.testOnDemandPanel = new TestOnDemandPanel((WsdlTestCase)this.getModelItem());
        return this.testOnDemandPanel;
    }

    public class SynchronizeWithLoadUIAction
    extends AbstractAction {
        public SynchronizeWithLoadUIAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/synchronizeWithLoadUI.png"));
            this.putValue("ShortDescription", "Synchronizes this testcase with loadUI");
        }

        public void actionPerformed(ActionEvent e) {
            WsdlProject project = WsdlTestCaseDesktopPanel.this.testCase.getTestSuite().getProject();
            if (IntegrationUtils.forceSaveProject(project)) {
                IntegrationUtils.bringLoadUIToFront();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ModelItemListDragAndDropable
    extends JListDragAndDropable<JList> {
        public ModelItemListDragAndDropable(JList list, WsdlTestCase testCase) {
            super(list, testCase);
        }

        @Override
        public ModelItem getModelItemAtRow(int row) {
            return (ModelItem)((JList)this.getList()).getModel().getElementAt(row);
        }

        @Override
        public int getModelItemRow(ModelItem modelItem) {
            ListModel model = ((JList)this.getList()).getModel();
            for (int c = 0; c < model.getSize(); ++c) {
                if (model.getElementAt(c) != modelItem) continue;
                return c;
            }
            return -1;
        }

        @Override
        public Component getRenderer(ModelItem modelItem) {
            return ((JList)this.getList()).getCellRenderer().getListCellRendererComponent((JList<ModelItem>)this.getList(), modelItem, this.getModelItemRow(modelItem), true, true);
        }

        @Override
        public void setDragInfo(String dropInfo) {
            super.setDragInfo(dropInfo == null || dropInfo.length() == 0 ? null : dropInfo);
        }
    }

    private class AddWsdlTestStepAction
    extends AbstractAction
    implements Runnable {
        private final WsdlTestStepFactory factory;

        public AddWsdlTestStepAction(WsdlTestStepFactory factory) {
            this.factory = factory;
            this.putValue("SmallIcon", UISupport.createImageIcon(factory.getTestStepIconPath()));
            this.putValue("ShortDescription", "Create a new " + factory.getTestStepName() + " TestStep");
        }

        public void actionPerformed(ActionEvent e) {
            SwingActionDelegate.invoke(this);
        }

        public void run() {
            WsdlTestStep testStep;
            TestStepConfig newTestStepConfig;
            if (!this.factory.canAddTestStepToTestCase(WsdlTestCaseDesktopPanel.this.testCase)) {
                return;
            }
            int ix = WsdlTestCaseDesktopPanel.this.testStepList.getTestStepList().getSelectedIndex();
            String name = UISupport.prompt("Specify name for new step", ix == -1 ? "Add Step" : "Insert Step", this.factory.getTestStepName());
            if (name != null && (newTestStepConfig = this.factory.createNewTestStep((WsdlTestCase)WsdlTestCaseDesktopPanel.this.getModelItem(), name)) != null && (testStep = ((WsdlTestCase)WsdlTestCaseDesktopPanel.this.getModelItem()).insertTestStep(newTestStepConfig, ix)) != null) {
                UISupport.selectAndShow(testStep);
            }
        }
    }

    private class TearDownScriptGroovyEditorModel
    extends AbstractGroovyEditorModel {
        public Action createRunAction() {
            return new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MockTestRunner mockTestRunner = new MockTestRunner((WsdlTestCase)WsdlTestCaseDesktopPanel.this.getModelItem(), SoapUI.ensureGroovyLog());
                        ((WsdlTestCase)WsdlTestCaseDesktopPanel.this.getModelItem()).runTearDownScript(new MockTestRunContext(mockTestRunner, null), mockTestRunner);
                    }
                    catch (Exception e1) {
                        UISupport.showErrorMessage(e1);
                    }
                }
            };
        }

        public TearDownScriptGroovyEditorModel() {
            super(new String[]{"log", "testCase", "context", "testRunner"}, (ModelItem)WsdlTestCaseDesktopPanel.this.getModelItem(), "TearDown");
        }

        public String getScript() {
            return ((WsdlTestCase)WsdlTestCaseDesktopPanel.this.getModelItem()).getTearDownScript();
        }

        public void setScript(String text) {
            ((WsdlTestCase)WsdlTestCaseDesktopPanel.this.getModelItem()).setTearDownScript(text);
        }
    }

    private class SetupScriptGroovyEditorModel
    extends AbstractGroovyEditorModel {
        public Action createRunAction() {
            return new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MockTestRunner mockTestRunner = new MockTestRunner((WsdlTestCase)WsdlTestCaseDesktopPanel.this.getModelItem(), SoapUI.ensureGroovyLog());
                        ((WsdlTestCase)WsdlTestCaseDesktopPanel.this.getModelItem()).runSetupScript(new MockTestRunContext(mockTestRunner, null), mockTestRunner);
                    }
                    catch (Exception e1) {
                        UISupport.showErrorMessage(e1);
                    }
                }
            };
        }

        public SetupScriptGroovyEditorModel() {
            super(new String[]{"log", "testCase", "context", "testRunner"}, (ModelItem)WsdlTestCaseDesktopPanel.this.getModelItem(), "Setup");
        }

        public String getScript() {
            return ((WsdlTestCase)WsdlTestCaseDesktopPanel.this.getModelItem()).getSetupScript();
        }

        public void setScript(String text) {
            ((WsdlTestCase)WsdlTestCaseDesktopPanel.this.getModelItem()).setSetupScript(text);
        }
    }

    public class CancelRunTestCaseAction
    extends AbstractAction {
        public CancelRunTestCaseAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/stop_testcase.gif"));
            this.putValue("ShortDescription", "Stops running this testcase");
        }

        public void actionPerformed(ActionEvent e) {
            if (WsdlTestCaseDesktopPanel.this.runner != null) {
                WsdlTestCaseDesktopPanel.this.runner.cancel("canceled in UI");
            }
            WsdlTestCaseDesktopPanel.this.canceled = true;
        }
    }

    public class RunTestCaseAction
    extends AbstractAction {
        public RunTestCaseAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run_testcase.gif"));
            this.putValue("ShortDescription", "Runs this testcase");
        }

        public void actionPerformed(ActionEvent e) {
            WsdlTestCaseDesktopPanel.this.canceled = false;
            WsdlTestCaseDesktopPanel.this.runTestCase();
        }
    }

    public class InternalTestRunListener
    extends TestRunListenerAdapter {
        public void beforeRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
            if (SoapUI.getTestMonitor().hasRunningLoadTest((TestCase)WsdlTestCaseDesktopPanel.this.getModelItem()) || SoapUI.getTestMonitor().hasRunningSecurityTest((TestCase)WsdlTestCaseDesktopPanel.this.getModelItem())) {
                return;
            }
            WsdlTestCaseDesktopPanel.this.runButton.setEnabled(false);
            WsdlTestCaseDesktopPanel.this.cancelButton.setEnabled(true);
            WsdlTestCaseDesktopPanel.this.testStepList.setEnabled(false);
            WsdlTestCaseDesktopPanel.this.testStepList.setSelectedIndex(-1);
            WsdlTestCaseDesktopPanel.this.testCaseLog.clear();
            WsdlTestCaseDesktopPanel.this.testCaseLog.addText("Test started at " + DateUtil.formatExtraFull(new Date()));
            WsdlTestCaseDesktopPanel.this.beforeRun();
            if (WsdlTestCaseDesktopPanel.this.runner == null) {
                WsdlTestCaseDesktopPanel.this.runner = testRunner;
            }
        }

        public synchronized void beforeStep(TestCaseRunner testRunner, TestCaseRunContext runContext, final TestStep testStep) {
            if (SoapUI.getTestMonitor().hasRunningLoadTest((TestCase)WsdlTestCaseDesktopPanel.this.getModelItem()) || SoapUI.getTestMonitor().hasRunningSecurityTest((TestCase)WsdlTestCaseDesktopPanel.this.getModelItem())) {
                return;
            }
            if (testStep != null) {
                if (SwingUtilities.isEventDispatchThread()) {
                    WsdlTestCaseDesktopPanel.this.testStepList.setSelectedValue(testStep, true);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            WsdlTestCaseDesktopPanel.this.testStepList.setSelectedValue(testStep, true);
                        }
                    });
                }
            }
        }

        public void afterRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
            if (SoapUI.getTestMonitor().hasRunningLoadTest((TestCase)WsdlTestCaseDesktopPanel.this.getModelItem()) || SoapUI.getTestMonitor().hasRunningSecurityTest((TestCase)WsdlTestCaseDesktopPanel.this.getModelItem())) {
                return;
            }
            AbstractTestCaseRunner wsdlRunner = (AbstractTestCaseRunner)testRunner;
            if (testRunner.getStatus() == TestRunner.Status.CANCELED) {
                WsdlTestCaseDesktopPanel.this.testCaseLog.addText("TestCase canceled [" + testRunner.getReason() + "], time taken = " + wsdlRunner.getTimeTaken());
            } else if (testRunner.getStatus() == TestRunner.Status.FAILED) {
                String msg = wsdlRunner.getReason();
                if (wsdlRunner.getError() != null) {
                    if (msg != null) {
                        msg = msg + ":";
                    }
                    msg = msg + wsdlRunner.getError();
                }
                WsdlTestCaseDesktopPanel.this.testCaseLog.addText("TestCase failed [" + msg + "], time taken = " + wsdlRunner.getTimeTaken());
            } else {
                WsdlTestCaseDesktopPanel.this.testCaseLog.addText("TestCase finished with status [" + (Object)((Object)testRunner.getStatus()) + "], time taken = " + wsdlRunner.getTimeTaken());
            }
            WsdlTestCaseDesktopPanel.this.lastRunner = WsdlTestCaseDesktopPanel.this.runner;
            WsdlTestCaseDesktopPanel.this.runner = null;
            JToggleButton loopButton = (JToggleButton)runContext.getProperty("loopButton");
            if (loopButton != null && loopButton.isSelected() && testRunner.getStatus() == TestRunner.Status.FINISHED) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        WsdlTestCaseDesktopPanel.this.runTestCase();
                    }
                });
            } else {
                WsdlTestCaseDesktopPanel.this.afterRun();
            }
        }

        public void afterStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStepResult stepResult) {
            if (SoapUI.getTestMonitor().hasRunningLoadTest((TestCase)WsdlTestCaseDesktopPanel.this.getModelItem()) || SoapUI.getTestMonitor().hasRunningSecurityTest((TestCase)WsdlTestCaseDesktopPanel.this.getModelItem())) {
                return;
            }
            WsdlTestCaseDesktopPanel.this.testCaseLog.addTestStepResult(stepResult);
        }
    }

    private final class InternalTestMonitorListener
    extends TestMonitorListenerAdapter {
        private InternalTestMonitorListener() {
        }

        public void loadTestStarted(LoadTestRunner runner) {
            WsdlTestCaseDesktopPanel.this.setRunningState();
        }

        public void loadTestFinished(LoadTestRunner runner) {
            WsdlTestCaseDesktopPanel.this.setRunningState();
        }

        public void securityTestStarted(SecurityTestRunner runner) {
            WsdlTestCaseDesktopPanel.this.setRunningState();
        }

        public void securityTestFinished(SecurityTestRunner runner) {
            WsdlTestCaseDesktopPanel.this.setRunningState();
        }
    }

    private final class TestOnDemandTabChangeListener
    implements ChangeListener {
        private TestOnDemandTabChangeListener() {
        }

        public void stateChanged(ChangeEvent evt) {
            JTabbedPane pane = (JTabbedPane)evt.getSource();
            if (pane.getSelectedComponent().equals(WsdlTestCaseDesktopPanel.this.testOnDemandPanel)) {
                WsdlTestCaseDesktopPanel.this.testOnDemandPanel.initializeLocationsCache();
            }
        }
    }
}

