/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.request;

import com.eviware.soapui.support.types.StringToStringsMap;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToStringsMapTableModel
extends AbstractTableModel
implements TableModel {
    private final String keyCaption;
    private final String valueCaption;
    private List<NameValuePair> keyList = new ArrayList<NameValuePair>();
    private final boolean editable;
    private StringToStringsMap data;

    public StringToStringsMapTableModel(StringToStringsMap data, String keyCaption, String valueCaption, boolean editable) {
        this.data = data;
        this.keyCaption = keyCaption;
        this.valueCaption = valueCaption;
        this.editable = editable;
        this.setData(data);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int arg0) {
        return arg0 == 0 ? this.keyCaption : this.valueCaption;
    }

    @Override
    public boolean isCellEditable(int arg0, int arg1) {
        return this.editable;
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return String.class;
    }

    @Override
    public void setValueAt(Object arg0, int arg1, int arg2) {
        NameValuePair nvpair = this.keyList.get(arg1);
        if (arg2 == 0) {
            ((List)this.data.get(nvpair.getKey())).remove(nvpair.getIndex());
            nvpair.setKey(String.valueOf(arg0));
            this.data.put(nvpair.getKey(), nvpair.getIndex());
        } else if (arg2 == 1) {
            this.data.replace(nvpair.getKey(), nvpair.getIndex(), String.valueOf(arg0));
            nvpair.setValue(String.valueOf(arg0));
        }
        this.fireTableCellUpdated(arg1, arg2);
    }

    @Override
    public int getRowCount() {
        return this.keyList.size();
    }

    @Override
    public Object getValueAt(int arg0, int arg1) {
        return arg1 == 0 ? this.keyList.get(arg0).getKey() : this.keyList.get(arg0).getIndex();
    }

    public void add(String key, String value) {
        this.data.add(key, value);
        this.keyList.add(new NameValuePair(key, value));
        this.fireTableRowsInserted(this.keyList.size() - 1, this.keyList.size() - 1);
    }

    public void remove(int row) {
        NameValuePair key = this.keyList.get(row);
        this.keyList.remove(row);
        this.data.remove(key.getKey(), key.getIndex());
        this.fireTableRowsDeleted(row, row);
    }

    public StringToStringsMap getData() {
        return new StringToStringsMap(this.data);
    }

    public synchronized void setData(StringToStringsMap newData) {
        this.data = newData == null ? new StringToStringsMap() : new StringToStringsMap(newData);
        this.keyList.clear();
        for (String key : this.data.keySet()) {
            for (String value : (List)this.data.get(key)) {
                this.keyList.add(new NameValuePair(key, value));
            }
        }
        this.fireTableDataChanged();
    }

    private class NameValuePair {
        private String key;
        private String value;

        public NameValuePair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getIndex() {
            return this.value;
        }
    }
}

