/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.mock;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.actions.mockservice.MockServiceOptionsAction;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunner;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.AbstractGroovyEditorModel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.PropertyHolderTable;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.mock.MockRunner;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.mock.MockServiceListener;
import com.eviware.soapui.model.support.MockRunListenerAdapter;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.components.GroovyEditorComponent;
import com.eviware.soapui.support.components.GroovyEditorInspector;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JFocusableComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JUndoableTextArea;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.swing.AbstractListMouseListener;
import com.eviware.soapui.support.swing.ModelItemListKeyListener;
import com.eviware.soapui.support.swing.ModelItemListMouseListener;
import com.eviware.soapui.ui.support.KeySensitiveModelItemDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.text.Document;
import org.apache.commons.collections.list.TreeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlMockServiceDesktopPanel
extends KeySensitiveModelItemDesktopPanel<WsdlMockService> {
    private JButton runButton;
    private WsdlMockRunner mockRunner;
    private JButton stopButton;
    private JProgressBar progressBar;
    private LogListModel logListModel;
    private JList testLogList;
    private JCheckBox enableLogCheckBox;
    private JScrollPane logScrollPane;
    private JList operationList;
    private InternalMockRunListener mockRunListener;
    private PropertyHolderTable propertiesTable;
    private JUndoableTextArea descriptionArea;
    private JButton showWsdlButton;
    private JButton optionsButton;
    private JLabel runInfoLabel;
    private GroovyEditorComponent startGroovyEditor;
    private GroovyEditorComponent stopGroovyEditor;
    private GroovyEditorComponent onRequestGroovyEditor;
    private GroovyEditorComponent afterRequestGroovyEditor;
    private JInspectorPanel inspectorPanel;
    private JInspectorPanel contentInspector;

    public WsdlMockServiceDesktopPanel(WsdlMockService mockService) {
        super(mockService);
        this.buildUI();
        this.setPreferredSize(new Dimension(400, 500));
        this.mockRunListener = new InternalMockRunListener();
        mockService.addMockRunListener(this.mockRunListener);
    }

    @Override
    public boolean onClose(boolean canCancel) {
        if (this.mockRunner != null && this.mockRunner.isRunning() && canCancel && !UISupport.confirm("Close and stop MockService", "Close MockService")) {
            return false;
        }
        if (this.mockRunner != null) {
            if (this.mockRunner.isRunning()) {
                this.mockRunner.stop();
            }
            this.mockRunner.release();
        }
        ((WsdlMockService)this.getModelItem()).removeMockRunListener(this.mockRunListener);
        ((OperationListModel)this.operationList.getModel()).release();
        this.logListModel.clear();
        this.propertiesTable.release();
        this.startGroovyEditor.release();
        this.stopGroovyEditor.release();
        this.onRequestGroovyEditor.release();
        this.afterRequestGroovyEditor.release();
        this.inspectorPanel.release();
        this.contentInspector.release();
        return this.release();
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.getModelItem() || modelItem == ((WsdlMockService)this.getModelItem()).getProject();
    }

    private void buildUI() {
        this.add((Component)this.buildToolbar(), "North");
        this.contentInspector = JInspectorPanelFactory.build(this.buildContent());
        this.contentInspector.setDefaultDividerLocation(0.5f);
        this.contentInspector.addInspector(new JComponentInspector<JComponent>(this.buildLog(), "Message Log", "A log of processed requests and their responses", true));
        this.contentInspector.setCurrentInspector("Message Log");
        this.add((Component)this.contentInspector.getComponent(), "Center");
        this.add((Component)new JLabel("--"), "Last");
    }

    public boolean logIsEnabled() {
        return this.enableLogCheckBox.isSelected();
    }

    private JComponent buildContent() {
        JTabbedPane tabs = new JTabbedPane();
        this.inspectorPanel = JInspectorPanelFactory.build(this.buildOperationList());
        tabs.addTab("Operations", this.inspectorPanel.getComponent());
        this.addTabs(tabs, this.inspectorPanel);
        if (StringUtils.hasContent(((WsdlMockService)this.getModelItem()).getDescription()) && ((WsdlMockService)this.getModelItem()).getSettings().getBoolean(UISettings.SHOW_DESCRIPTIONS)) {
            this.inspectorPanel.setCurrentInspector("Description");
        }
        return UISupport.createTabPanel(tabs, true);
    }

    protected void addTabs(JTabbedPane tabs, JInspectorPanel inspectorPanel) {
        inspectorPanel.addInspector(new JFocusableComponentInspector<JPanel>(this.buildDescriptionPanel(), this.descriptionArea, "Description", "A description for this MockService", true));
        inspectorPanel.addInspector(new JComponentInspector<JComponent>(this.buildPropertiesPanel(), "Properties", "Properties for this MockService", true));
        inspectorPanel.addInspector(new GroovyEditorInspector(this.buildStartScriptPanel(), "Start Script", "A Groovy script to run when starting the MockService"));
        inspectorPanel.addInspector(new GroovyEditorInspector(this.buildStopScriptPanel(), "Stop Script", "A Groovy script to run when stopping the MockService"));
        inspectorPanel.addInspector(new GroovyEditorInspector(this.buildOnRequestScriptPanel(), "OnRequest Script", "A Groovy script to run when receiving a request before it is dispatched"));
        inspectorPanel.addInspector(new GroovyEditorInspector(this.buildAfterRequestScriptPanel(), "AfterRequest Script", "A Groovy script to run after a request has been dispatched"));
    }

    protected JComponent buildOperationList() {
        this.operationList = new JList(new OperationListModel());
        this.operationList.addMouseListener(new ModelItemListMouseListener(){
            private ActionList defaultActions;

            protected ActionList getDefaultActions() {
                if (this.defaultActions == null) {
                    this.defaultActions = new DefaultActionList();
                    this.defaultActions.addAction(SwingActionDelegate.createDelegate("AddNewMockOperationAction", WsdlMockServiceDesktopPanel.this.getModelItem(), null, null));
                }
                return this.defaultActions;
            }
        });
        this.operationList.setCellRenderer(new OperationListCellRenderer());
        this.operationList.addKeyListener(new ModelItemListKeyListener(){

            public ModelItem getModelItemAt(int ix) {
                return ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).getMockOperationAt(ix);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.operationList);
        return UISupport.buildPanelWithToolbar(this.buildMockOperationListToolbar(), scrollPane);
    }

    private JComponent buildMockOperationListToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.add(UISupport.createToolbarButton(SwingActionDelegate.createDelegate("AddNewMockOperationAction", this.getModelItem(), null, "/mockOperation.gif")));
        return toolbar;
    }

    protected JComponent buildPropertiesPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.propertiesTable = new PropertyHolderTable((TestPropertyHolder)this.getModelItem());
        panel.add((Component)this.propertiesTable, "Center");
        return panel;
    }

    protected GroovyEditorComponent buildStartScriptPanel() {
        this.startGroovyEditor = new GroovyEditorComponent(new StartScriptGroovyEditorModel(), null);
        return this.startGroovyEditor;
    }

    protected GroovyEditorComponent buildStopScriptPanel() {
        this.stopGroovyEditor = new GroovyEditorComponent(new StopScriptGroovyEditorModel(), null);
        return this.stopGroovyEditor;
    }

    protected GroovyEditorComponent buildOnRequestScriptPanel() {
        this.onRequestGroovyEditor = new GroovyEditorComponent(new OnRequestScriptGroovyEditorModel(), null);
        return this.onRequestGroovyEditor;
    }

    protected GroovyEditorComponent buildAfterRequestScriptPanel() {
        this.afterRequestGroovyEditor = new GroovyEditorComponent(new AfterRequestScriptGroovyEditorModel(), null);
        return this.afterRequestGroovyEditor;
    }

    protected JPanel buildDescriptionPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.descriptionArea = new JUndoableTextArea(((WsdlMockService)this.getModelItem()).getDescription());
        this.descriptionArea.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).setDescription(WsdlMockServiceDesktopPanel.this.descriptionArea.getText());
            }
        });
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        UISupport.addTitledBorder(panel, "MockService Description");
        panel.add((Component)new JScrollPane(this.descriptionArea), "Center");
        return panel;
    }

    protected JComponent buildLog() {
        JPanel panel = new JPanel(new BorderLayout());
        JXToolBar builder = UISupport.createToolbar();
        this.enableLogCheckBox = new JCheckBox(" ", true);
        this.enableLogCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                WsdlMockServiceDesktopPanel.this.testLogList.setEnabled(WsdlMockServiceDesktopPanel.this.enableLogCheckBox.isSelected());
                if (WsdlMockServiceDesktopPanel.this.mockRunner != null) {
                    WsdlMockServiceDesktopPanel.this.mockRunner.setLogEnabled(WsdlMockServiceDesktopPanel.this.enableLogCheckBox.isSelected());
                }
                WsdlMockServiceDesktopPanel.this.logScrollPane.repaint();
            }
        });
        this.enableLogCheckBox.setOpaque(false);
        builder.addFixed(this.enableLogCheckBox);
        builder.addRelatedGap();
        builder.addFixed(new JLabel("Enable"));
        builder.addRelatedGap();
        this.addLogActions(builder);
        builder.addGlue();
        builder.setBorder(BorderFactory.createEmptyBorder(2, 3, 3, 3));
        panel.add((Component)builder, "North");
        this.logListModel = new LogListModel();
        this.testLogList = new JList(this.logListModel);
        this.testLogList.setCellRenderer(new LogCellRenderer());
        this.testLogList.addMouseListener(new LogListMouseListener());
        this.testLogList.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.logScrollPane = new JScrollPane(this.testLogList);
        panel.add((Component)this.logScrollPane, "Center");
        return panel;
    }

    protected void addLogActions(JXToolBar builder) {
        builder.addFixed(UISupport.createToolbarButton(new ClearLogAction()));
        builder.addRelatedGap();
        builder.addFixed(UISupport.createToolbarButton(new SetLogOptionsAction()));
    }

    protected JXToolBar buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        this.runButton = WsdlMockServiceDesktopPanel.createActionButton(new RunMockServiceAction(), true);
        this.stopButton = WsdlMockServiceDesktopPanel.createActionButton(new StopMockServiceAction(), false);
        this.optionsButton = WsdlMockServiceDesktopPanel.createActionButton(SwingActionDelegate.createDelegate(new MockServiceOptionsAction(), this.getModelItem(), null, "/options.gif"), true);
        this.showWsdlButton = WsdlMockServiceDesktopPanel.createActionButton(new ShowWsdlAction(), false);
        toolbar.addFixed(this.runButton);
        toolbar.addFixed(this.stopButton);
        toolbar.addFixed(this.showWsdlButton);
        toolbar.addFixed(this.optionsButton);
        toolbar.addGlue();
        this.runInfoLabel = new JLabel("", 4);
        toolbar.addFixed(UISupport.setFixedSize(this.runInfoLabel, 200, 20));
        toolbar.addRelatedGap();
        this.progressBar = new JProgressBar();
        JPanel progressBarPanel = UISupport.createProgressBarPanel(this.progressBar, 2, false);
        progressBarPanel.setPreferredSize(new Dimension(60, 20));
        toolbar.addFixed(progressBarPanel);
        toolbar.addRelatedGap();
        toolbar.addFixed(WsdlMockServiceDesktopPanel.createActionButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/mock/services.html"), true));
        return toolbar;
    }

    public void startMockService() {
        if (this.mockRunner != null && this.mockRunner.isRunning() || SoapUI.getMockEngine().hasRunningMock((MockService)this.getModelItem())) {
            UISupport.showErrorMessage("MockService is already running");
        } else {
            if (this.mockRunner != null) {
                this.mockRunner.release();
            }
            try {
                ((WsdlMockService)this.getModelItem()).start();
            }
            catch (Exception e) {
                UISupport.showErrorMessage(e);
                return;
            }
        }
    }

    private long getDefaultMaxSize() {
        return ((WsdlMockService)this.getModelItem()).getSettings().getLong(LogListModel.class.getName() + "@maxSize", 100L);
    }

    protected long getMaxLogSize() {
        if (this.logListModel != null) {
            return this.logListModel.getMaxSize();
        }
        return this.getDefaultMaxSize();
    }

    protected void setMaxLogSize(long size) {
        this.logListModel.setMaxSize(size);
        if (this.mockRunner != null) {
            this.mockRunner.setMaxResults(this.logListModel.getMaxSize());
        }
    }

    @Override
    protected void renameModelItem() {
        SoapUI.getActionRegistry().performAction("RenameMockServiceAction", (ModelItem)this.getModelItem(), null);
    }

    @Override
    protected void cloneModelItem() {
        SoapUI.getActionRegistry().performAction("CloneMockServiceAction", (ModelItem)this.getModelItem(), null);
    }

    private class AfterRequestScriptGroovyEditorModel
    extends AbstractGroovyEditorModel {
        public AfterRequestScriptGroovyEditorModel() {
            super(new String[]{"log", "context", "mockResult", "mockRunner"}, (ModelItem)WsdlMockServiceDesktopPanel.this.getModelItem(), "AfterRequest");
        }

        public String getScript() {
            return ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).getAfterRequestScript();
        }

        public void setScript(String text) {
            ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).setAfterRequestScript(text);
        }

        public Action createRunAction() {
            return new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        WsdlMockRunContext context = WsdlMockServiceDesktopPanel.this.mockRunner == null ? new WsdlMockRunContext((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem(), null) : WsdlMockServiceDesktopPanel.this.mockRunner.getMockContext();
                        ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).runAfterRequestScript(context, WsdlMockServiceDesktopPanel.this.mockRunner, null);
                    }
                    catch (Exception e1) {
                        UISupport.showErrorMessage(e1);
                    }
                }
            };
        }
    }

    private class OnRequestScriptGroovyEditorModel
    extends AbstractGroovyEditorModel {
        public OnRequestScriptGroovyEditorModel() {
            super(new String[]{"log", "context", "mockRequest", "mockRunner"}, (ModelItem)WsdlMockServiceDesktopPanel.this.getModelItem(), "OnRequest");
        }

        public String getScript() {
            return ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).getOnRequestScript();
        }

        public void setScript(String text) {
            ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).setOnRequestScript(text);
        }

        public Action createRunAction() {
            return new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        WsdlMockRunContext context = WsdlMockServiceDesktopPanel.this.mockRunner == null ? new WsdlMockRunContext((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem(), null) : WsdlMockServiceDesktopPanel.this.mockRunner.getMockContext();
                        ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).runOnRequestScript(context, WsdlMockServiceDesktopPanel.this.mockRunner, null);
                    }
                    catch (Exception e1) {
                        UISupport.showErrorMessage(e1);
                    }
                }
            };
        }
    }

    private class StopScriptGroovyEditorModel
    extends AbstractGroovyEditorModel {
        public StopScriptGroovyEditorModel() {
            super(new String[]{"log", "context", "mockRunner"}, (ModelItem)WsdlMockServiceDesktopPanel.this.getModelItem(), "Stop");
        }

        public String getScript() {
            return ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).getStopScript();
        }

        public void setScript(String text) {
            ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).setStopScript(text);
        }

        public Action createRunAction() {
            return new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        WsdlMockRunContext context = WsdlMockServiceDesktopPanel.this.mockRunner == null ? new WsdlMockRunContext((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem(), null) : WsdlMockServiceDesktopPanel.this.mockRunner.getMockContext();
                        ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).runStopScript(context, WsdlMockServiceDesktopPanel.this.mockRunner);
                    }
                    catch (Exception e1) {
                        UISupport.showErrorMessage(e1);
                    }
                }
            };
        }
    }

    private class StartScriptGroovyEditorModel
    extends AbstractGroovyEditorModel {
        public StartScriptGroovyEditorModel() {
            super(new String[]{"log", "context", "mockRunner"}, (ModelItem)WsdlMockServiceDesktopPanel.this.getModelItem(), "Start");
        }

        public String getScript() {
            return ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).getStartScript();
        }

        public void setScript(String text) {
            ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).setStartScript(text);
        }

        public Action createRunAction() {
            return new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        WsdlMockRunContext context = WsdlMockServiceDesktopPanel.this.mockRunner == null ? new WsdlMockRunContext((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem(), null) : WsdlMockServiceDesktopPanel.this.mockRunner.getMockContext();
                        ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).runStartScript(context, WsdlMockServiceDesktopPanel.this.mockRunner);
                    }
                    catch (Exception e1) {
                        UISupport.showErrorMessage(e1);
                    }
                }
            };
        }
    }

    private final class LogListMouseListener
    extends AbstractListMouseListener {
        private LogListMouseListener() {
        }

        protected ActionList getActionsForRow(JList list, int row) {
            MockResult result = (MockResult)WsdlMockServiceDesktopPanel.this.logListModel.getElementAt(row);
            return result == null ? null : result.getActions();
        }
    }

    private class ClearLogAction
    extends AbstractAction {
        public ClearLogAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/clear_loadtest.gif"));
            this.putValue("ShortDescription", "Clears the MockService Log");
        }

        public void actionPerformed(ActionEvent e) {
            WsdlMockServiceDesktopPanel.this.logListModel.clear();
            if (WsdlMockServiceDesktopPanel.this.mockRunner != null) {
                WsdlMockServiceDesktopPanel.this.mockRunner.clearResults();
            }
        }
    }

    private class SetLogOptionsAction
    extends AbstractAction {
        public SetLogOptionsAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/options.gif"));
            this.putValue("ShortDescription", "Sets MockService Log Options");
        }

        public void actionPerformed(ActionEvent e) {
            String s = UISupport.prompt("Enter maximum number of rows for MockService Log", "Log Options", String.valueOf(WsdlMockServiceDesktopPanel.this.logListModel.getMaxSize()));
            if (s != null) {
                try {
                    long newMaxSize = Long.parseLong(s);
                    if (newMaxSize > 0L) {
                        WsdlMockServiceDesktopPanel.this.setMaxLogSize(newMaxSize);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private class LogListModel
    extends AbstractListModel {
        private List<MockResult> elements = Collections.synchronizedList(new TreeList());
        private long maxSize;

        public LogListModel() {
            this.maxSize = WsdlMockServiceDesktopPanel.this.getDefaultMaxSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElement(MockResult result) {
            this.elements.add(result);
            this.fireIntervalAdded(this, this.elements.size() - 1, this.elements.size() - 1);
            LogListModel logListModel = this;
            synchronized (logListModel) {
                while ((long)this.elements.size() > this.maxSize) {
                    this.removeElementAt(0);
                }
            }
        }

        public Object getElementAt(int index) {
            try {
                if (this.elements.size() <= index) {
                    return null;
                }
                return this.elements.get(index);
            }
            catch (Throwable t) {
                return null;
            }
        }

        public void removeElementAt(int index) {
            this.elements.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            LogListModel logListModel = this;
            synchronized (logListModel) {
                int sz = this.elements.size();
                if (sz > 0) {
                    this.elements.clear();
                    this.fireIntervalRemoved(this, 0, sz - 1);
                }
            }
        }

        public int getSize() {
            return this.elements.size();
        }

        public long getMaxSize() {
            return this.maxSize;
        }

        public synchronized void setMaxSize(long l) {
            this.maxSize = l;
            while (this.elements.size() > 0 && (long)this.elements.size() > this.maxSize) {
                this.removeElementAt(0);
            }
            ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).getSettings().setLong(LogListModel.class.getName() + "@maxSize", this.maxSize);
        }
    }

    private static final class LogCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public LogCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(String.valueOf(value));
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            return this;
        }
    }

    public class StopMockServiceAction
    extends AbstractAction {
        public StopMockServiceAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/cancel_request.gif"));
            this.putValue("ShortDescription", "Stops this MockService on the specified port and endpoint");
        }

        public void actionPerformed(ActionEvent arg0) {
            if (WsdlMockServiceDesktopPanel.this.mockRunner == null) {
                UISupport.showErrorMessage("MockService is not running");
            } else {
                WsdlMockServiceDesktopPanel.this.mockRunner.stop();
                WsdlMockServiceDesktopPanel.this.mockRunner.release();
                WsdlMockServiceDesktopPanel.this.mockRunner = null;
            }
        }
    }

    public class ShowWsdlAction
    extends AbstractAction {
        public ShowWsdlAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/interface.gif"));
            this.putValue("ShortDescription", "Opens the root WSDL page in a browser");
        }

        public void actionPerformed(ActionEvent arg0) {
            WsdlMockService mockService = (WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem();
            Tools.openURL(mockService.getLocalEndpoint() + "?WSDL");
        }
    }

    public class RunMockServiceAction
    extends AbstractAction {
        public RunMockServiceAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/submit_request.gif"));
            this.putValue("ShortDescription", "Starts this MockService on the specified port and endpoint");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("alt ENTER"));
        }

        public void actionPerformed(ActionEvent arg0) {
            WsdlMockServiceDesktopPanel.this.startMockService();
        }
    }

    private static final class OperationListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private OperationListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            MockOperation testStep = (MockOperation)value;
            this.setText(testStep.getName());
            this.setIcon(testStep.getIcon());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            return this;
        }
    }

    public class OperationListModel
    extends AbstractListModel
    implements ListModel,
    MockServiceListener,
    PropertyChangeListener {
        private List<WsdlMockOperation> operations = new ArrayList<WsdlMockOperation>();

        public OperationListModel() {
            for (int c = 0; c < ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).getMockOperationCount(); ++c) {
                WsdlMockOperation mockOperation = ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).getMockOperationAt(c);
                mockOperation.addPropertyChangeListener(this);
                this.operations.add(mockOperation);
            }
            ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).addMockServiceListener(this);
        }

        public Object getElementAt(int arg0) {
            return this.operations.get(arg0);
        }

        public int getSize() {
            return this.operations.size();
        }

        public void mockOperationAdded(MockOperation operation) {
            this.operations.add((WsdlMockOperation)operation);
            operation.addPropertyChangeListener(this);
            this.fireIntervalAdded(this, this.operations.size() - 1, this.operations.size() - 1);
        }

        public void mockOperationRemoved(MockOperation operation) {
            int ix = this.operations.indexOf(operation);
            this.operations.remove(ix);
            operation.removePropertyChangeListener(this);
            this.fireIntervalRemoved(this, ix, ix);
        }

        public void mockResponseAdded(MockResponse request) {
        }

        public void mockResponseRemoved(MockResponse request) {
        }

        public void propertyChange(PropertyChangeEvent arg0) {
            if (arg0.getPropertyName().equals(WsdlMockOperation.NAME_PROPERTY)) {
                int ix = this.operations.indexOf(arg0.getSource());
                this.fireContentsChanged(this, ix, ix);
            }
        }

        public void release() {
            for (WsdlMockOperation operation : this.operations) {
                operation.removePropertyChangeListener(this);
            }
            ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).removeMockServiceListener(this);
        }
    }

    private final class InternalMockRunListener
    extends MockRunListenerAdapter {
        private InternalMockRunListener() {
        }

        public void onMockRunnerStart(MockRunner runner) {
            WsdlMockServiceDesktopPanel.this.mockRunner = (WsdlMockRunner)runner;
            WsdlMockServiceDesktopPanel.this.mockRunner.setMaxResults(WsdlMockServiceDesktopPanel.this.logListModel.getMaxSize());
            WsdlMockServiceDesktopPanel.this.mockRunner.setLogEnabled(WsdlMockServiceDesktopPanel.this.enableLogCheckBox.isSelected());
            WsdlMockServiceDesktopPanel.this.progressBar.setIndeterminate(true);
            WsdlMockServiceDesktopPanel.this.runButton.setEnabled(false);
            WsdlMockServiceDesktopPanel.this.stopButton.setEnabled(true);
            WsdlMockServiceDesktopPanel.this.optionsButton.setEnabled(false);
            WsdlMockServiceDesktopPanel.this.showWsdlButton.setEnabled(true);
            WsdlMockServiceDesktopPanel.this.runInfoLabel.setText("running on port " + ((WsdlMockService)WsdlMockServiceDesktopPanel.this.getModelItem()).getPort());
        }

        public void onMockRunnerStop(MockRunner mockRunner) {
            WsdlMockServiceDesktopPanel.this.progressBar.setIndeterminate(false);
            WsdlMockServiceDesktopPanel.this.runButton.setEnabled(true);
            WsdlMockServiceDesktopPanel.this.stopButton.setEnabled(false);
            WsdlMockServiceDesktopPanel.this.optionsButton.setEnabled(true);
            WsdlMockServiceDesktopPanel.this.showWsdlButton.setEnabled(false);
            WsdlMockServiceDesktopPanel.this.runInfoLabel.setText("");
        }

        public void onMockResult(MockResult result) {
            if (WsdlMockServiceDesktopPanel.this.logIsEnabled()) {
                WsdlMockServiceDesktopPanel.this.logListModel.addElement(result);
            }
        }
    }
}

