/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.loadtest;

import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.assertions.LoadTestAssertionRegistry;
import com.eviware.soapui.model.testsuite.ResultContainer;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionListBuilder;
import com.eviware.soapui.support.action.swing.ActionSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class JStatisticsTable
extends JPanel {
    private final WsdlLoadTest loadTest;
    private JXTable statisticsTable;
    private JPopupMenu popup;

    public JStatisticsTable(WsdlLoadTest loadTest) {
        super(new BorderLayout());
        this.loadTest = loadTest;
        this.statisticsTable = new JXTable((TableModel)loadTest.getStatisticsModel());
        this.statisticsTable.setColumnControlVisible(true);
        this.statisticsTable.getTableHeader().setReorderingAllowed(false);
        this.statisticsTable.addMouseListener((MouseListener)new StatisticsTableMouseListener());
        TableColumnModel columnModel = this.statisticsTable.getColumnModel();
        columnModel.getColumn(0).setMaxWidth(5);
        columnModel.getColumn(0).setCellRenderer(new ColorLabelTableCellRenderer());
        columnModel.getColumn(1).setPreferredWidth(150);
        columnModel.getColumn(2).setPreferredWidth(20);
        columnModel.getColumn(3).setPreferredWidth(20);
        columnModel.getColumn(4).setPreferredWidth(20);
        columnModel.getColumn(5).setPreferredWidth(20);
        columnModel.getColumn(6).setPreferredWidth(20);
        columnModel.getColumn(7).setPreferredWidth(20);
        columnModel.getColumn(8).setPreferredWidth(20);
        columnModel.getColumn(9).setPreferredWidth(20);
        columnModel.getColumn(10).setPreferredWidth(20);
        columnModel.getColumn(11).setPreferredWidth(20);
        JScrollPane scrollPane = new JScrollPane((Component)this.statisticsTable);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.add((Component)scrollPane, "Center");
        JMenu assertionsMenu = new JMenu("Add Assertion");
        for (String assertion : LoadTestAssertionRegistry.getAvailableAssertions()) {
            assertionsMenu.add(new AddAssertionAction(assertion));
        }
        this.popup = new JPopupMenu();
        this.popup.add(assertionsMenu);
        this.popup.setInvoker((Component)this.statisticsTable);
    }

    public void release() {
        this.loadTest.getStatisticsModel().removeTableModelListener((TableModelListener)this.statisticsTable);
    }

    public void showPopup(MouseEvent e) {
        int row = this.statisticsTable.rowAtPoint(e.getPoint());
        if (row == -1) {
            return;
        }
        if (this.statisticsTable.getSelectedRow() != row) {
            this.statisticsTable.getSelectionModel().setSelectionInterval(row, row);
        }
        row = this.statisticsTable.convertRowIndexToModel(row);
        while (this.popup.getComponentCount() > 1) {
            this.popup.remove(1);
        }
        if (row < this.statisticsTable.getRowCount() - 1) {
            TestStep testStep = this.loadTest.getStatisticsModel().getTestStepAtRow(row);
            ActionSupport.addActions(ActionListBuilder.buildActions(testStep), this.popup);
        }
        this.popup.setLocation((int)(this.statisticsTable.getLocationOnScreen().getX() + e.getPoint().getX()), (int)(this.statisticsTable.getLocationOnScreen().getY() + e.getPoint().getY()));
        this.popup.setVisible(true);
    }

    private class AddAssertionAction
    extends AbstractAction {
        private final String type;

        public AddAssertionAction(String type) {
            super(type);
            this.type = type;
        }

        public void actionPerformed(ActionEvent e) {
            int row = JStatisticsTable.this.statisticsTable.getSelectedRow();
            if (row == -1) {
                return;
            }
            String target = "- Any -";
            row = JStatisticsTable.this.statisticsTable.convertRowIndexToModel(row);
            if (row == JStatisticsTable.this.statisticsTable.getRowCount() - 1) {
                target = "- Total -";
            } else if (row >= 0) {
                target = JStatisticsTable.this.loadTest.getTestCase().getTestStepAt(row).getName();
            }
            JStatisticsTable.this.loadTest.addAssertion(this.type, target, true);
        }
    }

    private static final class ColorLabelTableCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private Color bgColor = this.getBackground();

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Color) {
                this.setBackground((Color)value);
            } else {
                this.setBackground(this.bgColor);
            }
            return this;
        }
    }

    private final class StatisticsTableMouseListener
    extends MouseAdapter {
        private StatisticsTableMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (JStatisticsTable.this.statisticsTable.getSelectedColumn() == 1 && e.getClickCount() > 1) {
                int row = JStatisticsTable.this.statisticsTable.getSelectedRow();
                if (row < 0) {
                    return;
                }
                row = JStatisticsTable.this.statisticsTable.convertRowIndexToModel(row);
                ResultContainer modelItem = row == JStatisticsTable.this.statisticsTable.getRowCount() - 1 ? JStatisticsTable.this.loadTest.getTestCase() : JStatisticsTable.this.loadTest.getStatisticsModel().getTestStepAtRow(row);
                ActionList actions = ActionListBuilder.buildActions(modelItem);
                if (actions != null) {
                    actions.performDefaultAction(new ActionEvent(JStatisticsTable.this.statisticsTable, 0, null));
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JStatisticsTable.this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JStatisticsTable.this.showPopup(e);
            }
        }
    }
}

