/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.monitor;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.monitor.MonitorMessageExchangeDataSource;
import com.eviware.soapui.impl.wsdl.monitor.WsdlMonitorMessageExchange;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.MultipartMessageSupport;
import com.eviware.soapui.impl.wsdl.support.soap.SoapUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wss.IncomingWss;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.propertyexpansion.DefaultPropertyExpansionContext;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.types.StringToStringsMap;
import com.eviware.soapui.support.uri.HttpParser;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import org.apache.http.Header;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpMonWsdlMonitorMessageExchange
extends WsdlMonitorMessageExchange {
    private URL targetUrl;
    private StringToStringsMap responseHeaders;
    private long timeTaken;
    private long timestamp;
    private StringToStringsMap requestHeaders;
    private String requestContent;
    private String responseContent;
    private int responseContentLength;
    private int requestContentLength;
    private String requestHost;
    private WsdlProject project;
    private WsdlOperation operation;
    private byte[] capturedRequestData;
    private byte[] capturedResponseData;
    private String responseContentType;
    private MultipartMessageSupport responseMmSupport;
    private static final String HTTP_ELEMENT_CHARSET = "US-ASCII";
    private SoapVersion soapVersion;
    private MultipartMessageSupport requestMmSupport;
    private String requestContentType;
    private boolean discarded;
    private Vector requestWssResult;
    private Vector responseWssResult;

    public TcpMonWsdlMonitorMessageExchange(WsdlProject project) {
        super(null);
        this.project = project;
        this.responseHeaders = new StringToStringsMap();
        this.requestHeaders = new StringToStringsMap();
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public String getEndpoint() {
        return this.targetUrl == null ? null : this.targetUrl.toString();
    }

    @Override
    public WsdlOperation getOperation() {
        return this.operation;
    }

    @Override
    public Response getResponse() {
        return null;
    }

    @Override
    public Operation getModelItem() {
        return this.operation;
    }

    @Override
    public Attachment[] getRequestAttachments() {
        return this.requestMmSupport == null ? new Attachment[]{} : this.requestMmSupport.getAttachments();
    }

    @Override
    public String getRequestContent() {
        return this.requestMmSupport == null ? this.requestContent : this.requestMmSupport.getContentAsString();
    }

    @Override
    public StringToStringsMap getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public Attachment[] getResponseAttachments() {
        return this.responseMmSupport == null ? new Attachment[]{} : this.responseMmSupport.getAttachments();
    }

    @Override
    public String getResponseContent() {
        return this.responseMmSupport == null ? this.responseContent : this.responseMmSupport.getContentAsString();
    }

    @Override
    public StringToStringsMap getResponseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public long getTimeTaken() {
        return this.timeTaken;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTargetUrl(URL targetHost) {
        this.targetUrl = targetHost;
    }

    public boolean isActive() {
        return false;
    }

    @Override
    public long getRequestContentLength() {
        return this.requestContentLength;
    }

    @Override
    public long getResponseContentLength() {
        return this.responseContentLength;
    }

    @Override
    public String getRequestHost() {
        return this.requestHost;
    }

    @Override
    public URL getTargetUrl() {
        return this.targetUrl;
    }

    @Override
    public byte[] getRawRequestData() {
        return this.capturedRequestData;
    }

    @Override
    public byte[] getRawResponseData() {
        return this.capturedResponseData;
    }

    @Override
    public boolean hasRawData() {
        return true;
    }

    public void finish(byte[] capturedRequestData, byte[] capturedResponseData) {
        this.capturedRequestData = capturedRequestData;
        this.capturedResponseData = capturedResponseData;
        if (this.timeTaken == 0L) {
            this.timeTaken = System.currentTimeMillis() - this.timestamp;
        }
    }

    @Override
    public void prepare(IncomingWss requestWss, IncomingWss responseWss) {
        this.parseRequestData(this.capturedRequestData, requestWss);
        this.parseReponseData(this.capturedResponseData, responseWss);
    }

    private void parseReponseData(byte[] capturedResponseData, IncomingWss responseWss) {
        this.responseContentLength = capturedResponseData.length;
        ByteArrayInputStream in = new ByteArrayInputStream(capturedResponseData);
        try {
            String line = null;
            while ((line = HttpParser.readLine(in, HTTP_ELEMENT_CHARSET)) != null && line.length() == 0) {
            }
            if (line == null) {
                throw new Exception("Missing request status line");
            }
            Header[] headers = HttpParser.parseHeaders(in, HTTP_ELEMENT_CHARSET);
            if (headers != null) {
                for (Header header : headers) {
                    this.responseHeaders.put(header.getName(), header.getValue());
                }
            }
            this.responseContentType = this.responseHeaders.get("Content-Type", "");
            if (this.responseContentType != null && this.responseContentType.toUpperCase().startsWith("MULTIPART")) {
                StringToStringMap values = StringToStringMap.fromHttpHeader(this.responseContentType);
                this.responseMmSupport = new MultipartMessageSupport(new MonitorMessageExchangeDataSource("monitor response", in, this.responseContentType), (String)values.get("start"), null, true, SoapUI.getSettings().getBoolean(WsdlSettings.PRETTY_PRINT_RESPONSE_MESSAGES));
                this.responseContentType = this.responseMmSupport.getRootPart().getContentType();
            } else {
                this.responseContent = XmlUtils.prettyPrintXml(Tools.readAll(in, 0L).toString());
            }
            this.processResponseWss(responseWss);
        }
        catch (Exception e) {
            try {
                in.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void processResponseWss(IncomingWss responseWss) throws IOException {
        if (responseWss != null) {
            Document dom = XmlUtils.parseXml(this.responseContent);
            try {
                this.responseWssResult = responseWss.processIncoming(dom, new DefaultPropertyExpansionContext(this.project));
                if (this.responseWssResult != null && this.responseWssResult.size() > 0) {
                    StringWriter writer = new StringWriter();
                    XmlUtils.serialize(dom, (Writer)writer);
                    this.responseContent = writer.toString();
                }
            }
            catch (Exception e) {
                if (this.responseWssResult == null) {
                    this.responseWssResult = new Vector();
                }
                this.responseWssResult.add(e);
            }
        }
    }

    private void parseRequestData(byte[] capturedRequestData, IncomingWss requestWss) {
        this.requestContentLength = capturedRequestData.length;
        ByteArrayInputStream in = new ByteArrayInputStream(capturedRequestData);
        try {
            String line = null;
            while ((line = HttpParser.readLine(in, HTTP_ELEMENT_CHARSET)) != null && line.length() == 0) {
            }
            if (line == null) {
                throw new Exception("Missing request status line");
            }
            Header[] headers = HttpParser.parseHeaders(in, HTTP_ELEMENT_CHARSET);
            if (headers != null) {
                for (Header header : headers) {
                    this.requestHeaders.put(header.getName(), header.getValue());
                }
            }
            this.requestContentType = this.requestHeaders.get("Content-Type", "");
            if (this.requestContentType != null && this.requestContentType.toUpperCase().startsWith("MULTIPART")) {
                StringToStringMap values = StringToStringMap.fromHttpHeader(this.requestContentType);
                this.requestMmSupport = new MultipartMessageSupport(new MonitorMessageExchangeDataSource("monitor request", in, this.requestContentType), (String)values.get("start"), null, true, SoapUI.getSettings().getBoolean(WsdlSettings.PRETTY_PRINT_RESPONSE_MESSAGES));
                this.requestContentType = this.requestMmSupport.getRootPart().getContentType();
            } else {
                this.requestContent = XmlUtils.prettyPrintXml(Tools.readAll(in, 0L).toString());
            }
            this.processRequestWss(requestWss);
            this.operation = this.findOperation();
        }
        catch (Exception e) {
            try {
                in.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void processRequestWss(IncomingWss requestWss) throws IOException {
        if (requestWss != null) {
            Document dom = XmlUtils.parseXml(this.requestContent);
            try {
                this.requestWssResult = requestWss.processIncoming(dom, new DefaultPropertyExpansionContext(this.project));
                if (this.requestWssResult != null && this.requestWssResult.size() > 0) {
                    StringWriter writer = new StringWriter();
                    XmlUtils.serialize(dom, (Writer)writer);
                    this.requestContent = writer.toString();
                }
            }
            catch (Exception e) {
                if (this.requestWssResult == null) {
                    this.requestWssResult = new Vector();
                }
                this.requestWssResult.add(e);
            }
        }
    }

    private WsdlOperation findOperation() throws Exception {
        this.soapVersion = SoapUtils.deduceSoapVersion(this.requestContentType, this.getRequestContent());
        if (this.soapVersion == null) {
            throw new Exception("Unrecognized SOAP Version");
        }
        String soapAction = SoapUtils.getSoapAction(this.soapVersion, this.requestHeaders);
        ArrayList<WsdlOperation> operations = new ArrayList<WsdlOperation>();
        for (WsdlInterface iface : ModelSupport.getChildren(this.project, WsdlInterface.class)) {
            for (Operation operation : iface.getOperationList()) {
                operations.add((WsdlOperation)operation);
            }
        }
        return SoapUtils.findOperationForRequest(this.soapVersion, soapAction, XmlUtils.createXmlObject(this.getRequestContent()), operations, true, false, this.getRequestAttachments());
    }

    public void setRequestHost(String requestHost) {
        this.requestHost = requestHost;
    }

    @Override
    public SoapVersion getSoapVersion() {
        if (this.soapVersion == null) {
            this.soapVersion = SoapUtils.deduceSoapVersion(this.requestHeaders.get("Content-Type", ""), this.getRequestContent());
        }
        return this.soapVersion;
    }

    public void setTimeTaken(long timeTaken) {
        this.timeTaken = timeTaken;
    }

    @Override
    public void discard() {
        this.operation = null;
        this.project = null;
        this.requestContent = null;
        this.requestHeaders = null;
        this.responseContent = null;
        this.responseHeaders = null;
        this.requestMmSupport = null;
        this.discarded = true;
    }

    @Override
    public boolean isDiscarded() {
        return this.discarded;
    }

    public Vector getRequestWssResult() {
        return this.requestWssResult;
    }

    public Vector getResponseWssResult() {
        return this.responseWssResult;
    }

    @Override
    public int getResponseStatusCode() {
        return 0;
    }

    @Override
    public String getResponseContentType() {
        return null;
    }

    @Override
    public String getRequestMethod() {
        return null;
    }

    @Override
    public Map<String, String> getHttpRequestParameters() {
        return null;
    }
}

