/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.monitor;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.monitor.Connection;
import com.eviware.soapui.impl.wsdl.monitor.SlowLinkSimulator;
import com.eviware.soapui.impl.wsdl.monitor.SoapMonitor;
import java.net.ServerSocket;
import java.net.Socket;

class SocketWaiter
extends Thread {
    ServerSocket sSocket = null;
    SoapMonitor listener;
    int port;
    boolean pleaseStop = false;
    private SlowLinkSimulator slowLink;

    public SocketWaiter(String name, SoapMonitor l, int p) {
        super(name);
        this.listener = l;
        this.port = p;
        this.slowLink = new SlowLinkSimulator(0, 0);
        this.start();
    }

    public void run() {
        try {
            this.sSocket = new ServerSocket(this.port);
            while (true) {
                Socket inSocket = this.sSocket.accept();
                if (!this.pleaseStop) {
                    new Connection(this.getName() + " connection from " + inSocket.getRemoteSocketAddress(), this.listener, inSocket, this.slowLink);
                    inSocket = null;
                    continue;
                }
                break;
            }
        }
        catch (Exception exp) {
            if (!"socket closed".equals(exp.getMessage())) {
                this.listener.stop();
            }
            SoapUI.log.info((Object)("Error stopping SocketWaiter: " + exp.toString()));
        }
    }

    public void halt() {
        try {
            this.pleaseStop = true;
            new Socket("127.0.0.1", this.port);
            if (this.sSocket != null) {
                this.sSocket.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

