/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.monitor;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.monitor.CaptureInputStream;
import com.eviware.soapui.impl.wsdl.monitor.SlowLinkSimulator;
import com.eviware.soapui.impl.wsdl.monitor.SoapMonitor;
import com.eviware.soapui.impl.wsdl.monitor.SocketRR;
import com.eviware.soapui.impl.wsdl.monitor.TcpMonWsdlMonitorMessageExchange;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.net.URL;

class Connection
extends Thread {
    private SoapMonitor monitor;
    private boolean active;
    private Socket inSocket = null;
    private Socket outSocket = null;
    private SocketRR rr1 = null;
    private SocketRR rr2 = null;
    private InputStream inputStream = null;
    private String httpProxyHost = null;
    private int httpProxyPort = 80;
    private SlowLinkSimulator slowLink;

    public Connection(String name, SoapMonitor l, SlowLinkSimulator slowLink) {
        super(name);
        this.monitor = l;
        this.httpProxyHost = l.getHttpProxyHost();
        this.httpProxyPort = l.getHttpProxyPort();
        this.slowLink = slowLink;
    }

    public Connection(String name, SoapMonitor l, Socket s, SlowLinkSimulator slowLink) {
        this(name, l, slowLink);
        this.inSocket = s;
        this.start();
    }

    public Connection(String name, SoapMonitor l, InputStream in, SlowLinkSimulator slowLink) {
        this(name, l, slowLink);
        this.inputStream = in;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.setContextClassLoader(SoapUI.getSoapUICore().getExtensionClassLoader());
        try {
            URL targetUrl;
            this.active = true;
            this.httpProxyHost = System.getProperty("http.proxyHost");
            if (this.httpProxyHost != null && this.httpProxyHost.equals("")) {
                this.httpProxyHost = null;
            }
            if (this.httpProxyHost != null) {
                String tmp = System.getProperty("http.proxyPort");
                if (tmp != null && tmp.equals("")) {
                    tmp = null;
                }
                this.httpProxyPort = tmp == null ? 80 : Integer.parseInt(tmp);
            }
            String fromHost = "";
            if (this.inSocket != null) {
                fromHost = this.inSocket.getInetAddress().getHostName();
            }
            String targetHost = this.monitor.getTargetHost();
            int targetPort = this.monitor.getTargetPort();
            int listenPort = this.monitor.getLocalPort();
            InputStream tmpIn1 = this.inputStream;
            OutputStream tmpOut1 = null;
            InputStream tmpIn2 = null;
            OutputStream tmpOut2 = null;
            if (tmpIn1 == null) {
                tmpIn1 = this.inSocket.getInputStream();
            }
            if (this.inSocket != null) {
                tmpOut1 = this.inSocket.getOutputStream();
            }
            CaptureInputStream requestCapture = new CaptureInputStream(tmpIn1);
            tmpIn1 = requestCapture;
            String bufferedData = null;
            StringBuffer buf = null;
            TcpMonWsdlMonitorMessageExchange exchange = new TcpMonWsdlMonitorMessageExchange(this.monitor.getProject());
            exchange.setRequestHost(fromHost);
            boolean isProxy = true;
            URL uRL = targetUrl = isProxy ? null : new URL(this.monitor.getTargetEndpoint());
            if (isProxy || this.httpProxyHost != null) {
                int len;
                byte[] b = new byte[1];
                buf = new StringBuffer();
                while ((len = tmpIn1.read(b, 0, 1)) != -1) {
                    String s = new String(b);
                    buf.append(s);
                    if (b[0] != 10) continue;
                }
                bufferedData = buf.toString();
                if (bufferedData.startsWith("GET ") || bufferedData.startsWith("POST ") || bufferedData.startsWith("PUT ") || bufferedData.startsWith("DELETE ")) {
                    int start = bufferedData.indexOf(32) + 1;
                    while (bufferedData.charAt(start) == ' ') {
                        ++start;
                    }
                    int end2 = bufferedData.indexOf(32, start);
                    String urlString = bufferedData.substring(start, end2);
                    if (urlString.charAt(0) == '/') {
                        urlString = urlString.substring(1);
                    }
                    if (isProxy) {
                        targetUrl = new URL(urlString);
                        targetHost = targetUrl.getHost();
                        targetPort = targetUrl.getPort();
                        if (targetPort == -1) {
                            targetPort = 80;
                        }
                        bufferedData = bufferedData.substring(0, start) + targetUrl.getFile() + bufferedData.substring(end2);
                        bufferedData = bufferedData + "Connection: close\r\n";
                    } else {
                        targetUrl = new URL("http://" + targetHost + ":" + targetPort + "/" + urlString);
                        bufferedData = bufferedData.substring(0, start) + targetUrl.toExternalForm() + bufferedData.substring(end2);
                        targetHost = this.httpProxyHost;
                        targetPort = this.httpProxyPort;
                    }
                }
            } else {
                int len;
                byte[] b1 = new byte[1];
                buf = new StringBuffer();
                String lastLine = null;
                while ((len = tmpIn1.read(b1, 0, 1)) != -1) {
                    String s1 = new String(b1);
                    buf.append(s1);
                    if (b1[0] != 10) continue;
                    String line = buf.toString();
                    buf.setLength(0);
                    if (line.startsWith("Host: ")) {
                        String newHost = "Host: " + targetHost + ":" + listenPort + "\r\n";
                        bufferedData = bufferedData.concat(newHost);
                        bufferedData = bufferedData + "Connection: close\r\n";
                        break;
                    }
                    if (line.equals("\r\n") || "\n".equals(lastLine) && line.equals("\n")) {
                        bufferedData = bufferedData + "Connection: close" + line;
                        break;
                    }
                    bufferedData = bufferedData == null ? line : bufferedData.concat(line);
                    lastLine = line;
                }
            }
            if (targetPort == -1) {
                targetPort = 80;
            }
            exchange.setTargetUrl(targetUrl);
            this.outSocket = new Socket(targetHost, targetPort);
            tmpIn2 = this.outSocket.getInputStream();
            CaptureInputStream responseCapture = new CaptureInputStream(tmpIn2);
            tmpIn2 = responseCapture;
            tmpOut2 = this.outSocket.getOutputStream();
            if (bufferedData != null) {
                byte[] b = bufferedData.getBytes();
                tmpOut2.write(b);
                this.slowLink.pump(b.length);
            }
            this.rr1 = new SocketRR(this.getName() + " to endpoint", this, this.inSocket, tmpIn1, this.outSocket, tmpOut2, this.slowLink);
            SlowLinkSimulator responseLink = new SlowLinkSimulator(this.slowLink);
            this.rr2 = new SocketRR(this.getName() + " from endpoint", this, this.outSocket, tmpIn2, this.inSocket, tmpOut1, responseLink);
            while (this.rr1 != null || this.rr2 != null) {
                if (this.rr2 != null) {
                    exchange.setTimeTaken(this.rr2.getElapsed());
                }
                if (null != this.rr1 && this.rr1.isDone()) {
                    this.rr1 = null;
                }
                if (null != this.rr2 && this.rr2.isDone()) {
                    this.rr2 = null;
                }
                Connection connection = this;
                synchronized (connection) {
                    this.wait(10L);
                }
            }
            this.active = false;
            exchange.finish(requestCapture.getCapturedData(), responseCapture.getCapturedData());
            this.monitor.addMessageExchange(exchange);
        }
        catch (Exception e) {
            StringWriter st = new StringWriter();
            PrintWriter wr = new PrintWriter(st);
            e.printStackTrace(wr);
            wr.close();
            this.halt();
        }
    }

    protected boolean isActive() {
        return this.active;
    }

    synchronized void wakeUp() {
        this.notifyAll();
    }

    public void halt() {
        try {
            if (this.rr1 != null) {
                this.rr1.halt();
            }
            if (this.rr2 != null) {
                this.rr2.halt();
            }
            if (this.inSocket != null) {
                this.inSocket.close();
            }
            this.inSocket = null;
            if (this.outSocket != null) {
                this.outSocket.close();
            }
            this.outSocket = null;
        }
        catch (Exception e) {
            SoapUI.log.info((Object)("Error halting connection: " + e.toString()));
        }
    }

    public void remove() {
        try {
            this.halt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

