/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock.dispatch;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.impl.wsdl.mock.dispatch.AbstractMockOperationDispatcher;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatchFactory;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatcher;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditor;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditorModel;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class XPathMockOperationDispatcher
extends AbstractMockOperationDispatcher {
    private GroovyEditor xpathEditor;

    public XPathMockOperationDispatcher(WsdlMockOperation mockOperation) {
        super(mockOperation);
    }

    public WsdlMockResponse selectMockResponse(WsdlMockRequest request, WsdlMockResult result) throws DispatchException {
        String[] values;
        XmlObject xmlObject;
        try {
            xmlObject = request.getRequestXmlObject();
        }
        catch (XmlException e) {
            throw new DispatchException("Error getting XmlObject for request: " + (Object)((Object)e));
        }
        String path = this.getMockOperation().getDispatchPath();
        if (StringUtils.isNullOrEmpty(path)) {
            throw new DispatchException("Missing dispatch XPath expression");
        }
        for (String value : values = XmlUtils.selectNodeValues(xmlObject, path)) {
            WsdlMockResponse mockResponse = this.getMockOperation().getMockResponseByName(value);
            if (mockResponse == null) continue;
            return mockResponse;
        }
        return null;
    }

    public JComponent getEditorComponent() {
        JPanel xpathEditorPanel = new JPanel(new BorderLayout());
        DispatchXPathGroovyEditorModel editorModel = new DispatchXPathGroovyEditorModel();
        this.xpathEditor = new GroovyEditor(editorModel);
        xpathEditorPanel.add((Component)this.xpathEditor, "Center");
        xpathEditorPanel.add((Component)this.buildXPathEditorToolbar(editorModel), "First");
        return xpathEditorPanel;
    }

    public GroovyEditor getXPathEditor() {
        return this.xpathEditor;
    }

    public void release() {
        this.releaseEditorComponent();
        super.release();
    }

    public void releaseEditorComponent() {
        if (this.xpathEditor != null) {
            this.xpathEditor.release();
        }
        super.releaseEditorComponent();
    }

    protected JXToolBar buildXPathEditorToolbar(DispatchXPathGroovyEditorModel editorModel) {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addSpace(3);
        this.addToolbarActions(editorModel, toolbar);
        toolbar.addGlue();
        toolbar.addFixed(ModelItemDesktopPanel.createActionButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/mock/operations.html#XPath_Dispatching"), true));
        return toolbar;
    }

    protected void addToolbarActions(DispatchXPathGroovyEditorModel editorModel, JXToolBar toolbar) {
        toolbar.addFixed(UISupport.createToolbarButton(editorModel.getRunAction()));
    }

    private class RunXPathAction
    extends AbstractAction {
        public RunXPathAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run_groovy_script.gif"));
            this.putValue("ShortDescription", "Evaluates this xpath expression against the latest request");
        }

        public void actionPerformed(ActionEvent e) {
            WsdlMockResult lastMockResult = XPathMockOperationDispatcher.this.getMockOperation().getLastMockResult();
            if (lastMockResult == null) {
                UISupport.showErrorMessage("Missing last request to select from");
                return;
            }
            try {
                WsdlMockResponse retVal = XPathMockOperationDispatcher.this.selectMockResponse(lastMockResult.getMockRequest(), null);
                UISupport.showInfoMessage("XPath Selection returned [" + (retVal == null ? "null" : retVal.getName()) + "]");
            }
            catch (Exception e1) {
                SoapUI.logError(e1);
            }
        }
    }

    public class DispatchXPathGroovyEditorModel
    implements GroovyEditorModel {
        private RunXPathAction runXPathAction;

        public DispatchXPathGroovyEditorModel() {
            this.runXPathAction = new RunXPathAction();
        }

        public String[] getKeywords() {
            return new String[]{"define", "namespace"};
        }

        public Action getRunAction() {
            return this.runXPathAction;
        }

        public String getScript() {
            return XPathMockOperationDispatcher.this.getMockOperation().getDispatchPath();
        }

        public Settings getSettings() {
            return XPathMockOperationDispatcher.this.getMockOperation().getSettings();
        }

        public void setScript(String text) {
            XPathMockOperationDispatcher.this.getMockOperation().setDispatchPath(text);
        }

        public String getScriptName() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        public ModelItem getModelItem() {
            return XPathMockOperationDispatcher.this.getMockOperation();
        }
    }

    public static class Factory
    implements MockOperationDispatchFactory {
        public MockOperationDispatcher build(WsdlMockOperation mockOperation) {
            return new XPathMockOperationDispatcher(mockOperation);
        }
    }
}

