/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock.dispatch;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunner;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.mock.dispatch.AbstractMockOperationDispatcher;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatchFactory;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatcher;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditor;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditorModel;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.scripting.ScriptEnginePool;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ScriptMockOperationDispatcher
extends AbstractMockOperationDispatcher
implements PropertyChangeListener {
    private ScriptEnginePool scriptEnginePool;
    private GroovyEditor groovyEditor;
    private JPanel groovyEditorPanel;

    public ScriptMockOperationDispatcher(WsdlMockOperation mockOperation) {
        super(mockOperation);
        this.scriptEnginePool = new ScriptEnginePool(mockOperation);
        this.scriptEnginePool.setScript(mockOperation.getDispatchPath());
        mockOperation.addPropertyChangeListener(WsdlMockOperation.DISPATCH_PATH_PROPERTY, this);
    }

    public WsdlMockResponse selectMockResponse(WsdlMockRequest request, WsdlMockResult result) throws DispatchException {
        String dispatchScript = this.getMockOperation().getDispatchPath();
        if (StringUtils.hasContent(dispatchScript)) {
            SoapUIScriptEngine scriptEngine = this.scriptEnginePool.getScriptEngine();
            try {
                WsdlMockService mockService = this.getMockOperation().getMockService();
                WsdlMockRunner mockRunner = mockService.getMockRunner();
                WsdlMockRunContext context = mockRunner == null ? new WsdlMockRunContext(mockService, null) : mockRunner.getMockContext();
                scriptEngine.setVariable("context", context);
                scriptEngine.setVariable("requestContext", request == null ? null : request.getRequestContext());
                scriptEngine.setVariable("mockRequest", request);
                scriptEngine.setVariable("mockOperation", this.getMockOperation());
                scriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
                scriptEngine.setScript(dispatchScript);
                Object retVal = scriptEngine.run();
                WsdlMockResponse wsdlMockResponse = this.getMockOperation().getMockResponseByName(String.valueOf(retVal));
                Object var11_11 = null;
                this.scriptEnginePool.returnScriptEngine(scriptEngine);
                return wsdlMockResponse;
            }
            catch (Throwable e) {
                try {
                    SoapUI.logError(e);
                    throw new DispatchException("Failed to dispatch using script; " + e);
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    this.scriptEnginePool.returnScriptEngine(scriptEngine);
                    throw throwable;
                }
            }
        }
        return null;
    }

    public void release() {
        this.scriptEnginePool.release();
        this.releaseEditorComponent();
        this.getMockOperation().removePropertyChangeListener(WsdlMockOperation.DISPATCH_PATH_PROPERTY, this);
        super.release();
    }

    public JComponent getEditorComponent() {
        if (this.groovyEditorPanel == null) {
            this.groovyEditorPanel = new JPanel(new BorderLayout());
            DispatchScriptGroovyEditorModel editorModel = new DispatchScriptGroovyEditorModel();
            this.groovyEditor = (GroovyEditor)UISupport.getEditorFactory().buildGroovyEditor(editorModel);
            this.groovyEditorPanel.add((Component)this.groovyEditor, "Center");
            this.groovyEditorPanel.add((Component)this.buildGroovyEditorToolbar(editorModel), "First");
        }
        return this.groovyEditorPanel;
    }

    public void releaseEditorComponent() {
        if (this.groovyEditor != null) {
            this.groovyEditor.release();
        }
        this.groovyEditor = null;
        this.groovyEditorPanel = null;
        super.releaseEditorComponent();
    }

    protected JXToolBar buildGroovyEditorToolbar(DispatchScriptGroovyEditorModel editorModel) {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addSpace(3);
        toolbar.addFixed(UISupport.createToolbarButton(editorModel.getRunAction()));
        toolbar.addGlue();
        JLabel label = new JLabel("<html>Script is invoked with <code>log</code>, <code>context</code>, <code>requestContext</code>, <code>mockRequest</code> and <code>mockOperation</code> variables</html>");
        label.setToolTipText(label.getText());
        label.setMaximumSize(label.getPreferredSize());
        toolbar.add(label);
        toolbar.addFixed(ModelItemDesktopPanel.createActionButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/mock/operations.html#Groovy_Script_Dispatching"), true));
        return toolbar;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.scriptEnginePool.setScript(String.valueOf(evt.getNewValue()));
    }

    private class RunScriptAction
    extends AbstractAction {
        public RunScriptAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run_groovy_script.gif"));
            this.putValue("ShortDescription", "Runs this script using a mockRequest and context");
        }

        public void actionPerformed(ActionEvent e) {
            WsdlMockResult lastMockResult = ScriptMockOperationDispatcher.this.getMockOperation().getLastMockResult();
            WsdlMockRequest mockRequest = lastMockResult == null ? null : lastMockResult.getMockRequest();
            try {
                WsdlMockResponse retVal = ScriptMockOperationDispatcher.this.selectMockResponse(mockRequest, null);
                UISupport.showInfoMessage("Script returned [" + (retVal == null ? "null" : retVal.getName()) + "]");
            }
            catch (Exception e1) {
                UISupport.showErrorMessage(e1);
            }
        }
    }

    public class DispatchScriptGroovyEditorModel
    implements GroovyEditorModel {
        private RunScriptAction runScriptAction;

        public DispatchScriptGroovyEditorModel() {
            this.runScriptAction = new RunScriptAction();
        }

        public String[] getKeywords() {
            return new String[]{"mockRequest", "context", "requestContext", "log", "mockOperation"};
        }

        public Action getRunAction() {
            return this.runScriptAction;
        }

        public String getScript() {
            return ScriptMockOperationDispatcher.this.getMockOperation().getDispatchPath();
        }

        public Settings getSettings() {
            return ScriptMockOperationDispatcher.this.getMockOperation().getSettings();
        }

        public void setScript(String text) {
            ScriptMockOperationDispatcher.this.getMockOperation().setDispatchPath(text);
        }

        public String getScriptName() {
            return "Dispatch";
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        public ModelItem getModelItem() {
            return ScriptMockOperationDispatcher.this.getMockOperation();
        }
    }

    public static class Factory
    implements MockOperationDispatchFactory {
        public MockOperationDispatcher build(WsdlMockOperation mockOperation) {
            return new ScriptMockOperationDispatcher(mockOperation);
        }
    }
}

