/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.MockOperationConfig;
import com.eviware.soapui.config.MockOperationDocumentConfig;
import com.eviware.soapui.config.MockServiceConfig;
import com.eviware.soapui.config.TestCaseConfig;
import com.eviware.soapui.impl.wsdl.AbstractTestPropertyHolderWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunner;
import com.eviware.soapui.impl.wsdl.support.ExternalDependency;
import com.eviware.soapui.impl.wsdl.support.MockServiceExternalDependency;
import com.eviware.soapui.impl.wsdl.support.ModelItemIconAnimator;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.BeanPathPropertySupport;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.mock.MockRunListener;
import com.eviware.soapui.model.mock.MockRunner;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.mock.MockServiceListener;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.settings.SSLSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import com.eviware.soapui.support.resolver.ResolveDialog;
import com.eviware.soapui.support.scripting.ScriptEnginePool;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineRegistry;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.ImageIcon;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlMockService
extends AbstractTestPropertyHolderWsdlModelItem<MockServiceConfig>
implements MockService {
    private static final String REQUIRE_SOAP_VERSION = WsdlMockService.class.getName() + "@require-soap-version";
    private static final String REQUIRE_SOAP_ACTION = WsdlMockService.class.getName() + "@require-soap-action";
    public static final String START_SCRIPT_PROPERTY = WsdlMockService.class.getName() + "@startScript";
    public static final String STOP_SCRIPT_PROPERTY = WsdlMockService.class.getName() + "@stopScript";
    public static final String INCOMING_WSS = WsdlMockService.class.getName() + "@incoming-wss";
    public static final String OUGOING_WSS = WsdlMockService.class.getName() + "@outgoing-wss";
    private List<WsdlMockOperation> mockOperations = new ArrayList<WsdlMockOperation>();
    private Set<MockRunListener> mockRunListeners = new HashSet<MockRunListener>();
    private Set<MockServiceListener> mockServiceListeners = new HashSet<MockServiceListener>();
    private MockServiceIconAnimator iconAnimator;
    private WsdlMockRunner mockRunner;
    private SoapUIScriptEngine startScriptEngine;
    private SoapUIScriptEngine stopScriptEngine;
    private BeanPathPropertySupport docrootProperty;
    private ScriptEnginePool onRequestScriptEnginePool;
    private ScriptEnginePool afterRequestScriptEnginePool;
    private WsdlMockOperation faultMockOperation;
    private String mockServiceEndpoint;

    public WsdlMockService(Project project, MockServiceConfig config) {
        super(config, project, "/mockService.gif");
        List testStepConfigs = config.getMockOperationList();
        for (MockOperationConfig tsc : testStepConfigs) {
            WsdlMockOperation testStep = new WsdlMockOperation(this, tsc);
            this.mockOperations.add(testStep);
        }
        if (!config.isSetPort() || config.getPort() < 1) {
            config.setPort(8080);
        }
        if (!config.isSetPath()) {
            config.setPath("/");
        }
        if (!this.getSettings().isSet(REQUIRE_SOAP_ACTION)) {
            this.setRequireSoapAction(false);
        }
        try {
            if (!config.isSetHost() || !StringUtils.hasContent(config.getHost())) {
                config.setHost(InetAddress.getLocalHost().getHostName());
            }
        }
        catch (UnknownHostException e) {
            SoapUI.logError(e);
        }
        this.iconAnimator = new MockServiceIconAnimator();
        this.addMockRunListener(this.iconAnimator);
        for (MockRunListener listener : SoapUI.getListenerRegistry().getListeners(MockRunListener.class)) {
            this.addMockRunListener(listener);
        }
        if (!((MockServiceConfig)this.getConfig()).isSetProperties()) {
            ((MockServiceConfig)this.getConfig()).addNewProperties();
        }
        this.setPropertiesConfig(((MockServiceConfig)this.getConfig()).getProperties());
        this.docrootProperty = new BeanPathPropertySupport(this, "docroot");
        if (((MockServiceConfig)this.getConfig()).isSetFaultMockOperation()) {
            this.faultMockOperation = this.getMockOperationByName(((MockServiceConfig)this.getConfig()).getFaultMockOperation());
        }
    }

    @Override
    public void addMockRunListener(MockRunListener listener) {
        this.mockRunListeners.add(listener);
    }

    @Override
    public String getPath() {
        return ((MockServiceConfig)this.getConfig()).getPath();
    }

    @Override
    public WsdlMockOperation getMockOperationAt(int index) {
        return this.mockOperations.get(index);
    }

    @Override
    public WsdlMockOperation getMockOperationByName(String name) {
        return (WsdlMockOperation)this.getWsdlModelItemByName(this.mockOperations, name);
    }

    @Override
    public int getMockOperationCount() {
        return this.mockOperations.size();
    }

    @Override
    public WsdlProject getProject() {
        return (WsdlProject)this.getParent();
    }

    @Override
    public int getPort() {
        return ((MockServiceConfig)this.getConfig()).getPort();
    }

    public String getHost() {
        return ((MockServiceConfig)this.getConfig()).getHost();
    }

    public void setHost(String host) {
        ((MockServiceConfig)this.getConfig()).setHost(host);
    }

    public boolean getBindToHostOnly() {
        return ((MockServiceConfig)this.getConfig()).getBindToHostOnly();
    }

    public void setBindToHostOnly(boolean bindToHostOnly) {
        ((MockServiceConfig)this.getConfig()).setBindToHostOnly(bindToHostOnly);
    }

    @Override
    public void removeMockRunListener(MockRunListener listener) {
        this.mockRunListeners.remove(listener);
    }

    public WsdlMockRunner start(WsdlTestRunContext context) throws Exception {
        String path = this.getPath();
        if (path == null || path.trim().length() == 0 || path.trim().charAt(0) != '/') {
            throw new Exception("Invalid path; must start with '/'");
        }
        this.mockRunner = new WsdlMockRunner(this, context);
        return this.mockRunner;
    }

    public WsdlMockRunner getMockRunner() {
        return this.mockRunner;
    }

    public WsdlMockOperation getMockOperation(Operation operation) {
        for (int c = 0; c < this.getMockOperationCount(); ++c) {
            WsdlMockOperation mockOperation = this.mockOperations.get(c);
            if (mockOperation.getOperation() != operation) continue;
            return mockOperation;
        }
        return null;
    }

    public WsdlMockOperation addNewMockOperation(WsdlOperation operation) {
        if (this.getMockOperation(operation) != null) {
            return null;
        }
        MockOperationConfig config = ((MockServiceConfig)this.getConfig()).addNewMockOperation();
        config.setName(operation.getName());
        WsdlMockOperation mockOperation = new WsdlMockOperation(this, config, operation);
        this.mockOperations.add(mockOperation);
        this.fireMockOperationAdded(mockOperation);
        return mockOperation;
    }

    public void setPort(int port) {
        String oldEndpoint = this.getLocalEndpoint();
        int oldPort = this.getPort();
        if (port != oldPort) {
            ((MockServiceConfig)this.getConfig()).setPort(port);
            this.notifyPropertyChanged(PORT_PROPERTY, oldPort, port);
            for (WsdlInterface iface : this.getMockedInterfaces()) {
                if (!Arrays.asList(iface.getEndpoints()).contains(oldEndpoint)) continue;
                iface.changeEndpoint(oldEndpoint, this.getLocalEndpoint());
            }
        }
    }

    public WsdlInterface[] getMockedInterfaces() {
        HashSet<WsdlInterface> result = new HashSet<WsdlInterface>();
        for (WsdlMockOperation mockOperation : this.mockOperations) {
            WsdlOperation operation = mockOperation.getOperation();
            if (operation == null) continue;
            result.add(operation.getInterface());
        }
        return result.toArray(new WsdlInterface[result.size()]);
    }

    @Override
    public void release() {
        super.release();
        if (this.mockRunner != null) {
            if (this.mockRunner.isRunning()) {
                this.mockRunner.stop();
            }
            if (this.mockRunner != null) {
                this.mockRunner.release();
            }
        }
        for (WsdlMockOperation operation : this.mockOperations) {
            operation.release();
        }
        this.mockServiceListeners.clear();
        if (this.onRequestScriptEnginePool != null) {
            this.onRequestScriptEnginePool.release();
        }
        if (this.afterRequestScriptEnginePool != null) {
            this.afterRequestScriptEnginePool.release();
        }
        if (this.startScriptEngine != null) {
            this.startScriptEngine.release();
        }
        if (this.stopScriptEngine != null) {
            this.stopScriptEngine.release();
        }
    }

    public void setPath(String path) {
        String oldEndpoint = this.getLocalEndpoint();
        String oldPath = this.getPath();
        if (!path.equals(oldPath)) {
            ((MockServiceConfig)this.getConfig()).setPath(path);
            this.notifyPropertyChanged(PATH_PROPERTY, oldPath, path);
            for (WsdlInterface iface : this.getMockedInterfaces()) {
                if (!Arrays.asList(iface.getEndpoints()).contains(oldEndpoint)) continue;
                iface.changeEndpoint(oldEndpoint, this.getLocalEndpoint());
            }
        }
    }

    public MockRunListener[] getMockRunListeners() {
        return this.mockRunListeners.toArray(new MockRunListener[this.mockRunListeners.size()]);
    }

    public void removeMockOperation(WsdlMockOperation mockOperation) {
        int ix = this.mockOperations.indexOf(mockOperation);
        if (ix == -1) {
            throw new RuntimeException("Unkonws MockOperation specified to removeMockOperation");
        }
        this.mockOperations.remove(ix);
        this.fireMockOperationRemoved(mockOperation);
        mockOperation.release();
        ((MockServiceConfig)this.getConfig()).removeMockOperation(ix);
    }

    @Override
    public void addMockServiceListener(MockServiceListener listener) {
        this.mockServiceListeners.add(listener);
    }

    @Override
    public void removeMockServiceListener(MockServiceListener listener) {
        this.mockServiceListeners.remove(listener);
    }

    protected void fireMockOperationAdded(WsdlMockOperation mockOperation) {
        MockServiceListener[] listeners;
        for (MockServiceListener listener : listeners = this.mockServiceListeners.toArray(new MockServiceListener[this.mockServiceListeners.size()])) {
            listener.mockOperationAdded(mockOperation);
        }
    }

    protected void fireMockOperationRemoved(WsdlMockOperation mockOperation) {
        MockServiceListener[] listeners;
        for (MockServiceListener listener : listeners = this.mockServiceListeners.toArray(new MockServiceListener[this.mockServiceListeners.size()])) {
            listener.mockOperationRemoved(mockOperation);
        }
    }

    protected void fireMockResponseAdded(WsdlMockResponse mockResponse) {
        MockServiceListener[] listeners;
        for (MockServiceListener listener : listeners = this.mockServiceListeners.toArray(new MockServiceListener[this.mockServiceListeners.size()])) {
            listener.mockResponseAdded(mockResponse);
        }
    }

    protected void fireMockResponseRemoved(WsdlMockResponse mockResponse) {
        MockServiceListener[] listeners;
        for (MockServiceListener listener : listeners = this.mockServiceListeners.toArray(new MockServiceListener[this.mockServiceListeners.size()])) {
            listener.mockResponseRemoved(mockResponse);
        }
    }

    @Override
    public ImageIcon getIcon() {
        return this.iconAnimator.getIcon();
    }

    public WsdlMockOperation getFaultMockOperation() {
        return this.faultMockOperation;
    }

    public void setFaultMockOperation(WsdlMockOperation mockOperation) {
        this.faultMockOperation = mockOperation;
        if (this.faultMockOperation == null) {
            if (((MockServiceConfig)this.getConfig()).isSetFaultMockOperation()) {
                ((MockServiceConfig)this.getConfig()).unsetFaultMockOperation();
            }
        } else {
            ((MockServiceConfig)this.getConfig()).setFaultMockOperation(this.faultMockOperation.getName());
        }
    }

    public String getLocalEndpoint() {
        String host = this.getHost();
        if (StringUtils.isNullOrEmpty(host)) {
            host = "127.0.0.1";
        }
        return this.getProtocol() + host + ":" + this.getPort() + this.getPath();
    }

    private String getProtocol() {
        try {
            boolean sslEnabled = SoapUI.getSettings().getBoolean(SSLSettings.ENABLE_MOCK_SSL);
            String protocol = sslEnabled ? "https://" : "http://";
            return protocol;
        }
        catch (Exception e) {
            return "http://";
        }
    }

    public boolean isRequireSoapVersion() {
        return this.getSettings().getBoolean(REQUIRE_SOAP_VERSION);
    }

    public void setRequireSoapVersion(boolean requireSoapVersion) {
        this.getSettings().setBoolean(REQUIRE_SOAP_VERSION, requireSoapVersion);
    }

    public boolean isRequireSoapAction() {
        return this.getSettings().getBoolean(REQUIRE_SOAP_ACTION);
    }

    public void setRequireSoapAction(boolean requireSoapAction) {
        this.getSettings().setBoolean(REQUIRE_SOAP_ACTION, requireSoapAction);
    }

    @Override
    public WsdlMockRunner start() throws Exception {
        return this.start(null);
    }

    public boolean hasMockOperation(Operation operation) {
        return this.getMockOperation(operation) != null;
    }

    public void setStartScript(String script) {
        String oldScript = this.getStartScript();
        if (!((MockServiceConfig)this.getConfig()).isSetStartScript()) {
            ((MockServiceConfig)this.getConfig()).addNewStartScript();
        }
        ((MockServiceConfig)this.getConfig()).getStartScript().setStringValue(script);
        if (this.startScriptEngine != null) {
            this.startScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged(START_SCRIPT_PROPERTY, oldScript, script);
    }

    public String getStartScript() {
        return ((MockServiceConfig)this.getConfig()).isSetStartScript() ? ((MockServiceConfig)this.getConfig()).getStartScript().getStringValue() : null;
    }

    public void setStopScript(String script) {
        String oldScript = this.getStopScript();
        if (!((MockServiceConfig)this.getConfig()).isSetStopScript()) {
            ((MockServiceConfig)this.getConfig()).addNewStopScript();
        }
        ((MockServiceConfig)this.getConfig()).getStopScript().setStringValue(script);
        if (this.stopScriptEngine != null) {
            this.stopScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged(STOP_SCRIPT_PROPERTY, oldScript, script);
    }

    public String getStopScript() {
        return ((MockServiceConfig)this.getConfig()).isSetStopScript() ? ((MockServiceConfig)this.getConfig()).getStopScript().getStringValue() : null;
    }

    public Object runStartScript(WsdlMockRunContext runContext, WsdlMockRunner runner) throws Exception {
        String script = this.getStartScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.startScriptEngine == null) {
            this.startScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.startScriptEngine.setScript(script);
        }
        this.startScriptEngine.setVariable("context", runContext);
        this.startScriptEngine.setVariable("mockRunner", runner);
        this.startScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.startScriptEngine.run();
    }

    public Object runStopScript(WsdlMockRunContext runContext, WsdlMockRunner runner) throws Exception {
        String script = this.getStopScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.stopScriptEngine == null) {
            this.stopScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.stopScriptEngine.setScript(script);
        }
        this.stopScriptEngine.setVariable("context", runContext);
        this.stopScriptEngine.setVariable("mockRunner", runner);
        this.stopScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.stopScriptEngine.run();
    }

    public void setOnRequestScript(String script) {
        String oldScript = this.getOnRequestScript();
        if (!((MockServiceConfig)this.getConfig()).isSetOnRequestScript()) {
            ((MockServiceConfig)this.getConfig()).addNewOnRequestScript();
        }
        ((MockServiceConfig)this.getConfig()).getOnRequestScript().setStringValue(script);
        if (this.onRequestScriptEnginePool != null) {
            this.onRequestScriptEnginePool.setScript(script);
        }
        this.notifyPropertyChanged("onRequestScript", oldScript, script);
    }

    public String getOnRequestScript() {
        return ((MockServiceConfig)this.getConfig()).isSetOnRequestScript() ? ((MockServiceConfig)this.getConfig()).getOnRequestScript().getStringValue() : null;
    }

    public void setAfterRequestScript(String script) {
        String oldScript = this.getAfterRequestScript();
        if (!((MockServiceConfig)this.getConfig()).isSetAfterRequestScript()) {
            ((MockServiceConfig)this.getConfig()).addNewAfterRequestScript();
        }
        ((MockServiceConfig)this.getConfig()).getAfterRequestScript().setStringValue(script);
        if (this.afterRequestScriptEnginePool != null) {
            this.afterRequestScriptEnginePool.setScript(script);
        }
        this.notifyPropertyChanged("afterRequestScript", oldScript, script);
    }

    public String getAfterRequestScript() {
        return ((MockServiceConfig)this.getConfig()).isSetAfterRequestScript() ? ((MockServiceConfig)this.getConfig()).getAfterRequestScript().getStringValue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runOnRequestScript(WsdlMockRunContext runContext, WsdlMockRunner runner, WsdlMockRequest mockRequest) throws Exception {
        String script = this.getOnRequestScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.onRequestScriptEnginePool == null) {
            this.onRequestScriptEnginePool = new ScriptEnginePool(this);
            this.onRequestScriptEnginePool.setScript(script);
        }
        SoapUIScriptEngine scriptEngine = this.onRequestScriptEnginePool.getScriptEngine();
        try {
            scriptEngine.setVariable("context", runContext);
            scriptEngine.setVariable("mockRequest", mockRequest);
            scriptEngine.setVariable("mockRunner", runner);
            scriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
            Object object = scriptEngine.run();
            Object var8_7 = null;
            this.onRequestScriptEnginePool.returnScriptEngine(scriptEngine);
            return object;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.onRequestScriptEnginePool.returnScriptEngine(scriptEngine);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runAfterRequestScript(WsdlMockRunContext runContext, WsdlMockRunner runner, MockResult mockResult) throws Exception {
        String script = this.getAfterRequestScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.afterRequestScriptEnginePool == null) {
            this.afterRequestScriptEnginePool = new ScriptEnginePool(this);
            this.afterRequestScriptEnginePool.setScript(script);
        }
        SoapUIScriptEngine scriptEngine = this.afterRequestScriptEnginePool.getScriptEngine();
        try {
            scriptEngine.setVariable("context", runContext);
            scriptEngine.setVariable("mockResult", mockResult);
            scriptEngine.setVariable("mockRunner", runner);
            scriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
            Object object = scriptEngine.run();
            Object var8_7 = null;
            this.afterRequestScriptEnginePool.returnScriptEngine(scriptEngine);
            return object;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.afterRequestScriptEnginePool.returnScriptEngine(scriptEngine);
            throw throwable;
        }
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        return this.mockOperations;
    }

    @Override
    public List<MockOperation> getMockOperationList() {
        return Collections.unmodifiableList(new ArrayList<WsdlMockOperation>(this.mockOperations));
    }

    public String getIncomingWss() {
        return ((MockServiceConfig)this.getConfig()).getIncomingWss();
    }

    public void setIncomingWss(String incomingWss) {
        String old = this.getIncomingWss();
        ((MockServiceConfig)this.getConfig()).setIncomingWss(incomingWss);
        this.notifyPropertyChanged(INCOMING_WSS, old, incomingWss);
    }

    public String getOutgoingWss() {
        return ((MockServiceConfig)this.getConfig()).getOutgoingWss();
    }

    public void setOutgoingWss(String outgoingWss) {
        String old = this.getOutgoingWss();
        ((MockServiceConfig)this.getConfig()).setOutgoingWss(outgoingWss);
        this.notifyPropertyChanged(OUGOING_WSS, old, outgoingWss);
    }

    public boolean isDispatchResponseMessages() {
        return ((MockServiceConfig)this.getConfig()).getDispatchResponseMessages();
    }

    public void setDispatchResponseMessages(boolean dispatchResponseMessages) {
        boolean old = this.isDispatchResponseMessages();
        ((MockServiceConfig)this.getConfig()).setDispatchResponseMessages(dispatchResponseMessages);
        this.notifyPropertyChanged("dispatchResponseMessages", old, dispatchResponseMessages);
    }

    public List<WsdlOperation> getMockedOperations() {
        ArrayList<WsdlOperation> result = new ArrayList<WsdlOperation>();
        for (WsdlMockOperation mockOperation : this.mockOperations) {
            result.add(mockOperation.getOperation());
        }
        return result;
    }

    public void setDocroot(String docroot) {
        this.docrootProperty.set(docroot, true);
    }

    public String getDocroot() {
        return this.docrootProperty.get();
    }

    @Override
    public void addExternalDependencies(List<ExternalDependency> dependencies) {
        super.addExternalDependencies(dependencies);
        dependencies.add(new MockServiceExternalDependency(this.docrootProperty));
    }

    @Override
    public void resolve(ResolveContext<?> context) {
        super.resolve(context);
        this.docrootProperty.resolveFile(context, "Missing MockService docroot");
    }

    public void replace(WsdlMockOperation mockOperation, MockOperationConfig reloadedMockOperation) {
        int ix = this.mockOperations.indexOf(mockOperation);
        if (ix == -1) {
            throw new RuntimeException("Unkonws MockOperation specified to removeMockOperation");
        }
        this.mockOperations.remove(ix);
        this.fireMockOperationRemoved(mockOperation);
        mockOperation.release();
        ((MockServiceConfig)this.getConfig()).removeMockOperation(ix);
        MockOperationConfig newConfig = (MockOperationConfig)((MockServiceConfig)this.getConfig()).insertNewMockOperation(ix).set((XmlObject)reloadedMockOperation).changeType(MockOperationConfig.type);
        WsdlMockOperation newOperation = new WsdlMockOperation(this, newConfig);
        this.mockOperations.add(ix, newOperation);
        newOperation.afterLoad();
        this.fireMockOperationAdded(newOperation);
    }

    public void export(File file) {
        try {
            ((MockServiceConfig)this.getConfig()).newCursor().save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void importMockOperation(File file) {
        MockOperationConfig mockOperationNewConfig = null;
        if (!file.exists()) {
            UISupport.showErrorMessage("Error loading mock operation.");
            return;
        }
        try {
            mockOperationNewConfig = MockOperationDocumentConfig.Factory.parse((File)file).getMockOperation();
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        if (mockOperationNewConfig != null) {
            MockOperationConfig newConfig = (MockOperationConfig)((MockServiceConfig)this.getConfig()).addNewMockOperation().set((XmlObject)mockOperationNewConfig).changeType(TestCaseConfig.type);
            WsdlMockOperation newMockOperation = new WsdlMockOperation(this, newConfig);
            ModelSupport.unsetIds(newMockOperation);
            newMockOperation.afterLoad();
            this.mockOperations.add(newMockOperation);
            this.fireMockOperationAdded(newMockOperation);
            this.resolveImportedMockOperation(newMockOperation);
        } else {
            UISupport.showErrorMessage("Not valid mock operation xml");
        }
    }

    private void resolveImportedMockOperation(WsdlMockOperation mockOperation) {
        ResolveDialog resolver = new ResolveDialog("Validate MockOperation", "Checks MockOperation for inconsistencies", null);
        resolver.setShowOkMessage(false);
        resolver.resolve(mockOperation);
    }

    public String toString() {
        return this.getName();
    }

    public String getMockServiceEndpoint() {
        return this.mockServiceEndpoint;
    }

    public void setMockServiceEndpoint(String mockServiceEndpoint) {
        this.mockServiceEndpoint = mockServiceEndpoint;
    }

    public String getLocalMockServiceEndpoint() {
        if (this.mockServiceEndpoint != null) {
            return this.mockServiceEndpoint + this.getPath();
        }
        String host = this.getHost();
        if (StringUtils.isNullOrEmpty(host)) {
            host = "127.0.0.1";
        }
        int port = (int)(this.getSettings().getBoolean(SSLSettings.ENABLE_MOCK_SSL) ? this.getSettings().getLong(SSLSettings.MOCK_PORT, 443L) : (long)this.getPort());
        return this.getProtocol() + host + ":" + port + this.getPath();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MockServiceIconAnimator
    extends ModelItemIconAnimator<WsdlMockService>
    implements MockRunListener {
        public MockServiceIconAnimator() {
            super(WsdlMockService.this, "/mockService.gif", "/mockService", 4, "gif");
        }

        @Override
        public MockResult onMockRequest(MockRunner runner, HttpServletRequest request, HttpServletResponse response) {
            return null;
        }

        @Override
        public void onMockResult(MockResult result) {
        }

        @Override
        public void onMockRunnerStart(MockRunner mockRunner) {
            this.start();
        }

        @Override
        public void onMockRunnerStop(MockRunner mockRunner) {
            this.stop();
            WsdlMockService.this.mockRunner = null;
        }
    }
}

