/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.definition.export.WsdlDefinitionExporter;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.support.soap.SoapUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.mock.MockRunListener;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.support.AbstractMockRunner;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.editor.inspectors.attachments.ContentTypeHandler;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import org.apache.commons.collections.list.TreeList;
import org.apache.log4j.Logger;
import org.mortbay.jetty.Request;
import org.xml.sax.InputSource;

public class WsdlMockRunner
extends AbstractMockRunner {
    private WsdlMockService mockService;
    private final List<WsdlMockResult> mockResults = Collections.synchronizedList(new TreeList());
    private long maxResults = 100L;
    private int removed = 0;
    private final WsdlMockRunContext mockContext;
    private final Map<String, StringToStringMap> wsdlCache = new HashMap<String, StringToStringMap>();
    private boolean running;
    private boolean logEnabled = true;
    private static final Logger log = Logger.getLogger(WsdlMockRunner.class);

    public WsdlMockRunner(WsdlMockService mockService, WsdlTestRunContext context) throws Exception {
        this.mockService = mockService;
        HashSet<WsdlInterface> interfaces = new HashSet<WsdlInterface>();
        for (int i = 0; i < mockService.getMockOperationCount(); ++i) {
            WsdlOperation operation = mockService.getMockOperationAt(i).getOperation();
            if (operation == null) continue;
            interfaces.add(operation.getInterface());
        }
        for (WsdlInterface iface : interfaces) {
            iface.getWsdlContext().loadIfNecessary();
        }
        this.initWsdlCache();
        this.mockContext = new WsdlMockRunContext(mockService, context);
        this.start();
    }

    private void initWsdlCache() {
        for (WsdlInterface iface : this.mockService.getMockedInterfaces()) {
            if (!iface.getInterfaceType().equals("wsdl")) continue;
            try {
                WsdlDefinitionExporter exporter = new WsdlDefinitionExporter(iface);
                String wsdlPrefix = this.getInterfacePrefix(iface).substring(1);
                StringToStringMap parts = exporter.createFilesForExport("/" + wsdlPrefix + "&part=");
                for (String key : parts.keySet()) {
                    InputSource inputSource;
                    String content;
                    if (!key.toLowerCase().endsWith(".wsdl") || (content = WsdlUtils.replacePortEndpoint(iface, inputSource = new InputSource(new StringReader((String)parts.get(key))), this.mockService.getLocalMockServiceEndpoint())) == null) continue;
                    parts.put(key, content);
                }
                this.wsdlCache.put(iface.getName(), parts);
                log.info((Object)("Mounted WSDL for interface [" + iface.getName() + "] at [" + this.getOverviewUrl() + "]"));
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
    }

    public String getInterfacePrefix(Interface iface) {
        String wsdlPrefix = this.getOverviewUrl() + "&interface=" + iface.getName();
        return wsdlPrefix;
    }

    public WsdlMockRunContext getMockContext() {
        return this.mockContext;
    }

    public synchronized void addMockResult(WsdlMockResult mockResult) {
        if (this.maxResults > 0L && this.logEnabled) {
            this.mockResults.add(mockResult);
        }
        while ((long)this.mockResults.size() > this.maxResults) {
            this.mockResults.remove(0);
            ++this.removed;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop() {
        MockRunListener[] mockRunListeners;
        if (!this.isRunning()) {
            return;
        }
        SoapUI.getMockEngine().stopMockService(this);
        for (MockRunListener listener : mockRunListeners = this.mockService.getMockRunListeners()) {
            listener.onMockRunnerStop(this);
        }
        try {
            this.mockService.runStopScript(this.mockContext, this);
            this.running = false;
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    public WsdlMockService getMockService() {
        return this.mockService;
    }

    public long getMaxResults() {
        return this.maxResults;
    }

    public synchronized void setMaxResults(long l) {
        this.maxResults = l;
        while ((long)this.mockResults.size() > l) {
            this.mockResults.remove(0);
            ++this.removed;
        }
    }

    public MockResult dispatchHeadRequest(HttpServletRequest request, HttpServletResponse response) throws DispatchException {
        response.setStatus(200);
        return null;
    }

    public WsdlMockResult dispatchPostRequest(WsdlMockRequest mockRequest) throws Exception {
        WsdlMockResult result = null;
        try {
            long timestamp = System.currentTimeMillis();
            SoapVersion soapVersion = mockRequest.getSoapVersion();
            if (soapVersion == null) {
                throw new DispatchException("Unrecognized SOAP Version");
            }
            String soapAction = mockRequest.getSoapAction();
            WsdlOperation operation = null;
            if (SoapUtils.isSoapFault(mockRequest.getRequestContent(), soapVersion)) {
                WsdlMockOperation faultMockOperation = this.mockService.getFaultMockOperation();
                if (faultMockOperation != null) {
                    operation = faultMockOperation.getOperation();
                }
            } else {
                try {
                    operation = SoapUtils.findOperationForRequest(soapVersion, soapAction, mockRequest.getRequestXmlObject(), this.mockService.getMockedOperations(), this.mockService.isRequireSoapVersion(), this.mockService.isRequireSoapAction(), mockRequest.getRequestAttachments());
                }
                catch (Exception e) {
                    if (this.mockService.isDispatchResponseMessages()) {
                        try {
                            operation = SoapUtils.findOperationForResponse(soapVersion, soapAction, mockRequest.getRequestXmlObject(), this.mockService.getMockedOperations(), this.mockService.isRequireSoapVersion(), this.mockService.isRequireSoapAction());
                            if (operation != null) {
                                mockRequest.setResponseMessage(true);
                            }
                        }
                        catch (Exception e2) {
                            throw e;
                        }
                    }
                    throw e;
                }
            }
            if (operation != null) {
                WsdlMockOperation mockOperation = this.mockService.getMockOperation(operation);
                if (mockOperation != null) {
                    long startTime = System.nanoTime();
                    result = mockOperation.dispatchRequest(mockRequest);
                    if (mockRequest.getHttpRequest() instanceof Request) {
                        ((Request)mockRequest.getHttpRequest()).setHandled(true);
                    }
                    result.setTimeTaken((System.nanoTime() - startTime) / 1000000L);
                    result.setTimestamp(timestamp);
                    this.addMockResult(result);
                    return result;
                }
                throw new DispatchException("Failed to find matching operation for request");
            }
            throw new DispatchException("Missing operation for soapAction [" + soapAction + "] and body element [" + XmlUtils.getQName(mockRequest.getContentElement()) + "] with SOAP Version [" + mockRequest.getSoapVersion() + "]");
        }
        catch (Exception e) {
            if (e instanceof DispatchException) {
                throw (DispatchException)e;
            }
            throw new DispatchException(e);
        }
    }

    public MockResult getMockResultAt(int index) {
        return index <= this.removed ? null : this.mockResults.get(index - this.removed);
    }

    public int getMockResultCount() {
        return this.mockResults.size() + this.removed;
    }

    public synchronized void clearResults() {
        this.mockResults.clear();
    }

    public void release() {
        this.clearResults();
        this.mockService = null;
        this.mockContext.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MockResult dispatchRequest(HttpServletRequest request, HttpServletResponse response) throws DispatchException {
        Object result = null;
        try {
            MockResult mockResult;
            try {
                for (MockRunListener listener : this.mockService.getMockRunListeners()) {
                    result = listener.onMockRequest(this, request, response);
                    if (!(result instanceof MockResult)) continue;
                    MockResult mockResult2 = result;
                    Object var10_12 = null;
                    if (!(result instanceof MockResult)) return mockResult2;
                    for (MockRunListener listener2 : this.mockService.getMockRunListeners()) {
                        listener2.onMockResult((MockResult)result);
                    }
                    return mockResult2;
                }
                WsdlMockRequest mockRequest = new WsdlMockRequest(request, response, this.mockContext);
                result = this.mockService.runOnRequestScript(this.mockContext, this, mockRequest);
                if (!(result instanceof MockResult)) {
                    String method = mockRequest.getMethod();
                    result = method.equals("POST") ? this.dispatchPostRequest(mockRequest) : super.dispatchRequest(request, response);
                }
                this.mockService.runAfterRequestScript(this.mockContext, this, (MockResult)result);
                mockResult = (MockResult)result;
                Object var10_13 = null;
            }
            catch (Throwable e) {
                if (e instanceof DispatchException) {
                    throw (DispatchException)e;
                }
                throw new DispatchException(e);
            }
            if (!(result instanceof MockResult)) return mockResult;
            for (MockRunListener listener2 : this.mockService.getMockRunListeners()) {
                listener2.onMockResult((MockResult)result);
            }
            return mockResult;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (result instanceof MockResult) {
                for (MockRunListener listener2 : this.mockService.getMockRunListeners()) {
                    listener2.onMockResult((MockResult)result);
                }
            }
            throw throwable;
        }
    }

    public MockResult dispatchGetRequest(HttpServletRequest request, HttpServletResponse response) throws DispatchException {
        try {
            String qs = request.getQueryString();
            if (qs != null && qs.toUpperCase().startsWith("WSDL")) {
                this.dispatchWsdlRequest(request, response);
            } else if (qs != null && qs.startsWith("cmd=")) {
                this.dispatchCommand(request.getParameter("cmd"), request, response);
            } else {
                String docroot = PropertyExpander.expandProperties(this.mockContext, this.getMockService().getDocroot());
                if (StringUtils.hasContent(docroot)) {
                    try {
                        String filename;
                        File file;
                        String pathInfo = request.getPathInfo();
                        if (pathInfo == null) {
                            pathInfo = "";
                        }
                        if (this.mockService.getPath().length() > 1 && pathInfo.startsWith(this.mockService.getPath())) {
                            pathInfo = pathInfo.substring(this.mockService.getPath().length());
                        }
                        if ((file = new File(filename = docroot + pathInfo.replace('/', File.separatorChar))).exists()) {
                            this.returnFile(response, file);
                        }
                    }
                    catch (Throwable e) {
                        throw new DispatchException(e);
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new DispatchException(e);
        }
    }

    public void returnFile(HttpServletResponse response, File file) throws FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream(file);
        response.setStatus(200);
        long length = file.length();
        response.setContentLength((int)length);
        response.setContentType(ContentTypeHandler.getContentTypeFromFilename(file.getName()));
        Tools.readAndWrite(in, length, (OutputStream)response.getOutputStream());
        in.close();
    }

    private void dispatchCommand(String cmd, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ("stop".equals(cmd)) {
            response.setStatus(200);
            response.flushBuffer();
            SoapUI.getThreadPool().execute(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    WsdlMockRunner.this.stop();
                }
            });
        } else if ("restart".equals(cmd)) {
            response.setStatus(200);
            response.flushBuffer();
            SoapUI.getThreadPool().execute(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    WsdlMockRunner.this.stop();
                    try {
                        WsdlMockRunner.this.mockService.start();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    protected void dispatchWsdlRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String content;
        if (request.getQueryString().equalsIgnoreCase("WSDL")) {
            this.printWsdl(response);
            return;
        }
        String ifaceName = request.getParameter("interface");
        WsdlInterface iface = (WsdlInterface)this.mockService.getProject().getInterfaceByName(ifaceName);
        if (iface == null) {
            this.printInterfaceList(response);
            return;
        }
        StringToStringMap parts = this.wsdlCache.get(iface.getName());
        String part = request.getParameter("part");
        String string = content = StringUtils.isNullOrEmpty(part) ? null : (String)parts.get(part);
        if (content == null) {
            this.printPartList(iface, parts, response);
            return;
        }
        if (content != null) {
            this.printOkXmlResult(response, content);
        }
    }

    public void printOkXmlResult(HttpServletResponse response, String content) throws IOException {
        response.setStatus(200);
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().print(content);
    }

    public void printWsdl(HttpServletResponse response) throws IOException {
        WsdlInterface[] mockedInterfaces = this.mockService.getMockedInterfaces();
        if (mockedInterfaces.length == 1) {
            StringToStringMap parts = this.wsdlCache.get(mockedInterfaces[0].getName());
            this.printOkXmlResult(response, (String)parts.get(parts.get("#root#")));
        } else {
            try {
                WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                Definition def = wsdlFactory.newDefinition();
                for (WsdlInterface iface : mockedInterfaces) {
                    StringToStringMap parts = this.wsdlCache.get(iface.getName());
                    Import wsdlImport = def.createImport();
                    wsdlImport.setLocationURI(this.getInterfacePrefix(iface) + "&part=" + (String)parts.get("#root#"));
                    wsdlImport.setNamespaceURI(WsdlUtils.getTargetNamespace(iface.getWsdlContext().getDefinition()));
                    def.addImport(wsdlImport);
                }
                response.setStatus(200);
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF-8");
                WSDLWriter writer = wsdlFactory.newWSDLWriter();
                writer.writeWSDL(def, (Writer)response.getWriter());
            }
            catch (Exception e) {
                SoapUI.logError(e);
                throw new IOException("Failed to create combined WSDL");
            }
        }
    }

    public void printPartList(WsdlInterface iface, StringToStringMap parts, HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.print("<html><body><p>Parts in interface [" + iface.getName() + "]</p><ul>");
        for (String key : parts.keySet()) {
            if (key.equals("#root#")) continue;
            out.print("<li><a href=\"");
            out.print(this.getInterfacePrefix(iface) + "&part=" + key);
            out.print("\">" + key + "</a></li>");
        }
        out.print("</ul></p></body></html>");
    }

    public void printInterfaceList(HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.print("<html><body><p>Mocked Interfaces in project [" + this.mockService.getProject().getName() + "]</p><ul>");
        for (Interface interface_ : ModelSupport.getChildren(this.mockService.getProject(), WsdlInterface.class)) {
            out.print("<li><a href=\"");
            out.print(this.getInterfacePrefix(interface_));
            out.print("\">" + interface_.getName() + "</a></li>");
        }
        out.print("</ul></p></body></html>");
    }

    public String getOverviewUrl() {
        return this.mockService.getPath() + "?WSDL";
    }

    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    public void start() throws Exception {
        MockRunListener[] mockRunListeners;
        if (this.running) {
            return;
        }
        this.mockContext.reset();
        this.mockService.runStartScript(this.mockContext, this);
        SoapUI.getMockEngine().startMockService(this);
        this.running = true;
        for (MockRunListener listener : mockRunListeners = this.mockService.getMockRunListeners()) {
            listener.onMockRunnerStart(this);
        }
    }
}

