/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.actions.SoapUIPreferencesAction;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.integration.impl.CajoClient;
import com.eviware.soapui.settings.LoadUISettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartLoadUI
extends AbstractSoapUIAction<WsdlProject> {
    private static final String SH = ".sh";
    private static final String BAT = ".bat";
    private static final String COMMAND = ".command";
    private static final String LOADUI_LAUNCH_EXTENSION = UISupport.isWindows() ? ".bat" : (UISupport.isMac() ? ".command" : ".sh");
    private static final String LOADUI = "loadUI";
    public static final String SOAPUI_ACTION_ID = "StartLoadUI";
    public static final String LOADUI_LAUNCH_TITLE = "Launch loadUI";
    public static final String LOADUI_LAUNCH_QUESTION = "For this action you have to launch loadUI. Launch it now?";

    public StartLoadUI() {
        super("Start loadUI", "Start loadUI application");
    }

    @Override
    public void perform(WsdlProject project, Object param) {
        String loadUIBatPath = StartLoadUI.getLoadUIPath();
        StartLoadUI.startLoadUI(loadUIBatPath);
    }

    public static Process launchLoadUI() {
        String loadUILaunchPath = StartLoadUI.getLoadUIPath();
        return StartLoadUI.startLoadUI(loadUILaunchPath);
    }

    private static Process startLoadUI(String loadUILaunchPath) {
        if (CajoClient.getInstance().testConnection()) {
            try {
                CajoClient.getInstance().invoke("bringToFront", null);
                return null;
            }
            catch (Exception e) {
                SoapUI.log.error((Object)"Error while invoke cajo server in loadui ", (Throwable)e);
            }
        }
        try {
            while (!new File(loadUILaunchPath).exists()) {
                UISupport.showInfoMessage("No loadUI" + LOADUI_LAUNCH_EXTENSION + " in path:\"" + loadUILaunchPath + "\"");
                if (UISupport.getMainFrame() == null) continue;
                if (SoapUIPreferencesAction.getInstance().show("loadUI Settings")) {
                    loadUILaunchPath = StartLoadUI.getLoadUIPath();
                    continue;
                }
                return null;
            }
            String[] commandsWin = new String[]{"cmd.exe", "/c", LOADUI + LOADUI_LAUNCH_EXTENSION};
            String[] commandsLinux = new String[]{"sh", LOADUI + LOADUI_LAUNCH_EXTENSION};
            String[] commandsMac = new String[]{"sh", LOADUI + LOADUI_LAUNCH_EXTENSION};
            ProcessBuilder pb = new ProcessBuilder(UISupport.isWindows() ? commandsWin : (UISupport.isMac() ? commandsMac : commandsLinux));
            pb.directory(new File(SoapUI.getSettings().getString(LoadUISettings.LOADUI_PATH, "")));
            Process p = pb.start();
            return p;
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return null;
        }
    }

    private static String getLoadUIPath() {
        return SoapUI.getSettings().getString(LoadUISettings.LOADUI_PATH, "") + File.separator + LOADUI + LOADUI_LAUNCH_EXTENSION;
    }

    public static boolean testCajoConnection() {
        return CajoClient.getInstance().testConnection();
    }
}

